<?php
/**
 * WRC Pricing Tables Ultimate - v1.2.4 - 16 July, 2023
 * Custom Style Sheet for Shortcode 1 and 2
 */
function wrcpt_set_custom_css($page_id, $st_pageid = false) {
	$tot_feat = 0; $custom_css = ''; $shortcode = 1;
	$all_post_urls = $post_id = array();
	$current_post_id = $page_id;
	$pricing_table_lists = get_option('packageTables');
	$pricing_id_lists = get_option('packageIDs');
	$pricing_table_lists = explode(', ', $pricing_table_lists);
	$pricing_id_lists = explode(', ', $pricing_id_lists);
	$wrcpt_options = get_option('pricing_table_global');
	$wrcpt_custom = isset($wrcpt_options['wrccss']) ? htmlspecialchars_decode($wrcpt_options['wrccss']) : '';
	if(isset($wrcpt_options['gdfont']) && $wrcpt_options['gdfont'] != 'yes') {
		$global_font1 = isset($wrcpt_options['prfont']) ? $wrcpt_options['prfont'] : '';
		$global_font2 = isset($wrcpt_options['scfont']) ? $wrcpt_options['scfont'] : '';
	} else {
		$global_font1 = $global_font2 = '';
	}
	if(isset($p_combo['scode']) && $p_combo['scode'] == 'sc-1') {
		$shortcode = 1;
	}
	foreach($pricing_table_lists as $key => $p_table) :
		if(get_option($p_table) !== FALSE) :
			$id = $pricing_id_lists[$key];
			$tableID = strtolower($p_table) . '-' .$id;
			if(get_option($p_table.'_option') !== FALSE) :
				$p_combo = get_option($p_table.'_option');

				$all_post_urls = isset($p_combo['spurl']) ? explode( "\n", $p_combo['spurl'] ) : array();
				foreach($all_post_urls as $url) {
					if($url != '') {
						$post_id[] = url_to_postid( $url );
					} else {
						$post_id[] = 0;
					}
				}
				$scode_pageid[] = $post_id;
				if (in_array($current_post_id, $post_id) || $current_post_id == 'preview') :
					$p_feature = get_option($p_table.'_feature');
					if($p_feature) { $tot_feat = count($p_feature)/6; }
					$p_lists = get_option($p_table);
					$p_options = explode(', ', $p_lists);
					$p_count = count($p_options);
					$i = 1; $j = 0;
					$ptn_light = isset($p_combo['ptnbg']) ? wrcpt_adjustBrightness($p_combo['ptnbg'], 50) : array();
					$pta_light = isset($p_combo['ptabg']) ? wrcpt_adjustBrightness($p_combo['ptabg'], 50) : array();
					$ptn_dark = isset($p_combo['ptnbg']) ? wrcpt_adjustBrightness($p_combo['ptnbg'], -30) : array();
					$pta_dark = isset($p_combo['ptabg']) ? wrcpt_adjustBrightness($p_combo['ptabg'], -30) : array();
					$cbdlight = isset($p_combo['ccborder']) ? wrcpt_adjustBrightness($p_combo['ccborder'], 50) : array();

					/* Preparing structural settings of the different parts of the table. */
					$bottom_padding = isset($p_combo['tbpad']) ? (int)$p_combo['tbpad']+1 : 3;
					if(isset($p_combo['cwidth']) && $p_combo['cwidth']) { $container_width = (int)$p_combo['cwidth']; } else { $container_width = 100; }

					if(isset($p_combo['maxcol']) && $p_combo['maxcol']) { $maximum_column = (int)$p_combo['maxcol']; } else { $maximum_column = 4; }

					if(isset($p_combo['tbody']) && $p_combo['tbody']) { $title_box_height = (int)$p_combo['tbody']; } else { $title_box_height = 62; }

					if(isset($p_combo['pbody']) && $p_combo['pbody']) { $price_box_height = (int)$p_combo['pbody']; } else { $price_box_height = 120; }

					if(isset($p_combo['ftbody']) && $p_combo['ftbody']) { $feature_box_height = (int)$p_combo['ftbody']; } else { $feature_box_height = 52; }

					if((isset($p_combo['imghgt']) && $p_combo['imghgt']) && $p_combo['bgimg'] != 'yes') { $image_height_a = (int)$p_combo['imghgt']; } else { $image_height_a = $price_box_height; }

					if(isset($p_combo['vbody']) && $p_combo['vbody']) { $video_height = (int)$p_combo['vbody']; } else { $video_height = $price_box_height; }

					if(isset($p_combo['btbody']) && $p_combo['btbody']) { $button_box_height = (int)$p_combo['btbody']; } else { $button_box_height = 60; }

					if((isset($p_combo['etclr']) && $p_combo['etclr'] == 'yes') && isset($p_combo['tbpad'])){ $table_padding = (int)$p_combo['tbpad']; } else { $table_padding = 0; }

					if(isset($p_combo['vbody']) && $p_combo['vbody']) { $video_box_height = (int)$p_combo['vbody']; } else { $video_box_height = 150; }

					if(isset($p_combo['bwidth']) && (int)$p_combo['bwidth'] < 120) { $button_padding = (int)$p_combo['bwidth'] * 0.0833; } else { $button_padding = 10; }

					if(isset($p_combo['colgap']) && $p_combo['colgap']) { $margin = $p_combo['colgap']; } else { $margin = 0; }

					if(isset($p_combo['capwidth']) && $p_combo['capwidth']) { $caption_width = (float)$p_combo['capwidth']; } else { $caption_width = 19; }

					/* Calculating responsive width of the pricing table for both tablet and mobile view.
					* Here, we are calculating responsive width both for caption column and package column.
					*/
					if($shortcode == 1) {
						if($p_combo) {
							if($p_combo['autocol'] == 'no') {
								if($p_count > $maximum_column) {
									$width = ($container_width)/$maximum_column . '%';
									$cap_width = ($container_width)/($maximum_column+1) . '%';
								} else {
									$width = ($container_width)/$p_count . '%';
									$cap_width = ($container_width)/($p_count+1) . '%';
								}
							} else {
								if($p_combo['ftcap'] == "yes") {
									$single_column_width = ((100 - $caption_width) - ($margin * (12-1)))/12;
								} else {
									$single_column_width = (100 - ($margin * (12-1)))/12;
								}
								$width = ($single_column_width * (12 / $maximum_column)) + ($margin * ((12 / $maximum_column) - 1)) . '%';
								$cap_width = $caption_width . '%';
							}
							$tab_width = (((100 - ($margin * (12-1)))/12) * (12 / 2)) + ($margin * ((12 / 2) - 1)) . '%';
							$mob_width = ((100/12 * (12 / 1))) . '%';
						}
					}
					if($shortcode == 1) {
						/* Responsive View */
						if($p_combo['ftcap'] == "yes") {
							if($p_combo['pbrad'] != '' && $p_combo['pbrad'] != 0) {
								if($p_combo['btompr'] == 'yes') {
									$custom_css .= '@media only screen and (max-width : 1024px) {'.PHP_EOL;
									$custom_css .= '#'.$tableID.' .package_details li.color-1.title_top_radius,#'.$tableID.' .package_details.details-1 {-moz-border-radius-topleft:'.$p_combo['pbrad'].'px !important'.';-webkit-border-top-left-radius:'.$p_combo['pbrad'].'px !important'.';-khtml-border-top-left-radius:'.$p_combo['pbrad'].'px !important'.';border-top-left-radius: '.$p_combo['pbrad'].'px !important'.';}
									}'.PHP_EOL;
									if($p_combo['envid'] == 'yes' && ($p_combo['opvid'] == 'vid-3' || $p_combo['opvid'] == 'vid-4')) {
										$custom_css .= '@media only screen and (min-width : 1024px) {'.PHP_EOL;
										$custom_css .= '#'.$tableID.' .package_details.package-1 li.video-1,#'.$tableID.' .package_details.package-1 li.video-1 iframe {-moz-border-radius-topleft:0;-webkit-border-top-left-radius:0;-khtml-border-top-left-radius:0;border-top-left-radius: 0;}
										}'.PHP_EOL;
									}
								} else {
									if(($p_combo['enimg'] == 'yes' && $p_combo['bgimg'] != 'yes') && ($p_combo['opimg'] == 'opt-3' || $p_combo['opimg'] == 'opt-4')) {
										$custom_css .= '@media only screen and (min-width : 1024px) {'.PHP_EOL;
										$custom_css .= '#'.$tableID.' .package_details.package-1 li.plan-1.top_price,#'.$tableID.' .package_details.package-1,#'.$tableID.' .package_details.package-1 li.plan-1.top_price img {-moz-border-radius-topleft:0 !important;-webkit-border-top-left-radius:0 !important;-khtml-border-top-left-radius:0 !important;border-top-left-radius: 0 !important;}
										}'.PHP_EOL;
									}
									if($p_combo['envid'] == 'yes' && ($p_combo['opvid'] == 'vid-3' || $p_combo['opvid'] == 'vid-4')) {
										$custom_css .= '@media only screen and (min-width : 1024px) {'.PHP_EOL;
										$custom_css .= '#'.$tableID.' .package_details.package-1 li.video-1,#'.$tableID.' .package_details.package-1 li.video-1 iframe {-moz-border-radius-topleft:0 !important;-webkit-border-top-left-radius:0 !important;-khtml-border-top-left-radius:0 !important;border-top-left-radius: 0 !important;}
										}'.PHP_EOL;
									}
								}
							}
						}
						$custom_css .= '@media only screen and (max-width : 767px) {'.PHP_EOL;
						if((isset($p_combo['togg3']) && $p_combo['togg3'] == 'yes') && (isset($p_combo['togg4']) && $p_combo['togg4'] == 'yes')) {
							$custom_css .= '#'.$tableID.' .toggle-slide{min-width:90%}'.PHP_EOL;
							$custom_css .= '#'.$tableID.' .toggle-four,#'.$tableID.' .toggle-three,#'.$tableID.' .toggle-two,#'.$tableID.' .toggle-one{width:25%;}'.PHP_EOL;
						}
						if(((isset($p_combo['togg3']) && $p_combo['togg3'] == 'yes') && (isset($p_combo['togg4']) && $p_combo['togg4'] != 'yes')) || ((isset($p_combo['togg3']) && $p_combo['togg3'] != 'yes') && (isset($p_combo['togg4']) && $p_combo['togg4'] == 'yes'))) {
							$custom_css .= '#'.$tableID.' .toggle-slide{min-width:90%}'.PHP_EOL;
							$custom_css .= '#'.$tableID.' .toggle-four,#'.$tableID.' .toggle-three,#'.$tableID.' .toggle-two,#'.$tableID.' .toggle-one{width:33.3333334%;}'.PHP_EOL;
						}
						$spt1 = isset($p_combo['sptext']) ? $p_combo['sptext'] : '';
						$spt2 = isset($p_combo['sptext2']) ? $p_combo['sptext2'] : '';
						$spt3 = isset($p_combo['sptext3']) ? $p_combo['sptext3'] : '';
						$l_height = (isset($p_combo['ptheight']) && $p_combo['ptheight']) ? (int)$p_combo['ptheight'] : 40;
						if($spt1 != '' && $spt2 != '' && $spt3 == '') {
							if($l_height != '') {
								$custom_css .= '#'.$tableID.' .toggle-three,#'.$tableID.' .toggle-two{line-height:'.((24*$l_height)/40).'px!important}'.PHP_EOL;
							}
							$custom_css .= '#'.$tableID.' .toggle-three span,#'.$tableID.' .toggle-two span{position:absolute;top:18px;left:50%;width:100%;padding:0!important;margin:0;transform:translateX(-50%)}'.PHP_EOL;
						} elseif($spt1 != '' && $spt2 == '' && $spt3 != '') {
							if($l_height != '') {
								$custom_css .= '#'.$tableID.' .toggle-four,#'.$tableID.' .toggle-two{line-height:'.((24*$l_height)/40).'px!important}'.PHP_EOL;
							}
							$custom_css .= '#'.$tableID.' .toggle-four span,#'.$tableID.' .toggle-two span{position:absolute;top:18px;left:50%;width:100%;padding:0!important;margin:0;transform:translateX(-50%)}'.PHP_EOL;
						} elseif($spt1 == '' && $spt2 != '' && $spt3 != '') {
							if($l_height != '') {
								$custom_css .= '#'.$tableID.' .toggle-four,#'.$tableID.' .toggle-three{line-height:'.((24*$l_height)/40).'px!important}'.PHP_EOL;
							}
							$custom_css .= '#'.$tableID.' .toggle-four span,#'.$tableID.' .toggle-three span{position:absolute;top:18px;left:50%;width:100%;padding:0!important;margin:0;transform:translateX(-50%)}'.PHP_EOL;
						} elseif($spt1 != '' && $spt2 == '' && $spt3 == '') {
							if($l_height != '') {
								$custom_css .= '#'.$tableID.' .toggle-two{line-height:'.((24*$l_height)/40).'px!important}'.PHP_EOL;
							}
							$custom_css .= '#'.$tableID.' .toggle-two span{position:absolute;top:18px;left:50%;width:100%;padding:0!important;margin:0;transform:translateX(-50%)}'.PHP_EOL;
						} elseif($spt1 == '' && $spt2 != '' && $spt3 == '') {
							if($l_height != '') {
								$custom_css .= '#'.$tableID.' .toggle-three{line-height:'.((24*$l_height)/40).'px!important}'.PHP_EOL;
							}
							$custom_css .= '#'.$tableID.' .toggle-three span{position:absolute;top:18px;left:50%;width:100%;padding:0!important;margin:0;transform:translateX(-50%)}'.PHP_EOL;
						} elseif($spt1 == '' && $spt2 == '' && $spt3 != '') {
							if($l_height != '') {
								$custom_css .= '#'.$tableID.' .toggle-four{line-height:'.((24*$l_height)/40).'px!important}'.PHP_EOL;
							}
							$custom_css .= '#'.$tableID.' .toggle-four span{position:absolute;top:18px;left:50%;width:100%;padding:0!important;margin:0;transform:translateX(-50%)}'.PHP_EOL;
						} else {
							if($l_height != '') {
								$custom_css .= '#'.$tableID.' .toggle-four,#'.$tableID.' .toggle-three,#'.$tableID.' .toggle-two{line-height:'.((24*$l_height)/40).'px!important}'.PHP_EOL;
							}
							$custom_css .= '#'.$tableID.' .toggle-four span,#'.$tableID.' .toggle-three span,#'.$tableID.' .toggle-two span{position:absolute;top:18px;left:50%;width:100%;padding:0!important;margin:0;transform:translateX(-50%)}'.PHP_EOL;
						}
						$custom_css .= '}'.PHP_EOL;
						$custom_css .= '@media only screen and (max-width : 480px) {'.PHP_EOL;
						$custom_css .= '#'.$tableID.' .package_details {width: '.$mob_width.';margin-top: 40px !important}'.PHP_EOL;
						/* if($p_combo['togg3'] == 'yes') {
							$custom_css .= '#'.$tableID.' .toggle-three,#'.$tableID.' .toggle-two,#'.$tableID.' .toggle-one{width:33.3333334%;}'.PHP_EOL;
						} */
						$custom_css .= '}'.PHP_EOL;
						$custom_css .= '@media only screen and (min-width : 481px) and (max-width: 1023px) {'.PHP_EOL;
							$custom_css .= '#'.$tableID.' .package_details {width: '.$tab_width.'}'.PHP_EOL;
							if($p_combo['tbpad'] > 0) {
								$custom_css .= '#'.$tableID.' .package_details:nth-of-type(2n+1) {padding-right:'.$p_combo['tbpad'].'px !important}'.PHP_EOL;
							}
							if($p_combo['ftcap'] == "yes") {
								$custom_css .= '.wrcpt_content .wrc_pricing_table .package_details:nth-of-type(2n) span.text_tooltip:hover:after,.wrcpt_content .wrc_pricing_table .package_details:nth-of-type(2n) span.icon_tooltip:hover:after{left:-30px!important;right:auto!important}'.PHP_EOL;
								$custom_css .= '.wrcpt_content .wrc_pricing_table .package_details:nth-of-type(2n+1) span.text_tooltip:hover:after,.wrcpt_content .wrc_pricing_table .package_details:nth-of-type(2n+1) span.icon_tooltip:hover:after{left:auto!important;right:-30px!important}'.PHP_EOL;
							}
						$custom_css .= '}'.PHP_EOL;
						
						/* Cut Prices Font size */
						if((isset($p_combo['cutprs']) && $p_combo['cutprs'])) {
							$custom_css .= '#'.$tableID.' .package_details h2 span.price_cut {font-size: '.$p_combo['cutprs'].'}'.PHP_EOL;
						}
						if($p_combo['ftcap'] != "yes") {
							if($p_combo['autocol'] == 'yes') {
								$custom_css .= '@media only screen and (min-width : 481px) and (max-width: 1023px) {'.PHP_EOL;
								$custom_css .= '#'.$tableID.' .package_details:nth-of-type(2n+1) {margin-right:'.$p_combo['colgap'].'%}'.PHP_EOL;
								$custom_css .= '}'.PHP_EOL;
							}
							$custom_css .= '@media screen and (min-width: 1024px) {'.PHP_EOL;
							$custom_css .= '#'.$tableID.' .package_details {';if($p_combo['autocol'] == 'yes') { $custom_css .= 'margin-right:'.$p_combo['colgap'].'%;'; } $custom_css .= 'width: '.$width.'}'.PHP_EOL;
							$custom_css .= '#'.$tableID.' .package_details:nth-of-type('.$maximum_column.'n+'.$maximum_column.') {margin-right: 0}'.PHP_EOL;
							$custom_css .= '}'.PHP_EOL;
						} else {
							if($p_combo['autocol'] == 'yes') {
								$custom_css .= '@media only screen and (min-width : 481px) and (max-width: 1023px) {'.PHP_EOL;
								$custom_css .= '#'.$tableID.' .package_details:nth-of-type(2n+2) {margin-right:'.$p_combo['colgap'].'%}'.PHP_EOL;
								$custom_css .= '}'.PHP_EOL;
							}
							$custom_css .= '@media screen and (min-width: 1024px) {'.PHP_EOL;
								$custom_css .= '#'.$tableID.' .package_caption {width: '.$cap_width.'}'.PHP_EOL;
								if($p_combo['pgfont'] || $global_font1 || $p_combo['ctsize'] || $p_combo['ctcolor'] || $p_combo['cttdir']) {
									if($p_combo['btompr'] != 'yes') {
										if(isset($p_combo['hdptnm']) && $p_combo['hdptnm'] == 'yes') {
											$custom_css .= '#'.$tableID.' .package_caption li.pricing_table_plan h3.caption,#'.$tableID.' .package_caption li.pricing_table_video h3.caption {display:none}'.PHP_EOL;
										} else {
											$custom_css .= '#'.$tableID.' .package_caption li.pricing_table_plan h3.caption,#'.$tableID.' .package_caption li.pricing_table_video h3.caption {'; if($p_combo['pgfont']) { $custom_css .= 'font-family: '.$p_combo['pgfont'].';'; } else { if($global_font1){ $custom_css .= 'font-family: '.$global_font1.';'; }} if($p_combo['ctsize']) { $custom_css .= 'font-size: '.$p_combo['ctsize'].';'; } if($p_combo['ctcolor']) { $custom_css .= 'color:'.$p_combo['ctcolor'].';'; } if($p_combo['cttdir']) { $custom_css .= 'text-align:'.$p_combo['cttdir'].';'; } $custom_css .= '}'.PHP_EOL;
										}
									} else {
										if(isset($p_combo['hdptnm']) && $p_combo['hdptnm'] == 'yes') {
											$custom_css .= '#'.$tableID.' .package_caption li.pricing_table_plan h3.caption,#'.$tableID.' .package_caption li.pricing_table_video h3.caption {display:none}'.PHP_EOL;
										} else {
											$custom_css .= '#'.$tableID.' .package_caption li.pricing_table_title h3.caption,#'.$tableID.' .package_caption li.pricing_table_plan h3.caption,#'.$tableID.' .package_caption li.pricing_table_video h3.caption {'; if($p_combo['pgfont']) { $custom_css .= 'font-family: '.$p_combo['pgfont'].';'; } else { if($global_font1){ $custom_css .= 'font-family: '.$global_font1.';'; }} if($p_combo['ctsize']) { $custom_css .= 'font-size: '.$p_combo['ctsize'].';'; } if($p_combo['ctcolor']) { $custom_css .= 'color:'.$p_combo['ctcolor'].';'; } if($p_combo['cttdir']) { $custom_css .= 'text-align:'.$p_combo['cttdir'].';'; } $custom_css .= '}'.PHP_EOL;
										}
									}
								}
								$custom_css .= '#'.$tableID.' .package_details {'; if($p_combo['autocol'] == 'yes') { $custom_css .= 'width: '.$width.';margin-right:'.$p_combo['colgap'].'%;'; } else { $custom_css .= 'width: '.$cap_width.';'; } $custom_css .= '}'.PHP_EOL;
								$custom_css .= '#'.$tableID.' .package_details:nth-of-type('.($maximum_column + 1).'n+'.($maximum_column + 1).') {margin-right: 0}'.PHP_EOL;
								$custom_css .= '#'.$tableID.' .package_details:nth-child('.$maximum_column.'n+1) span.text_tooltip:hover:after,#'.$tableID.' .package_details:nth-child('.$maximum_column.'n+1) span.icon_tooltip:hover:after{left:auto;right:-30px}'.PHP_EOL;
								if($p_combo['envid'] != 'yes') {
									if($p_combo['tbody']) {
										$custom_css .= '#'.$tableID.' .package_caption li.pricing_table_title {height:'.$p_combo['tbody'].'}'.PHP_EOL;
									}
									if($p_combo['enimg'] != 'yes') {
										if($p_combo['pbody']) {
											$custom_css .= '#'.$tableID.' .package_caption li.pricing_table_plan {height: '.$p_combo['pbody'].';line-height: '.$p_combo['pbody'].';}'.PHP_EOL;
										}
									} else {
										$custom_css .= '#'.$tableID.' .package_caption li.pricing_table_plan {height: '.$image_height_a.'px;line-height: '.$image_height_a.'px;}'.PHP_EOL;
									}
								} else {
									if($p_combo['opvid'] == 'vid-1') {
										if($p_combo['tbody']) {
											$custom_css .= '#'.$tableID.' .package_caption li.pricing_table_title {height: '.$p_combo['tbody'].'}'.PHP_EOL;
										}
										if($p_combo['btompr'] == 'yes') {
											$custom_css .= '#'.$tableID.' .package_caption li.pricing_table_plan {height: '.$video_box_height.'px;line-height: '.$video_box_height.'px;margin:0}'.PHP_EOL;
										} else {
											$custom_css .= '#'.$tableID.' .package_caption li.pricing_table_plan {height: '.$video_box_height+$price_box_height.'px;line-height: '.$video_box_height+$price_box_height.'px}'.PHP_EOL;
										}
									} elseif($p_combo['opvid'] == 'vid-2') {
										if($p_combo['tbody']) {
											$custom_css .= '#'.$tableID.' .package_caption li.pricing_table_title {height: '.$p_combo['tbody'].'}'.PHP_EOL;
										}
										$custom_css .= '#'.$tableID.' .package_caption li.pricing_table_plan {height: '.$video_box_height.'px;line-height: '.$video_box_height.'px;margin:0;}'.PHP_EOL;
									} elseif($p_combo['opvid'] == 'vid-3') {
										$custom_css .= '#'.$tableID.' .package_caption li.pricing_table_title {height: 0}'.PHP_EOL;
										if($p_combo['btompr'] == 'yes') {
											$custom_css .= '#'.$tableID.' .package_caption li.pricing_table_plan {height: '.$video_box_height.'px;line-height: '.$video_box_height.'px;margin:0;}'.PHP_EOL;
										} else {
											$custom_css .= '#'.$tableID.' .package_caption li.pricing_table_plan {height: '.$video_box_height.'px;line-height: '.$video_box_height.'px;margin:'.($price_box_height-2).'px 0 0;}'.PHP_EOL;
										}
									} else {
										$custom_css .= '#'.$tableID.' .package_caption li.pricing_table_title {height: 0}'.PHP_EOL;
										$custom_css .= '#'.$tableID.' .package_caption li.pricing_table_plan {height: '.$video_box_height.'px;line-height: '.$video_box_height.'px;margin:0;}'.PHP_EOL;
									}
								}
								if($p_combo['btbody']) {
									$custom_css .= '#'.$tableID.' .package_caption li.pricing_table_button {height:'.$p_combo['btbody'].';line-height: 100%}'.PHP_EOL;
								}
								$custom_css .= '#'.$tableID.' .package_caption li.feature_style_2 span.fa-icon,#'.$tableID.' .package_caption li.feature_style_3 span.fa-icon {color:'.$p_combo['cftcolor'].'}'.PHP_EOL;
								$custom_css .= '#'.$tableID.' .package_caption li.feature_style_2 span.caption,#'.$tableID.' .package_caption li.feature_style_3 span.caption,#'.$tableID.' .package_caption li.feature_style_2 span.cap_tooltip,#'.$tableID.' .package_caption li.feature_style_3 span.cap_tooltip,#'.$tableID.' .package_details li.feature_style_1 span {'; if($p_combo['cftsize']) { $custom_css .= 'font-size: '.$p_combo['cftsize'].';'; } $custom_css .= 'color:'.$p_combo['cftcolor'].';}'.PHP_EOL;
								$custom_css .= '#'.$tableID.' .package_caption li.feature_style_2 span.caption a,#'.$tableID.' .package_caption li.feature_style_3 span.caption a {color:'.$p_combo['furlclr'].'}'.PHP_EOL;
								$custom_css .= '#'.$tableID.' .package_caption li.feature_style_2 span.caption a:hover,#'.$tableID.' .package_caption li.feature_style_3 span.caption a:hover {color:'.$p_combo['furlhvr'].'}'.PHP_EOL;
								if($p_combo['ftbody']) {
									$custom_css .= '#'.$tableID.' .package_caption li.feature_style_2,#'.$tableID.' .package_caption li.feature_style_3 {height: '.$p_combo['ftbody'].';line-height: '.$p_combo['ftbody'].';}'.PHP_EOL;
								}
								$custom_css .= '#'.$tableID.' .package_caption li.feature_style_2 {background-color: '.$p_combo['capbg2'].';}'.PHP_EOL;
								$custom_css .= '#'.$tableID.' .package_caption li.feature_style_3 {background-color: '.$p_combo['capbg1'].';}'.PHP_EOL;
							$custom_css .= '}'.PHP_EOL;
						}
						/* End of responsive view */

						/* Custom Style for Pricing Table Settings */
						/* Container Width */
						if($p_combo['cwidth']) {
							$custom_css .= '#'.$tableID.' {width:'.$container_width.'%}'.PHP_EOL;
						}
						/* Primary Font */
						if(isset($p_combo['pgfont']) && $p_combo['pgfont']) {
							$custom_css .= '#'.$tableID.' .wrc_pricing_table {';if($p_combo['pgfont']) { $custom_css .= 'font-family: '.$p_combo['pgfont'].';'; }if(isset($p_combo['ptmtop']) && $p_combo['ptmtop']) { $custom_css .= 'margin-top: '.$p_combo['ptmtop'].'px;'; } $custom_css .= '}'.PHP_EOL;
						} else {
							if($global_font1) {
								$custom_css .= '#'.$tableID.' .wrc_pricing_table {font-family: '.$global_font1.';'; if(isset($p_combo['ptmtop']) && $p_combo['ptmtop']) { $custom_css .= 'margin-top: '.$p_combo['ptmtop'].'px;'; } $custom_css .= '}'.PHP_EOL;
							}
						}
						/* Category BG Color, Category Font Size, Category Height */
						if($p_combo['fcatbg'] || $p_combo['cfsize'] || $p_combo['ffnclr'] || $p_combo['fcbody']) {
							$custom_css .= '#'.$tableID.' .package_caption li.feature_cate_row,#'.$tableID.' .package_details li.feature_cate_row {'; if($p_combo['fcatbg']) { $custom_css .= 'background-color:'.$p_combo['fcatbg'].';'; } if($p_combo['cfsize']) { $custom_css .= 'font-size:'.$p_combo['cfsize'].';'; } if($p_combo['ffnclr']) { $custom_css .= 'color:'.$p_combo['ffnclr'].''; } $custom_css .= ';'; if($p_combo['fcbody']) { $custom_css .= 'height:'.$p_combo['fcbody'].';line-height:'.$p_combo['fcbody'].''; } $custom_css .= '}'.PHP_EOL;
						}
						/* Column Shadow */
						if($p_combo['colshad'] == 'yes') {
							$custom_css .= '#'.$tableID.' .package_details {-moz-box-shadow: 0px 0px 3px '.$p_combo['cscolor'].';-webkit-box-shadow: 0px 0px 3px '.$p_combo['cscolor'].';box-shadow: 0px 0px 3px '.$p_combo['cscolor'].'}'.PHP_EOL;
							$custom_css .= '#'.$tableID.' .package_details:hover {-moz-box-shadow: 0px 0px 3px '.$p_combo['cshcolor'].';-webkit-box-shadow: 0px 0px 3px '.$p_combo['cshcolor'].';box-shadow: 0px 0px 3px '.$p_combo['cshcolor'].'}'.PHP_EOL;
						}
						/* Caption Column Shadow */
						if($p_combo['cshade'] == 'yes') {
							$custom_css .= '#'.$tableID.' .package_caption {-moz-box-shadow: 0px 0px 3px '.$p_combo['cscolor'].';-webkit-box-shadow: 0px 0px 3px '.$p_combo['cscolor'].';box-shadow: 0px 0px 3px '.$p_combo['cscolor'].'}'.PHP_EOL;
						}
						/* Feature Icon */
						if($p_combo['enicon'] == "no") {
							$custom_css .= '#'.$tableID.' .package_details li.feature_style_1 .feature_lists {padding: 0 3px 0 5px}'.PHP_EOL;
						}
						/* Enlarge Column on Hover */
						if($p_combo['encol'] != "yes") {
							$custom_css .= '#'.$tableID.' .package_details:hover {-moz-transform: none;-webkit-transform: none;-o-transform: none;-ms-transform: none;transform: none}'.PHP_EOL;
						}
						/* Disable Shadow on Highlight */
						if($p_combo['dscol'] == "yes") {
							$custom_css .= '#'.$tableID.' .package_details:hover {box-shadow: none;}'.PHP_EOL;
						}
						/* Secondary Font for Caption Column */
						if($p_combo['sgfont']) {
							$custom_css .= '#'.$tableID.' .package_caption li.feature_style_2,#'.$tableID.' .package_caption li.feature_style_3,#'.$tableID.' .package_details li.feature_style_1 {font-family: '.$p_combo['sgfont'].'}'.PHP_EOL;
						} else {
							if($global_font2) {
								$custom_css .= '#'.$tableID.' .package_caption li.feature_style_2,#'.$tableID.' .package_caption li.feature_style_3,#'.$tableID.' .package_details li.feature_style_1 {font-family: '.$global_font2.'}'.PHP_EOL;
							}
						}
						/* ToolTip BG Color, ToolTip Font Color, Tooltip Width */
						if($p_combo['ttbg'] || $p_combo['tttext'] || $p_combo['ttwidth']) {
							$custom_css .= '#'.$tableID.' .package_caption span.cap_tooltip:hover:after,#'.$tableID.' .package_details span.text_tooltip:hover:after,#'.$tableID.' .package_details span.icon_tooltip:hover:after {'; if($p_combo['ttbg']) { $custom_css .= 'background: '.$p_combo['ttbg'].';'; } if($p_combo['tttext']) { $custom_css .= 'color: '.$p_combo['tttext'].';'; } if($p_combo['ttwidth']) { $custom_css .= 'width: '.$p_combo['ttwidth']; } $custom_css .= '}'.PHP_EOL;
						}
						/**
						* @entips - Enable Feature Tooltips
						* @cftdir - Caption Column Font Direction
						* @encbor - Enable Caption Column Border
						* @ccborder - Caption Feature Border Color
						*/
						if($p_combo['entips'] == 'yes' || $p_combo['cftdir'] || $p_combo['encbor'] == 'yes' || $p_combo['ccborder']) {
							$custom_css .= '#'.$tableID.' .package_caption li.feature_style_2,#'.$tableID.' .package_caption li.feature_style_3 {'; if($p_combo['entips'] == 'yes') { $custom_css .= 'padding-right: 30px;'; } if($p_combo['cftdir']) { $custom_css .= 'text-align: '.$p_combo['cftdir']; } if($p_combo['encbor'] == 'yes' && $p_combo['ccborder']) { $custom_css .= ';border: 1px solid '.$p_combo['ccborder'].';'; /* if($p_combo['ccborder']) { $custom_css .= 'border-bottom: 2px solid '.$p_combo['ccborder']; } */} $custom_css .= '}'.PHP_EOL;
						}
						/**
						* @encbor - Enable Caption Column Border
						* @ccborder - Caption Feature Border Color
						*/
						if($p_combo['etclr'] == 'yes' && $p_combo['encbor'] == 'yes' && $p_combo['topbut'] != 'yes' && $p_combo['captbg'] != 'yes') {
							if($p_combo['ccborder']) {
								$custom_css .= '#'.$tableID.' .package_caption li.pricing_table_plan::before,#'.$tableID.' .package_caption li.pricing_table_video::before{content:"";position:absolute;left:0;bottom:-'.(($p_combo['cbrad']*2)-2).'px;width:100%;height:'.($p_combo['cbrad']*2).'px;background-color:'.$p_combo['ccborder'].' !important;border-top-left-radius:'.($p_combo['cbrad']+5).'px}'.PHP_EOL;
							}
						}
						/**
						* @encbor - Enable Caption Column Border
						* @btompr - Display Price at the Bottom
						* @ccborder - Caption Feature Border Color
						*/
						/* if($p_combo['encbor'] == 'yes' && $p_combo['btompr'] == 'yes') {
							$custom_css .= '#'.$tableID.' .package_details li.pricing_table_plan {border-top: 2px solid '.$p_combo['ccborder'].'}'.PHP_EOL;
						} */
						/* Display Price at the Bottom */
						if($p_combo['btompr'] == 'yes') {
							if($p_combo['enimg'] != 'yes' && $p_combo['envid'] != 'yes') {
								$custom_css .= '#'.$tableID.' .package_caption li.pricing_table_plan {display: none}'.PHP_EOL;
							}
							if($p_combo['enimg'] == 'yes' && $p_combo['bgimg'] != 'yes') {
								$custom_css .= '#'.$tableID.' .package_details li.top_price h2 {display: none}'.PHP_EOL;
								$custom_css .= '#'.$tableID.' .package_caption li.pricing_table_plan{'; if($p_combo['ftcap'] != 'yes' && $p_combo['opimg'] == 'opt-4') { $custom_css .= 'height:'.($image_height_a-$title_box_height).'px !important;line-height:'.($image_height_a-$title_box_height).'px !important'; } else { if($p_combo['ftcap'] != 'yes') { $custom_css .= 'height:'.$image_height_a.'px !important;line-height:'.$image_height_a.'px !important'; }} $custom_css .= '}'.PHP_EOL;
							} else {
								$custom_css .= '#'.$tableID.' .package_details li.top_price {display: none}'.PHP_EOL;
							}
						/* Display Price at the Top */
						} else {
							if(($p_combo['enimg'] == 'yes' && $p_combo['bgimg'] != 'yes') && $p_combo['opimg'] == 'opt-4' && $p_combo['ftcap'] != 'yes') {
								$custom_css .= '#'.$tableID.' .package_caption li.pricing_table_plan {height: '.($image_height_a-$title_box_height).'px;line-height: '.($image_height_a-$title_box_height).'px;}'.PHP_EOL;
							}
						}
						/* Hide Caption Feature Name */
						if($p_combo['hidecfn'] == 'yes') {
							$custom_css .= '#'.$tableID.' .package_caption li.feature_style_2 .caption_lists,#'.$tableID.' .package_caption li.feature_style_3 .caption_lists {display: none}'.PHP_EOL;
						}
						/* Enable Pricing Toggles */
						if($p_combo['mcurr'] == 'yes') {
							if($p_combo['tgpos']) {
								$custom_css .= '#'.$tableID.' .toggle {text-align: '.$p_combo['tgpos'].'}'.PHP_EOL;
							}
							if($p_combo['ptwidth']) {
								$custom_css .= '#'.$tableID.' .toggle-slide {width: '.$p_combo['ptwidth'].'}'.PHP_EOL;
							}
							if($p_combo['ptnbg'] || $p_combo['ptntext']) {
								$custom_css .= '#'.$tableID.' .toggle-four,#'.$tableID.' .toggle-three,#'.$tableID.' .toggle-two,#'.$tableID.' .toggle-select .toggle-one {'; if($p_combo['ptnbg']) { $custom_css .= 'background: -moz-linear-gradient('.$ptn_light.', '.$p_combo['ptnbg'].');background: -webkit-gradient(linear, center top, center bottom, from('.$ptn_light.'), to('.$p_combo['ptnbg'].'));background: -webkit-linear-gradient('.$ptn_light.', '.$p_combo['ptnbg'].');background: -o-linear-gradient('.$ptn_light.', '.$p_combo['ptnbg'].');background: -ms-linear-gradient('.$ptn_light.', '.$p_combo['ptnbg'].');filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=\''.$ptn_light.'\', endColorstr=\''.$p_combo['ptnbg'].'\',GradientType=1);-ms-filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=\''.$ptn_light.'\', endColorstr=\''.$p_combo['ptnbg'].'\',GradientType=1);background: linear-gradient('.$ptn_light.', '.$p_combo['ptnbg'].');'; } if($p_combo['ptntext']) { $custom_css .= 'color: '.$p_combo['ptntext']; } $custom_css .= '}'.PHP_EOL;
							}
							if($p_combo['ptabg'] || $p_combo['ptatext']) {
								$custom_css .= '#'.$tableID.' .toggle-one,#'.$tableID.' .toggle-select .active {'; if($p_combo['ptabg']) { $custom_css .= 'background: -moz-linear-gradient('.$pta_light.', '.$p_combo['ptabg'].');background: -webkit-gradient(linear, center top, center bottom, from('.$pta_light.'), to('.$p_combo['ptabg'].'));background: -webkit-linear-gradient('.$pta_light.', '.$p_combo['ptabg'].');background: -o-linear-gradient('.$pta_light.', '.$p_combo['ptabg'].');background: -ms-linear-gradient('.$pta_light.', '.$p_combo['ptabg'].');filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=\''.$pta_light.'\', endColorstr=\''.$p_combo['ptabg'].'\',GradientType=1);-ms-filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=\''.$pta_light.'\', endColorstr=\''.$p_combo['ptabg'].'\',GradientType=1);background: linear-gradient('.$pta_light.', '.$p_combo['ptabg'].');'; } if($p_combo['ptatext']) { $custom_css .= 'color: '.$p_combo['ptatext']; } $custom_css .= '}'.PHP_EOL;
							}
							if($p_combo['ptnbg'] || $p_combo['ptabg']) {
								if((isset($p_combo['togg3']) && $p_combo['togg3'] == 'yes') && (isset($p_combo['togg4']) && $p_combo['togg4'] == 'yes')) {
									$custom_css .= '#'.$tableID.' .toggle-one,#'.$tableID.' .toggle-two,#'.$tableID.' .toggle-three {border-right: 1px solid '.$ptn_dark.';}'.PHP_EOL;
								} else {
									if((isset($p_combo['togg3']) && $p_combo['togg3'] == 'yes') || (isset($p_combo['togg4']) && $p_combo['togg4'] == 'yes')) {
										$custom_css .= '#'.$tableID.' .toggle-one,#'.$tableID.' .toggle-two {border-right: 1px solid '.$ptn_dark.'}'.PHP_EOL;
									} else {
										$custom_css .= '#'.$tableID.' .toggle-one,#'.$tableID.' .toggle-two {border-right:0}'.PHP_EOL;
									}
								}
								$custom_css .= '#'.$tableID.' .toggle-two,#'.$tableID.' .toggle-three,#'.$tableID.' .toggle-four {border-left: 1px solid '.$ptn_light.';}'.PHP_EOL;
								/* $custom_css .= '#'.$tableID.' .toggle-select .active {border-right: 1px solid '.$pta_dark.';}'.PHP_EOL; */
								$custom_css .= '#'.$tableID.' .toggle-two.active,#'.$tableID.' .toggle-three.active,#'.$tableID.' .toggle-four.active {border-left: 1px solid '.$pta_light.';}'.PHP_EOL;
							}
							if($p_combo['ptsize'] || $p_combo['ptheight']) {
								$custom_css .= '#'.$tableID.' .toggle-four,#'.$tableID.' .toggle-three,#'.$tableID.' .toggle-two,#'.$tableID.' .toggle-one {'; if($p_combo['ptsize']) { $custom_css .= 'font-size: '.$p_combo['ptsize']; } if($p_combo['ptheight']) { $custom_css .= ';height: '.$p_combo['ptheight'].';line-height: '.$p_combo['ptheight']; } $custom_css .= '}'.PHP_EOL;
							}
							if($p_combo['ptsptext'] || $p_combo['ptspsize']) {
								$custom_css .= '#'.$tableID.' .toggle-four span,#'.$tableID.' .toggle-three span,#'.$tableID.' .toggle-two span {'; if($p_combo['ptspsize']) { $custom_css .= 'font-size: '.$p_combo['ptspsize']; } if($p_combo['ptsptext']) { $custom_css .= ';color: '.$p_combo['ptsptext']; } $custom_css .= '}'.PHP_EOL;
							}
						}
						/* ToolTips Background Color */
						if($p_combo['ttbg']) {
							$custom_css .= '#'.$tableID.' .package_details span.text_tooltip:hover:before,#'.$tableID.' .package_details span.icon_tooltip:hover:before {border-color: '.$p_combo['ttbg'].' transparent;}'.PHP_EOL;
							$custom_css .= '#'.$tableID.' .package_caption span.cap_tooltip:hover:before {border-color: transparent '.$p_combo['ttbg'].' transparent transparent}'.PHP_EOL;
						}
						/* Align Tick or Cross Icon at Left */
						if($p_combo['tcleft'] == 'yes') {
							if($p_combo['enfatc'] == 'yes') {
								$custom_css .= '#'.$tableID.' .package_details span.ic-tick,#'.$tableID.' .package_details span.ic-cross {float: left;margin-right: 5px}'.PHP_EOL;
							} else {
								$custom_css .= '#'.$tableID.' .package_details span.feature_yes,#'.$tableID.' .package_details span.feature_no {float: left;margin-right: 5px}'.PHP_EOL;
							}
						}
						/* Tick Icon */
						if($p_combo['tick'] == "tick-10") {
							$custom_css .= '#'.$tableID.' .package_details span.feature_yes:before {background: url('.plugins_url( '../images/wrcpt-buttons.png', __FILE__ ).') no-repeat -340px -41px}'.PHP_EOL;
						} elseif($p_combo['tick'] == "tick-9") {
							$custom_css .= '#'.$tableID.' .package_details span.feature_yes:before {background: url('.plugins_url( '../images/wrcpt-buttons.png', __FILE__ ).') no-repeat -305px -41px}'.PHP_EOL;
						} elseif($p_combo['tick'] == "tick-8") {
							$custom_css .= '#'.$tableID.' .package_details span.feature_yes:before {background: url('.plugins_url( '../images/wrcpt-buttons.png', __FILE__ ).') no-repeat -270px -41px}'.PHP_EOL;
						} elseif($p_combo['tick'] == "tick-7") {
							$custom_css .= '#'.$tableID.' .package_details span.feature_yes:before {background: url('.plugins_url( '../images/wrcpt-buttons.png', __FILE__ ).') no-repeat -235px -42px}'.PHP_EOL;
						} elseif($p_combo['tick'] == "tick-6") {
							$custom_css .= '#'.$tableID.' .package_details span.feature_yes:before {background: url('.plugins_url( '../images/wrcpt-buttons.png', __FILE__ ).') no-repeat -200px -40px}'.PHP_EOL;
						} elseif($p_combo['tick'] == "tick-5") {
							$custom_css .= '#'.$tableID.' .package_details span.feature_yes:before {background: url('.plugins_url( '../images/wrcpt-buttons.png', __FILE__ ).') no-repeat -129px -40px}'.PHP_EOL;
						} elseif($p_combo['tick'] == "tick-4") {
							$custom_css .= '#'.$tableID.' .package_details span.feature_yes:before {background: url('.plugins_url( '../images/wrcpt-buttons.png', __FILE__ ).') no-repeat -165px -42px}'.PHP_EOL;
						} elseif($p_combo['tick'] == "tick-3") {
							$custom_css .= '#'.$tableID.' .package_details span.feature_yes:before {background: url('.plugins_url( '../images/wrcpt-buttons.png', __FILE__ ).') no-repeat -95px -40px}'.PHP_EOL;
						} elseif($p_combo['tick'] == "tick-2") {
							$custom_css .= '#'.$tableID.' .package_details span.feature_yes:before {background: url('.plugins_url( '../images/wrcpt-buttons.png', __FILE__ ).') no-repeat -60px -41px}'.PHP_EOL;
						} else {
							$custom_css .= '#'.$tableID.' .package_details span.feature_yes:before {background: url('.plugins_url( '../images/wrcpt-buttons.png', __FILE__ ).') no-repeat -24px -41px}'.PHP_EOL;
						}
						/* Cross Icon */
						if($p_combo['cross'] == "cross-10") {
							$custom_css .= '#'.$tableID.' .package_details span.feature_no:before {background: url('.plugins_url( '../images/wrcpt-buttons.png', __FILE__ ).') no-repeat -340px -91px}'.PHP_EOL;
						} elseif($p_combo['cross'] == "cross-9") {
							$custom_css .= '#'.$tableID.' .package_details span.feature_no:before {background: url('.plugins_url( '../images/wrcpt-buttons.png', __FILE__ ).') no-repeat -305px -91px}'.PHP_EOL;
						} elseif($p_combo['cross'] == "cross-8") {
							$custom_css .= '#'.$tableID.' .package_details span.feature_no:before {background: url('.plugins_url( '../images/wrcpt-buttons.png', __FILE__ ).') no-repeat -270px -91px}'.PHP_EOL;
						} elseif($p_combo['cross'] == "cross-7") {
							$custom_css .= '#'.$tableID.' .package_details span.feature_no:before {background: url('.plugins_url( '../images/wrcpt-buttons.png', __FILE__ ).') no-repeat -234px -91px}'.PHP_EOL;
						} elseif($p_combo['cross'] == "cross-6") {
							$custom_css .= '#'.$tableID.' .package_details span.feature_no:before {background: url('.plugins_url( '../images/wrcpt-buttons.png', __FILE__ ).') no-repeat -200px -91px}'.PHP_EOL;
						} elseif($p_combo['cross'] == "cross-5") {
							$custom_css .= '#'.$tableID.' .package_details span.feature_no:before {background: url('.plugins_url( '../images/wrcpt-buttons.png', __FILE__ ).') no-repeat -165px -91px}'.PHP_EOL;
						} elseif($p_combo['cross'] == "cross-4") {
							$custom_css .= '#'.$tableID.' .package_details span.feature_no:before {background: url('.plugins_url( '../images/wrcpt-buttons.png', __FILE__ ).') no-repeat -129px -91px}'.PHP_EOL;
						} elseif($p_combo['cross'] == "cross-3") {
							$custom_css .= '#'.$tableID.' .package_details span.feature_no:before {background: url('.plugins_url( '../images/wrcpt-buttons.png', __FILE__ ).') no-repeat -95px -91px}'.PHP_EOL;
						} elseif($p_combo['cross'] == "cross-2") {
							$custom_css .= '#'.$tableID.' .package_details span.feature_no:before {background: url('.plugins_url( '../images/wrcpt-buttons.png', __FILE__ ).') no-repeat -59px -90px}'.PHP_EOL;
						} else {
							$custom_css .= '#'.$tableID.' .package_details span.feature_no:before {background: url('.plugins_url( '../images/wrcpt-buttons.png', __FILE__ ).') no-repeat -24px -91px}'.PHP_EOL;
						}
						/* Star Icon to Show */
						if($p_combo['fstar'] == "star-1") {
							$custom_css .= '#'.$tableID.' .package_details span.feature_star:before {background: url('.plugins_url( '../images/wrcpt-star.png', __FILE__ ).') no-repeat -20px -20px}'.PHP_EOL;
							$custom_css .= '#'.$tableID.' .package_details span.star_empty:before {background: url('.plugins_url( '../images/wrcpt-star.png', __FILE__ ).') no-repeat -20px -64px}'.PHP_EOL;
						} elseif($p_combo['fstar'] == "star-2") {
							$custom_css .= '#'.$tableID.' .package_details span.feature_star:before {background: url('.plugins_url( '../images/wrcpt-star.png', __FILE__ ).') no-repeat -55px -20px}'.PHP_EOL;
							$custom_css .= '#'.$tableID.' .package_details span.star_empty:before {background: url('.plugins_url( '../images/wrcpt-star.png', __FILE__ ).') no-repeat -55px -64px}'.PHP_EOL;
						} elseif($p_combo['fstar'] == "star-3") {
							$custom_css .= '#'.$tableID.' .package_details span.feature_star:before {background: url('.plugins_url( '../images/wrcpt-star.png', __FILE__ ).') no-repeat -90px -20px}'.PHP_EOL;
							$custom_css .= '#'.$tableID.' .package_details span.star_empty:before {background: url('.plugins_url( '../images/wrcpt-star.png', __FILE__ ).') no-repeat -90px -64px}'.PHP_EOL;
						} elseif($p_combo['fstar'] == "star-4") {
							$custom_css .= '#'.$tableID.' .package_details span.feature_star:before {background: url('.plugins_url( '../images/wrcpt-star.png', __FILE__ ).') no-repeat -125px -20px}'.PHP_EOL;
							$custom_css .= '#'.$tableID.' .package_details span.star_empty:before {background: url('.plugins_url( '../images/wrcpt-star.png', __FILE__ ).') no-repeat -125px -64px}'.PHP_EOL;
						} else {
							$custom_css .= '#'.$tableID.' .package_details span.feature_star:before {background: url('.plugins_url( '../images/wrcpt-star.png', __FILE__ ).') no-repeat -160px -20px}'.PHP_EOL;
							$custom_css .= '#'.$tableID.' .package_details span.star_empty:before {background: url('.plugins_url( '../images/wrcpt-star.png', __FILE__ ).') no-repeat -160px -64px}'.PHP_EOL;
						}
						/* Image Opacity */
						if($p_combo['imgopc'] != '' && $p_combo['bgimg'] != 'yes') {
							$custom_css .= '#'.$tableID.' .package_details li.pricing_table_plan img {opacity:'; if($p_combo['imgopc'] > 9) { $custom_css .= '1'; } else { $custom_css .= '.'.$p_combo['imgopc']; } $custom_css .= '}'.PHP_EOL;
						}
						/* Hide Title */
						if($p_combo['htitle'] == 'yes') {
							$custom_css .= '#'.$tableID.' .package_caption li.pricing_table_title, #'.$tableID.' .package_details li.pricing_table_title {display:none}'.PHP_EOL;
						}
						/* Hide Price */
						if($p_combo['hprice'] == 'yes') {
							$custom_css .= '#'.$tableID.' .package_caption li.pricing_table_plan, #'.$tableID.' .package_details li.pricing_table_plan {display:none}'.PHP_EOL;
						}
						/* Hide Feature */
						if($p_combo['hfeat'] == 'yes') {
							$custom_css .= '#'.$tableID.' .package_caption li.feature_style_2,#'.$tableID.' .package_caption li.feature_style_3,#'.$tableID.' .package_details li.feature_style_1,#'.$tableID.' .package_details li.feature_cate_row {display:none}'.PHP_EOL;
						}
						/* Hide Button */
						if($p_combo['hbutton'] == 'yes') {
							$custom_css .= '#'.$tableID.' .package_details li.pricing_table_button {display:none}'.PHP_EOL;
						}
						/* Table Name BG Color */
						if($p_combo['captbg'] == 'yes') {
							if($p_combo['btompr'] != 'yes') {
								$custom_css .= '#'.$tableID.' .package_caption li.pricing_table_plan,#'.$tableID.' .package_caption li.pricing_table_video {background: '.$p_combo['prnbg'].';'; if($p_combo['etclr'] == 'yes') { if($p_combo['encate'] != 'yes') { $custom_css .= 'margin:0;'; } else { $custom_css .= 'margin:0 0 -1px '.$table_padding.'px;'; } } $custom_css .= '-moz-border-radius-topleft:'.$p_combo['cbrad'].'px;-webkit-border-top-left-radius:'.$p_combo['cbrad'].'px;-khtml-border-top-left-radius:'.$p_combo['cbrad'].'px;border-top-left-radius: '.$p_combo['cbrad'].'px}'.PHP_EOL;
								$custom_css .= '#'.$tableID.' .package_caption li.pricing_table_button{background: '.$p_combo['prnbg'].'}'.PHP_EOL;
							} else {
								$custom_css .= '#'.$tableID.' .package_caption li.pricing_table_title {background: '.$p_combo['prnbg'].';'; if($p_combo['etclr'] == 'yes') { $custom_css .= 'margin:0 0 1px '.$table_padding.'px;'; } $custom_css .= '-moz-border-radius-topleft:'.$p_combo['cbrad'].'px;-webkit-border-top-left-radius:'.$p_combo['cbrad'].'px;-khtml-border-top-left-radius:'.$p_combo['cbrad'].'px;border-top-left-radius: '.$p_combo['cbrad'].'px;-moz-border-radius-topright:'.$p_combo['cbrad'].'px;-webkit-border-top-right-radius:'.$p_combo['cbrad'].'px;-khtml-border-top-right-radius:'.$p_combo['cbrad'].'px;border-top-right-radius: '.$p_combo['cbrad'].'px}'.PHP_EOL;
								$custom_css .= '#'.$tableID.' .package_caption li.pricing_table_plan,#'.$tableID.' .package_caption li.pricing_table_video {background: '.$p_combo['prnbg'].';}'.PHP_EOL;
								if($p_combo['envid'] == 'yes' && ($p_combo['opvid'] == 'vid-3' || $p_combo['opvid'] == 'vid-4')) {
									if($p_combo['cbrad']) {
										$custom_css .= '#'.$tableID.' .package_caption li.pricing_table_plan,#'.$tableID.' .package_caption li.pricing_table_video {-moz-border-radius-topleft:'.$p_combo['cbrad'].'px;-webkit-border-top-left-radius:'.$p_combo['cbrad'].'px;-khtml-border-top-left-radius:'.$p_combo['cbrad'].'px;border-top-left-radius: '.$p_combo['cbrad'].'px;}'.PHP_EOL;
									}
								}
								if(($p_combo['enimg'] == 'yes' && $p_combo['bgimg'] != 'yes') && ($p_combo['opimg'] == 'opt-3' || $p_combo['opimg'] == 'opt-4')) {
									if($p_combo['cbrad']) {
										$custom_css .= '#'.$tableID.' .package_caption li.pricing_table_plan {-moz-border-radius-topleft:'.$p_combo['cbrad'].'px;-webkit-border-top-left-radius:'.$p_combo['cbrad'].'px;-khtml-border-top-left-radius:'.$p_combo['cbrad'].'px;border-top-left-radius: '.$p_combo['cbrad'].'px;}'.PHP_EOL;
									}
								}
								$custom_css .= '#'.$tableID.' .package_caption li.pricing_table_button{background: '.$p_combo['prnbg'].';margin-top:0}'.PHP_EOL;
							}
						}
						/* Caption Column Border Radius */
						if($p_combo['cbrad'] != '' && $p_combo['cbrad'] != 0) {
							if($p_combo['captbg'] != 'yes') {
								$custom_css .= '#'.$tableID.' .package_caption li.top_left {-moz-border-radius-topleft:'.$p_combo['cbrad'].'px;-webkit-border-top-left-radius:'.$p_combo['cbrad'].'px;-khtml-border-top-left-radius:'.$p_combo['cbrad'].'px;border-top-left-radius: '.$p_combo['cbrad'].'px;';if($p_combo['etclr'] == 'yes') {$custom_css .= 'border-top:none'; } $custom_css .= '}'.PHP_EOL;
							}	
							$custom_css .= '#'.$tableID.' .package_caption li.bottom_left {-moz-border-radius-bottomleft:'.$p_combo['cbrad'].'px;-webkit-border-bottom-left-radius:'.$p_combo['cbrad'].'px;-khtml-border-bottom-left-radius:'.$p_combo['cbrad'].'px;border-bottom-left-radius: '.$p_combo['cbrad'].'px;';if($p_combo['etclr'] == 'yes') {$custom_css .= 'border-bottom:none'; } $custom_css .= '}'.PHP_EOL;
						}
						/* Enable Table Background */
						if($p_combo['etclr'] == 'yes') {
							/* Caption Column Background */
							if($p_combo['ccolbg'] != '') {
								if($p_combo['captbg'] != 'yes') {
									$custom_css .= '#'.$tableID.' .package_caption li.top_left {border-top:'; if($table_padding) { $custom_css .= $table_padding.'px'; } else { $custom_css .= '2px'; } $custom_css .= ' solid '.$p_combo['ccolbg'].' !important}'.PHP_EOL;
								}
								$custom_css .= '#'.$tableID.' .package_caption li.bottom_left {border-bottom:'; if($table_padding) { $custom_css .= $table_padding.'px'; } else { $custom_css .= '2px'; } $custom_css .= ' solid '.$p_combo['ccolbg'].' !important}'.PHP_EOL;
								$custom_css .= '#'.$tableID.' .package_caption li.feature_style_2,#'.$tableID.' .package_caption li.feature_style_3,#'.$tableID.' .package_caption li.feature_cate_row {border-left:'; if($table_padding) { $custom_css .= $table_padding.'px'; } else { $custom_css .= '2px'; } $custom_css .= ' solid '.$p_combo['ccolbg'].'}'.PHP_EOL;
							}
							/* Space Between Columns */
							if($p_combo['colgap'] == '' || $p_combo['colgap'] == 0) {
								if($p_combo['captbg'] == 'yes') {
									$custom_css .= '#'.$tableID.' .package_caption {padding:'; if($table_padding) { $custom_css .= ($table_padding-1).'px'.' 0 '.$table_padding.'px'.' '. $table_padding.'px'; } else { $custom_css .= '1px 0 3px 2px'; } $custom_css .= '}'.PHP_EOL;
								} else {
									$custom_css .= '#'.$tableID.' .package_caption {padding:'; if($table_padding) { $custom_css .= $table_padding.'px'.' 0 '.$table_padding.'px'.' '. $table_padding.'px'; } else { $custom_css .= '2px 0 3px 2px'; } $custom_css .= '}'.PHP_EOL;
								}
							} else {
								if($p_combo['captbg'] == 'yes') {
									$custom_css .= '#'.$tableID.' .package_caption {padding:'; if($table_padding) { $custom_css .= ($table_padding-1).'px'.' 0 '.$table_padding.'px'.' '. $table_padding.'px'; } else { $custom_css .= '1px 0 3px 2px'; } $custom_css .= '}'.PHP_EOL;
								} else {
									$custom_css .= '#'.$tableID.' .package_caption {padding:'; if($table_padding) { $custom_css .= $table_padding.'px'.' 0 '.$table_padding.'px'.' '. $table_padding.'px'; } else { $custom_css .= '2px 0 3px 2px'; } $custom_css .= '}'.PHP_EOL;
								}
							}
						}
					}
					foreach($p_options as $key => $value) :
						$packageType = get_option($value);
						/**
						 * Set video player height for special package and regular packgae
						 * also set video player height for price at bottom and top
						 */
						if($packageType['spack'] == 'yes') {
							if($p_combo['envid'] == 'yes' && ($p_combo['opvid'] == 'vid-1' || $p_combo['opvid'] == 'vid-2')) {
								if($p_combo['btompr'] == 'yes') {
									$video_player_height = $video_box_height;
								} else {
									$video_player_height = $video_box_height + 20;
								}
							} else {
								if($p_combo['btompr'] == 'yes') {
									$video_player_height = $video_box_height + 20;
								} else {
									$video_player_height = $video_box_height + 40;
								}
							}
						} else {
							$video_player_height = $video_box_height;
						}
						/**
						 * Set background gradient for title, price and button body
						 */
						if($p_combo['ttgrd'] == 'yes') { $tlight = wrcpt_adjustBrightness($packageType['tbcolor'], 0); }
						else { $tlight = wrcpt_adjustBrightness($packageType['tbcolor'], 50); }
						if($p_combo['prgrd'] == 'yes') { $pdark = wrcpt_adjustBrightness($packageType['pbcolor'], 0); }
						else { $pdark = wrcpt_adjustBrightness($packageType['pbcolor'], 20); }
						$blight = wrcpt_adjustBrightness($packageType['bcolor'], 50);
						$bdark = wrcpt_adjustBrightness($packageType['bhover'], 20);
						$bhlight = wrcpt_adjustBrightness($packageType['bhover'], 50);
						if($p_combo['dsgrd'] == 'yes') { $bbdark = wrcpt_adjustBrightness($packageType['bbcolor'], 0); }
						else { $bbdark = wrcpt_adjustBrightness($packageType['bbcolor'], 20); }
						$rlight = wrcpt_adjustBrightness($packageType['rbcolor'], 80);
						$rdark = wrcpt_adjustBrightness($packageType['rbcolor'], 20);
						$bdlight = wrcpt_adjustBrightness($packageType['ftborder'], 50);
						$circle_light = wrcpt_adjustBrightness($packageType['pcircle'], -34);
						$circle_dark = wrcpt_adjustBrightness($packageType['pcircle'], -101.5);
						$i = 1;

						/* Shortcode 1 */
						if($shortcode == 1) {
							/* Primary Font, Title Font Size, Title Font Color */
							if($p_combo['pgfont'] || $global_font1 || $p_combo['tsize'] || $packageType['tcolor']) {
								$custom_css .= '#'.$tableID.' .package_details h3.txcolor-'.$packageType['pid'].' {'; if($p_combo['pgfont']) { $custom_css .= 'font-family: '.$p_combo['pgfont'].';'; } else { if($global_font1){ $custom_css .= 'font-family: '.$global_font1.';'; }} if($p_combo['tsize']) { $custom_css .= 'font-size: '.$p_combo['tsize'].';'; } if($packageType['tcolor']) { $custom_css .= 'color: '.$packageType['tcolor'].';'; } $custom_css .= '}'.PHP_EOL;
							}
							/* Title Font Hover Color */
							if($packageType['thover']) {
								$custom_css .= '#'.$tableID.' .package_details:hover h3.txcolor-'.$packageType['pid'].' {color: '.$packageType['thover'].';}'.PHP_EOL;
							}
							/* Secondary Font for Title Description, Title Description Font Size */
							if($p_combo['sgfont'] || $global_font2 || $p_combo['tdesc'] || $packageType['tdescl']) {
								$custom_css .= '#'.$tableID.' .package_details h3.txcolor-'.$packageType['pid'].' span.package_desc {'; if($p_combo['sgfont']) { $custom_css .= 'font-family: '.$p_combo['sgfont'].';'; } else { if($global_font2){ $custom_css .= 'font-family: '.$global_font2.';'; }} if($p_combo['tdesc']) { $custom_css .= 'font-size:'.$p_combo['tdesc'].';'; } if($packageType['tdescl']) { $custom_css .= 'color:'.$packageType['tdescl'].';'; } $custom_css .= '}'.PHP_EOL;
							}
							/* Title BG Color, Title Body Height */
							$custom_css .= '#'.$tableID.' .package_details li.color-'.$packageType['pid'].' {background: -moz-linear-gradient('.$tlight.', '.$packageType['tbcolor'].');background: -webkit-gradient(linear, center top, center bottom, from('.$tlight.'), to('.$packageType['tbcolor'].'));background: -webkit-linear-gradient('.$tlight.', '.$packageType['tbcolor'].');background: -o-linear-gradient('.$tlight.', '.$packageType['tbcolor'].');background: -ms-linear-gradient('.$tlight.', '.$packageType['tbcolor'].');filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=\''.$tlight.'\', endColorstr=\''.$packageType['tbcolor'].'\',GradientType=1);-ms-filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=\''.$tlight.'\', endColorstr=\''.$packageType['tbcolor'].'\',GradientType=1);background: linear-gradient('.$tlight.', '.$packageType['tbcolor'].');'; if($p_combo['tbody']) { $custom_css .= 'height: '.$p_combo['tbody'].';line-height: '.$p_combo['tbody'].';'; } $custom_css .= '}'.PHP_EOL;
							/* Column Border Radius */
							if($p_combo['pbrad'] != '' && $p_combo['pbrad'] != 0) {
								$custom_css .= '#'.$tableID.' .package_details li.color-'.$packageType['pid'].'.title_top_radius,#'.$tableID.' .package_details.details-'.$packageType['pid'].' {-moz-border-radius-topleft:'.$p_combo['pbrad'].'px;-webkit-border-top-left-radius:'.$p_combo['pbrad'].'px;-khtml-border-top-left-radius:'.$p_combo['pbrad'].'px;border-top-left-radius: '.$p_combo['pbrad'].'px;-moz-border-radius-topright:'.$p_combo['pbrad'].'px;-webkit-border-top-right-radius:'.$p_combo['pbrad'].'px;-khtml-border-top-right-radius:'.$p_combo['pbrad'].'px;border-top-right-radius: '.$p_combo['pbrad'].'px}'.PHP_EOL;
								/* If video enable */
								if($p_combo['envid'] == 'yes' && ($p_combo['opvid'] == 'vid-3' || $p_combo['opvid'] == 'vid-4')) {
									$brdwd = 0.3 * $p_combo['pbrad'];
									$custom_css .= '#'.$tableID.' .package_details li.video-'.$packageType['pid'].',#'.$tableID.' .package_details li.video-'.$packageType['pid'].' iframe {-moz-border-radius-topleft:'.$p_combo['pbrad'].'px;-webkit-border-top-left-radius:'.$p_combo['pbrad'].'px;-khtml-border-top-left-radius:'.$p_combo['pbrad'].'px;border-top-left-radius: '.$p_combo['pbrad'].'px;-moz-border-radius-topright:'.$p_combo['pbrad'].'px;-webkit-border-top-right-radius:'.$p_combo['pbrad'].'px;-khtml-border-top-right-radius:'.$p_combo['pbrad'].'px;border-top-right-radius: '.$p_combo['pbrad'].'px}'.PHP_EOL;
									$custom_css .= '#'.$tableID.' .package_details li.video-'.$packageType['pid'].' iframe {border: '.$brdwd.'px solid #000}'.PHP_EOL;
								}
								/* If image enable */
								if(($p_combo['enimg'] == 'yes' && $p_combo['bgimg'] != 'yes') && ($p_combo['opimg'] == 'opt-3' || $p_combo['opimg'] == 'opt-4')) {
									$custom_css .= '#'.$tableID.' .package_details li.plan-'.$packageType['pid'].'.top_price,#'.$tableID.' .package_details.package-'.$packageType['pid'].',#'.$tableID.' .package_details li.plan-'.$packageType['pid'].'.top_price img {-moz-border-radius-topleft:'.$p_combo['pbrad'].'px;-webkit-border-top-left-radius:'.$p_combo['pbrad'].'px;-khtml-border-top-left-radius:'.$p_combo['pbrad'].'px;border-top-left-radius: '.$p_combo['pbrad'].'px;-moz-border-radius-topright:'.$p_combo['pbrad'].'px;-webkit-border-top-right-radius:'.$p_combo['pbrad'].'px;-khtml-border-top-right-radius:'.$p_combo['pbrad'].'px;border-top-right-radius: '.$p_combo['pbrad'].'px}'.PHP_EOL;
									/* If image not enable */
								} else {
									$custom_css .= '#'.$tableID.' .package_details.package-'.$packageType['pid'].' {-moz-border-radius-topleft:'.$p_combo['pbrad'].'px;-webkit-border-top-left-radius:'.$p_combo['pbrad'].'px;-khtml-border-top-left-radius:'.$p_combo['pbrad'].'px;border-top-left-radius: '.$p_combo['pbrad'].'px;-moz-border-radius-topright:'.$p_combo['pbrad'].'px;-webkit-border-top-right-radius:'.$p_combo['pbrad'].'px;-khtml-border-top-right-radius:'.$p_combo['pbrad'].'px;border-top-right-radius: '.$p_combo['pbrad'].'px}'.PHP_EOL;
								}
							}
							/* Primary Font, Price Font Size (Big), Price Font Color (Big) */
							if($p_combo['pgfont'] || $global_font1 || $p_combo['psbig'] || $p_combo['crlepr'] == 'yes' || $packageType['pcbig']) {
								$custom_css .= '#'.$tableID.' .package_details h2.txcolor-'.$packageType['pid'].' {'; if($p_combo['pgfont']) { $custom_css .= 'font-family: '.$p_combo['pgfont'].';'; } else { if($global_font1){ $custom_css .= 'font-family: '.$global_font1.';'; }} if($p_combo['psbig']) { $custom_css .= 'font-size: '.$p_combo['psbig'].';'; } if($packageType['pcbig']) { $custom_css .= 'color: '.$packageType['pcbig'].';'; } if($p_combo['crlepr'] == 'yes') { $custom_css .= 'background: '.$packageType['pcircle'].';width: '.($price_box_height - 10).'px !important;height: '.($price_box_height - 10).'px;line-height: '.((int)$price_box_height - 30).'px;margin-bottom: 5px;border: 1px solid '.$circle_dark.' !important;-moz-border-radius: '.$price_box_height.'px'.';-webkit-border-radius: '.$price_box_height.'px'.';border-radius: '.$price_box_height.'px'.';-moz-box-shadow: 0 5px 20px '.$circle_light.' inset, 0 3px 0 '.$circle_dark.' inset;-webkit-box-shadow: 0 5px 20px '.$circle_light.' inset, 0 3px 0 '.$circle_dark.' inset;box-shadow: 0 5px 20px '.$circle_light.' inset, 0 3px 0 '.$circle_dark.' inset;z-index: 0;'; } $custom_css .= '}'.PHP_EOL;
								if($p_combo['crlepr'] == 'yes') {
									$custom_css .= '#'.$tableID.' .package_details h2.txcolor-'.$packageType['pid'].' span.cent {position: relative;vertical-align: top;}'.PHP_EOL;
									$custom_css .= '#'.$tableID.' .package_details h2.txcolor-'.$packageType['pid'].' span.plan {position: absolute;left: 50%;bottom: '.(int)$price_box_height * 0.3.'px;transform: translateX(-50%);}'.PHP_EOL;
								}
								$custom_css .= '#'.$tableID.' .package_details h2.txcolor-'.$packageType['pid'].' span.price {'; if($p_combo['psbig']) { $custom_css .= 'font-size: '.$p_combo['psbig'].';'; } if($packageType['pcbig']) { $custom_css .= 'color: '.$packageType['pcbig'].';'; } $custom_css .= '}'.PHP_EOL;
								/* Cut Prices Font Color */
								if((isset($packageType['cutclr']) && $packageType['cutclr'])) {
									$custom_css .= '#'.$tableID.' .package_details h2.txcolor-'.$packageType['pid'].' span.price_cut {color: '.$packageType['cutclr'].'}'.PHP_EOL;
								}
							}
							/* Secondary Font for Price Description */
							if($p_combo['sgfont']) {
								$custom_css .= '#'.$tableID.' .package_details h2.txcolor-'.$packageType['pid'].' span.price_desc {font-family: '.$p_combo['sgfont'].'}'.PHP_EOL;
							} else {
								if($global_font2){
									$custom_css .= '#'.$tableID.' .package_details h2.txcolor-'.$packageType['pid'].' span.price_desc {font-family: '.$global_font2.'}'.PHP_EOL;
								}
							}
							/* Price Font Hover Color (Big) */
							if($packageType['phbig']) {
								$custom_css .= '#'.$tableID.' .package_details:hover h2.txcolor-'.$packageType['pid'].' .price {color: '.$packageType['phbig'].';}'.PHP_EOL;
							}
							/* Primary Font, Price Font Size (Small), Price Font Color (Small) */
							if($p_combo['pgfont'] || $global_font1 || $p_combo['pssmall'] || $packageType['pcsmall']) {
								$custom_css .= '#'.$tableID.' .package_details h2.txcolor-'.$packageType['pid'].' span.unit,#'.$tableID.' .package_details h2.txcolor-'.$packageType['pid'].' span.cent,#'.$tableID.' .package_details h2.txcolor-'.$packageType['pid'].' span.plan {'; if($p_combo['pgfont']) { $custom_css .= 'font-family: '.$p_combo['pgfont'].';'; } else { if($global_font1){ $custom_css .= 'font-family: '.$global_font1.';'; }} if($p_combo['pssmall']) { $custom_css .= 'font-size: '.$p_combo['pssmall'].';'; } if($packageType['pcsmall']) { $custom_css .= 'color: '.$packageType['pcsmall'].';'; } $custom_css .= '}'.PHP_EOL;
							}
							/* Price Font Hover Color (Small) */
							if($packageType['phsmall']) {
								$custom_css .= '#'.$tableID.' .package_details:hover h2.txcolor-'.$packageType['pid'].' span.unit,#'.$tableID.' .package_details:hover h2.txcolor-'.$packageType['pid'].' span.cent,#'.$tableID.' .package_details:hover h2.txcolor-'.$packageType['pid'].' span.plan {color: '.$packageType['phsmall'].';}'.PHP_EOL;
							}
							/* Price BG Color, Price Body Height, Enable Feature Border */
							$custom_css .= '#'.$tableID.' .package_details li.plan-'.$packageType['pid'].' {background: -moz-linear-gradient('.$pdark.', '.$packageType['pbcolor'].');background: -webkit-gradient(linear, center top, center bottom, from('.$pdark.'), to('.$packageType['pbcolor'].'));background: -webkit-linear-gradient('.$pdark.', '.$packageType['pbcolor'].');background: -o-linear-gradient('.$pdark.', '.$packageType['pbcolor'].');background: -ms-linear-gradient('.$pdark.', '.$packageType['pbcolor'].');filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\''.$pdark.'\', endColorstr=\''.$packageType['pbcolor'].'\', GradientType=1 );-ms-filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\''.$pdark.'\', endColorstr=\''.$packageType['pbcolor'].'\', GradientType=1 );background: linear-gradient('.$pdark.', '.$packageType['pbcolor'].');'; if($p_combo['pbody']) { $custom_css .= 'height:'.$p_combo['pbody'].';line-height:'.$p_combo['pbody'].';'; } if($p_combo['enfbor'] == 'yes' && $p_combo['btompr'] == 'yes') {$custom_css .= 'margin-top:1px;';}/* if($p_combo['enfbor'] == 'yes') { $custom_css .= 'border-bottom: 2px solid '.$packageType['ftborder']; } */ $custom_css .= '}'.PHP_EOL;
							/* Enable Image */
							if($p_combo['enimg'] == 'yes' && $p_combo['bgimg'] != 'yes') {
								$custom_css .= '#'.$tableID.' .package_details li.plan-'.$packageType['pid'].'.top_price {height: '.$image_height_a.'px;line-height: '.$image_height_a.'px;background:'; if($packageType['imgclr']) { $custom_css .= $packageType['imgclr']; } else { $custom_css .= '#fff'; } $custom_css .= '}'.PHP_EOL;
								$custom_css .= '#'.$tableID.' .package_details li.plan-'.$packageType['pid'].' img {position: absolute;left: 0;right: 0;top: 0;bottom: 0;margin:'; if($p_combo['imgmrg'] || $p_combo['imgmrg'] == 0) { $custom_css .= $p_combo['imgmrg']; } else { $custom_css .= 'auto'; } $custom_css .= '}'.PHP_EOL;
								if($p_combo['opimg'] == 'opt-1') {
									$custom_css .= '#'.$tableID.' .package_details h2.txcolor-'.$packageType['pid'].' span.unit,#'.$tableID.' .package_details h2.txcolor-'.$packageType['pid'].' span.cent {line-height:normal; vertical-align:text-top;}'.PHP_EOL;
									$custom_css .= '#'.$tableID.' .package_details h2.txcolor-'.$packageType['pid'].' span.cent {top:20px;}'.PHP_EOL;
								} elseif($p_combo['opimg'] == 'opt-3') {
									$custom_css .= '#'.$tableID.' .package_caption li.pricing_table_title {display: none}'.PHP_EOL;
									$custom_css .= '#'.$tableID.' .package_details.details-'.$packageType['pid'].' {padding-top: '.($table_padding+1).'px}'.PHP_EOL;
									$custom_css .= '#'.$tableID.' .package_details h2.txcolor-'.$packageType['pid'].' span.unit,#'.$tableID.' .package_details h2.txcolor-'.$packageType['pid'].' span.cent {line-height:normal; vertical-align:text-top;}'.PHP_EOL;
									$custom_css .= '#'.$tableID.' .package_details h2.txcolor-'.$packageType['pid'].' span.cent {top:20px;}'.PHP_EOL;
								} else {
									$custom_css .= '#'.$tableID.' .package_details.details-'.$packageType['pid'].' {padding-top: '.($table_padding+1).'px}'.PHP_EOL;
									if($p_combo['crlepr'] == 'yes') {
										$custom_css .= '#'.$tableID.' .package_details li.plan-'.$packageType['pid'].'.top_price.img_circle {background: '.$packageType['pcircle'].';border-radius: 9999px;width: '.((int)$p_combo['imgwid'] + 40).'px;height: '.((int)$p_combo['imghgt'] + 40).'px;line-height: '.((int)$p_combo['imghgt'] + 20).'px;margin: '.$p_combo['imgmrg'].';}'.PHP_EOL;
										$custom_css .= '#'.$tableID.' .package_details li.plan-'.$packageType['pid'].' img {top: 50%;transform: translateY(-50%);}'.PHP_EOL;
									}
									if($p_combo['opimg'] != 'opt-2') {
										$custom_css .= '#'.$tableID.' .package_caption li.pricing_table_title {display: none}'.PHP_EOL;
									}
								}
							}
							/* Enable Video */
							if($p_combo['envid'] == 'yes') {
								$custom_css .= '#'.$tableID.' .package_details li.video-'.$packageType['pid'].' {background:'.$pdark.';width:100%;height:'.$video_player_height.'px}'.PHP_EOL;
							}
							/* Button Body BG, Button Body Height */
							$custom_css .= '#'.$tableID.' .package_details li.bbcolor-'.$packageType['pid'].' {background: -moz-linear-gradient('.$bbdark.', '.$packageType['bbcolor'].');background: -webkit-gradient(linear, center top, center bottom, from('.$bbdark.'), to('.$packageType['bbcolor'].'));background: -webkit-linear-gradient('.$bbdark.', '.$packageType['bbcolor'].');background: -o-linear-gradient('.$bbdark.', '.$packageType['bbcolor'].');background: -ms-linear-gradient('.$bbdark.', '.$packageType['bbcolor'].');filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\''.$bbdark.'\', endColorstr=\''.$packageType['bbcolor'].'\',GradientType=1 );-ms-filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\''.$bbdark.'\', endColorstr=\''.$packageType['bbcolor'].'\',GradientType=1 );background: linear-gradient('.$bbdark.', '.$packageType['bbcolor'].');'; if($p_combo['btbody']) { $custom_css .= 'height:'.$p_combo['btbody'].';line-height: 100%'; } /* if($p_combo['enfbor'] == 'yes') { $custom_css .= ';border-top: 1px solid '.$bdlight; } if($p_combo['topbut'] == 'yes' && $p_combo['captbg'] != 'yes') { $custom_css .= ';margin-top:0'; } */$custom_css .= '}'.PHP_EOL;
							/* Button BG Color, Button Font Size and Color, Button Height and Width */
							$custom_css .= '#'.$tableID.' .package_details li.button-'.$packageType['pid'].' .action_button {background: -moz-linear-gradient('.$blight.', '.$packageType['bcolor'].');background: -webkit-gradient(linear, center top, center bottom, from('.$blight.'), to('.$packageType['bcolor'].'));background: -webkit-linear-gradient('.$blight.', '.$packageType['bcolor'].');background: -o-linear-gradient('.$blight.', '.$packageType['bcolor'].');background: -ms-linear-gradient('.$blight.', '.$packageType['bcolor'].');filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\''.$blight.'\', endColorstr=\''.$packageType['bcolor'].'\',GradientType=1 );-ms-filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\''.$blight.'\', endColorstr=\''.$packageType['bcolor'].'\',GradientType=1 );background: linear-gradient('.$blight.', '.$packageType['bcolor'].');border:1px solid '.$packageType['bcolor'].';'; if($p_combo['sgfont']) { $custom_css .= 'font-family: '.$p_combo['sgfont'].';'; } else { if($global_font2){ $custom_css .= 'font-family: '.$global_font2.';'; }} if($p_combo['btsize']) { $custom_css .= 'font-size: '.$p_combo['btsize'].';'; } if($packageType['btcolor']) { $custom_css .= 'color: '.$packageType['btcolor'].';'; } if($p_combo['bheight']) { $custom_css .= 'height:'.$p_combo['bheight'].';line-height:'.$p_combo['bheight'].';'; } if($p_combo['bwidth']) { $custom_css .= 'width:'.$p_combo['bwidth'].';padding:0 '.round($button_padding).'px'; } $custom_css .= '}'.PHP_EOL;
							/* Button on Hover */
							$custom_css .= '#'.$tableID.' .package_details li.button-'.$packageType['pid'].' .action_button:hover {background: -moz-linear-gradient('.$bhlight.', '.$packageType['bhover'].');background: -webkit-gradient(linear, center top, center bottom, from('.$bhlight.'), to('.$packageType['bhover'].'));background: -webkit-linear-gradient('.$bhlight.', '.$packageType['bhover'].');background: -o-linear-gradient('.$bhlight.', '.$packageType['bhover'].');background: -ms-linear-gradient('.$bhlight.', '.$packageType['bhover'].');filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\''.$bhlight.'\', endColorstr=\''.$packageType['bhover'].'\',GradientType=1 );-ms-filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\''.$bhlight.'\', endColorstr=\''.$packageType['bhover'].'\',GradientType=1 );background: linear-gradient('.$bhlight.', '.$packageType['bhover'].');border:1px solid '.$packageType['bhover'].';color: '.$packageType['bthover'].';}'.PHP_EOL;
							/* Button Icon Color, Width */
							if($packageType['btcolor']) {
								$custom_css .= '#'.$tableID.' .package_details li.button-'.$packageType['pid'].' .action_button span {color: '.$packageType['btcolor'].';}'.PHP_EOL;
								$custom_css .= '#'.$tableID.' .package_details li.button-'.$packageType['pid'].' .action_button:hover span {color: '.$packageType['bthover'].';}'.PHP_EOL;
							}
							if($p_combo['bwidth']) {
								$custom_css .= '#'.$tableID.' .package_details li.button-'.$packageType['pid'].' span.button_icon {padding: 0 '.round($button_padding).'px 0 0;}'.PHP_EOL;
							}
							/* Show Button Icon if Available */
							if($packageType['bicon'] != '') {
								if($p_combo['bwidth']) {
									$custom_css .= '#'.$tableID.' .package_details li.button-'.$packageType['pid'].' span.icon_divider {margin-right: '.round($button_padding).'px}'.PHP_EOL;
								}
								$custom_css .= '#'.$tableID.' .package_details li.button-'.$packageType['pid'].' span.icon_divider:before {border-left:1px solid '.$packageType['bcolor'].';border-right:1px solid '.$blight.';'; if($p_combo['bheight']) { $custom_css .= 'height: '.((int)$p_combo['bheight']-1).'px'; } $custom_css .= '}'.PHP_EOL;
								$custom_css .= '#'.$tableID.' .package_details li.button-'.$packageType['pid'].' .action_button:hover span.icon_divider:before {border-left:1px solid '.$packageType['bhover'].';border-right:1px solid '.$bhlight.'}'.PHP_EOL;
							}
							/* Feature Values Font Size and Font Color */
							if($p_combo['ftsize'] || $packageType['ftcolor']) {
								$custom_css .= '#'.$tableID.' .package_details li.ftcolor-'.$packageType['pid'].',#'.$tableID.' .package_details li.ftcolor-'.$packageType['pid'].' a.wrc_tooltip,#'.$tableID.' .package_details li.ftcolor-'.$packageType['pid'].' .feat_cap,#'.$tableID.' .package_details li.ftcolor-'.$packageType['pid'].' span.text_tooltip,#'.$tableID.' .package_details li.ftcolor-'.$packageType['pid'].' span.icon_tooltip,#'.$tableID.' .package_details li.ftcolor-'.$packageType['pid'].' span.fa-icon,#'.$tableID.' .package_details li.ftcolor-'.$packageType['pid'].' span.hide-fa-icon {'; if($p_combo['ftsize']) { $custom_css .= 'font-size: '.$p_combo['ftsize'].';'; } if($packageType['ftcolor']) { $custom_css .= 'color: '.$packageType['ftcolor']; } $custom_css .= '}'.PHP_EOL;
							}
							/* Feature URL Color and Hover Color */
							if($p_combo['furlclr']) {
								$custom_css .= '#'.$tableID.' .package_details li.ftcolor-'.$packageType['pid'].' .feat_cap a{color:'.$p_combo['furlclr'].'}'.PHP_EOL;
							}
							if($p_combo['furlclr']) {
								$custom_css .= '#'.$tableID.' .package_details li.ftcolor-'.$packageType['pid'].' .feat_cap a:hover{color:'.$p_combo['furlhvr'].'}'.PHP_EOL;
							}
							/* Enable Font Awesome Tick/Cross */
							if($p_combo['enfatc'] == 'yes') {
								$custom_css .= '#'.$tableID.' .package_details li.ftcolor-'.$packageType['pid'].' span.ic-tick {color: '.$p_combo['fatclr'].'}'.PHP_EOL;
								$custom_css .= '#'.$tableID.' .package_details li.ftcolor-'.$packageType['pid'].' span.ic-cross {color: '.$p_combo['facclr'].'}'.PHP_EOL;
							}
							/* Feature Name Font Size and Font Color */
							if($p_combo['cftsize'] || $packageType['fncolor']) {
								$custom_css .= '#'.$tableID.' .package_details li.ftcolor-'.$packageType['pid'].' span.feat_value,#'.$tableID.' .package_details li.ftcolor-'.$packageType['pid'].' span.media_screen {'; if($p_combo['cftsize']) { $custom_css .= 'font-size: '.$p_combo['cftsize'].';'; } if($packageType['fncolor']) { $custom_css .= 'color: '.$packageType['fncolor']; } $custom_css .= '}'.PHP_EOL;
							}
							/* Feature Body Height */
							if($p_combo['ftbody']) {
								$custom_css .= '#'.$tableID.' .package_details li.ftcolor-'.$packageType['pid'].' {height: '.$p_combo['ftbody'].';line-height: '.$p_combo['ftbody'].'}'.PHP_EOL;
							}
							/* Set padding if caption column enable */
							if($p_combo['ftcap'] == "yes") {
								$custom_css .= '#'.$tableID.' .package_details li.ftcolor-'.$packageType['pid'].' {padding:0 5px 0 '; if($p_combo['ftpad'] != '') { $custom_css .= $p_combo['ftpad']; } else { $custom_css .= '20'; } $custom_css .= 'px}'.PHP_EOL;
							}
							/* Feature direction, padding and border */
							if($p_combo['ftdir'] || $p_combo['ftpad'] || $packageType['ftborder']) {
								$custom_css .= '#'.$tableID.' .package_details li.ftcolor-'.$packageType['pid'].' {'; if($p_combo['ftdir']) { $custom_css .= 'text-align:'.$p_combo['ftdir'].';'; } if($p_combo['ftpad'] != '') { $custom_css .= 'padding-left:'.$p_combo['ftpad'].'px;'; } if($p_combo['enfbor'] == 'yes' && $packageType['ftborder']) { $custom_css .= 'border-top: 1px solid '.$packageType['ftborder'].';'; } $custom_css .= '}'.PHP_EOL;
								$custom_css .= '#'.$tableID.' .package_details li.ftcolor-'.$packageType['pid'].'.last-feature {'; if($p_combo['enfbor'] == 'yes' && $packageType['ftborder']) { $custom_css .= 'border-bottom: 1px solid '.$packageType['ftborder'].';'; } $custom_css .= '}'.PHP_EOL;
							}
							/* Feature Background Color even */
							if($packageType['fbrow2']) {
								$custom_css .= '#'.$tableID.' .package_details li.rowcolor-'.$packageType['pid'].' {background-color: '.$packageType['fbrow2'].';}'.PHP_EOL;
							}
							/* Feature Background Color odd */
							if($packageType['fbrow1']) {
								$custom_css .= '#'.$tableID.' .package_details li.altrowcolor-'.$packageType['pid'].' {background-color: '.$packageType['fbrow1'].';}'.PHP_EOL;
							}
							/* Ribbon */
							if($p_combo['enribs'] == 'yes') {
								/* Ribbon 1 */
								if($p_combo['markrib'] == 'rb-1') {
									/* Price section at top */
									if($p_combo['btompr'] != 'yes') {
										if($p_combo['hprice'] != 'yes') {
											$custom_css .= '#'.$tableID.' .package_details li .ribbon_color-'.$packageType['pid'].' {top:'.($title_box_height + 1).'px}'.PHP_EOL;
										} else {
											$custom_css .= '#'.$tableID.' .package_details li .ribbon_color-'.$packageType['pid'].' {top:'.($title_box_height-14).'px}'.PHP_EOL;
										}
									/* Price section at bottom */
									} else {
										if($p_combo['enimg'] != 'yes' && $p_combo['envid'] != 'yes') {
											$custom_css .= '#'.$tableID.' .package_details li .ribbon_color-'.$packageType['pid'].' {top:10px}'.PHP_EOL;
										} else {
											$custom_css .= '#'.$tableID.' .package_details li .ribbon_color-'.$packageType['pid'].' {top:'.($title_box_height + 1).'px}'.PHP_EOL;
										}
									}
									/* Table BG is enable */
									if($p_combo['etclr'] == 'yes') {
										$custom_css .= '#'.$tableID.' .package_details li .ribbon_color-'.$packageType['pid'].' {right:-'.((int)$p_combo['tbpad']+8).'px}'.PHP_EOL;
									}
									/* Font and color Setup */
									if($p_combo['sgfont'] || $global_font2 || $p_combo['rtsize']) {
										$custom_css .= '#'.$tableID.' .package_details li .ribbon_color-'.$packageType['pid'].' {'; if($p_combo['sgfont']) { $custom_css .= 'font-family: '.$p_combo['sgfont'].';'; } else { if($global_font2){ $custom_css .= 'font-family: '.$global_font2.';'; }} if($p_combo['rtsize']) { $custom_css .= 'font-size: '.$p_combo['rtsize']; } $custom_css .= '}'.PHP_EOL;
									}
									$custom_css .= '#'.$tableID.' .package_details li .ribbon_color-'.$packageType['pid'].' a {background: '.$packageType['rbcolor'].';background: -moz-linear-gradient(left, '.$rlight.', '.$packageType['rbcolor'].');background: -webkit-linear-gradient(left, '.$rlight.', '.$packageType['rbcolor'].');background: -o-linear-gradient(left, '.$rlight.', '.$packageType['rbcolor'].');background: -ms-linear-gradient(left, '.$rlight.', '.$packageType['rbcolor'].');filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\''.$rlight.'\', endColorstr=\''.$packageType['rbcolor'].'\',GradientType=1 );-ms-filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=\''.$rlight.'\', endColorstr=\''.$packageType['rbcolor'].'\',GradientType=1);background: linear-gradient(to right, '.$rlight.', '.$packageType['rbcolor'].');color: '.$packageType['rtcolor'].'}'.PHP_EOL;
									$custom_css .= '#'.$tableID.' .package_details li .ribbon_color-'.$packageType['pid'].' a:before {border-color: transparent '.$rlight.' transparent transparent}'.PHP_EOL;
									$custom_css .= '#'.$tableID.' .package_details li .ribbon_color-'.$packageType['pid'].' a:after {border-top: 8px solid rgba(0,0,0,.5)}'.PHP_EOL;
									$custom_css .= '#'.$tableID.' .package_details:hover li .ribbon_color-'.$packageType['pid'].' a {color: '.$packageType['rthover'].'}'.PHP_EOL;
								/* Ribbon 2 */
								} elseif($p_combo['markrib'] == 'rb-2') {
									/* Price section at top */
									if($p_combo['btompr'] != 'yes') {
										if($p_combo['hprice'] != 'yes') {
											$custom_css .= '#'.$tableID.' .package_details li .rc-color-'.$packageType['pid'].' {'; if($p_combo['enimg'] == 'yes' && $p_combo['bgimg'] != 'yes') { $custom_css .= 'top: '.($title_box_height + $image_height_a) - 34; } elseif($p_combo['envid'] == 'yes') { $custom_css .= 'top: '.(($title_box_height + (int)$p_combo['vbody']) - 34); } else { $custom_css .= 'top: '.($title_box_height + $price_box_height) - 34; } $custom_css .= 'px}'.PHP_EOL;
										} else {
											$custom_css .= '#'.$tableID.' .package_details li .rc-color-'.$packageType['pid'].' {top:'.($title_box_height-30).'px}'.PHP_EOL;
										}
									/* Price section at bottom */
									} else {
										if($p_combo['enimg'] != 'yes' && $p_combo['envid'] != 'yes') {
											$custom_css .= '#'.$tableID.' .package_details li .rc-color-'.$packageType['pid'].' {top:'.($price_box_height-35).'px}'.PHP_EOL;
										} else {
											$custom_css .= '#'.$tableID.' .package_details li .rc-color-'.$packageType['pid'].' {'; if($p_combo['envid'] != 'yes') { $custom_css .= 'top: '.(($title_box_height + $image_height_a) - 34).'px;'; } else { $custom_css .= 'top: '.(($title_box_height + (int)$p_combo['vbody']) - 34).'px;'; } $custom_css .= '}'.PHP_EOL;
										}
									}
									/* Table BG is enable */
									if($p_combo['etclr'] == 'yes') {
										$custom_css .= '#'.$tableID.' .package_details li .rc-color-'.$packageType['pid'].' {left:-'.($p_combo['tbpad']+1).'px}'.PHP_EOL;
									}
									/* Font and color Setup */
									if($p_combo['sgfont'] || $global_font2 || $packageType['rbcolor'] || $p_combo['rtsize'] || $packageType['rtcolor']) {
										$custom_css .= '#'.$tableID.' .package_details li .rc-color-'.$packageType['pid'].' {'; if($p_combo['sgfont']) { $custom_css .= 'font-family: '.$p_combo['sgfont'].';'; } else { if($global_font2){ $custom_css .= 'font-family: '.$global_font2.';'; }} if($packageType['rbcolor']) { $custom_css .= 'background-color: '.$packageType['rbcolor'].' !important;'; } if($p_combo['rtsize']) { $custom_css .= 'font-size: '.$p_combo['rtsize'].';'; } if($packageType['rtcolor']) { $custom_css .= 'color: '.$packageType['rtcolor']; } $custom_css .= '}'.PHP_EOL;
									}
									$custom_css .= '#'.$tableID.' .package_details:hover li .rc-color-'.$packageType['pid'].' {color: '.$packageType['rthover'].' !important}'.PHP_EOL;
								/* Ribbon 3 */
								} elseif($p_combo['markrib'] == 'rb-3') {
									/* Table BG is enable */
									if($p_combo['etclr'] == 'yes') {
										$custom_css .= '#'.$tableID.' .package_details li .ribbon-color-'.$packageType['pid'].' {left: -'.($p_combo['tbpad']+5).'px;top: -'.($p_combo['tbpad']+5).'px;}'.PHP_EOL;
									}
									/* Font and color Setup */
									if($p_combo['sgfont'] || $global_font2 || $p_combo['rtsize'] || $packageType['rtcolor'] || $packageType['rbcolor']) {
										$custom_css .= '#'.$tableID.' .package_details li .ribbon-color-'.$packageType['pid'].' span {'; if($p_combo['sgfont']) { $custom_css .= 'font-family: '.$p_combo['sgfont'].';'; } else { if($global_font2){ $custom_css .= 'font-family: '.$global_font2.';'; }} if($p_combo['rtsize']) { $custom_css .= 'font-size: '.$p_combo['rtsize'].';'; } if($packageType['rtcolor']) { $custom_css .= 'color: '.$packageType['rtcolor'].';'; } if($packageType['rbcolor']) { $custom_css .= 'background: '.$packageType['rbcolor'].' !important;background: -moz-linear-gradient('.$rlight.' 0%, '.$packageType['rbcolor'].' 100%) !important;background: -webkit-linear-gradient('.$rlight.' 0%, '.$packageType['rbcolor'].' 100%) !important;background: -o-linear-gradient('.$rlight.' 0%, '.$packageType['rbcolor'].' 100%) !important;background: -ms-linear-gradient('.$rlight.' 0%, '.$packageType['rbcolor'].' 100%) !important;filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=\''.$rlight.' 0%\', endColorstr=\''.$packageType['rbcolor'].' 100%\', GradientType=1);-ms-filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\''.$rlight.' 0%\', endColorstr=\''.$packageType['rbcolor'].' 100%\',GradientType=1 );background: linear-gradient('.$rlight.' 0%, '.$packageType['rbcolor'].' 100%) !important'; } $custom_css .= '}'.PHP_EOL;
									}
									$custom_css .= '#'.$tableID.' .package_details li .ribbon-color-'.$packageType['pid'].' span::before {border-left: 3px solid '.$packageType['rbcolor'].';border-top: 3px solid '.$packageType['rbcolor'].'}'.PHP_EOL;
									$custom_css .= '#'.$tableID.' .package_details li .ribbon-color-'.$packageType['pid'].' span::after {border-right: 3px solid '.$packageType['rbcolor'].';border-top: 3px solid '.$packageType['rbcolor'].'}'.PHP_EOL;
									$custom_css .= '#'.$tableID.' .package_details:hover li .ribbon-color-'.$packageType['pid'].' span {color: '.$packageType['rthover'].'}'.PHP_EOL;
								/* Ribbon 4 */
								} elseif($p_combo['markrib'] == 'rb-4') {
									/* Price section at top */
									if($p_combo['btompr'] != 'yes') {
										if($p_combo['hprice'] != 'yes') {
											$custom_css .= '#'.$tableID.' .package_details li .rban-color-'.$packageType['pid'].' {top: '.($title_box_height + 1).'px;}'.PHP_EOL;
										} else {
											$custom_css .= '#'.$tableID.' .package_details li .rban-color-'.$packageType['pid'].' {top:'.($title_box_height - 17).'px;}'.PHP_EOL;
										}
									/* Price section at bottom */
									} else {
										if($p_combo['enimg'] != 'yes' && $p_combo['envid'] != 'yes') {
											$custom_css .= '#'.$tableID.' .package_details li .rban-color-'.$packageType['pid'].' {top:10px}'.PHP_EOL;
										} else {
											$custom_css .= '#'.$tableID.' .package_details li .rban-color-'.$packageType['pid'].' {'; if($p_combo['envid'] == 'yes') { $custom_css .= 'top:'.$title_box_height + $video_box_height - 39; } else { $custom_css .= 'top:'.($title_box_height + 1); } $custom_css .= 'px}'.PHP_EOL;
										}
									}
									/* Table BG is enable */
									if($p_combo['etclr'] == 'yes') {
										$custom_css .= '#'.$tableID.' .package_details li .rban-color-'.$packageType['pid'].' {right:-'.($p_combo['tbpad']+8).'px}'.PHP_EOL;
									}
									/* Font and color Setup */
									if($p_combo['sgfont'] || $global_font2 || $p_combo['rtsize'] || $packageType['rbcolor'] || $packageType['rtcolor']) {
										$custom_css .= '#'.$tableID.' .package_details li .rban-color-'.$packageType['pid'].' a {'; if($p_combo['sgfont']) { $custom_css .= 'font-family: '.$p_combo['sgfont'].';'; } else { if($global_font2){ $custom_css .= 'font-family: '.$global_font2.';'; }} if($p_combo['rtsize']) { $custom_css .= 'font-size: '.$p_combo['rtsize'].';'; } if($packageType['rbcolor']) { $custom_css .= 'background: '.$packageType['rbcolor'].';'; } if($packageType['rtcolor']) { $custom_css .= 'color: '.$packageType['rtcolor']; } $custom_css .= '}'.PHP_EOL;
									}
									$custom_css .= '#'.$tableID.' .package_details li .rban-color-'.$packageType['pid'].' a:before {border-color: '.$packageType['rbcolor'].' transparent}'.PHP_EOL;
									$custom_css .= '#'.$tableID.' .package_details li .rban-color-'.$packageType['pid'].' a:after {border-top: 8px solid rgba(0,0,0,.5)}'.PHP_EOL;
									$custom_css .= '#'.$tableID.' .package_details:hover li .rban-color-'.$packageType['pid'].' a {color: '.$packageType['rthover'].'}'.PHP_EOL;
								/* Ribbon 5 */
								} elseif($p_combo['markrib'] == 'rb-5') {
									/* Price section at top */
									if($p_combo['btompr'] != 'yes') {
										if($p_combo['hprice'] != 'yes') {
											$custom_css .= '#'.$tableID.' .package_details li .rcon-color-'.$packageType['pid'].' {top: '.($title_box_height-1).'px}'.PHP_EOL;
										} else {
											$custom_css .= '#'.$tableID.' .package_details li .rcon-color-'.$packageType['pid'].' {top: 0}'.PHP_EOL;
										}
										/* Price section at bottom */
									} else {
										if($p_combo['enimg'] != 'yes' && $p_combo['envid'] != 'yes') {
											$custom_css .= '#'.$tableID.' .package_details li .rcon-color-'.$packageType['pid'].' {top: 0}'.PHP_EOL;
										} else {
											$custom_css .= '#'.$tableID.' .package_details li .rcon-color-'.$packageType['pid'].' {top: '.($title_box_height-1).'px}'.PHP_EOL;
										}
									}
									/* Font and color Setup */
									if($p_combo['sgfont'] || $global_font2 || $p_combo['rtsize'] || $packageType['rtcolor'] || $packageType['rbcolor']) {
										$custom_css .= '#'.$tableID.' .package_details li .rcon-color-'.$packageType['pid'].' a {'; if($p_combo['sgfont']) { $custom_css .= 'font-family: '.$p_combo['sgfont'].';'; } else { if($global_font2){ $custom_css .= 'font-family: '.$global_font2.';'; }} if($p_combo['rtsize']) { $custom_css .= 'font-size: '.$p_combo['rtsize'].';'; } if($packageType['rtcolor']) { $custom_css .= 'color: '.$packageType['rtcolor'].';'; } if($packageType['rbcolor']) { $custom_css .= 'background: '.$packageType['rbcolor'].';background: -moz-linear-gradient('.$rdark.' 0%, '.$packageType['rbcolor'].' 100%);background: -webkit-linear-gradient('.$rdark.' 0%, '.$packageType['rbcolor'].' 100%);background: -o-linear-gradient('.$rdark.' 0%, '.$packageType['rbcolor'].' 100%);background: -ms-linear-gradient('.$rdark.' 0%, '.$packageType['rbcolor'].' 100%);filter: progid:DXImageTransform.Microsoft.gradient(startColorstr=\''.$rdark.' 0%\', endColorstr=\''.$packageType['rbcolor'].' 100%\', GradientType=1);-ms-filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\''.$rdark.' 0%\', endColorstr=\''.$packageType['rbcolor'].' 100%\',GradientType=1 );background: linear-gradient('.$rdark.' 0%, '.$packageType['rbcolor'].' 100%);border: 1px solid '.$rlight; } $custom_css .= '}'.PHP_EOL;
									}
									$custom_css .= '#'.$tableID.' .package_details:hover li .rcon-color-'.$packageType['pid'].' a {color: '.$packageType['rthover'].'}'.PHP_EOL;
								}
							}
							/* If column is special */
							if($packageType['spack'] == 'yes') {
								$column_number = $packageType['pid'];
								/* Table BG Enable */
								if($p_combo['etclr'] == 'yes') {
									/* No Column Space */
									if($p_combo['colgap'] == '' || $p_combo['colgap'] == 0) {
										$custom_css .= '#'.$tableID.' .package_details.details-'.($column_number+1).' {padding-left: 0 !important}'.PHP_EOL;
									}
									/* Image or Video Enable */
									if($p_combo['enimg'] == 'yes' || $p_combo['envid'] == 'yes') {
										if(($p_combo['enimg'] == 'yes' && $p_combo['bgimg'] != 'yes') && ($p_combo['opimg'] == 'opt-3' || $p_combo['opimg'] == 'opt-4')) {
											$custom_css .= '#'.$tableID.' .special-package li.plan-'.$packageType['pid'].'.top_price {height: '.($image_height_a+40).'px;line-height: '.($image_height_a+40).'px}'.PHP_EOL;
										} elseif($p_combo['envid'] == 'yes' && $p_combo['opvid'] == 'vid-3') {
											$custom_css .= '#'.$tableID.' .special-package li.plan-'.$packageType['pid'].'.top_price {height: '.$price_box_height.'px;line-height: '.$price_box_height.'px}'.PHP_EOL;
										} elseif($p_combo['envid'] == 'yes' && $p_combo['opvid'] == 'vid-1') {
											/* Price section at top */
											if($p_combo['btompr'] != 'yes') {
												$custom_css .= '#'.$tableID.' .special-package li.pricing_table_video {height: '.($video_height+20).'px !important;line-height: '.($video_height+20).'px !important}'.PHP_EOL;
											/* Price section at bottom */
											} else {
												$custom_css .= '#'.$tableID.' .special-package li.pricing_table_video {height: '.$video_height.'px !important;line-height: '.$video_height.'px !important}'.PHP_EOL;
											}
										} else {
											$custom_css .= '#'.$tableID.' .special-package li.plan-'.$packageType['pid'].'.top_price {height: '.($image_height_a+20).'px;line-height: '.($image_height_a+20).'px}'.PHP_EOL;
										}
										/* No image or video */
									} else {
										$custom_css .= '#'.$tableID.' .special-package li.plan-'.$packageType['pid'].' {'; if($p_combo['btompr'] != 'yes') { $custom_css .= 'height: '.($price_box_height+20).'px !important;line-height: '.($price_box_height+20).'px !important'; } $custom_css .= '}'.PHP_EOL;
									}
									/* Special column button */
									if($p_combo['topbut'] == 'yes') {
										$custom_css .= '#'.$tableID.' .special-package li.pricing_table_button {height:'.$button_box_height.'px !important;line-height:'.$button_box_height.'px !important;padding-top: 0}'.PHP_EOL;
									} else {
										$custom_css .= '#'.$tableID.' .special-package li.pricing_table_button {height:'.($button_box_height+15).'px !important;line-height:'.$button_box_height.'px !important;padding-top: 5px}'.PHP_EOL;
									}
									/* Table BG Not Enable */
								} else {
									/* Image or Video Enable */
									if($p_combo['enimg'] == 'yes' || $p_combo['envid'] == 'yes') {
										if(($p_combo['enimg'] == 'yes' && $p_combo['bgimg'] != 'yes') && ($p_combo['opimg'] == 'opt-3' || $p_combo['opimg'] == 'opt-4')) {
											$custom_css .= '#'.$tableID.' .special-package li.plan-'.$packageType['pid'].'.top_price {height: '.($image_height_a+40).'px;line-height: '.($image_height_a+40).'px}'.PHP_EOL;
										} elseif($p_combo['envid'] == 'yes' && $p_combo['opvid'] == 'vid-3') {
											$custom_css .= '#'.$tableID.' .special-package li.plan-'.$packageType['pid'].'.top_price {height: '.$price_box_height.'px;line-height: '.$price_box_height.'px}'.PHP_EOL;
										} elseif($p_combo['envid'] == 'yes' && $p_combo['opvid'] == 'vid-1') {
											/* Price section at top */
											if($p_combo['btompr'] != 'yes') {
												$custom_css .= '#'.$tableID.' .special-package li.pricing_table_video {height: '.($video_height+20).'px !important;line-height: '.($video_height+20).'px !important}'.PHP_EOL;
											/* Price section at bottom */
											} else {
												$custom_css .= '#'.$tableID.' .special-package li.pricing_table_video {height: '.$video_height.'px !important;line-height: '.$video_height.'px !important}'.PHP_EOL;
											}
										} else {
											$custom_css .= '#'.$tableID.' .special-package li.plan-'.$packageType['pid'].'.top_price {height: '.($image_height_a+20)-$table_padding.'px;line-height: '.($image_height_a+20)-$table_padding.'px}'.PHP_EOL;
										}
										/* No image or video */
									} else {
										$custom_css .= '#'.$tableID.' .special-package li.plan-'.$packageType['pid'].' {'; if($p_combo['btompr'] != 'yes') { $custom_css .= 'height: '.($price_box_height+20)-$table_padding.'px !important;line-height: '.($price_box_height+20)-$table_padding.'px !important'; } $custom_css .= '}'.PHP_EOL;
									}
									/* Special column button */
									if($p_combo['topbut'] == 'yes') {
										$custom_css .= '#'.$tableID.' .special-package li.pricing_table_button {height:'.$button_box_height.'px !important;line-height:'.$button_box_height.'px !important;padding-top: 0}'.PHP_EOL;
									} else{
										$custom_css .= '#'.$tableID.' .special-package li.pricing_table_button {height:'.($button_box_height+10).'px !important;line-height:'.($button_box_height-3).'px !important;padding-top: 5px}'.PHP_EOL;
									}
								}
								/* Special column margin, padding and BG */
								$custom_css .= '#'.$tableID.' .special-package {z-index: 100;'; if($p_combo['btompr'] == 'yes') { if($p_combo['enimg'] == 'yes' && $p_combo['bgimg'] != 'yes') { $custom_css .= 'margin-top: 0'; } else { $custom_css .= 'margin-top: 20px'; }} else { if($p_combo['hprice'] != 'yes') { $custom_css .= 'margin-top: 0'; } else { $custom_css .= 'margin-top: 20px'; }} $custom_css .= ';'; if($p_combo['etclr'] == 'yes') { $custom_css .= 'padding-right:'; if($table_padding) { $custom_css .= $table_padding.'px !important'; } else { $custom_css .= '2px !important'; } $custom_css .= ';background-color: '.$packageType['tbcolor']; } $custom_css .= '}'.PHP_EOL;
								/* Special column title height */
								$custom_css .= '#'.$tableID.' .special-package li.pricing_table_title {height: '.($title_box_height+20).'px !important;line-height: '.($title_box_height+20).'px !important}'.PHP_EOL;
								/* Special column button body */
								if($p_combo['btbody'] == '' && $p_combo['topbut'] != 'yes') {
									$custom_css .= '#'.$tableID.' .special-package li.pricing_table_button {height:80px !important;line-height:80px !important}'.PHP_EOL;
								} else {
									if($p_combo['topbut'] != 'yes') {
										$custom_css .= '#'.$tableID.' .special-package li.pricing_table_button {height:'.((int)$p_combo['btbody']+20).'px !important;line-height:'.((int)$p_combo['btbody']+20).'px !important}'.PHP_EOL;
									}
								}
								/* Button at top */
								if(($p_combo['enfbor'] == 'yes' && $p_combo['topbut'] == 'yes') && $packageType['ftborder']) {
									$custom_css .= '#'.$tableID.' .package_details li.ftcolor-'.$packageType['pid'].'.last-feature{height: '.($feature_box_height+30).'px;}'.PHP_EOL;
								}
								/* Special column ribbon */
								/* Ribbon 1 */
								if($p_combo['markrib'] == 'rb-1') {
									/* Price section at top */
									if($p_combo['btompr'] != 'yes') {
										if($p_combo['hprice'] != 'yes') {
											$custom_css .= '#'.$tableID.' .special-package li .wrc-ribbon {top:'.($title_box_height + 21).'px}'.PHP_EOL;
										} else {
											$custom_css .= '#'.$tableID.' .special-package li .wrc-ribbon {top:'.($title_box_height-14).'px}'.PHP_EOL;
										}
									/* Price section at bottom */
									} else {
										if(($p_combo['enimg'] == 'yes' && $p_combo['bgimg'] != 'yes') || $p_combo['envid'] == 'yes') {
											$custom_css .= '#'.$tableID.' .special-package li .wrc-ribbon {top:'.($title_box_height + 21).'px}'.PHP_EOL;
										}
									}
								}
								/* Ribbon 2 */
								if($p_combo['markrib'] == 'rb-2') {
									/* Price section at top */
									if($p_combo['btompr'] != 'yes') {
										if($p_combo['hprice'] != 'yes') {
											$custom_css .= '#'.$tableID.' .special-package li .ribbon-container {'; if($p_combo['enimg'] == 'yes' && $p_combo['bgimg'] != 'yes') { $custom_css .= 'top: '.($title_box_height + $image_height_a) + 6; } elseif($p_combo['envid'] == 'yes') { $custom_css .= 'top: '.($title_box_height + $video_box_height) + 6; } else { $custom_css .= 'top: '.($title_box_height + $price_box_height) + 6; } $custom_css .= 'px}'.PHP_EOL;
										} else {
											$custom_css .= '#'.$tableID.' .special-package li .ribbon-container {top:'.($title_box_height-10).'px}'.PHP_EOL;
										}
										/* Price section at bottom */
									} else {
										if(($p_combo['enimg'] == 'yes' && $p_combo['bgimg'] != 'yes') || $p_combo['envid'] == 'yes') {
											$custom_css .= '#'.$tableID.' .special-package li .ribbon-container {'; if($p_combo['envid'] != 'yes') { $custom_css .= 'top: '.(($title_box_height + $image_height_a) + 6).'px;'; } else { $custom_css .= 'top: '.(($title_box_height + $video_box_height) - 14).'px;'; } $custom_css .= '}'.PHP_EOL;
										}
									}
								}
								/* Ribbon 4 */
								if($p_combo['markrib'] == 'rb-4') {
									/* Price section at top */
									if($p_combo['btompr'] != 'yes') {
										if($p_combo['hprice'] != 'yes') {
											$custom_css .= '#'.$tableID.' .special-package li .ribbon-banner {top:'.($title_box_height + 21).'px;}'.PHP_EOL;
										} else {
											$custom_css .= '#'.$tableID.' .special-package li .ribbon-banner {top:'.($title_box_height - 14).'px;}'.PHP_EOL;
										}
									/* Price section at bottom */
									} else {
										if(($p_combo['enimg'] == 'yes' && $p_combo['bgimg'] != 'yes') || $p_combo['envid'] == 'yes') {
											$custom_css .= '#'.$tableID.' .special-package li .ribbon-banner {'; if($p_combo['envid'] == 'yes') { $custom_css .= 'top:'.($title_box_height + $video_box_height - 19); } else { $custom_css .= 'top:'.($title_box_height + 21); } $custom_css .= 'px}'.PHP_EOL;
										}
									}
								}
								/* Ribbon 5 */
								if($p_combo['markrib'] == 'rb-5') {
									/* Price section at top */
									if($p_combo['btompr'] != 'yes') {
										if($p_combo['hprice'] != 'yes') {
											$custom_css .= '#'.$tableID.' .special-package li .corner-ribbon {top:'.($title_box_height + 19).'px}'.PHP_EOL;
										} else {
											$custom_css .= '#'.$tableID.' .special-package li .corner-ribbon {top:0}'.PHP_EOL;
										}
										/* Price section at bottom */
									} else {
										if(($p_combo['enimg'] == 'yes' && $p_combo['bgimg'] != 'yes') || $p_combo['envid'] == 'yes') {
											$custom_css .= '#'.$tableID.' .special-package li .corner-ribbon {top:'.($title_box_height + 19).'px}'.PHP_EOL;
										}
									}
								}
							}
							/* Table background is Enable */
							if($p_combo['etclr'] == 'yes') {
								$custom_css .= '#'.$tableID.' .package_details.details-'.$packageType['pid'].' {background: '.$packageType['pbclr'].';}'.PHP_EOL;
								/* No Space Between Columns */
								if($p_combo['colgap'] == '' || $p_combo['colgap'] == 0) {
									$custom_css .= '#'.$tableID.' .package_details.details-'.$packageType['pid'].' {padding:'; if($table_padding) { $custom_css .= $table_padding.'px'; } else { $custom_css .= '2px'; } $custom_css .= '}'.PHP_EOL;
									$custom_css .= '#'.$tableID.' .package_details.details-'.$packageType['pid'].':last-child{padding-right:'; if($table_padding) { $custom_css .= $table_padding.'px'; } else { $custom_css .= '2px'; } $custom_css .= '}'.PHP_EOL;
									$custom_css .= '#'.$tableID.' .package_details.details-'.$packageType['pid'].':hover {padding:'; if($table_padding) { $custom_css .= $table_padding; } else { $custom_css .= '2'; } $custom_css .= 'px !important}'.PHP_EOL;
									$custom_css .= '#'.$tableID.' .package_details.details-'.$packageType['pid'].':hover:last-child{padding-left:'; if($table_padding) { $custom_css .= $table_padding.'px'; } else { $custom_css .= '2px'; } $custom_css .= ' !important}'.PHP_EOL;
									$custom_css .= '@media only screen and (max-width: 480px) {'.PHP_EOL;
										$custom_css .= '#'.$tableID.' .package_details.details-'.$packageType['pid'].' {padding:'; if($table_padding) { $custom_css .= $table_padding.'px !important'; } else { $custom_css .= '2px !important'; } $custom_css .= '}'.PHP_EOL;
									$custom_css .= '}'.PHP_EOL;
								/* Space Between Columns */
								} else {
									$custom_css .= '#'.$tableID.' .package_details.details-'.$packageType['pid'].' {padding:'; if($table_padding) { $custom_css .= $table_padding.'px'; } else { $custom_css .= '2px'; } $custom_css .= '}'.PHP_EOL;
								}
								/* If button not hide */
								if($p_combo['hbutton'] != 'yes') {
									$custom_css .= '#'.$tableID.' .package_details li.ftcolor-'.$packageType['pid'].'.feature_end {border-bottom: none;'; if($table_padding != '') { $custom_css .= 'margin-bottom: '.($table_padding-1).'px'; } else { $custom_css .= 'margin-bottom: 1px'; } $custom_css .= '}'.PHP_EOL;
								}
							}
							/* Use Image as background */
							if($p_combo['enimg'] == 'yes' && $p_combo['bgimg'] == 'yes') {
								if($p_combo['imgov'] != 'yes') {
									$custom_css .= '#'.$tableID.' .package_details .color-'.$packageType['pid'].',#'.$tableID.' .package_details .plan-'.$packageType['pid'].',#'.$tableID.' .package_details .ftcolor-'.$packageType['pid'].',#'.$tableID.' .package_details .bbcolor-'.$packageType['pid'].' {background: transparent !important;}'.PHP_EOL;
									$custom_css .= '#'.$tableID.' .package_details.details-'.$packageType['pid'].',#'.$tableID.' .package_details.package-'.$packageType['pid'].' {background-image: url('; if($packageType['pimg'] != '') { $custom_css .= $packageType['pimg']; } else { $custom_css .= 'https://www.realwebcare.com/images/bg/pricing_table_'.$p_combo['templ'].'_'.$packageType['pid'].'.png'; } $custom_css .= ');background-position: 50% 50%;-webkit-background-size: cover;-moz-background-size: cover;-o-background-size: cover;background-size: cover;background-repeat: no-repeat;'; if($packageType['imgclr'] != '') { $custom_css .= 'border: '.$table_padding.'px solid '.$packageType['imgclr'].';'; } $custom_css .= '}'.PHP_EOL;
								} else {
									if($p_combo['etclr'] == 'yes') {
										if($table_padding == 0) {
											$pad_width = 4;
										} else {
											$pad_width = $table_padding*2;
										}
										$tot_width = 'calc(100% - '.$pad_width.'px)';
									} else {
										$tot_width = '100%';
									}
									$custom_css .= '#'.$tableID.' .package_details.details-'.$packageType['pid'].':before,#'.$tableID.' .package_details.package-'.$packageType['pid'].':before {content:"";position:absolute;width:'.$tot_width.';height:100%;background-image: url('; if($packageType['pimg'] != '') { $custom_css .= $packageType['pimg']; } else { $custom_css .= 'https://www.realwebcare.com/images/bg/pricing_table_'.$p_combo['templ'].'_'.$packageType['pid'].'.png'; } $custom_css .= ');background-position: 50% 50%;-webkit-background-size: cover;-moz-background-size: cover;-o-background-size: cover;background-size: cover;background-repeat: no-repeat;';if($p_combo['pbrad'] != '' && $p_combo['pbrad'] != 0) { $custom_css .= '-moz-border-radius-topleft:'.$p_combo['pbrad'].'px;-webkit-border-top-left-radius:'.$p_combo['pbrad'].'px;-khtml-border-top-left-radius:'.$p_combo['pbrad'].'px;border-top-left-radius: '.$p_combo['pbrad'].'px;-moz-border-radius-topright:'.$p_combo['pbrad'].'px;-webkit-border-top-right-radius:'.$p_combo['pbrad'].'px;-khtml-border-top-right-radius:'.$p_combo['pbrad'].'px;border-top-right-radius: '.$p_combo['pbrad'].'px;'; } $custom_css .= 'overflow: hidden;z-index: 2}'.PHP_EOL;
								}
							}
						}
					endforeach;
				endif;
				$post_id = array();
			endif;
		endif;
	endforeach;
	if($wrcpt_custom != '') { $custom_css .= $wrcpt_custom; }
	if($st_pageid == false) {
		return $custom_css;
	} else {
		return $scode_pageid;
	}
}
?>