<?php
/**
 * Adding a top-level menu page and a submenu page for pricing table plugin.
 *
 * @uses  add_menu_page()	 - Adding a top-level menu page for pricing table plugin.
 * These functions takes a capability which will be used to determine whether
 * or not a page is included in the menu.
 *
 * @uses  add_submenu_page() - Adding a submenu page for pricing table plugin.
 * The functions which is hooked in to handle the output of the page must check
 * that the user has the required capability as well.
 *
 * Including other pages to make the plugin workable.
 *
 * WRC Pricing Tables Ultimate - v1.2.4 - 16 July, 2023
 */
add_action('admin_menu', 'wrcpt_register_menu');
define( 'WRCPT_DOMAIN', 'wrcpt' );

/* Adding a top-level and submenu pages*/
function wrcpt_register_menu() {
	add_menu_page('WRC Pricing Table', __('Pricing Tables', WRCPT_DOMAIN ), 'add_users', __FILE__, 'wrcpt_plugin_menu', plugins_url( '../images/icon.png', __FILE__ ));
	add_submenu_page(__FILE__, __('WRCPT Lists', WRCPT_DOMAIN ), __('All Pricing Tables', WRCPT_DOMAIN ), 'add_users', __FILE__, 'wrcpt_plugin_menu');
	add_submenu_page(__FILE__, 'WRCPT Template', __('Templates', WRCPT_DOMAIN ), 'add_users', 'wrcpt_template', 'wrcpt_template_page');
	add_submenu_page(__FILE__, 'WRCPT Global', __('Tools', WRCPT_DOMAIN ), 'add_users', 'wrcpt_global', 'wrcpt_global_page');
	add_submenu_page(__FILE__, 'WRCPT Help', __('Help', WRCPT_DOMAIN ), 'add_users', 'wrcpt_help', 'wrcpt_help_page');
}

/* Including Help File */
function wrcpt_help_page() {
	if ( !current_user_can( 'manage_options' ) )  {
		wp_die( __( 'You do not have sufficient permissions to access this page.' ) );
	}
	require_once ( WRCPT_PLUGIN_PATH . 'inc/wrcpt-guide.php' );
}

/* Including Pricing Table Global Settings Page */
function wrcpt_global_page() {
	if ( !current_user_can( 'manage_options' ) )  {
		wp_die( __( 'You do not have sufficient permissions to access this page.', 'wrcpt' ) );
	}
	require_once ( WRCPT_PLUGIN_PATH . 'lib/process-global-settings.php' );
}

/* Including Template File */
function wrcpt_template_page() {
	if ( !current_user_can( 'manage_options' ) )  {
		wp_die( __( 'You do not have sufficient permissions to access this page.', WRCPT_DOMAIN ) );
	}
	require_once ( WRCPT_PLUGIN_PATH . 'template/process-template.php' );
}

/* Including Process File */
function wrcpt_plugin_menu() {
	if ( !current_user_can( 'manage_options' ) )  {
		wp_die( __( 'You do not have sufficient permissions to access this page.', WRCPT_DOMAIN ) );
	}
	require_once ( WRCPT_PLUGIN_PATH . 'inc/process-table.php' );
}

/* Including other files to make the plugin workable. */
require_once ( WRCPT_PLUGIN_PATH . 'lib/process_table-option.php' );
require_once ( WRCPT_PLUGIN_PATH . 'template/process-template-option.php' );
require_once ( WRCPT_PLUGIN_PATH . 'inc/modify-package.php' );
require_once ( WRCPT_PLUGIN_PATH . 'inc/process-feature.php' );
require_once ( WRCPT_PLUGIN_PATH . 'inc/display-package.php' );
require_once ( WRCPT_PLUGIN_PATH . 'inc/wrcpt-sidebar.php' );

/* Calling a function to add a new pricing table details. */
if(isset($_POST['new_pricing_table']) && $_POST['new_pricing_table'] == "newtable") {
	if( isset( $_POST['wrcpt_add_new'] ) ) { wrcpt_add_new_table(); }
}

/* Calling a function to set pricing table global options. */
if(isset($_POST['wrcpt_global']) && $_POST['wrcpt_global'] == "process") {
	if( isset( $_POST['wrcpt_process'] ) ) { wrcpt_set_global_options(); }
	/* Optimizing database by deleting unnecessary package options. */
	if( isset( $_POST['wrcpt_optimize'] ) ) { wrcpt_unuseful_package_options(); }
}
if(isset($_POST['wrcpt_custom']) && $_POST['wrcpt_custom'] == "custcss") {
	if( isset( $_POST['wrcpt_ccss'] ) ) { wrcpt_set_global_options(); }
}
?>