<?php
/**
 * Generating preview/demo of the plugin to get an idea that
 * how the plugin will look like at the front-end?
 * WRC Pricing Tables Ultimate - v1.2.4 - 16 July, 2023
 */
function wrcpt_view_pricing_packages() {
	$i = 1;
	$pricing_table = $_POST['packtable'];
	$tableId = $_POST['tableid'];
	$package_lists = get_option($pricing_table);
	$packageOptions = explode(', ', $package_lists);
	$packageCount = count($packageOptions); ?>
	<style type="text/css">
		*,*:after,*:before{-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;padding:0;margin:0}
	</style>
	<div id="tabledisplaydiv">
		<h3><span id="editPackages" class="edit_pack button button-large" data-id="<?php echo $pricing_table; ?>" data-count="<?php echo $packageCount; ?>"><?php _e('Edit Columns', 'wrcpt'); ?></span></h3>
		<?php echo do_shortcode('[wrc-pricing-table id="'.$tableId.'"]'); ?>
	</div>
    <p class="get_started"><?php _e('<strong>&#8270;&#8270;</strong> Preview may be slightly different from the original results due to the variation of CSS in front-end and admin panel. From the preview, you will just get an idea that, how the plugin will look like at the front-end after publishing.<br><br><strong>&#8270;&#8270;</strong> Pricing Toggle will not work in preview due to WordPress admin jQuery setup. Publish the shorcode in your theme. There the pricing toggle will work.', 'wrcpt'); ?></p>
<?php
	die;
}
add_action( 'wp_ajax_nopriv_wrcpt_view_pricing_packages', 'wrcpt_view_pricing_packages' );
add_action( 'wp_ajax_wrcpt_view_pricing_packages', 'wrcpt_view_pricing_packages' );
?>