<?php
/**
 * Updating Pricing Table columns by editing column and feature details
 * and/or by adding new column as well.
 *
 * Also coloring the table using ColorPicker and
 * configuring the table from pricing table settings.
 *
 * WRC Pricing Tables Ultimate - v1.2.4 - 16 July, 2023
 */
function wrcpt_edit_pricing_packages() {
	$fv = 1; $ac = 1; $cf = 1; $sc = 1; $ed = 0;
	$f_value = '';
	$f_tips = '';
	// get the pricing table name
	$pricing_table = $_POST['packtable'];

	// make the first word uppercare and remove '_' by space
	$pricing_table_name = ucwords(str_replace('_', ' ', $pricing_table));
	// get feature options for the table
	$package_feature = get_option($pricing_table.'_feature');
	// get settings options for the table
	$packageCombine = get_option($pricing_table.'_option');
	// get packageOptions1, packageOptions2, ... for the table
	$package_lists = get_option($pricing_table);
	// get package options in an array
	$packageOptions = explode(', ', $package_lists);
	$packageItem = get_option($packageOptions[0]);
	$global_options = get_option('pricing_table_global');

	// check how many features are available
	if(isset($package_feature['flink1'])) {
		if(isset($package_feature['fcate1'])) {
			$featureNum = count($package_feature)/6;
		} else {
			$featureNum = count($package_feature)/5;
		}
	} else {
		$featureNum = count($package_feature)/2;
	}

	$template = isset($packageCombine['templ']) ? $packageCombine['templ'] : 'temp0';
	$checkValue = uniqid('yes');
	$siteurl = get_site_url();

	if(isset($global_options['wpedit']) && $global_options['wpedit'] == 'yes') {
		$editor = 'wysiwyg';
	} else {
		$editor = 'editor';
	} ?>
	<input type="hidden" name="wrcpt_process" value="process" />
	<div id="tablecolumndiv">
		<div class="tablecolumnwrap">
			<h3><?php _e('Pricing Table Columns', 'wrcpt'); ?></h3>
			<!-- <div id="addButtons"><a href="#" class="button button-large" id="addPackage"><?php //_e('New Column', 'wrcpt'); ?></a></div> -->
			<div id="addButtons">
				<a id="addPackage" class="newcolumn" href="#" role="button">
					<span><?php _e('New Column', 'wrcpt'); ?></span>
					<div class="icon">
						<i class="dashicons dashicons-plus-alt"></i>
						<i class="dashicons dashicons-yes-alt"></i>
					</div>
				</a>
			</div>
			<div class="accordion-expand-holder">
				<button type="button" class="expand"><span class="dashicons dashicons-editor-expand"></span>&nbsp;<?php _e(' Expand', 'wrcpt'); ?></button>
				<button type="button" class="collapse"><span class="dashicons dashicons-editor-contract"></span>&nbsp;<?php _e(' Collapse', 'wrcpt'); ?></button>
			</div>
			<div id="sortable_column">
			<?php
			if(!empty($package_lists)) {
				foreach($packageOptions as $option => $value) {
				$packageValue = get_option($value); ?>
                <!-- Start package_details -->
				<div id="wrcpt-<?php echo $ac; ?>" class="package_details">
					<h4 id="pcolumn<?php echo $ac; ?>" class="tablenum">Pricing Column <?php echo $ac; ?></h4>
					<?php if($packageValue['pdisp'] == 'show') { ?><span id="hidePack<?php echo $ac; ?>" class="column_hide"><span class="dashicons dashicons-fullscreen-alt"></span><?php } else { ?><span id="showPack<?php echo $ac; ?>" class="column_show"><span class="dashicons dashicons-fullscreen-exit-alt"></span><?php } ?><input type="hidden" name="hide_show[]" value="<?php echo $packageValue['pdisp']; ?>" /></span>
					<span id="delPackage"><span class="dashicons dashicons-trash"></span></span>
					<div id="accordion<?php echo $ac; ?>" class="column_container">
						<h3 class="ptitle"><?php _e('Pricing Column Details', 'wrcpt'); ?></h3>
						<div class="element-input">
							<label class="input-check"><?php _e('Enlarge Column?', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('If you want to highlight the current column from some of the other columns, simply mark the checkbox.', 'wrcpt'); ?>"></a></label>
							<input type="checkbox" class="tickbox" name="special_package[<?php echo $ac-1; ?>]" id="special_package" value="yes"<?php if($packageValue['spack'] == 'yes') {?> checked="checked"<?php } ?> /><hr />
							<h4><?php _e('Package Name', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('Enter your pricing package name here. You can also enter a short description of the package name. There are many users who choose a package based on the name, instead of features. So, a short description might help users to select the appropriate package.', 'wrcpt'); ?>"></a></h4>
							<label class="input-title"><?php _e('Package Name', 'wrcpt'); ?></label>
							<input type="text" name="package_type[]" class="medium" id="package_type" value="<?php echo $packageValue['type']; ?>" />
    						<textarea name="package_desc[]" class="medium" id="package_desc" cols="27" rows="2" placeholder="<?php _e('Enter Short Description', 'wrcpt'); ?>"><?php echo $packageValue['tdesc']; ?></textarea><hr />
							<h4><?php _e('Package Pricing', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('Enter the price of the package, price currency, price plan (monthly or yearly) and a short description about pricing.', 'wrcpt'); ?>"></a></h4>
							<label class="input-title"><?php _e('Package Price', 'wrcpt'); ?></label>
							<input name="price_number[]" type="text" class="col_price" value="<?php echo $packageValue['price']; ?>" />&nbsp;.&nbsp;<input name="price_fraction[]" type="number" class="col_price" value="<?php echo $packageValue['cent']; ?>" min="0" max="99" placeholder="00" />
							<label class="input-title"><?php _e('Cut Price', 'wrcpt'); ?></label>
			  				<input name="price_cut[]" type="text" class="col_price" value="<?php echo $packageValue['cutpr']; ?>" placeholder="0" />&nbsp;.&nbsp;<input name="cut_fraction[]" type="number" class="col_price" value="<?php echo $packageValue['cutfr']; ?>" min="0" max="99" placeholder="00" />
							<label class="input-title"><?php _e('Price Plan', 'wrcpt'); ?></label>
							<input name="package_plan[]" id="package_plan" type="text" class="medium" value="<?php echo $packageValue['plan']; ?>" />
							<label class="input-title"><?php _e('Price Unit', 'wrcpt'); ?></label>
							<input name="price_unit[]" id="price_unit" type="text" class="medium" value="<?php echo $packageValue['unit']; ?>" />
							<label class="input-check"><?php _e('Enable Pricing Toggle', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('If you want to display another price for this package using Pricing Toggle, simply mark the checkbox.', 'wrcpt'); ?>"></a></label>
							<?php if($packageValue['enptg'] == 'show') { ?><span id="showToggle<?php echo $ac; ?>" class="toggle_hide"><span class="dashicons dashicons-yes"></span><?php } else { ?><span id="showToggle<?php echo $ac; ?>" class="toggle_show"><span class="dashicons dashicons-empty"></span><?php } ?><input type="hidden" name="toggle_display[]" id="toggle_display" value="<?php echo $packageValue['enptg']; ?>" /></span>
							<div id="enable_toggle">
								<label class="input-title"><?php _e('Package Price (2nd Toggle)', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('Enter another price, if Pricing Toggle is enabled.', 'wrcpt'); ?>"></a></label>
								<input name="price_number_toggle[]" type="text" class="col_price" value="<?php echo $packageValue['tgprice']; ?>" />&nbsp;.&nbsp;<input name="price_fraction_toggle[]" type="number" class="col_price" value="<?php echo $packageValue['tgcent']; ?>" min="0" max="99" placeholder="00" />
								<label class="input-title"><?php _e('Cut Price (2nd Toggle)', 'wrcpt'); ?></label>
								<input name="price_cut_toggle[]" type="text" class="col_price" value="<?php echo $packageValue['tgcut']; ?>" />&nbsp;.&nbsp;<input name="cut_fraction_toggle[]" type="number" class="col_price" value="<?php echo $packageValue['tgcutfr']; ?>" min="0" max="99" placeholder="00" />
								<label class="input-title"><?php _e('Price Plan (2nd Toggle)', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('Enter another price plan (e.g. monthly or yearly), if Pricing Toggle is enabled.', 'wrcpt'); ?>"></a></label>
								<input name="package_plan_toggle[]" id="package_plan_toggle" type="text" class="medium" value="<?php echo $packageValue['tgplan']; ?>" />
								<label class="input-title"><?php _e('Price Unit (2nd Toggle)', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('Enter another price unit (e.g. $ or &#2547;), if Pricing Toggle is enabled.', 'wrcpt'); ?>"></a></label>
								<input name="price_unit_toggle[]" id="price_unit_toggle" type="text" class="medium" value="<?php echo $packageValue['tgunit']; ?>" />
								<label class="input-title"><?php _e('1st Button Link (2nd Toggle)', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('Enter button link for another price, if Pricing Toggle is enabled.', 'wrcpt'); ?>"></a></label>
								<input type="text" name="button_toggle_link[]" class="medium" id="button_toggle_link" value="<?php echo $packageValue['btglink']; ?>" placeholder="<?php _e('e.g. http://example.com', 'wrcpt'); ?>" />
								<div class="pricing_button_two">
									<label class="input-title"><?php _e('2nd Button Link (2nd Toggle)', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('Enter button link for another price, if Pricing Toggle is enabled.', 'wrcpt'); ?>"></a></label>
									<input type="text" name="second_btn_tglink1[]" class="medium" id="second_btn_tglink1" value="<?php echo $packageValue['sbntl1']; ?>" placeholder="<?php _e('e.g. http://example.com', 'wrcpt'); ?>" />
								</div>
								<div id="third_toggle_features">
									<hr>
									<label class="input-title"><?php _e('Package Price (3rd Toggle)', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('Enter another price, if Pricing Toggle is enabled.', 'wrcpt'); ?>"></a></label>
									<input name="price_number_toggle2[]" type="text" class="col_price" value="<?php echo $packageValue['tgprc2']; ?>" placeholder="0" />&nbsp;.&nbsp;<input name="price_fraction_toggle2[]" type="number" class="col_price" value="<?php echo $packageValue['tgcnt2']; ?>" min="0" max="99" placeholder="00" />
									<label class="input-title"><?php _e('Cut Price (3rd Toggle)', 'wrcpt'); ?></label>
									<input name="price_cut_toggle2[]" type="text" class="col_price" value="<?php echo $packageValue['tgcut2']; ?>" placeholder="0" />&nbsp;.&nbsp;<input name="cut_fraction_toggle2[]" type="number" class="col_price" value="<?php echo $packageValue['tgcfr2']; ?>" min="0" max="99" placeholder="00" />
									<label class="input-title"><?php _e('Price Plan (3rd Toggle)', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('Enter another price plan (e.g. monthly or yearly), if Pricing Toggle is enabled.', 'wrcpt'); ?>"></a></label>
									<input name="package_plan_toggle2[]" type="text" class="medium" value="<?php echo $packageValue['tgpln2']; ?>" placeholder="<?php _e('e.g. month', 'wrcpt'); ?>" />
									<label class="input-title"><?php _e('Price Unit (3rd Toggle)', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('Enter another price unit (e.g. $ or &#2547;), if Pricing Toggle is enabled.', 'wrcpt'); ?>"></a></label>
									<input name="price_unit_toggle2[]" type="text" class="medium" value="<?php echo $packageValue['tgunt2']; ?>" placeholder="<?php _e('e.g. $', 'wrcpt'); ?>" />
									<label class="input-title"><?php _e('1st Button Link (3rd Toggle)', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('Enter button link for another price, if Pricing Toggle is enabled.', 'wrcpt'); ?>"></a></label>
									<input name="button_toggle_link2[]" type="text" class="medium" value="<?php echo $packageValue['tgbln2']; ?>" placeholder="<?php _e('e.g. http://example.com', 'wrcpt'); ?>" />
									<div class="pricing_button_two">
										<label class="input-title"><?php _e('2nd Button Link (3rd Toggle)', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('Enter button link for another price, if Pricing Toggle is enabled.', 'wrcpt'); ?>"></a></label>
										<input name="second_btn_tglink2[]" type="text" class="medium" value="<?php echo $packageValue['sbntl2']; ?>" placeholder="<?php _e('e.g. http://example.com', 'wrcpt'); ?>" />
									</div>
								</div>
								<div id="forth_toggle_features">
									<hr>
									<label class="input-title"><?php _e('Package Price (4th Toggle)', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('Enter another price, if Pricing Toggle is enabled.', 'wrcpt'); ?>"></a></label>
									<input name="price_number_toggle3[]" type="text" class="col_price" value="<?php echo $packageValue['tgprc3']; ?>" placeholder="0" />&nbsp;.&nbsp;<input name="price_fraction_toggle3[]" type="number" class="col_price" value="<?php echo $packageValue['tgcnt3']; ?>" min="0" max="99" placeholder="00" />
									<label class="input-title"><?php _e('Cut Price (4th Toggle)', 'wrcpt'); ?></label>
									<input name="price_cut_toggle3[]" type="text" class="col_price" value="<?php echo $packageValue['tgcut3']; ?>" placeholder="0" />&nbsp;.&nbsp;<input name="cut_fraction_toggle3[]" type="number" class="col_price" value="<?php echo $packageValue['tgcfr3']; ?>" min="0" max="99" placeholder="00" />
									<label class="input-title"><?php _e('Price Plan (4th Toggle)', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('Enter another price plan (e.g. monthly or yearly), if Pricing Toggle is enabled.', 'wrcpt'); ?>"></a></label>
									<input name="package_plan_toggle3[]" type="text" class="medium" value="<?php echo $packageValue['tgpln3']; ?>" placeholder="<?php _e('e.g. month', 'wrcpt'); ?>" />
									<label class="input-title"><?php _e('Price Unit (4th Toggle)', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('Enter another price unit (e.g. $ or &#2547;), if Pricing Toggle is enabled.', 'wrcpt'); ?>"></a></label>
									<input name="price_unit_toggle3[]" type="text" class="medium" value="<?php echo $packageValue['tgunt3']; ?>" placeholder="<?php _e('e.g. $', 'wrcpt'); ?>" />
									<label class="input-title"><?php _e('1st Button Link (4th Toggle)', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('Enter button link for another price, if Pricing Toggle is enabled.', 'wrcpt'); ?>"></a></label>
									<input name="button_toggle_link3[]" type="text" class="medium" value="<?php echo $packageValue['tgbln3']; ?>" placeholder="<?php _e('e.g. http://example.com', 'wrcpt'); ?>" />
									<div class="pricing_button_two">
										<label class="input-title"><?php _e('2nd Button Link (4th Toggle)', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('Enter button link for another price, if Pricing Toggle is enabled.', 'wrcpt'); ?>"></a></label>
										<input name="second_btn_tglink3[]" type="text" class="medium" value="<?php echo $packageValue['sbntl3']; ?>" placeholder="<?php _e('e.g. http://example.com', 'wrcpt'); ?>" />
									</div>
								</div>
							</div>
							<hr>
							<textarea name="price_desc[]" class="medium" id="price_desc" cols="27" rows="2" placeholder="<?php _e('Enter Short Description', 'wrcpt'); ?>"><?php echo $packageValue['pdesc']; ?></textarea><hr />
							<h4><?php _e('Package Features', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('Enter feature values and feature ToolTips here. To show the tick icon mark the checkbox and to show cross icon unmark the checkbox. To display ToolTips, you should enable ToolTips in General settings under Pricing Table Settings.', 'wrcpt'); ?>"></a></h4><?php
							if($package_feature) {
								for($i = 1; $i <= $featureNum; $i++) {
									if(isset($packageValue['fitem'.$fv])) {
										$f_value = $packageValue['fitem'.$fv];
										$f_tips = $packageValue['tip'.$fv];
									}
									if($package_feature['ftype'.$i] == 'text') { ?>
										<label class="input-title"><?php echo $package_feature['fitem'.$i]; ?></label><input type="text" class="medium" name="feature_value[]" id="feature_value" value="<?php echo $f_value; ?>" placeholder="<?php _e('Feature Value', 'wrcpt'); ?>" /><textarea name="tooltips[]" id="tooltips" class="medium" cols="27" rows="2" placeholder="<?php _e('Enter Tooltip', 'wrcpt'); ?>"><?php echo $f_tips; ?></textarea><hr /><?php
									} elseif($package_feature['ftype'.$i] == 'html') {
										$ed++; ?>
										<label class="input-title"><?php echo $package_feature['fitem'.$i]; ?></label><?php
										if($editor == 'wysiwyg') :
                                        $editor_settings = array(
                                            'teeny'         => TRUE,
											'tinymce'       => TRUE,
                                            'textarea_name' => 'feature_value[]',
                                            'textarea_rows' => 5,
                                            'editor_class'	=> 'wrcpt-wp-editor',
											'media_buttons' => FALSE,
                                        );
                                        echo wrcpt_get_wp_editor(htmlspecialchars_decode($f_value), 'tablecustom'.$ed, $editor_settings); ?>
                                        <div class="wrcpt-editor-bottom"></div><?php
										else: ?>
										<textarea name="feature_value[]" id="feature_value" class="medium" cols="27" rows="2" placeholder="<?php esc_html_e('<a href="http://www.example.com">Example</a>', 'wrcpt'); ?>"><?php echo esc_textarea($f_value); ?></textarea><?php
										endif; ?>
                                        <textarea name="tooltips[]" id="tooltips" class="medium" cols="27" rows="2" placeholder="<?php _e('Enter Tooltip', 'wrcpt'); ?>"><?php echo $f_tips; ?></textarea><hr /><?php
									} elseif($package_feature['ftype'.$i] == 'check') { ?>
										<label class="input-check"><?php echo $package_feature['fitem'.$i]; ?></label><input type="checkbox" class="tickbox" name="feature_value[<?php echo 'ftype'.$cf; ?>]" id="feature_value" value="<?php echo $checkValue; ?>"<?php if($f_value == 'tick') {?> checked="checked"<?php } ?> /><textarea name="tooltips[]" id="tooltips" class="medium" cols="27" rows="2" placeholder="<?php _e('Enter Tooltip', 'wrcpt'); ?>"><?php echo $f_tips; ?></textarea><hr /><?php
										$cf++;
									} elseif($package_feature['ftype'.$i] == 'starrate') { ?>
										<label class="input-check"><?php echo $package_feature['fitem'.$i]; ?><a href="#" class="wrc_tooltip" rel="<?php _e('Enter your star rating here in between 0 to 5.', 'wrcpt'); ?>"></a></label>
	                                    <input type="number" step="any" class="medium" name="feature_value[]" id="star_value" value="<?php echo $f_value; ?>" min="0" max="5" placeholder="<?php _e('3', 'wrcpt'); ?>" />
                                        <textarea name="tooltips[]" id="tooltips" class="medium" cols="27" rows="2" placeholder="<?php _e('Enter Tooltip', 'wrcpt'); ?>"><?php echo $f_tips; ?></textarea><hr /><?php
										$sc++;
									} else {
										$tc_value = $packageValue['fitem'.$fv.'c']; ?>
										<label class="input-title-check"><?php echo $package_feature['fitem'.$i]; ?></label>
										<input type="checkbox" class="tickbox" name="feature_value[<?php echo 'ftype'.$cf; ?>]" id="feature_value" value="<?php echo $checkValue; ?>"<?php if($tc_value == 'tick') {?> checked="checked"<?php } ?> /><input type="text" class="medium checktext" name="feature_value[]" id="feature_value" value="<?php echo $f_value; ?>" placeholder="<?php _e('Feature Value', 'wrcpt'); ?>" /><textarea name="tooltips[]" id="tooltips" class="medium" cols="27" rows="2" placeholder="<?php _e('Enter Tooltip', 'wrcpt'); ?>"><?php echo $f_tips; ?></textarea><hr /><?php
										$cf++;
									} $fv++;
								}
							} else { echo '<label class="input-title">' . __('There are no feature items!', 'wrcpt') . '</label>'; } ?>
							<h4><?php _e('Package Button', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('Enter your call to action text and call to action URL here. The URL is usually either a payment link or a page where users can create an account.', 'wrcpt'); ?>"></a></h4>
							<label class="input-check"><?php _e('Enable to Enter PayPal Code', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('If you want to display PayPal button instead of normal button or any other subscription button or an iframe, simply mark the checkbox.', 'wrcpt'); ?>"></a></label>
							<?php if($packageValue['paypal'] == 'show') { ?><span id="showPayPal<?php echo $ac; ?>" class="paypal_hide"><span class="dashicons dashicons-yes"></span><?php } else { ?><span id="showPayPal<?php echo $ac; ?>" class="paypal_show"><span class="dashicons dashicons-empty"></span><?php } ?><input type="hidden" name="paypal_button[]" id="paypal_button" value="<?php echo $packageValue['paypal']; ?>" /></span>
							<div id="paypal_code">
                                <label class="input-check"><?php _e('Use Hosted Buttons', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('You need to create new hosted buttons on the Live PayPal site. This ensures that the hosted_button_id value of the button is correct. In PayPal Payments Standard, you can create and store buttons on the PayPal site. These hosted buttons have a hidden variable, hosted_button_id, which has a numerical value. This ID number points to a particular button created by a merchant or developer; it\'s also unique to a particular PayPal account.', 'wrcpt'); ?>"></a></label>
                                <?php if($packageValue['hsbtn'] == 'show') { ?><span id="showHosted<?php echo $ac; ?>" class="hosted_hide"><span class="dashicons dashicons-yes"></span><?php } else { ?><span id="showHosted<?php echo $ac; ?>" class="hosted_show"><span class="dashicons dashicons-empty"></span><?php } ?><input type="hidden" name="hosted_button[]" id="hosted_button" value="<?php echo $packageValue['hsbtn']; ?>" /></span>
                                <div id="hosted-button">
                                    <label class="input-title"><?php _e('Hosted Button ID', 'wrcpt'); ?></label>
                                    <input type="text" name="host_button_id[]" class="medium" id="host_button_id" value="<?php echo $packageValue['hsbid']; ?>" placeholder="<?php _e('RT8RW4A8CWA', 'wrcpt'); ?>" />
                                </div>
								<div id="unencrypted-button">
                                    <h5><?php _e('Currency', 'wrcpt'); ?></h5>
                                    <label class="input-title"><?php _e('Currency', 'wrcpt'); ?></label>
                                    <select name="pp_currency[]" class="font-dir">
                                        <option <?php if ($packageValue['ppcur'] == "AUD") { echo "SELECTED"; } ?> value="AUD">Australian Dollar - AUD</option>
                                        <option <?php if ($packageValue['ppcur'] == "BRL") { echo "SELECTED"; } ?> value="BRL">Brazilian Real - BRL</option> 
                                        <option <?php if ($packageValue['ppcur'] == "CAD") { echo "SELECTED"; } ?> value="CAD">Canadian Dollar - CAD</option>
                                        <option <?php if ($packageValue['ppcur'] == "CZK") { echo "SELECTED"; } ?> value="CZK">Czech Koruna - CZK</option>
                                        <option <?php if ($packageValue['ppcur'] == "DKK") { echo "SELECTED"; } ?> value="DKK">Danish Krone - DKK</option>
                                        <option <?php if ($packageValue['ppcur'] == "EUR") { echo "SELECTED"; } ?> value="EUR">Euro - EUR</option>
                                        <option <?php if ($packageValue['ppcur'] == "HKD") { echo "SELECTED"; } ?> value="HKD">Hong Kong Dollar - HKD</option> 	 
                                        <option <?php if ($packageValue['ppcur'] == "HUF") { echo "SELECTED"; } ?> value="HUF">Hungarian Forint - HUF</option>
                                        <option <?php if ($packageValue['ppcur'] == "ILS") { echo "SELECTED"; } ?> value="ILS">Israeli New Sheqel - ILS</option>
                                        <option <?php if ($packageValue['ppcur'] == "JPY") { echo "SELECTED"; } ?> value="JPY">Japanese Yen - JPY</option>
                                        <option <?php if ($packageValue['ppcur'] == "MYR") { echo "SELECTED"; } ?> value="MYR">Malaysian Ringgit - MYR</option>
                                        <option <?php if ($packageValue['ppcur'] == "MXN") { echo "SELECTED"; } ?> value="MXN">Mexican Peso - MXN</option>
                                        <option <?php if ($packageValue['ppcur'] == "NOK") { echo "SELECTED"; } ?> value="NOK">Norwegian Krone - NOK</option>
                                        <option <?php if ($packageValue['ppcur'] == "NZD") { echo "SELECTED"; } ?> value="NZD">New Zealand Dollar - NZD</option>
                                        <option <?php if ($packageValue['ppcur'] == "PHP") { echo "SELECTED"; } ?> value="PHP">Philippine Peso - PHP</option>
                                        <option <?php if ($packageValue['ppcur'] == "PLN") { echo "SELECTED"; } ?> value="PLN">Polish Zloty - PLN</option>
                                        <option <?php if ($packageValue['ppcur'] == "GBP") { echo "SELECTED"; } ?> value="GBP">Pound Sterling - GBP</option>
                                        <option <?php if ($packageValue['ppcur'] == "RUB") { echo "SELECTED"; } ?> value="RUB">Russian Ruble - RUB</option>
                                        <option <?php if ($packageValue['ppcur'] == "SGD") { echo "SELECTED"; } ?> value="SGD">Singapore Dollar - SGD</option>
                                        <option <?php if ($packageValue['ppcur'] == "SEK") { echo "SELECTED"; } ?> value="SEK">Swedish Krona - SEK</option>
                                        <option <?php if ($packageValue['ppcur'] == "CHF") { echo "SELECTED"; } ?> value="CHF">Swiss Franc - CHF</option>
                                        <option <?php if ($packageValue['ppcur'] == "TWD") { echo "SELECTED"; } ?> value="TWD">Taiwan New Dollar - TWD</option>
                                        <option <?php if ($packageValue['ppcur'] == "THB") { echo "SELECTED"; } ?> value="THB">Thai Baht - THB</option>
                                        <option <?php if ($packageValue['ppcur'] == "TRY") { echo "SELECTED"; } ?> value="TRY">Turkish Lira - TRY</option>
                                        <option <?php if ($packageValue['ppcur'] == "USD") { echo "SELECTED"; } ?> value="USD">U.S. Dollar - USD</option>
                                    </select><br><br>
                                    <h5><?php _e('PayPal Account', 'wrcpt'); ?></h5>
                                    <label class="input-title"><?php _e('Live Account (Required)', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php echo __('Enter a valid Merchant account ID (strongly recommend) or PayPal account email address. All payments will go to this account. You can find your Merchant account ID in your PayPal account under Profile >> My business info >> Merchant account ID. If you don\'t have a PayPal account, you can sign up for free at PayPal.com.', 'wrcpt'); ?>"></a></label>
                                    <input type="text" name="pp_liveacc[]" class="medium" id="pp_liveacc" value="<?php echo $packageValue['pplva']; ?>">
                                    <label class="input-title"><?php _e('Sandbox Account (Optional)', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php echo __('Enter a valid sandbox PayPal account email address. A Sandbox account is a PayPal accont with fake money used for testing. This is useful to make sure your PayPal account and settings are working properly being going live.', 'wrcpt'); ?>"></a></label>
                                    <input type="text" name="pp_sandbox[]" class="medium" id="pp_sandbox" value="<?php echo $packageValue['ppsbx']; ?>">
                                    <label class="input-title"><?php _e('Payment Action', 'wrcpt'); ?> <?php _e('(Learn more about Authorize', 'wrcpt'); ?> <a target='_blank' href='https://developer.paypal.com/docs/classic/paypal-payments-standard/integration-guide/authcapture/'><?php _e('here', 'wrcpt'); ?></a><?php _e(')', 'wrcpt'); ?>:</label>
                                    <select name="pp_action[]" class="font-dir">
                                        <option <?php if ($packageValue['pactn'] == "1") { echo "SELECTED"; } ?> value="1">Sale (Default)</option>
                                        <option <?php if ($packageValue['pactn'] == "2") { echo "SELECTED"; } ?> value="2">Authorize</option> 
                                    </select><br><br>
                                    <h5><?php _e('Other Settings', 'wrcpt'); ?></h5>
                                    <label class="input-title"><?php _e('Cancel URL', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php echo __("If the customer goes to PayPal and clicks the cancel button, where do they go. Example: $siteurl/cancel. Max length: 1,024.", "wrcpt"); ?>"></a></label>
                                    <input type="text" name="pp_cancel[]" class="medium" id="pp_cancel" value="<?php echo $packageValue['ppcnc']; ?>">
                                    <label class="input-title"><?php _e('Return URL', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php echo __("If the customer goes to PayPal and successfully pays, where are they redirected to after. Example: $siteurl/thankyou. Max length: 1,024.", "wrcpt"); ?>"></a></label>
                                    <input type="text" name="pp_return[]" class="medium" id="pp_return" value="<?php echo $packageValue['pprtn']; ?>">
                                </div>
                                <label class="input-title"><?php _e('Language', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php echo __("If you use Hosted Button ID, This will work in the Button Image. The button image will be displayed with your selected language.", "wrcpt"); ?>"></a></label>
                                <select name="pp_language[]" class="font-dir">
                                    <option <?php if ($packageValue['pplng'] == "1") { echo "SELECTED"; } ?> value="1">Danish</option>
                                    <option <?php if ($packageValue['pplng'] == "2") { echo "SELECTED"; } ?> value="2">Dutch</option>
                                    <option <?php if ($packageValue['pplng'] == "3") { echo "SELECTED"; } ?> value="3">English</option>
                                    <option <?php if ($packageValue['pplng'] == "20") { echo "SELECTED"; } ?> value="20">English - UK</option>
                                    <option <?php if ($packageValue['pplng'] == "4") { echo "SELECTED"; } ?> value="4">French</option>
                                    <option <?php if ($packageValue['pplng'] == "5") { echo "SELECTED"; } ?> value="5">German</option>
                                    <option <?php if ($packageValue['pplng'] == "6") { echo "SELECTED"; } ?> value="6">Hebrew</option>
                                    <option <?php if ($packageValue['pplng'] == "7") { echo "SELECTED"; } ?> value="7">Italian</option>
                                    <option <?php if ($packageValue['pplng'] == "8") { echo "SELECTED"; } ?> value="8">Japanese</option>
                                    <option <?php if ($packageValue['pplng'] == "9") { echo "SELECTED"; } ?> value="9">Norwgian</option>
                                    <option <?php if ($packageValue['pplng'] == "10") { echo "SELECTED"; } ?> value="10">Polish</option>
                                    <option <?php if ($packageValue['pplng'] == "11") { echo "SELECTED"; } ?> value="11">Portuguese</option>
                                    <option <?php if ($packageValue['pplng'] == "12") { echo "SELECTED"; } ?> value="12">Russian</option>
                                    <option <?php if ($packageValue['pplng'] == "13") { echo "SELECTED"; } ?> value="13">Spanish</option>
                                    <option <?php if ($packageValue['pplng'] == "14") { echo "SELECTED"; } ?> value="14">Swedish</option>
                                    <option <?php if ($packageValue['pplng'] == "15") { echo "SELECTED"; } ?> value="15">Simplified Chinese -China only</option>
                                    <option <?php if ($packageValue['pplng'] == "16") { echo "SELECTED"; } ?> value="16">Traditional Chinese - Hong Kong only</option>
                                    <option <?php if ($packageValue['pplng'] == "17") { echo "SELECTED"; } ?> value="17">Traditional Chinese - Taiwan only</option>
                                    <option <?php if ($packageValue['pplng'] == "18") { echo "SELECTED"; } ?> value="18">Turkish</option>
                                    <option <?php if ($packageValue['pplng'] == "19") { echo "SELECTED"; } ?> value="19">Thai</option>
                                </select>
                                <label class="input-title"><?php _e('Sandbox Mode', 'wrcpt'); ?>:</label>
                                <select name="pp_mode[]" class="font-dir">
                                    <option <?php if ($packageValue['pmode'] == "1") { echo "SELECTED"; } ?> value="1">On (Sandbox mode)</option>
                                    <option <?php if ($packageValue['pmode'] == "2") { echo "SELECTED"; } ?> value="2">Off (Live mode)</option> 
                                </select>
                                <label class="input-title"><?php _e('Button Size and type', 'wrcpt'); ?>:</label>
                                <select name="pp_button[]" class="font-dir">
                                    <option <?php if ($packageValue['ppbsz'] == "1") { echo "SELECTED"; } ?> value="1">Small</option>
                                    <option <?php if ($packageValue['ppbsz'] == "2") { echo "SELECTED"; } ?> value="2">Big</option>
                                    <option <?php if ($packageValue['ppbsz'] == "3") { echo "SELECTED"; } ?> value="3">Big with credit cards</option>
                                    <option <?php if ($packageValue['ppbsz'] == "4") { echo "SELECTED"; } ?> value="4">Gold (English Only)</option>
                                </select>
							</div>
							<div id="normal_button">
								<label class="input-title"><?php _e('Button Text', 'wrcpt'); ?></label>
								<input type="text" name="button_text[]" class="medium" id="button_text" value="<?php echo $packageValue['btext']; ?>" placeholder="<?php _e('e.g. Buy Now!', 'wrcpt'); ?>" />
								<label class="input-title"><?php _e('Button Link', 'wrcpt'); ?></label>
								<input type="text" name="button_link[]" class="medium" id="button_link" value="<?php echo $packageValue['blink']; ?>" placeholder="<?php _e('e.g. http://example.com', 'wrcpt'); ?>" />
								<label class="input-title"><?php _e('Button Icon', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('Add Font Awesome icon class name that corresponds to the icon you are trying to display; for example if you want to display the camera icon you can add the \'fas fa-camera-retro\' class.', 'wrcpt'); ?>"></a></label>
								<input type="text" name="button_icon[]" class="medium" id="button_icon" value="<?php echo $packageValue['bicon']; ?>" placeholder="<?php _e('e.g. fas fa-download', 'wrcpt'); ?>" />
							</div>
							<hr />
							<div class="pricing_button_two">
								<h4><?php _e('Package Button 2', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('Enter your call to action text and call to action URL here. The URL is usually either a payment link or a page where users can create an account.', 'wrcpt'); ?>"></a></h4>
								<div id="normal_button_two">
									<label class="input-title"><?php _e('Button Text', 'wrcpt'); ?></label>
									<input type="text" name="button_text2[]" class="medium" id="button_text2" value="<?php echo $packageValue['btext2']; ?>" placeholder="<?php _e('e.g. Buy Now!', 'wrcpt'); ?>" />
									<label class="input-title"><?php _e('Button Link', 'wrcpt'); ?></label>
									<input type="text" name="button_link2[]" class="medium" id="button_link2" value="<?php echo $packageValue['blink2']; ?>" placeholder="<?php _e('e.g. http://example.com', 'wrcpt'); ?>" />
									<label class="input-title"><?php _e('Button Icon', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('Add Font Awesome icon class name that corresponds to the icon you are trying to display; for example if you want to display the camera icon you can add the \'fas fa-camera-retro\' class.', 'wrcpt'); ?>"></a></label>
									<input type="text" name="button_icon2[]" class="medium" id="button_icon2" value="<?php echo $packageValue['bicon2']; ?>" placeholder="<?php _e('e.g. fas fa-download', 'wrcpt'); ?>" />
								</div>
								<hr />
							</div>
							<h4><?php _e('Package Ribbon', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('Enter ribbon text to make current package more attractive to users, like \'best\', \'new\', \'hot\' etc.', 'wrcpt'); ?>"></a></h4>
							<label class="input-title"><?php _e('Ribbon Text', 'wrcpt'); ?></label>
							<input type="text" name="ribbon_text[]" class="medium" id="ribbon_text" value="<?php echo $packageValue['rtext']; ?>" placeholder="<?php _e('e.g. Best', 'wrcpt'); ?>" />
						</div>
						<h3 class="ptitle"><?php _e('Pricing Column Colors', 'wrcpt'); ?></h3>
						<div class="element-input">
							<table>
								<!--Background Color -->
								<tr class="table-header">
									<td colspan="2"><?php _e('Background Colors', 'wrcpt'); ?></td>
								</tr>
								<tr class="table-input">
									<th><label class="input-title"><?php _e('Table Background Color', 'wrcpt'); ?></label></th>
									<td><input type="text" name="table_bg[]" class="table_bg" id="table_bg" value="<?php echo $packageValue['pbclr']; ?>" /></td>
								</tr>
								<tr class="table-input">
									<th><label class="input-title"><?php _e('Title Background Color', 'wrcpt'); ?></label></th>
									<td><input type="text" name="title_bg[]" class="title_bg" id="title_bg" value="<?php echo $packageValue['tbcolor']; ?>" /></td>
								</tr>
								<tr class="table-input">
									<th><label class="input-title"><?php _e('Pricing Background Color', 'wrcpt'); ?></label></th>
									<td><input type="text" name="price_bg[]" class="price_bg" id="price_bg" value="<?php echo $packageValue['pbcolor']; ?>" /></td>
								</tr>
								<tr class="table-input">
									<th><label class="input-title"><?php _e('Price Circle Background Color', 'wrcpt'); ?></label></th>
									<td><input type="text" name="price_cr[]" class="price_cr" id="price_cr" value="<?php echo $packageValue['pcircle']; ?>" /></td>
								</tr>
								<tr class="table-input">
									<th><label class="input-title"><?php _e('Image Background Color', 'wrcpt'); ?></label></th>
									<td><input type="text" name="image_bg[]" class="image_bg" id="image_bg" value="<?php echo $packageValue['imgclr']; ?>" /></td>
								</tr>
								<tr class="table-input">
									<th><label class="input-title"><?php _e('Feature Background Color 1', 'wrcpt'); ?></label></th>
									<td><input type="text" name="feat_row1_color[]" class="feat_row1_color" id="feat_row1_color" value="<?php echo $packageValue['fbrow1']; ?>" /></td>
								</tr>
								<tr class="table-input">
									<th><label class="input-title"><?php _e('Feature Background Color 2', 'wrcpt'); ?></label></th>
									<td><input type="text" name="feat_row2_color[]" class="feat_row2_color" id="feat_row2_color" value="<?php echo $packageValue['fbrow2']; ?>" /></td>
								</tr>
								<tr class="table-input">
									<th><label class="input-title"><?php _e('Button Background Color', 'wrcpt'); ?></label></th>
									<td><input type="text" name="button_bg[]" class="button_bg" id="button_bg" value="<?php echo $packageValue['bbcolor']; ?>" /></td>
								</tr>
								<tr class="table-input">
									<th><label class="input-title"><?php _e('Ribbon Background Color', 'wrcpt'); ?></label></th>
									<td><input type="text" name="ribbon_bg[]" class="ribbon_bg" id="ribbon_bg" value="<?php echo $packageValue['rbcolor']; ?>" /></td>
								</tr>
								<tr class="table-input">
									<th><label class="input-title"><?php _e('Feature Border Color', 'wrcpt'); ?></label></th>
									<td><input type="text" name="feat_border[]" class="feat_border" id="feat_border" value="<?php echo $packageValue['ftborder']; ?>" /></td>
								</tr>
								<!--Font Color -->
								<tr class="table-header">
									<td colspan="2"><?php _e('Font Colors', 'wrcpt'); ?></td>
								</tr>
								<tr class="table-input">
									<th><label class="input-title"><?php _e('Title Font Color', 'wrcpt'); ?></label></th>
									<td><input type="text" name="title_color[]" class="title_color" id="title_color" value="<?php echo $packageValue['tcolor']; ?>" /></td>
								</tr>
								<tr class="table-input">
									<th><label class="input-title"><?php _e('Title Font Hover Color', 'wrcpt'); ?></label></th>
									<td><input type="text" name="title_hover[]" class="title_hover" id="title_hover" value="<?php echo $packageValue['thover']; ?>" /></td>
								</tr>
								<tr class="table-input">
									<th><label class="input-title"><?php _e('Title Description Color', 'wrcpt'); ?></label></th>
									<td><input type="text" name="title_descp[]" class="title_descp" id="title_descp" value="<?php echo $packageValue['tdescl']; ?>" /></td>
								</tr>
								<tr class="table-input">
									<th><label class="input-title"><?php _e('Price Font Color (Big)', 'wrcpt'); ?></label></th>
									<td><input type="text" name="price_color_big[]" class="price_color_big" id="price_color_big" value="<?php echo $packageValue['pcbig']; ?>" /></td>
								</tr>
								<tr class="table-input">
									<th><label class="input-title"><?php _e('Price Font Hover Color (Big)', 'wrcpt'); ?></label></th>
									<td><input type="text" name="price_hover_big[]" class="price_hover_big" id="price_hover_big" value="<?php echo $packageValue['phbig']; ?>" /></td>
								</tr>
								<tr class="table-input">
									<th><label class="input-title"><?php _e('Price Font Color (Small)', 'wrcpt'); ?></label></th>
									<td><input type="text" name="price_color_small[]" class="price_color_small" id="price_color_small" value="<?php echo $packageValue['pcsmall']; ?>" /></td>
								</tr>
								<tr class="table-input">
									<th><label class="input-title"><?php _e('Price Font Hover Color (Small)', 'wrcpt'); ?></label></th>
									<td><input type="text" name="price_hover_small[]" class="price_hover_small" id="price_hover_small" value="<?php echo $packageValue['phsmall']; ?>" /></td>
								</tr>
								<tr class="table-input">
									<th><label class="input-title"><?php _e('Cut Prices Font Color', 'wrcpt'); ?></label></th>
									<td><input type="text" name="cut_price_color[]" class="cut_price_color" id="cut_price_color" value="<?php echo $packageValue['cutclr']; ?>" /></td>
								</tr>
								<tr class="table-input">
									<th><label class="input-title"><?php _e('Feature Name Font Color', 'wrcpt'); ?></label></th>
									<td><input type="text" name="feature_name_color[]" class="feature_name_color" id="feature_name_color" value="<?php echo $packageValue['fncolor']; ?>" /></td>
								</tr>
								<tr class="table-input">
									<th><label class="input-title"><?php _e('Feature Value Font Color', 'wrcpt'); ?></label></th>
									<td><input type="text" name="feature_text_color[]" class="feature_text_color" id="feature_text_color" value="<?php echo $packageValue['ftcolor']; ?>" /></td>
								</tr>
								<tr class="table-input">
									<th><label class="input-title"><?php _e('Ribbon Font Color', 'wrcpt'); ?></label></th>
									<td><input type="text" name="ribbon_text_color[]" class="ribbon_text_color" id="ribbon_text_color" value="<?php echo $packageValue['rtcolor']; ?>" /></td>
								</tr>
								<tr class="table-input">
									<th><label class="input-title"><?php _e('Ribbon Font Hover Color', 'wrcpt'); ?></label></th>
									<td><input type="text" name="ribbon_text_hover[]" class="ribbon_text_hover" id="ribbon_text_hover" value="<?php echo $packageValue['rthover']; ?>" /></td>
								</tr>
								<!--Button Color -->
								<tr class="table-header">
									<td colspan="2"><?php _e('Button Colors', 'wrcpt'); ?></td>
								</tr>
								<tr class="table-input">
									<th><label class="input-title"><?php _e('Button Font Color', 'wrcpt'); ?></label></th>
									<td><input type="text" name="button_text_color[]" class="button_text_color" id="button_text_color" value="<?php echo $packageValue['btcolor']; ?>" /></td>
								</tr>
								<tr class="table-input">
									<th><label class="input-title"><?php _e('Button Font Hover Color', 'wrcpt'); ?></label></th>
									<td><input type="text" name="button_text_hover[]" class="button_text_hover" id="button_text_hover" value="<?php echo $packageValue['bthover']; ?>" /></td>
								</tr>
								<tr class="table-input">
									<th><label class="input-title"><?php _e('Button Color', 'wrcpt'); ?></label></th>
									<td><input type="text" name="button_color[]" class="button_color" id="button_color" value="<?php echo $packageValue['bcolor']; ?>" /></td>
								</tr>
								<tr class="table-input">
									<th><label class="input-title"><?php _e('Button Hover Color', 'wrcpt'); ?></label></th>
									<td><input type="text" name="button_hover[]" class="button_hover" id="button_hover" value="<?php echo $packageValue['bhover']; ?>" /></td>
								</tr>
							</table>
						</div>
			  			<h3 class="ptitle"><?php _e('Pricing Column Special Options', 'wrcpt'); ?></h3>
						<div class="element-input">
							<h4><?php _e('Package Image', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('Enter the image location or upload an image from your computer. If Package Image is enabled in General Settings under Pricing Table Settings, image will be displayed along with the package and it is recommended that you set the image width before adding or updating package.', 'wrcpt'); ?>"></a></h4>
                            <div class="form-group wrcpt-uploader">
                                <label for="upload image" class="input-image"><?php _e('Upload Image', 'wrcpt'); ?></label>
                                <input type="text" name="image_path[]" class="medium" value="<?php echo $packageValue['pimg']; ?>" id="image_path" placeholder="<?php _e('Enter a URL / upload an image', 'wrcpt'); ?>">
                            </div>
							<input type="hidden" name="hidden_path[]" value="<?php echo $packageValue['pimg']; ?>" />
							<div id="show_upload_preview">
								<?php if(!empty($packageValue['pimg'])) { ?>
									<label class="input-image"><?php _e('Preview', 'wrcpt'); ?></label>
									<img src="<?php echo $packageValue['pimg'] ; ?>" alt="package image" class="preview_image">
									<span id="remove_image"></span>
								<?php } ?>
							</div><hr />
							<h4><?php _e('Package Video', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('Enter only YouTube video URL here. If Package Video is enabled in General Settings under Pricing Table Settings, YouTube video URL will be displayed along with the package.', 'wrcpt'); ?>"></a></h4>
							<label class="input-image"><?php _e('Enter Video URL', 'wrcpt'); ?></label>
							<input type="text" name="video_path[]" class="medium" value="<?php echo $packageValue['pvid']; ?>" id="video_path" placeholder="<?php _e('YouTube URL Only', 'wrcpt'); ?>" />
						</div>
						<input type="hidden" name="pricing_packages[]" value="<?php echo $value; ?>" />
						<input type="hidden" name="package_id[]" value="<?php echo $packageValue['pop']; ?>" />
						<input type="hidden" name="order_id[]" value="<?php echo $packageValue['order']; ?>" />
					</div>	<!-- End of column_container -->
				</div>	<!-- End of package_details -->
			<?php
					$fv = 1; $ac++;
				}
			} else _e('No Packages yet!', 'wrcpt'); ?>
			</div>	<!--//sortable_column -->
		</div>	<!--//tablecolumnwrap -->
	</div>	<!--//tablecolumndiv -->
	<div class="wrcpt-clear"></div>
	<div id="settingcolumndiv">
		<div class="settingcolumnwrap">
			<h3><?php _e('Pricing Table Settings', 'wrcpt'); ?></h3>
            <!--pricing table settings -->
			<div id="accordion_advance" class="package_advance">
            	<!--General Settings -->
				<h3 class="ptitle"><?php _e('General Settings', 'wrcpt'); ?></h3>
				<div class="advance-input">
					<label class="input-check"><?php _e('Enable Pricing Table', 'wrcpt'); ?>:
					<input type="checkbox" name="wrcpt_option" class="tickbox" id="wrcpt_option" value="yes" <?php if($packageCombine['enable'] == 'yes') { ?> checked="checked"  <?php } ?> /></label>
					<label id="modify-table" class="input-title"><?php _e('Modify Pricing Table ID:', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('This is an auto-generated table name generated when creating a table from a ready-made template. The rest of the options in the database will be created based on this name. Auto generated table name must be unique. If you enter a name that is already in use in the database, it will be saved in the database by adding an extra word to the name you entered. It will not be a problem. However, it is good practice to use an unique name.', 'wrcpt'); ?>"></a></label>
					<input type="text" name="pricing_table_name" class="medium" id="pricing_table_name" value="<?php echo $pricing_table_name; ?>" />
					<label id="nice-name" class="input-title"><?php _e('Pricing Table Display Name:', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('Here you can name as you wish. There is no problem if you give a name that is already used. This name will be used for display only.', 'wrcpt'); ?>"></a></label>
					<input type="text" name="pt_nice_name" class="medium" id="pt_nice_name" value="<?php echo $packageCombine['dname']; ?>" />
					<label class="input-title txarea"><?php _e('Shortcode Post/Page URLs (Enter One Per Line):', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('Enter the page URL(s) here where you want to show this pricing table. Earlier, the custom CSS was loading all the table\'s CSS. As a result, the file size was becoming very large which may slowdown your website to load. By entering the page URL(s), the customized CSS will load only the specific table\'s custom CSS. In this way, file size of the custom CSS will reduce and the page load faster.', 'wrcpt'); ?>"></a></label>
					<textarea name="shortcode_page_url" class="medium" id="shortcode_page_url" cols="27" rows="4" placeholder="<?php _e('Enter Shortcode Post/Page Urls', 'wrcpt'); ?>"><?php echo htmlspecialchars_decode( $packageCombine['spurl'] ); ?></textarea>
					<label id="cut-price-text" class="input-title"><?php _e('Cut Price Text:', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('If yoyu enter a cut price text, it will show on the left of the cut price. Keeping it empty will show nothing.', 'wrcpt'); ?>"></a></label>
					<input type="text" name="cut_pr_txt" class="medium" id="cut_pr_txt" value="<?php echo $packageCombine['cprtx']; ?>" />
					<label class="input-check"><?php _e('Open Link in New Tab', 'wrcpt'); ?>:
					<input type="checkbox" name="new_tab" class="tickbox" id="new_tab" value="yes" <?php if($packageCombine['nltab'] == 'yes') { ?> checked="checked"  <?php } ?> /></label>
					<div class="break-line"></div>
                    <!-- <h4><?php //_e('Select Shortcode', 'wrcpt'); ?></h3>
					<label class="input-radio" id="scode-choice"><?php //_e('Choose Pricing Table Shortcode', 'wrcpt'); ?>:</label>
					<div class="shortcode-use">
					<input type="radio" id="scode1" name="marked_scode" value="sc-1" <?php //if($packageCombine['scode'] == 'sc-1') { ?> checked="checked"  <?php //} ?> />
					<label for="scode1" class="scode_label"><?php //_e('Shortcode 1', 'wrcpt'); ?></label>
					<input type="radio" id="scode2" name="marked_scode" value="sc-2" <?php //if($packageCombine['scode'] == 'sc-2') { ?> checked="checked"  <?php //} ?> />
					<label for="scode2" class="scode_label"><?php //_e('Shortcode 2', 'wrcpt'); ?></label>
					</div>
                    <div class="break-line"></div> -->
					<input type="hidden" name="marked_scode" value="sc-1"/>
                    <h4><?php _e('Column Border', 'wrcpt'); ?></h3>
					<label class="input-check"><?php _e('Enable Table Border', 'wrcpt'); ?>:
					<input type="checkbox" name="table_color" class="tickbox" id="table_color" value="yes"<?php if($packageCombine['etclr'] == 'yes') { ?> checked="checked"<?php } ?> /></label>
					<div id="tb_bground">
                        <label class="input-title"><?php _e('Table Padding', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('It will take effect only if table background is enable under General Settings.', 'wrcpt'); ?>"></a></label>
                        <input type="number" name="table_pad" class="medium" id="table_pad" value="<?php echo $packageCombine['tbpad']; ?>" min="0" max="50" placeholder="e.g. 1" />
                    </div>
					<label class="input-check"><?php _e('Enable Feature Border', 'wrcpt'); ?>:
					<input type="checkbox" name="feature_border" class="tickbox" id="feature_border" value="yes" <?php if($packageCombine['enfbor'] == 'yes') { ?> checked="checked"  <?php } ?> /></label>
					<label class="input-check"><?php _e('Enable Caption Column Border', 'wrcpt'); ?>:
					<input type="checkbox" name="caption_border" class="tickbox" id="caption_border" value="yes" <?php if($packageCombine['encbor'] == 'yes') { ?> checked="checked"  <?php } ?> /></label>
					<div class="break-line"></div>
                    <h4><?php _e('Column Shadow', 'wrcpt'); ?></h3>
					<label class="input-check"><?php _e('Enable Column Shadow', 'wrcpt'); ?>:
					<input type="checkbox" name="column_shadow" class="tickbox" id="column_shadow" value="yes" <?php if($packageCombine['colshad'] == 'yes') { ?> checked="checked"  <?php } ?> /></label>
					<label class="input-check"><?php _e('Disable Shadow on Highlight', 'wrcpt'); ?>:
					<input type="checkbox" name="disable_shadow" class="tickbox" id="disable_shadow" value="yes" <?php if($packageCombine['dscol'] == 'yes') { ?> checked="checked"  <?php } ?> /></label>
					<label class="input-check"><?php _e('Enable Caption Column Shadow', 'wrcpt'); ?>:
					<input type="checkbox" name="caption_shadow" class="tickbox" id="caption_shadow" value="yes" <?php if($packageCombine['cshade'] == 'yes') { ?> checked="checked" <?php } ?> /></label>
					<div class="break-line"></div>
                    <h4><?php _e('Column Gradient', 'wrcpt'); ?></h3>
					<label class="input-check"><?php _e('Disable Title Gradient', 'wrcpt'); ?>:
					<input type="checkbox" name="title_gradient" class="tickbox" id="title_gradient" value="yes" <?php if($packageCombine['ttgrd'] == 'yes') { ?> checked="checked"<?php } ?>></label>
					<label class="input-check"><?php _e('Disable Price Gradient', 'wrcpt'); ?>:
					<input type="checkbox" name="price_gradient" class="tickbox" id="price_gradient" value="yes" <?php if($packageCombine['prgrd'] == 'yes') { ?> checked="checked"<?php } ?>></label>
					<label class="input-check"><?php _e('Disable Button Gradient', 'wrcpt'); ?>:
					<input type="checkbox" name="disable_gradient" class="tickbox" id="disable_gradient" value="yes" <?php if($packageCombine['dsgrd'] == 'yes') { ?> checked="checked" <?php } ?> /></label>
					<div class="break-line"></div>
                    <h4><?php _e('Column Features', 'wrcpt'); ?></h3>
					<label class="input-check"><?php _e('Enable Feature Categories', 'wrcpt'); ?>:
					<input type="checkbox" name="enable_category" class="tickbox" id="enable_category" value="yes" <?php if($packageCombine['encate'] == 'yes') { ?> checked="checked"  <?php } ?> /></label>
					<label class="input-check"><?php _e('Enable Feature Icons', 'wrcpt'); ?>:<a href="#" class="wrc_tooltip" rel="<?php _e('To display Font Awesome icon beside each feature simply mark the check box.', 'wrcpt'); ?>"></a>
					<input type="checkbox" name="enable_icon" class="tickbox" id="enable_icon" value="yes" <?php if($packageCombine['enicon'] == 'yes') { ?> checked="checked"  <?php } ?> /></label>
					<label class="input-check"><?php _e('Enable Feature Tooltips', 'wrcpt'); ?>:
					<input type="checkbox" name="enable_tooltip" class="tickbox" id="enable_tooltip" value="yes" <?php if($packageCombine['entips'] == 'yes') { ?> checked="checked"  <?php } ?> /></label>
					<div class="break-line"></div>
                    <h4><?php _e('Show/Hide', 'wrcpt'); ?></h4>
					<label class="input-check"><?php _e('Show Caption Title BG', 'wrcpt'); ?>:
					<input type="checkbox" name="cap_titlebg" class="tickbox" id="cap_titlebg" value="yes" <?php if($packageCombine['captbg'] == 'yes') { ?> checked="checked"  <?php } ?>/></label>
					<label class="input-check"><?php _e('Show Feature Links Without Caption Column', 'wrcpt'); ?>:<a href="#" class="wrc_tooltip" rel="<?php _e('If the caption column (comparison table) is not enabled, the featured links will still be displayed with the feature name.', 'wrcpt'); ?>"></a>
					<input type="checkbox" name="feat_link" class="tickbox" id="feat_link" value="yes" <?php if($packageCombine['fealn'] == 'yes') { ?> checked="checked"  <?php } ?>/></label>
					<label class="input-check"><?php _e('Show Caption Column Tooltip on Package Column', 'wrcpt'); ?>:<a href="#" class="wrc_tooltip" rel="<?php _e('If the caption column is enabled, it may not be possible to display the caption column separately in the tab and mobile views due to limited screen size. In this case, the title of the caption column feature is shown in the package column. However, due to the presence of the tooltip in the caption column, you can determine whether the package column will show the tooltip of the caption column or not.', 'wrcpt'); ?>"></a>
					<input type="checkbox" name="cap_ttip_pc" class="tickbox" id="cap_tooltip_pc" value="yes" <?php if($packageCombine['cpttpc'] == 'yes') { ?> checked="checked"  <?php } ?>/></label>
					<label class="input-check"><?php _e('Hide Empty Features', 'wrcpt'); ?>:<a href="#" class="wrc_tooltip" rel="<?php _e('Only work if feature caption is not enable. It is available in Structural Settings.', 'wrcpt'); ?>"></a>
					<input type="checkbox" name="empty_feature" class="tickbox" id="empty_feature" value="yes" <?php if($packageCombine['empft'] == 'yes') { ?> checked="checked"<?php } ?>/></label>
					<label class="input-check"><?php _e('Hide Feature Name', 'wrcpt'); ?>:
					<input type="checkbox" name="hide_fname" class="tickbox" id="hide_fname" value="yes" <?php if($packageCombine['hidefn'] == 'yes') { ?> checked="checked"  <?php } ?>/></label>
					<label class="input-check"><?php _e('Hide Caption Feature Name', 'wrcpt'); ?>:
					<input type="checkbox" name="hide_cfname" class="tickbox" id="hide_cfname" value="yes" <?php if($packageCombine['hidecfn'] == 'yes') { ?> checked="checked"<?php } ?>/></label>
					<label class="input-check"><?php _e('Show Package Button Two', 'wrcpt'); ?>:<a href="#" class="wrc_tooltip" rel="<?php _e('To incorporate an additional button in your pricing table, simply enable this option. Upon enabling, the second button will be seamlessly integrated within the Pricing Column Details section, following the initial Package Button.', 'wrcpt'); ?>"></a>
					<input type="checkbox" name="pbtn_two" class="tickbox" id="pbtn_two" value="yes" <?php if($packageCombine['pbttwo'] == 'yes') { ?> checked="checked"<?php } ?>/></label>
					<label class="input-check"><?php _e('Hide Pricing Table Name', 'wrcpt'); ?>:
					<input type="checkbox" name="hide_ptname" class="tickbox" id="hide_ptname" value="yes" <?php if($packageCombine['hdptnm'] == 'yes') { ?> checked="checked"<?php } ?>/></label>
					<div class="break-line"></div>
                    <h4><?php _e('Price Toggle', 'wrcpt'); ?></h3>
					<label class="input-check"><?php _e('Enable Pricing Toggles', 'wrcpt'); ?>:<a href="#" class="wrc_tooltip" rel="<?php _e('If you would like to set monthly/yearly different price or multiple currencies, simply mark the checkbox.', 'wrcpt'); ?>"></a>
					<input type="checkbox" name="toggle_price" class="tickbox" id="toggle_price" value="yes" <?php if($packageCombine['mcurr'] == 'yes') { ?> checked="checked" <?php } ?> /></label>
					<div id="pricing_toggle">
						<label class="input-title"><?php _e('First Toggle Text', 'wrcpt'); ?></label>
						<input type="text" name="toggle_text_one" class="medium" id="toggle_text_one" value="<?php echo $packageCombine['tgtext1']; ?>" placeholder="e.g. Monthly Plan" />
						<label class="input-title"><?php _e('Second Toggle Text', 'wrcpt'); ?></label>
						<input type="text" name="toggle_text_two" class="medium" id="toggle_text_two" value="<?php echo $packageCombine['tgtext2']; ?>" placeholder="e.g. Yearly Plan" />
						<label class="input-title"><?php _e('Special Text', 'wrcpt'); ?></label>
						<input type="text" name="special_text" class="medium" id="special_text" value="<?php echo $packageCombine['sptext']; ?>" placeholder="e.g. Save 20%" />
                        <label class="input-check"><?php _e('Enable 3rd Toggle', 'wrcpt'); ?>:<a href="#" class="wrc_tooltip" rel="<?php _e('If you would like to show 3 toggles, mark the checkbox.', 'wrcpt'); ?>"></a>
                        <input type="checkbox" name="third_toggle" class="tickbox" id="third_toggle" value="yes"<?php if($packageCombine['togg3'] == 'yes') { ?> checked="checked" <?php } ?>></label>
                        <div id="pricing_toggle_3">
                            <label class="input-title"><?php _e('Third Toggle Text', 'wrcpt'); ?></label>
                            <input type="text" name="toggle_text_three" class="medium" id="toggle_text_three" value="<?php echo $packageCombine['tgtext3']; ?>" placeholder="e.g. Other Plan" />
                            <label class="input-title"><?php _e('Special Text', 'wrcpt'); ?></label>
                            <input type="text" name="special_text_2" class="medium" id="special_text_2" value="<?php echo $packageCombine['sptext2']; ?>" placeholder="e.g. Save 20%" />
                        </div>
                        <label class="input-check"><?php _e('Enable 4th Toggle', 'wrcpt'); ?>:<a href="#" class="wrc_tooltip" rel="<?php _e('If you would like to show 4 toggles, mark the checkbox.', 'wrcpt'); ?>"></a>
                        <input type="checkbox" name="forth_toggle" class="tickbox" id="forth_toggle" value="yes"<?php if($packageCombine['togg4'] == 'yes') { ?> checked="checked" <?php } ?>></label>
                        <div id="pricing_toggle_4">
                            <label class="input-title"><?php _e('Forth Toggle Text', 'wrcpt'); ?></label>
                            <input type="text" name="toggle_text_four" class="medium" id="toggle_text_four" value="<?php echo $packageCombine['tgtext4']; ?>" placeholder="e.g. Other Plan" />
                            <label class="input-title"><?php _e('Special Text', 'wrcpt'); ?></label>
                            <input type="text" name="special_text_3" class="medium" id="special_text_3" value="<?php echo $packageCombine['sptext3']; ?>" placeholder="e.g. Save 20%" />
                        </div>
					</div>
					<div class="break-line"></div>
                    <h4><?php _e('Package Ribbons', 'wrcpt'); ?></h3>
					<label class="input-check"><?php _e('Enable Package Ribbons', 'wrcpt'); ?>:
					<input type="checkbox" name="enable_ribbon" class="tickbox" id="enable_ribbon" value="yes" <?php if($packageCombine['enribs'] == 'yes') { ?> checked="checked" <?php } ?> /></label>
					<label class="input-radio" id="ribbon-choice"><?php _e('Choose Package Ribbon', 'wrcpt'); ?>:</label>
					<div class="ribbon-all">
					<input type="radio" id="ribbon1" name="marked_ribbon" value="rb-1" <?php if($packageCombine['markrib'] == 'rb-1') { ?> checked="checked"  <?php } ?> />
					<label for="ribbon1" class="ribbon_label"><?php _e('Ribbon 1', 'wrcpt'); ?></label>
					<input type="radio" id="ribbon2" name="marked_ribbon" value="rb-2" <?php if($packageCombine['markrib'] == 'rb-2') { ?> checked="checked"  <?php } ?> />
					<label for="ribbon2" class="ribbon_label"><?php _e('Ribbon 2', 'wrcpt'); ?></label>
					<input type="radio" id="ribbon3" name="marked_ribbon" value="rb-3" <?php if($packageCombine['markrib'] == 'rb-3') { ?> checked="checked"  <?php } ?> />
					<label for="ribbon3" class="ribbon_label"><?php _e('Ribbon 3', 'wrcpt'); ?></label>
					<input type="radio" id="ribbon4" name="marked_ribbon" value="rb-4" <?php if($packageCombine['markrib'] == 'rb-4') { ?> checked="checked"  <?php } ?> />
					<label for="ribbon4" class="ribbon_label"><?php _e('Ribbon 4', 'wrcpt'); ?></label>
					<input type="radio" id="ribbon5" name="marked_ribbon" value="rb-5" <?php if($packageCombine['markrib'] == 'rb-5') { ?> checked="checked"  <?php } ?> />
					<label for="ribbon5" class="ribbon_label"><?php _e('Ribbon 5', 'wrcpt'); ?></label>
					</div>
					<div class="break-line"></div>
                    <h4><?php _e('Package Image', 'wrcpt'); ?></h3>
					<label class="input-check"><?php _e('Enable Package Images', 'wrcpt'); ?>:
					<input type="checkbox" name="enable_image" class="tickbox" id="enable_image" value="yes" <?php if($packageCombine['enimg'] == 'yes') { ?> checked="checked"<?php } ?>/></label>
					<label id="img-bground" class="input-check"><?php _e('Use Image as Background Image', 'wrcpt'); ?>:
					<input type="checkbox" name="bground_image" class="tickbox" id="bground_image" value="yes" <?php if($packageCombine['bgimg'] == 'yes') { ?> checked="checked"<?php } ?>/></label>
					<label id="img-overlay" class="input-check"><?php _e('Overlay with Image', 'wrcpt'); ?>:<a href="#" class="wrc_tooltip" rel="<?php _e('An image can have many empty spaces or transparent areas, especially if it\'s in PNG format. With the \'Overlay with Image\' feature, users can set their own color to those empty spaces. This option allows the user to customize the background color and make the pricing table more visually appealing. If the image has transparent areas, this feature is particularly useful as it allows users to add their own colors to the empty spaces of the image.', 'wrcpt'); ?>"></a>
					<input type="checkbox" name="img_overlay" class="tickbox" id="img_overlay" value="yes" <?php if($packageCombine['imgov'] == 'yes') { ?> checked="checked"<?php } ?>/></label>
					<label class="input-radio" id="image-option"><?php _e('Choose how you like to display Images', 'wrcpt'); ?>:</label>
					<div class="img-options">
					<input type="radio" id="option-1" name="image_show" value="opt-1" <?php if($packageCombine['opimg'] == 'opt-1') { ?> checked="checked"  <?php } ?> />
					<label for="option-1" class="image_label"><?php _e('Show All', 'wrcpt'); ?></label>
					<input type="radio" id="option-2" name="image_show" value="opt-2" <?php if($packageCombine['opimg'] == 'opt-2') { ?> checked="checked"  <?php } ?> />
					<label for="option-2" class="image_label"><?php _e('Title + Image', 'wrcpt'); ?></label>
					<input type="radio" id="option-3" name="image_show" value="opt-3" <?php if($packageCombine['opimg'] == 'opt-3') { ?> checked="checked"  <?php } ?> />
					<label for="option-3" class="image_label"><?php _e('Image + Price', 'wrcpt'); ?></label>
					<input type="radio" id="option-4" name="image_show" value="opt-4" <?php if($packageCombine['opimg'] == 'opt-4') { ?> checked="checked"  <?php } ?> />
					<label for="option-4" class="image_label"><?php _e('Only Image', 'wrcpt'); ?></label>
					</div>
					<label class="input-title" id="img-width"><?php _e('Image Width', 'wrcpt'); ?>:</label>
					<input type="text" name="image_width" class="medium" id="image_width" value="<?php echo $packageCombine['imgwid']; ?>" placeholder="e.g. 240px" />
					<label class="input-title" id="img-height"><?php _e('Image Height', 'wrcpt'); ?>:</label>
					<input type="text" name="image_height" class="medium" id="image_height" value="<?php echo $packageCombine['imghgt']; ?>" placeholder="e.g. 200px" />
					<label class="input-title" id="img-margin"><?php _e('Image Margin', 'wrcpt'); ?>:</label>
					<input type="text" name="image_margin" class="medium" id="image_margin" value="<?php echo $packageCombine['imgmrg']; ?>" placeholder="e.g. 10px or auto" />
					<label class="input-title" id="img-opacity"><?php _e('Image Opacity', 'wrcpt'); ?>:</label>
					<input type="number" name="image_opacity" class="medium" id="image_opacity" value="<?php echo $packageCombine['imgopc']; ?>" min="1" max="10" placeholder="e.g. 0.9" />
					<div class="break-line"></div>
                    <h4><?php _e('Package Video', 'wrcpt'); ?></h3>
					<label class="input-check"><?php _e('Enable Package Video', 'wrcpt'); ?>:
					<input type="checkbox" name="enable_video" class="tickbox" id="enable_video" value="yes" <?php if($packageCombine['envid'] == 'yes') { ?> checked="checked"  <?php } ?> /></label>
					<label class="input-radio" id="video-option"><?php _e('Choose how you like to display Video', 'wrcpt'); ?>:</label>
					<div class="vid-options">
					<input type="radio" id="video-1" name="video_show" value="vid-1" <?php if($packageCombine['opvid'] == 'vid-1') { ?> checked="checked"  <?php } ?> />
					<label for="video-1" class="video_label"><?php _e('Show All', 'wrcpt'); ?></label>
					<input type="radio" id="video-2" name="video_show" value="vid-2" <?php if($packageCombine['opvid'] == 'vid-2') { ?> checked="checked"  <?php } ?> />
					<label for="video-2" class="video_label"><?php _e('Title + Video', 'wrcpt'); ?></label>
					<input type="radio" id="video-3" name="video_show" value="vid-3" <?php if($packageCombine['opvid'] == 'vid-3') { ?> checked="checked"  <?php } ?> />
					<label for="video-3" class="video_label"><?php _e('Video + Price', 'wrcpt'); ?></label>
					<input type="radio" id="video-4" name="video_show" value="vid-4" <?php if($packageCombine['opvid'] == 'vid-4') { ?> checked="checked"  <?php } ?> />
					<label for="video-4" class="video_label"><?php _e('Only Video', 'wrcpt'); ?></label>
					</div>
					<div id="video-params">
                        <label class="input-title" id="vid-height"><?php _e('Video Height', 'wrcpt'); ?></label>
                        <input type="text" name="video_body" class="medium" id="video_body" value="<?php echo $packageCombine['vbody']; ?>" placeholder="e.g. 150px" />
                        <label class="input-check" id="full_screen"><?php _e('Allow Full Screen?', 'wrcpt'); ?>
                        <input type="checkbox" name="video_screen" class="tickbox" id="video_screen" value="yes" <?php if($packageCombine['vfscr'] == 'yes') { ?> checked="checked"<?php } ?> /></label>
                        <label class="input-check" id="show_brand"><?php _e('Show YouTube logo?', 'wrcpt'); ?>
                        <input type="checkbox" name="modest_brand" class="tickbox" id="modest_brand" value="yes" <?php if($packageCombine['mbrand'] == 'yes') { ?> checked="checked"<?php } ?> /></label>
                    </div>
					<div class="break-line"></div>
                    <h4><?php _e('Tick/Cross Icons', 'wrcpt'); ?></h3>
					<label class="input-check"><?php _e('Enable Font Awesome Tick/Cross', 'wrcpt'); ?>:
					<input type="checkbox" name="enable_tickcross" class="tickbox" id="enable_tickcross" value="yes" <?php if($packageCombine['enfatc'] == 'yes') { ?> checked="checked" <?php } ?> /></label>
					<div id="tickcross-items">
						<label class="input-radio" id="tick-choice"><?php _e('Choose Tick Icon to Show', 'wrcpt'); ?>:</label>
						<div class="tickicon_choice">
							<label for="tickicon1"><input type="radio" name="tick_mark" value="tick-1" class="hide_tick" <?php if($packageCombine['tick'] == 'tick-1') { ?> checked="checked"  <?php } ?> /><span id="tickicon1" class="tick-icons"></span></label>
							<label for="tickicon2"><input type="radio" name="tick_mark" value="tick-2" class="hide_tick" <?php if($packageCombine['tick'] == 'tick-2') { ?> checked="checked"  <?php } ?> /><span id="tickicon2" class="tick-icons"></span></label>
							<label for="tickicon3"><input type="radio" name="tick_mark" value="tick-3" class="hide_tick" <?php if($packageCombine['tick'] == 'tick-3') { ?> checked="checked"  <?php } ?> /><span id="tickicon3" class="tick-icons"></span></label>
							<label for="tickicon4"><input type="radio" name="tick_mark" value="tick-4" class="hide_tick" <?php if($packageCombine['tick'] == 'tick-4') { ?> checked="checked"  <?php } ?> /><span id="tickicon4" class="tick-icons"></span></label>
							<label for="tickicon5"><input type="radio" name="tick_mark" value="tick-5" class="hide_tick" <?php if($packageCombine['tick'] == 'tick-5') { ?> checked="checked"  <?php } ?> /><span id="tickicon5" class="tick-icons"></span></label>
						</div>
						<div class="tickicon_choice">
							<label for="tickicon6"><input type="radio" name="tick_mark" value="tick-6" class="hide_tick" <?php if($packageCombine['tick'] == 'tick-6') { ?> checked="checked"  <?php } ?> /><span id="tickicon6" class="tick-icons"></span></label>
							<label for="tickicon7"><input type="radio" name="tick_mark" value="tick-7" class="hide_tick" <?php if($packageCombine['tick'] == 'tick-7') { ?> checked="checked"  <?php } ?> /><span id="tickicon7" class="tick-icons"></span></label>
							<label for="tickicon8"><input type="radio" name="tick_mark" value="tick-8" class="hide_tick" <?php if($packageCombine['tick'] == 'tick-8') { ?> checked="checked"  <?php } ?> /><span id="tickicon8" class="tick-icons"></span></label>
							<label for="tickicon9"><input type="radio" name="tick_mark" value="tick-9" class="hide_tick" <?php if($packageCombine['tick'] == 'tick-9') { ?> checked="checked"  <?php } ?> /><span id="tickicon9" class="tick-icons"></span></label>
							<label for="tickicon10"><input type="radio" name="tick_mark" value="tick-10" class="hide_tick" <?php if($packageCombine['tick'] == 'tick-10') { ?> checked="checked"  <?php } ?> /><span id="tickicon10" class="tick-icons"></span></label>
						</div>
						<label class="input-radio" id="cross-choice"><?php _e('Choose Cross Icon to Show', 'wrcpt'); ?>:</label>
						<div class="tickicon_choice">
							<label for="crossicon1"><input type="radio" name="cross_mark" value="cross-1" class="hide_cross" <?php if($packageCombine['cross'] == 'cross-1') { ?> checked="checked"  <?php } ?> /><span id="crossicon1" class="cross-icons"></span></label>
							<label for="crossicon2"><input type="radio" name="cross_mark" value="cross-2" class="hide_cross" <?php if($packageCombine['cross'] == 'cross-2') { ?> checked="checked"  <?php } ?> /><span id="crossicon2" class="cross-icons"></span></label>
							<label for="crossicon3"><input type="radio" name="cross_mark" value="cross-3" class="hide_cross" <?php if($packageCombine['cross'] == 'cross-3') { ?> checked="checked"  <?php } ?> /><span id="crossicon3" class="cross-icons"></span></label>
							<label for="crossicon4"><input type="radio" name="cross_mark" value="cross-4" class="hide_cross" <?php if($packageCombine['cross'] == 'cross-4') { ?> checked="checked"  <?php } ?> /><span id="crossicon4" class="cross-icons"></span></label>
							<label for="crossicon5"><input type="radio" name="cross_mark" value="cross-5" class="hide_cross" <?php if($packageCombine['cross'] == 'cross-5') { ?> checked="checked"  <?php } ?> /><span id="crossicon5" class="cross-icons"></span></label>
						</div>
						<div class="tickicon_choice">
							<label for="crossicon6"><input type="radio" name="cross_mark" value="cross-6" class="hide_cross" <?php if($packageCombine['cross'] == 'cross-6') { ?> checked="checked"<?php } ?> /><span id="crossicon6" class="cross-icons"></span></label>
							<label for="crossicon7"><input type="radio" name="cross_mark" value="cross-7" class="hide_cross" <?php if($packageCombine['cross'] == 'cross-7') { ?> checked="checked"<?php } ?> /><span id="crossicon7" class="cross-icons"></span></label>
							<label for="crossicon8"><input type="radio" name="cross_mark" value="cross-8" class="hide_cross" <?php if($packageCombine['cross'] == 'cross-8') { ?> checked="checked"<?php } ?> /><span id="crossicon8" class="cross-icons"></span></label>
							<label for="crossicon9"><input type="radio" name="cross_mark" value="cross-9" class="hide_cross" <?php if($packageCombine['cross'] == 'cross-9') { ?> checked="checked"<?php } ?> /><span id="crossicon9" class="cross-icons"></span></label>
							<label for="crossicon10"><input type="radio" name="cross_mark" value="cross-10" class="hide_cross" <?php if($packageCombine['cross'] == 'cross-10') { ?> checked="checked"<?php } ?> /><span id="crossicon10" class="cross-icons"></span></label>
						</div>
					</div>
					<div id="awesome-icon">
						<label class="input-title" id="tick-icon"><?php _e('Font Awesome Tick Icon', 'wrcpt'); ?>:</label>
						<input type="text" name="awesome_tick" class="medium" id="awesome_tick" value="<?php echo $packageCombine['awetick']; ?>" placeholder="e.g. fas fa-check" />
						<label class="input-title" id="cross-icon"><?php _e('Font Awesome Cross Icon', 'wrcpt'); ?>:</label>
						<input type="text" name="awesome_cross" class="medium" id="awesome_cross" value="<?php echo $packageCombine['awecross']; ?>" placeholder="e.g. fas fa-times" />
					</div>
					<div class="break-line"></div>
                    <h4><?php _e('Star Icons', 'wrcpt'); ?></h3>
					<label class="input-radio" id="tick-choice"><?php _e('Choose Star Icon to Show', 'wrcpt'); ?>:</label>
					<div class="staricon_choice">
						<label for="staricon1"><input type="radio" name="star_mark" value="star-1" class="hide_star"<?php if($packageCombine['fstar'] == 'star-1') { echo ' checked="checked"';} ?> /><span id="staricon1" class="star-icons"></span></label>
						<label for="staricon2"><input type="radio" name="star_mark" value="star-2" class="hide_star"<?php if($packageCombine['fstar'] == 'star-2') { echo ' checked="checked"';} ?> /><span id="staricon2" class="star-icons"></span></label>
						<label for="staricon3"><input type="radio" name="star_mark" value="star-3" class="hide_star"<?php if($packageCombine['fstar'] == 'star-3') { echo ' checked="checked"';} ?> /><span id="staricon3" class="star-icons"></span></label>
						<label for="staricon4"><input type="radio" name="star_mark" value="star-4" class="hide_star"<?php if($packageCombine['fstar'] == 'star-4') { echo ' checked="checked"';} ?> /><span id="staricon4" class="star-icons"></span></label>
						<label for="staricon5"><input type="radio" name="star_mark" value="star-5" class="hide_star"<?php if($packageCombine['fstar'] == 'star-5') { echo ' checked="checked"';} ?> /><span id="staricon5" class="star-icons"></span></label>
					</div>
					<div class="break-line"></div>
				</div>
            	<!--Structural Settings -->
				<h3 class="ptitle"><?php _e('Structural Settings', 'wrcpt'); ?></h3>
				<div class="advance-input">
                    <h4><?php _e('Structure', 'wrcpt'); ?></h4>
					<label class="input-title"><?php _e('Pricing Table Container Width', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('Enter the total width of your pricing table here.', 'wrcpt'); ?>"></a></label>
					<input type="text" name="container_width" class="medium" id="container_width" value="<?php echo $packageCombine['cwidth']; ?>" placeholder="e.g. 100%" />
					<label class="input-title"><?php _e('Number of Columns per Row', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('If your pricing table has a lot of columns, then you can split the columns according to the rows by entering the number of columns in the right TextBox.', 'wrcpt'); ?>"></a></label>
					<input type="number" name="max_column" class="medium" id="max_column" value="<?php echo $packageCombine['maxcol']; ?>" min="0" max="12" placeholder="e.g. 6" />
					<label class="input-title"><?php _e('Pricing Table Margin Top', 'wrcpt'); ?></label>
					<input type="number" name="ptmargin_top" class="medium" id="ptmargin_top" value="<?php echo $packageCombine['ptmtop']; ?>" placeholder="e.g. 40px" />
					<label class="input-title"><?php _e('Package Column Border Radius', 'wrcpt'); ?></label>
					<input type="number" name="pack_radius" class="medium" id="pack_radius" value="<?php echo $packageCombine['pbrad']; ?>" placeholder="e.g. 10" />
					<label class="input-title"><?php _e('Caption Column Border Radius', 'wrcpt'); ?></label>
					<input type="number" name="cap_radius" class="medium" id="cap_radius" value="<?php echo $packageCombine['cbrad']; ?>" placeholder="e.g. 10" />
					<label class="input-check"><?php _e('Enlarge Column on Hover', 'wrcpt'); ?>:
					<input type="checkbox" name="enlarge_column" class="tickbox" id="enlarge_column" value="yes" <?php if($packageCombine['encol'] == 'yes') { ?> checked="checked"  <?php } ?> /></label>
					<label class="input-check"><?php _e('Display Price at the Bottom', 'wrcpt'); ?>:
					<input type="checkbox" name="bottom_price" class="tickbox" id="bottom_price" value="yes"<?php if($packageCombine['btompr'] == 'yes') { ?> checked="checked"<?php } ?> /></label>
					<label class="input-check"><?php _e('Display Price in Circle', 'wrcpt'); ?>:
					<input type="checkbox" name="price_circle" class="tickbox" id="price_circle" value="yes"<?php if($packageCombine['crlepr'] == 'yes') { ?> checked="checked"<?php } ?> /></label>
					<label class="input-check"><?php _e('Display 1st Button at the Top', 'wrcpt'); ?>:
					<input type="checkbox" name="button_top" class="tickbox" id="button_top" value="yes"<?php if($packageCombine['topbut'] == 'yes') { ?> checked="checked"<?php } ?>></label>
					<div class="break-line"></div>
                    <h4><?php _e('Caption Column &amp; Package Column', 'wrcpt'); ?></h3>
					<label class="input-check"><?php _e('Disable Auto Column Width', 'wrcpt'); ?>:<a href="#" class="wrc_tooltip" rel="<?php _e('If you want to setup caption column width manually simply mark the check box. It will allow you to enter the caption column width and the space between the columns.', 'wrcpt'); ?>"></a>
					<input type="checkbox" name="auto_column" class="tickbox" id="auto_column" value="yes" <?php if($packageCombine['autocol'] == 'yes') { ?> checked="checked"  <?php } ?> /></label>
					<label class="input-title" id="margin_right"><?php _e('Space Between Columns', 'wrcpt'); ?></label>
					<input type="number" step="any" name="column_space" class="medium" id="column_space" value="<?php echo $packageCombine['colgap']; ?>" placeholder="e.g. 1" />
					<label class="input-check"><?php _e('Enable Caption Column', 'wrcpt'); ?>:<a href="#" class="wrc_tooltip" rel="<?php _e('If you would like to display features name column separately on the left of the pricing table simply mark this checkbox.', 'wrcpt'); ?>"></a>
					<input type="checkbox" name="feature_caption" class="tickbox" id="feature_caption" value="yes" <?php if($packageCombine['ftcap'] == 'yes') { ?> checked="checked"  <?php } ?> /></label>
					<label class="input-title" id="cap_col_width"><?php _e('Caption Column Width', 'wrcpt'); ?></label>
					<input type="number" step="any" name="cap_column_width" class="medium" id="cap_column_width" value="<?php echo $packageCombine['capwidth']; ?>" placeholder="e.g. 18 or 18.73" />
					<div class="break-line"></div>
                    <h4><?php _e('Width', 'wrcpt'); ?></h4>
					<label class="input-title"><?php _e('Button Width', 'wrcpt'); ?></label>
					<input type="text" name="button_width" class="medium" id="button_width" value="<?php echo $packageCombine['bwidth']; ?>" placeholder="e.g. 140px" />
					<label class="input-title"><?php _e('Tooltip Width', 'wrcpt'); ?></label>
					<input type="text" name="tooltip_width" class="medium" id="tooltip_width" value="<?php echo $packageCombine['ttwidth']; ?>" placeholder="e.g. 130px" />
					<label class="input-title"><?php _e('Pricing Toggle Width', 'wrcpt'); ?></label>
					<input type="text" name="ptoggle_width" class="medium" id="ptoggle_width" value="<?php echo $packageCombine['ptwidth']; ?>" placeholder="e.g. 370px" />
					<div class="break-line"></div>
                    <h4><?php _e('Height', 'wrcpt'); ?></h3>
					<label class="input-title"><?php _e('Title Body Height', 'wrcpt'); ?></label>
					<input type="text" name="title_body" class="medium" id="title_body" value="<?php echo $packageCombine['tbody']; ?>" placeholder="e.g. 48px" />
					<label class="input-title"><?php _e('Price Body Height', 'wrcpt'); ?></label>
					<input type="text" name="price_body" class="medium" id="price_body" value="<?php echo $packageCombine['pbody']; ?>" placeholder="e.g. 120px" />
					<label class="input-title"><?php _e('Feature Category Height', 'wrcpt'); ?></label>
					<input type="text" name="ft_cate_height" class="medium" id="ft_cate_height" value="<?php echo $packageCombine['fcbody']; ?>" placeholder="e.g. 40px" />
					<label class="input-title"><?php _e('Feature Label Body Height', 'wrcpt'); ?></label>
					<input type="text" name="feature_body" class="medium" id="feature_body" value="<?php echo $packageCombine['ftbody']; ?>" placeholder="e.g. 42px" />
					<label class="input-title"><?php _e('Button Body Height', 'wrcpt'); ?></label>
					<input type="text" name="button_body" class="medium" id="button_body" value="<?php echo $packageCombine['btbody']; ?>" placeholder="e.g. 40px" />
					<label class="input-title"><?php _e('Button Height', 'wrcpt'); ?></label>
					<input type="text" name="button_height" class="medium" id="button_height" value="<?php echo $packageCombine['bheight']; ?>" placeholder="e.g. 30px" />
					<label class="input-title"><?php _e('Pricing Toggle Height', 'wrcpt'); ?></label>
					<input type="text" name="ptoggle_height" class="medium" id="ptoggle_height" value="<?php echo $packageCombine['ptheight']; ?>" placeholder="e.g. 40px" />
					<div class="break-line"></div>
                    <h4><?php _e('Position/Direction', 'wrcpt'); ?></h4>
					<label class="input-title"><?php _e('Pricing Toggle Position', 'wrcpt'); ?>:</label>
					<select name="ptoggle_pos" id="ptoggle_pos" class="font-dir">
						<?php if($packageCombine['tgpos'] == 'left') { ?>
						<option value="left" selected="selected"><?php _e('Left', 'wrcpt'); ?></option>
						<option value="right"><?php _e('Right', 'wrcpt'); ?></option>
						<option value="center"><?php _e('Center', 'wrcpt'); ?></option>
						<?php } elseif($packageCombine['tgpos'] == 'right') { ?>
						<option value="left"><?php _e('Left', 'wrcpt'); ?></option>
						<option value="right" selected="selected"><?php _e('Right', 'wrcpt'); ?></option>
						<option value="center"><?php _e('Center', 'wrcpt'); ?></option>
						<?php } else { ?>
						<option value="left"><?php _e('Left', 'wrcpt'); ?></option>
						<option value="right"><?php _e('Right', 'wrcpt'); ?></option>
						<option value="center" selected="selected"><?php _e('Center', 'wrcpt'); ?></option>
						<?php } ?>
					</select>
					<label class="input-title"><?php _e('Feature Label Font Direction', 'wrcpt'); ?>:</label>
					<select name="feature_align" id="feature_align" class="font-dir">
						<?php if($packageCombine['ftdir'] == 'left') { ?>
						<option value="left" selected="selected"><?php _e('Left', 'wrcpt'); ?></option>
						<option value="right"><?php _e('Right', 'wrcpt'); ?></option>
						<option value="center"><?php _e('Center', 'wrcpt'); ?></option>
						<?php } elseif($packageCombine['ftdir'] == 'right') { ?>
						<option value="left"><?php _e('Left', 'wrcpt'); ?></option>
						<option value="right" selected="selected"><?php _e('Right', 'wrcpt'); ?></option>
						<option value="center"><?php _e('Center', 'wrcpt'); ?></option>
						<?php } else { ?>
						<option value="left"><?php _e('Left', 'wrcpt'); ?></option>
						<option value="right"><?php _e('Right', 'wrcpt'); ?></option>
						<option value="center" selected="selected"><?php _e('Center', 'wrcpt'); ?></option>
						<?php } ?>
					</select>
					<label class="input-title"><?php _e('Feature Label Padding (Left)', 'wrcpt'); ?></label>
					<input type="number" name="feature_padding" class="medium" id="feature_padding" value="<?php echo $packageCombine['ftpad']; ?>" placeholder="e.g. 10" />
					<label class="input-title"><?php _e('Caption Column Title Direction', 'wrcpt'); ?>:</label>
					<select name="caption_title" id="caption_title" class="font-dir">
						<?php if($packageCombine['cttdir'] == 'left') { ?>
						<option value="left" selected="selected"><?php _e('Left', 'wrcpt'); ?></option>
						<option value="right"><?php _e('Right', 'wrcpt'); ?></option>
						<option value="center"><?php _e('Center', 'wrcpt'); ?></option>
						<?php } elseif($packageCombine['cttdir'] == 'right') { ?>
						<option value="left"><?php _e('Left', 'wrcpt'); ?></option>
						<option value="right" selected="selected"><?php _e('Right', 'wrcpt'); ?></option>
						<option value="center"><?php _e('Center', 'wrcpt'); ?></option>
						<?php } else { ?>
						<option value="left"><?php _e('Left', 'wrcpt'); ?></option>
						<option value="right"><?php _e('Right', 'wrcpt'); ?></option>
						<option value="center" selected="selected"><?php _e('Center', 'wrcpt'); ?></option>
						<?php } ?>
					</select>
					<label class="input-title"><?php _e('Caption Column Font Direction', 'wrcpt'); ?>:</label>
					<select name="caption_align" id="caption_align" class="font-dir">
						<?php if($packageCombine['cftdir'] == 'left') { ?>
						<option value="left" selected="selected"><?php _e('Left', 'wrcpt'); ?></option>
						<option value="right"><?php _e('Right', 'wrcpt'); ?></option>
						<option value="center"><?php _e('Center', 'wrcpt'); ?></option>
						<?php } elseif($packageCombine['cftdir'] == 'right') { ?>
						<option value="left"><?php _e('Left', 'wrcpt'); ?></option>
						<option value="right" selected="selected"><?php _e('Right', 'wrcpt'); ?></option>
						<option value="center"><?php _e('Center', 'wrcpt'); ?></option>
						<?php } else { ?>
						<option value="left"><?php _e('Left', 'wrcpt'); ?></option>
						<option value="right"><?php _e('Right', 'wrcpt'); ?></option>
						<option value="center" selected="selected"><?php _e('Center', 'wrcpt'); ?></option>
						<?php } ?>
					</select>
					<label class="input-check"><?php _e('Align Price Unit at Right', 'wrcpt'); ?>:
					<input type="checkbox" name="unit_right" class="tickbox" id="unit_right" value="yes"<?php if($packageCombine['purgt'] == 'yes') { ?> checked="checked"<?php } ?>/></label>
					<label class="input-check"><?php _e('Float Tick/Cross Icon at Left', 'wrcpt'); ?>:
					<input type="checkbox" name="tcicon_left" class="tickbox" id="tcicon_left" value="yes"<?php if($packageCombine['tcleft'] == 'yes') { ?> checked="checked"<?php } ?>/></label>
					<div class="break-line"></div>
                    <h4><?php _e('Show/Hide', 'wrcpt'); ?></h3>
					<label class="input-check" id="hide-table-parts"><?php _e('Hide which you don\'t like to display', 'wrcpt'); ?>:</label>
					<div class="table-body-options">
						<label for="hide_title" class="hide_table">
							<span><?php _e('Title', 'wrcpt'); ?></span>
							<input type="checkbox" name="hide_title" class="tickbox" id="hide_title" value="yes"<?php if($packageCombine['htitle'] == 'yes') { ?> checked="checked"<?php } ?>/>
						</label>
						<label for="hide_price" class="hide_table">
							<span><?php _e('Price', 'wrcpt'); ?></span>
							<input type="checkbox" name="hide_price" class="tickbox" id="hide_price" value="yes"<?php if($packageCombine['hprice'] == 'yes') { ?> checked="checked"<?php } ?>/>
						</label>
						<label for="hide_feature" class="hide_table">
							<span><?php _e('Features', 'wrcpt'); ?></span>
							<input type="checkbox" name="hide_feature" class="tickbox" id="hide_feature" value="yes"<?php if($packageCombine['hfeat'] == 'yes') { ?> checked="checked"<?php } ?>/>
						</label>
						<label for="hide_button" class="hide_table">
							<span><?php _e('Button', 'wrcpt'); ?></span>
							<input type="checkbox" name="hide_button" class="tickbox" id="hide_button" value="yes"<?php if($packageCombine['hbutton'] == 'yes') { ?> checked="checked"<?php } ?>/>
						</label>
					</div>
					<div class="break-line"></div>
				</div>
            	<!--Font Settings -->
				<h3 class="ptitle"><?php _e('Font Settings', 'wrcpt'); ?></h3>
				<div class="advance-input">
                    <h4><?php _e('Font Family', 'wrcpt'); ?></h4>
					<label class="input-title"><?php _e('Enter Primary Font Family', 'wrcpt'); ?></label>
					<input type="text" name="primary_font" class="medium" id="primary_font" value="<?php echo $packageCombine['pgfont']; ?>" placeholder="e.g. 'Roboto Condensed', serif" />
					<label class="input-title"><?php _e('Enter Secondary Font Family', 'wrcpt'); ?></label>
					<input type="text" name="secondary_font" class="medium" id="secondary_font" value="<?php echo $packageCombine['sgfont']; ?>" placeholder="e.g. 'Open Sans', sans-serif" />
					<div class="break-line"></div>
                    <h4><?php _e('Title', 'wrcpt'); ?></h4>
					<label class="input-title"><?php _e('Pricing Table Name Font Size', 'wrcpt'); ?></label>
					<input type="text" name="caption_size" class="medium" id="caption_size" value="<?php echo $packageCombine['ctsize']; ?>" placeholder="e.g. 36px" />
					<label class="input-title"><?php _e('Title Font Size', 'wrcpt'); ?></label>
					<input type="text" name="title_size" class="medium" id="title_size" value="<?php echo $packageCombine['tsize']; ?>" placeholder="e.g. 24px" />
					<label class="input-title"><?php _e('Title Description Font Size', 'wrcpt'); ?></label>
					<input type="text" name="desc_size" class="medium" id="desc_size" value="<?php echo $packageCombine['tdesc']; ?>" size="8" placeholder="e.g. 12px" />
					<div class="break-line"></div>
                    <h4><?php _e('Price', 'wrcpt'); ?></h3>
					<label class="input-title"><?php _e('Price Font Size (Big)', 'wrcpt'); ?></label>
					<input type="text" name="price_size_big" class="medium" id="price_size_big" value="<?php echo $packageCombine['psbig']; ?>" placeholder="e.g. 60px" />
					<label class="input-title"><?php _e('Price Font Size (Small)', 'wrcpt'); ?></label>
					<input type="text" name="price_size_small" class="medium" id="price_size_small" value="<?php echo $packageCombine['pssmall']; ?>" placeholder="e.g. 24px" />
					<label class="input-title"><?php _e('Cut Price Font Size', 'wrcpt'); ?></label>
					<input type="text" name="cut_price_size" class="medium" id="cut_price_size" value="<?php echo $packageCombine['cutprs']; ?>" placeholder="e.g. 24px" />
					<div class="break-line"></div>
                    <h4><?php _e('Feature', 'wrcpt'); ?></h3>
					<label class="input-title"><?php _e('Feature Category Font Size', 'wrcpt'); ?></label>
					<input type="text" name="ft_cate_fsize" class="medium" id="ft_cate_fsize" value="<?php echo $packageCombine['cfsize']; ?>" placeholder="e.g. 20px" />
					<label class="input-title"><?php _e('Feature Name Font Size', 'wrcpt'); ?></label>
					<input type="text" name="cap_feat_size" class="medium" id="cap_feat_size" value="<?php echo $packageCombine['cftsize']; ?>" placeholder="e.g. 12px" />
					<label class="input-title"><?php _e('Feature Values Font Size', 'wrcpt'); ?></label>
					<input type="text" name="feature_text_size" class="medium" id="feature_text_size" value="<?php echo $packageCombine['ftsize']; ?>" placeholder="e.g. 12px" />
					<div class="break-line"></div>
                    <h4><?php _e('Button &amp; Ribbon', 'wrcpt'); ?></h3>
					<label class="input-title"><?php _e('Button Text Font Size', 'wrcpt'); ?></label>
					<input type="text" name="button_text_size" class="medium" id="button_text_size" value="<?php echo $packageCombine['btsize']; ?>" placeholder="e.g. 12px" />
					<label class="input-title"><?php _e('Ribbon Text Font Size', 'wrcpt'); ?></label>
					<input type="text" name="ribbon_text_size" class="medium" id="ribbon_text_size" value="<?php echo $packageCombine['rtsize']; ?>" placeholder="e.g. 12px" />
					<div class="break-line"></div>
                    <h4><?php _e('Price Toggle', 'wrcpt'); ?></h3>
					<label class="input-title"><?php _e('Pricing Toggle Font Size', 'wrcpt'); ?></label>
					<input type="text" name="ptog_text_size" class="medium" id="ptog_text_size" value="<?php echo $packageCombine['ptsize']; ?>" placeholder="e.g. 14px" />
					<label class="input-title"><?php _e('Pricing Toggle Special Font Size', 'wrcpt'); ?></label>
					<input type="text" name="ptogsp_text_size" class="medium" id="ptogsp_text_size" value="<?php echo $packageCombine['ptspsize']; ?>" placeholder="e.g. 10px" />
					<div class="break-line"></div>
				</div>
                <!--Advanced Color Settings -->
				<h3 class="ptitle"><?php _e('Advanced Color Settings', 'wrcpt'); ?></h3>
				<div class="advance-input">
					<table>
						<!--Caption Column -->
						<tr class="table-header">
							<td colspan="2"><?php _e('Caption Column', 'wrcpt'); ?></td>
						</tr>
						<tr class="table-input">
							<th><label class="input-title"><?php _e('Caption Border Color', 'wrcpt'); ?></label></th>
							<td><input type="text" name="cap_col_bg" class="cap_col_bg" id="cap_col_bg" value="<?php echo $packageCombine['ccolbg']; ?>" /></td>
						</tr>
						<tr class="table-input">
							<th><label class="input-title"><?php _e('Caption Title BG Color', 'wrcpt'); ?></label></th>
							<td><input type="text" name="pricing_name_bg" class="pricing_name_bg" id="pricing_name_bg" value="<?php echo $packageCombine['prnbg']; ?>" /></td>
						</tr>
						<tr class="table-input">
							<th><label class="input-title"><?php _e('Caption Title Font Color', 'wrcpt'); ?></label></th>
							<td><input type="text" name="cap_font_color" class="cap_font_color" id="cap_font_color" value="<?php echo $packageCombine['ctcolor']; ?>" /></td>
						</tr>
						<tr class="table-input">
							<th><label class="input-title"><?php _e('Caption Feature BG Color 1', 'wrcpt'); ?></label></th>
							<td><input type="text" name="cap_row1_color" class="cap_row1_color" id="cap_row1_color" value="<?php echo $packageCombine['capbg1']; ?>" /></td>
						</tr>
						<tr class="table-input">
							<th><label class="input-title"><?php _e('Caption Feature BG Color 2', 'wrcpt'); ?></label></th>
							<td><input type="text" name="cap_row2_color" class="cap_row2_color" id="cap_row2_color" value="<?php echo $packageCombine['capbg2']; ?>" /></td>
						</tr>
						<tr class="table-input">
							<th><label class="input-title"><?php _e('Caption Feature Border', 'wrcpt'); ?></label></th>
							<td><input type="text" name="cap_border_color" class="cap_border_color" id="cap_border_color" value="<?php echo $packageCombine['ccborder']; ?>" /></td>
						</tr>
						<!--Tooltips -->
						<tr class="table-header">
							<td colspan="2"><?php _e('Tooltips', 'wrcpt'); ?></td>
						</tr>
						<tr class="table-input">
							<th><label class="input-title"><?php _e('ToolTips Background Color', 'wrcpt'); ?></label></th>
							<td><input type="text" name="ttip_bg_color" class="ttip_bg_color" id="ttip_bg_color" value="<?php echo $packageCombine['ttbg']; ?>" /></td>
						</tr>
						<tr class="table-input">
							<th><label class="input-title"><?php _e('ToolTips Font Color', 'wrcpt'); ?></label></th>
							<td><input type="text" name="ttip_font_color" class="ttip_font_color" id="ttip_font_color" value="<?php echo $packageCombine['tttext']; ?>" /></td>
						</tr>
						<!--Toggle -->
						<tr class="table-header">
							<td colspan="2"><?php _e('Price Toggle', 'wrcpt'); ?></td>
						</tr>
						<tr class="table-input">
							<th><label class="input-title"><?php _e('Pricing Toggle Active BG', 'wrcpt'); ?></label></th>
							<td><input type="text" name="ptog_bg_active" class="ptog_bg_active" id="ptog_bg_active" value="<?php echo $packageCombine['ptabg']; ?>" /></td>
						</tr>
						<tr class="table-input">
							<th><label class="input-title"><?php _e('Pricing Toggle Normal BG', 'wrcpt'); ?></label></th>
							<td><input type="text" name="ptog_bg_normal" class="ptog_bg_normal" id="ptog_bg_normal" value="<?php echo $packageCombine['ptnbg']; ?>" /></td>
						</tr>
						<tr class="table-input">
							<th><label class="input-title"><?php _e('Pricing Toggle Normal Font', 'wrcpt'); ?></label></th>
							<td><input type="text" name="ptn_font_color" class="ptn_font_color" id="ptn_font_color" value="<?php echo $packageCombine['ptntext']; ?>" /></td>
						</tr>
						<tr class="table-input">
							<th><label class="input-title"><?php _e('Pricing Toggle Active Font', 'wrcpt'); ?></label></th>
							<td><input type="text" name="pta_font_color" class="pta_font_color" id="pta_font_color" value="<?php echo $packageCombine['ptatext']; ?>" /></td>
						</tr>
						<tr class="table-input">
							<th><label class="input-title"><?php _e('Pricing Toggle Special Font', 'wrcpt'); ?></label></th>
							<td><input type="text" name="ptsp_font_color" class="ptsp_font_color" id="ptsp_font_color" value="<?php echo $packageCombine['ptsptext']; ?>" /></td>
						</tr>
						<!--Feature Color -->
						<tr class="table-header">
							<td colspan="2"><?php _e('Feature Colors', 'wrcpt'); ?></td>
						</tr>
						<tr class="table-input">
							<th><label class="input-title"><?php _e('Feature Category BG Color', 'wrcpt'); ?></label></th>
							<td><input type="text" name="ft_cate_color" class="ft_cate_color" id="ft_cate_color" value="<?php echo $packageCombine['fcatbg']; ?>" /></td>
						</tr>
						<tr class="table-input">
							<th><label class="input-title"><?php _e('Feature Category Font Color', 'wrcpt'); ?></label></th>
							<td><input type="text" name="ft_font_color" class="ft_font_color" id="ft_font_color" value="<?php echo $packageCombine['ffnclr']; ?>" /></td>
						</tr>
						<tr class="table-input">
							<th><label class="input-title"><?php _e('Feature Name Font Color', 'wrcpt'); ?></label></th>
							<td><input type="text" name="cap_feat_color" class="cap_feat_color" id="cap_feat_color" value="<?php echo $packageCombine['cftcolor']; ?>" /></td>
						</tr>
						<tr class="table-input">
							<th><label class="input-title"><?php _e('Feature URL Color', 'wrcpt'); ?></label></th>
							<td><input type="text" name="feat_url_color" class="feat_url_color" id="feat_url_color" value="<?php echo $packageCombine['furlclr']; ?>" /></td>
						</tr>
						<tr class="table-input">
							<th><label class="input-title"><?php _e('Feature URL Hover', 'wrcpt'); ?></label></th>
							<td><input type="text" name="feat_url_hover" class="feat_url_hover" id="feat_url_hover" value="<?php echo $packageCombine['furlhvr']; ?>" /></td>
						</tr>
						<!--Font Awesome -->
						<tr class="table-header">
							<td colspan="2"><?php _e('Font Awesome', 'wrcpt'); ?></td>
						</tr>
						<tr class="table-input">
							<th><label class="input-title"><?php _e('Font Awesome Tick Color', 'wrcpt'); ?></label></th>
							<td><input type="text" name="fawe_tick_color" class="fawe_tick_color" id="fawe_tick_color" value="<?php echo $packageCombine['fatclr']; ?>" /></td>
						</tr>
						<tr class="table-input">
							<th><label class="input-title"><?php _e('Font Awesome Cross Color', 'wrcpt'); ?></label></th>
							<td><input type="text" name="fawe_cross_color" class="fawe_cross_color" id="fawe_cross_color" value="<?php echo $packageCombine['facclr']; ?>" /></td>
						</tr>
						<!--Shadow Color -->
						<tr class="table-header">
							<td colspan="2"><?php _e('Column Shadow Colors', 'wrcpt'); ?></td>
						</tr>
						<tr class="table-input">
							<th><label class="input-title"><?php _e('Column Shadow Color', 'wrcpt'); ?></label></th>
							<td><input type="text" name="col_shad_color" class="col_shad_color" id="col_shad_color" value="<?php echo $packageCombine['cscolor']; ?>" /></td>
						</tr>
						<tr class="table-input">
							<th><label class="input-title"><?php _e('Column Shadow Highlight Color', 'wrcpt'); ?></label></th>
							<td><input type="text" name="col_shad_hover_color" class="col_shad_hover_color" id="col_shad_hover_color" value="<?php echo $packageCombine['cshcolor']; ?>" /></td>
						</tr>
					</table>
				</div>
			</div>	<!--//pricing table settings -->
		</div>	<!--settingcolumnwrap -->
	</div>	<!--settingcolumndiv -->
	<div class="wrcpt-clear"></div>
	<input type="hidden" id="submitted" name="submitted" value="<?php if(isset($packageCombine['subform']) && $packageCombine['subform']) { echo $packageCombine['subform']; } else { echo 'no'; } ?>" />
	<input type="hidden" name="pricing_table" value="<?php echo $pricing_table; ?>" />
	<input type="hidden" name="checkbox_value" value="<?php echo $checkValue; ?>" />
	<input type="hidden" name="template" value="<?php echo $template; ?>" />
	<input type="hidden" name="action" value="wrcpt_update_pricing_package">
  	<button type="submit" id="wrcpt_edit" class="button-primary"><?php _e('Update Package', 'wrcpt'); ?></button>
<?php
	wp_die();
}
add_action( 'wp_ajax_nopriv_wrcpt_edit_pricing_packages', 'wrcpt_edit_pricing_packages' );
add_action( 'wp_ajax_wrcpt_edit_pricing_packages', 'wrcpt_edit_pricing_packages' );
?>