<?php
/**
 * Editing Pricing Table features after creating a new table.
 *
 * WRC Pricing Tables Ultimate - v1.2.4 - 16 July, 2023
 */
function wrcpt_process_package_features() {
	$i = 1; $fp = 1; $package_feature = array();
	$pricing_table = $_POST['packtable'];
	$package_feature = get_option($pricing_table.'_feature', 'default_value');
	if ( $package_feature !== 'default_value' ) {
		if(isset($package_feature['flink1'])) {
			if(isset($package_feature['fcate1'])) {
				$featureNum = count($package_feature)/6;
			} else {
				$featureNum = count($package_feature)/5;
			}
		} else {
			$featureNum = count($package_feature)/2;
		}
	} else {
		$featureNum = 0;
	}
	$package_lists = get_option($pricing_table);
	$packageOptions = explode(', ', $package_lists); ?>
	<input type="hidden" name="process_feature" value="feature" />
	<div id="tablenamediv"><?php
	/* Edit features if available */
	if ( $package_feature !== 'default_value' ) { ?>
		<div id="pricingfeaturediv">
			<div class="pricingfeaturewrap">
				<h3><?php _e('Pricing Package Features', 'wrcpt'); ?></h3>
				<table id="feature_edititem" cellspacing="0">
					<thead>
						<tr class="featheader">
							<th><?php _e('Features', 'wrcpt'); ?><a href="#" class="wrc_feat_tooltip" rel="<?php _e('Enter your pricing table features in the text box. A feature is a distinctive characteristic of a good or service that sets it apart from similar items. Means of providing benefits to customers.', 'wrcpt'); ?>"><span class="dashicons dashicons-editor-help"></span></a></th>
							<th><?php _e('Feature Category', 'wrcpt'); ?></th>
							<th><?php _e('Feature URL', 'wrcpt'); ?></th>
							<th><?php _e('Short Description', 'wrcpt'); ?></th>
							<th><?php _e('Type', 'wrcpt'); ?></th>
							<th><?php _e('F. Awesome Icon', 'wrcpt'); ?><a href="#" class="wrc_feat_tooltip wrc_left" rel="<?php _e('To set up Font Awesome icon you just need to put the icon class in the below text box that corresponds to the icon you are trying to display; for example if you want to display the camera icon you can add the \'fas fa-camera-retro\' class. Visit https://fontawesome.com/how-to-use to learn more about Font Awesome.', 'wrcpt'); ?>"><span class="dashicons dashicons-editor-help"></span></a></th>
							<th><?php _e('Actions', 'wrcpt'); ?></th>
						</tr>
					</thead>
					<tbody>
					<?php for($i = 1; $i <= $featureNum; $i++) { ?>
						<tr class="featurebody">
							<td>
								<input type="text" name="feature_name[<?php echo 'fitem'.$i; ?>]" value="<?php echo $package_feature['fitem'.$i]; ?>" placeholder="<?php _e('Enter Feature Name', 'wrcpt'); ?>" size="20" required /><?php
								foreach($packageOptions as $option => $value) {
									$packageItem = get_option($value); ?>
									<input type="hidden" name="feature_value[]" value="<?php echo $packageItem['fitem'.$fp]; ?>" />
									<input type="hidden" name="tooltips[]" value="<?php echo $packageItem['tip'.$fp]; ?>" /><?php
								} $fp++; ?>
							</td>
							<td><input type="text" name="feature_cate[]" value="<?php echo $package_feature['fcate'.$i]; ?>" placeholder="<?php _e('Enter Category Name', 'wrcpt'); ?>" size="15" /></td>
							<td><input type="text" name="feature_link[]" value="<?php echo $package_feature['flink'.$i]; ?>" placeholder="<?php _e('Enter Feature URL', 'wrcpt'); ?>" size="20" /></td>
							<td><input type="text" name="feature_desc[]" value="<?php echo $package_feature['fdesc'.$i]; ?>" placeholder="<?php _e('Enter Short Description', 'wrcpt'); ?>" size="20" />
							<td class="select_ft">
								<select name="feature_type[]" id="feature_type_<?php echo $i; ?>">
									<?php if($package_feature['ftype'.$i] == 'text') { ?>
									<option value="text" selected="selected"><?php _e('Text', 'wrcpt'); ?></option>
									<option value="html"><?php _e('HTML', 'wrcpt'); ?></option>
									<option value="check"><?php _e('Checkbox', 'wrcpt'); ?></option>
									<option value="textcheck"><?php _e('Text and Checkbox', 'wrcpt'); ?></option>
									<option value="starrate"><?php _e('Star Ratings', 'wrcpt'); ?></option>
									<?php } elseif($package_feature['ftype'.$i] == 'html') { ?>
									<option value="text"><?php _e('Text', 'wrcpt'); ?></option>
									<option value="html" selected="selected"><?php _e('HTML', 'wrcpt'); ?></option>
									<option value="check"><?php _e('Checkbox', 'wrcpt'); ?></option>
									<option value="textcheck"><?php _e('Text and Checkbox', 'wrcpt'); ?></option>
									<option value="starrate"><?php _e('Star Ratings', 'wrcpt'); ?></option>
									<?php } elseif($package_feature['ftype'.$i] == 'check') { ?>
									<option value="text"><?php _e('Text', 'wrcpt'); ?></option>
									<option value="html"><?php _e('HTML', 'wrcpt'); ?></option>
									<option value="check" selected="selected"><?php _e('Checkbox', 'wrcpt'); ?></option>
									<option value="textcheck"><?php _e('Text and Checkbox', 'wrcpt'); ?></option>
									<option value="starrate"><?php _e('Star Ratings', 'wrcpt'); ?></option>
									<?php } elseif($package_feature['ftype'.$i] == 'textcheck') { ?>
									<option value="text"><?php _e('Text', 'wrcpt'); ?></option>
									<option value="html"><?php _e('HTML', 'wrcpt'); ?></option>
									<option value="check"><?php _e('Checkbox', 'wrcpt'); ?></option>
									<option value="textcheck" selected="selected"><?php _e('Text and Checkbox', 'wrcpt'); ?></option>
									<option value="starrate"><?php _e('Star Ratings', 'wrcpt'); ?></option>
									<?php } elseif($package_feature['ftype'.$i] == 'starrate') { ?>
									<option value="text"><?php _e('Text', 'wrcpt'); ?></option>
									<option value="html"><?php _e('HTML', 'wrcpt'); ?></option>
									<option value="check"><?php _e('Checkbox', 'wrcpt'); ?></option>
									<option value="textcheck"><?php _e('Text and Checkbox', 'wrcpt'); ?></option>
									<option value="star"><?php _e('Star Mark', 'wrcpt'); ?></option>
									<option value="starrate" selected="selected"><?php _e('Star Ratings', 'wrcpt'); ?></option>
									<?php } else { ?>
									<option value="text" selected="selected"><?php _e('Text', 'wrcpt'); ?></option>
									<option value="html"><?php _e('HTML', 'wrcpt'); ?></option>
									<option value="check"><?php _e('Checkbox', 'wrcpt'); ?></option>
									<option value="textcheck"><?php _e('Text and Checkbox', 'wrcpt'); ?></option>
									<option value="starrate"><?php _e('Star Ratings', 'wrcpt'); ?></option>
									<?php } ?>
								</select>
							</td>
							<td><input type="text" name="awesome_icon[]" value="<?php echo $package_feature['fasom'.$i]; ?>" placeholder="<?php _e('Enter Icon Class', 'wrcpt'); ?>" size="15" /></td>
							<td><span id="remFeatute"></span></td>
						</tr>
					<?php } ?>
					</tbody>
				</table>
				<input type="button" id="editfeature" class="button-primary" value="<?php _e('Add New', 'wrcpt'); ?>" />
			</div>
		</div>
		<input type="hidden" name="pricing_table" value="<?php echo $pricing_table; ?>" />
		<input type="hidden" name="package_feature" value="<?php echo $pricing_table.'_feature'; ?>" />
		<input type="hidden" name="action" value="wrcpt_update_package_features">
  		<button type="submit" id="wrcpt_upfeature" class="button-primary"><?php _e('Update Feature', 'wrcpt'); ?></button>
	<?php
	/* if no features available */
	} else { ?>
		<div id="pricingfeaturediv">
			<div class="pricingfeaturewrap">
				<h3><?php _e('Pricing Package Features', 'wrcpt'); ?></h3>
				<table id="feature_edititem" cellspacing="0">
					<tr class="featheader">
						<th><?php _e('Features', 'wrcpt'); ?><a href="#" class="wrc_feat_tooltip" rel="<?php _e('Enter your pricing table features in the text box. A feature is a distinctive characteristic of a good or service that sets it apart from similar items. Means of providing benefits to customers.', 'wrcpt'); ?>"><span class="dashicons dashicons-editor-help"></span></a></th>
						<th><?php _e('Feature Category', 'wrcpt'); ?></th>
						<th><?php _e('Feature URL', 'wrcpt'); ?></th>
						<th><?php _e('Short Description', 'wrcpt'); ?></th>
						<th><?php _e('Type', 'wrcpt'); ?></th>
						<th><?php _e('F. Awesome Icon', 'wrcpt'); ?><a href="#" class="wrc_feat_tooltip wrc_left" rel="<?php _e('To set up Font Awesome icon you just need to put the icon class in the below text box that corresponds to the icon you are trying to display; for example if you want to display the camera icon you can add the \'fas fa-camera-retro\' class. Visit https://fontawesome.com/how-to-use to learn more about Font Awesome.', 'wrcpt'); ?>"><span class="dashicons dashicons-editor-help"></span></a></th>
						<th><?php _e('Actions', 'wrcpt'); ?></th>
					</tr>
					<tr class="featurebody">
						<td><input type="text" name="feature_name[]" value="" placeholder="<?php _e('Enter Feature Name', 'wrcpt'); ?>" size="20" required /></td>
						<td><input type="text" name="feature_cate[]" value="" placeholder="<?php _e('Enter Category Name', 'wrcpt'); ?>" size="15" /></td>
						<td><input type="text" name="feature_link[]" value="" placeholder="<?php _e('Enter Feature URL', 'wrcpt'); ?>" size="20" /></td>
						<td><input type="text" name="feature_desc[]" value="" placeholder="<?php _e('Enter Short Description', 'wrcpt'); ?>" size="20" /></td>
						<td>
							<select name="feature_type[]" id="feature_type">
								<option value="text" selected="selected"><?php _e('Text', 'wrcpt'); ?></option>
								<option value="html"><?php _e('HTML', 'wrcpt'); ?></option>
								<option value="check"><?php _e('Checkbox', 'wrcpt'); ?></option>
								<option value="textcheck"><?php _e('Text and Checkbox', 'wrcpt'); ?></option>
								<option value="starrate"><?php _e('Star Ratings', 'wrcpt'); ?></option>
							</select>
						</td>
						<td><input type="text" name="awesome_icon[]" value="" placeholder="<?php _e('Enter Icon Class', 'wrcpt'); ?>" size="15" /></td>
						<td><span id="remFeatute"></span></td>
					</tr>
				</table>
				<input type="button" id="editfeature" class="button-primary" value="<?php _e('Add New', 'wrcpt'); ?>" />
			</div>
		</div>
		<input type="hidden" name="package_feature" value="<?php echo $pricing_table.'_feature'; ?>" />
		<input type="hidden" name="action" value="wrcpt_add_package_features">
  		<button type="submit" id="wrcpt_addfeature" class="button-primary"><?php _e('Add Feature', 'wrcpt'); ?></button>
		<!-- <input type="submit" id="wrcpt_addfeature" name="wrcpt_addfeature" class="button-primary" value="<?php //_e('Add Feature', 'wrcpt'); ?>" />  -->
	<?php } ?>
	</div>
	<div class="wrcpt-clear"></div>
	<div class="table_list">
		<p class="feature_notice">*** <?php _e('You can reorder features by dragging with the mouse', 'wrcpt'); ?> ***</p>
	</div>
<?php
	wp_die();
}
add_action( 'wp_ajax_nopriv_wrcpt_process_package_features', 'wrcpt_process_package_features' );
add_action( 'wp_ajax_wrcpt_process_package_features', 'wrcpt_process_package_features' );
?>