<?php
/**
 * Processing Pricing Table by creating a new table
 * and by making a lists of all pricing tables.
 *
 * Also processing pricing table features while adding a new table.
 *
 * WRC Pricing Tables Ultimate - v1.2.4 - 16 July, 2023
 */
$package_table = get_option('packageTables');
$package_ids = get_option('packageIDs');
$flag = 0; ?>
<div class="wrap">
	<div id="add_new_table" class="postbox-container">
	<h2 class="main-header"><?php _e('Pricing Tables', 'wrcpt'); ?> <a href="?page=wrcpt_template" id="new_table" class="add-new-h2"><?php _e('Add Template', 'wrcpt'); ?></a><span id="wrcpt-loading-image"></span></h2>
<?php
	/* Display Pricing Table Lists*/
	if($package_table) {
		$table_lists = explode(', ', $package_table);
		$active_lists = wrcpt_published_tables_count($table_lists);
		$inactive_lists = count($table_lists) - wrcpt_published_tables_count($table_lists);
		$id_lists = explode(', ', $package_ids); ?>
		<div class="table_list">
            <ul class="subsubsub">
                <li class="all">All <span class="count"><?php echo count($table_lists); ?></span></li>
                <li class="publish">Active <span class="count"><?php echo $active_lists; ?></span></li>
                <li class="unpublish">Inactive <span class="count"><?php echo $inactive_lists; ?></span></li>
            </ul><br>
			<form id='wrcpt_edit_form' method="post" action="<?php echo admin_url('admin-ajax.php'); ?>" enctype="multipart/form-data">
				<input type="hidden" name="wrcpt_edit_process" value="editprocess" />
				<input type="checkbox" id='checkallhide' class="check-all-hidden">
                <div id="wrcptupdate" class="button update-all">Update</div>
                <div id="wrcptaction" class="button button-del">Delete</div>
				<table id="wrcpt_list" class="form-table">
					<div id="form-messages">
						<button type="button" class="wrcpt_close">
							<span aria-hidden="true"><a><i class="dashicons dashicons-dismiss blackcross"></i></a></span>
						</button>
						<i class="start-icon dashicons dashicons-yes-alt"></i>
						<?php _e( '<strong>Well done!</strong> You successfully Updated Your Pricing Table Settings.', 'wrcpt' ); ?>
					</div><?php
					$upcount = wrcpt_count_unuseful_package_options();
					if ($upcount > 0) {
						echo '<div id="alert-message" class="notice-warning">
						<button type="button" class="wrcpt_close">
							<span aria-hidden="true"><a><i class="dashicons dashicons-dismiss blackcross"></i></a></span>
						</button>
						<i class="start-icon dashicons dashicons-warning"></i>'.
						sprintf(__( '<strong>Alert!</strong> %d unnecessary package options identified in the database! Please go to <strong>Pricing Tables >> Tools</strong> and click on <strong>Optimize Pricing Tables</strong> button to remove for a clearer pricing experience.', 'wrcpt' ), $upcount).'</div>';
					} ?>
					<thead>
						<tr>
							<th><input type="checkbox" id='checkall'></th>
							<th><?php _e('ID', 'wrcpt'); ?></th>
							<th><?php _e('Table Name', 'wrcpt'); ?></th>
							<th><?php _e('Shortcode', 'wrcpt'); ?></th>
							<th><?php _e('Template', 'wrcpt'); ?></th>
							<th><?php _e('Status', 'wrcpt'); ?></th>
						</tr>
					</thead>
<?php
					foreach($table_lists as $key => $list) {
						$list_item = ucwords(str_replace('_', ' ', $list));
						$package_lists = get_option($list);
						$package_feature = get_option($list.'_feature');
						$packageCombine = get_option($list.'_option');
						$package_item = explode(', ', $package_lists);
						$packageCount = count($package_item);
						$packageID = $id_lists[$key];
						$tableId = $key+1; $t_templ = 'temp0';
						$table_name = (isset($packageCombine['dname']) && $packageCombine['dname'] != '') ? $packageCombine['dname'] : $list_item;
						if($package_feature) {
							if(get_option($list) && $packageCount > 0) {
								$flag = 1; ?>
								<tbody id="wrcpt_<?php echo $list; ?>">
									<tr <?php if($tableId % 2 == 0) { echo 'class="alt"'; } ?> data-row-id="<?php echo $list; ?>">
										<td><input type="checkbox" class='wrcpt_checkbox' name="table_name[]" value="<?php echo $list; ?>" data-id="<?php echo $list; ?>"></td>
										<td><?php echo $tableId; ?></td>
										<td class="table_name" id="<?php echo $list; ?>">
											<div id="edit_package"><?php echo $table_name; ?>
											<span id="copy_table" class="duplicate_table" rel="<?php _e('Duplicate Table', 'wrcpt'); ?>" data-count="<?php echo $packageCount; ?>" data-id="<?php echo $list; ?>"></span></div>
											<span class="edit_pack" data-id="<?php echo $list; ?>" data-count="<?php echo $packageCount; ?>"><?php _e('Edit Columns', 'wrcpt'); ?></span>
											<span id="edit_feature" class="wrcpt_feature" data-id="<?php echo $list; ?>"><?php _e('Edit Features', 'wrcpt'); ?></span>
											<span id="view_package" class="view_pack" data-id="<?php echo $packageID; ?>" data-table="<?php echo $list; ?>"><?php _e('Preview', 'wrcpt'); ?></span>
											<span id="remTable" class="wrcpt_remove" data-id="<?php echo $list; ?>"><?php _e('Delete', 'wrcpt'); ?></span>
										</td>
										<td class="shortcode">
											<div class="tooltip">
												<input id="myInput-<?php echo $tableId; ?>" type="text" name="wrc_shortcode" class="wrc_shortcode" value="<?php echo esc_html('[wrc-pricing-table id="'.$packageID.'"]'); ?>" onclick="myFunction(<?php echo $tableId; ?>)" onmouseout="outFunc()">
												<span class="tooltiptext" id="myTooltip-<?php echo $tableId; ?>">Click to Copy Shortcode!</span>
											</div>
										</td>
										<td><div class="temp_choice">
										<?php if(isset($packageCombine['templ']) && $packageCombine['templ']!=''){$t_templ=$packageCombine['templ'];} ?>
											<select name="wrcpt_template" class="wrcpt_template" id="wrcpt_template" data-id="<?php echo $list; ?>">
												<option value="temp0">Default</option>
												<option value="temp1"<?php if($t_templ == 'temp1') { ?> selected<?php } ?>>Template 1</option>
												<option value="temp2"<?php if($t_templ == 'temp2') { ?> selected<?php } ?>>Template 2</option>
												<option value="temp3"<?php if($t_templ == 'temp3') { ?> selected<?php } ?>>Template 3</option>
												<option value="temp4"<?php if($t_templ == 'temp4') { ?> selected<?php } ?>>Template 4</option>
												<option value="temp5"<?php if($t_templ == 'temp5') { ?> selected<?php } ?>>Template 5</option>
												<option value="temp6"<?php if($t_templ == 'temp6') { ?> selected<?php } ?>>Template 6</option>
												<option value="temp7"<?php if($t_templ == 'temp7') { ?> selected<?php } ?>>Template 7</option>
												<option value="temp8"<?php if($t_templ == 'temp8') { ?> selected<?php } ?>>Template 8</option>
												<option value="temp9"<?php if($t_templ == 'temp9') { ?> selected<?php } ?>>Template 9</option>
												<option value="temp10"<?php if($t_templ == 'temp10') { ?> selected<?php } ?>>Template 10</option>
												<option value="temp11"<?php if($t_templ == 'temp11') { ?> selected<?php } ?>>Template 11</option>
												<option value="temp12"<?php if($t_templ == 'temp12') { ?> selected<?php } ?>>Template 12</option>
												<option value="temp13"<?php if($t_templ == 'temp13') { ?> selected<?php } ?>>Template 13</option>
												<option value="temp14"<?php if($t_templ == 'temp14') { ?> selected<?php } ?>>Template 14</option>
												<option value="temp15"<?php if($t_templ == 'temp15') { ?> selected<?php } ?>>Template 15</option>
												<option value="temp16"<?php if($t_templ == 'temp16') { ?> selected<?php } ?>>Template 16</option>
												<option value="temp17"<?php if($t_templ == 'temp17') { ?> selected<?php } ?>>Template 17</option>
												<option value="temp18"<?php if($t_templ == 'temp18') { ?> selected<?php } ?>>Template 18</option>
												<option value="temp19"<?php if($t_templ == 'temp19') { ?> selected<?php } ?>>Template 19</option>
												<option value="temp20"<?php if($t_templ == 'temp20') { ?> selected<?php } ?>>Template 20</option>
												<option value="temp21"<?php if($t_templ == 'temp21') { ?> selected<?php } ?>>Template 21</option>
												<option value="temp22"<?php if($t_templ == 'temp22') { ?> selected<?php } ?>>Template 22</option>
												<option value="temp23"<?php if($t_templ == 'temp23') { ?> selected<?php } ?>>Template 23</option>
												<option value="temp24"<?php if($t_templ == 'temp24') { ?> selected<?php } ?>>Template 24</option>
												<option value="temp25"<?php if($t_templ == 'temp25') { ?> selected<?php } ?>>Template 25</option>
												<option value="temp26"<?php if($t_templ == 'temp26') { ?> selected<?php } ?>>Template 26</option>
												<option value="temp27"<?php if($t_templ == 'temp27') { ?> selected<?php } ?>>Template 27</option>
												<option value="temp28"<?php if($t_templ == 'temp28') { ?> selected<?php } ?>>Template 28</option>
												<option value="temp29"<?php if($t_templ == 'temp29') { ?> selected<?php } ?>>Template 29</option>
												<option value="temp30"<?php if($t_templ == 'temp30') { ?> selected<?php } ?>>Template 30</option>
												<option value="temp31"<?php if($t_templ == 'temp31') { ?> selected<?php } ?>>Template 31</option>
												<option value="temp32"<?php if($t_templ == 'temp32') { ?> selected<?php } ?>>Template 32</option>
												<option value="temp33"<?php if($t_templ == 'temp33') { ?> selected<?php } ?>>Template 33</option>
												<option value="temp34"<?php if($t_templ == 'temp34') { ?> selected<?php } ?>>Template 34</option>
												<option value="temp35"<?php if($t_templ == 'temp35') { ?> selected<?php } ?>>Template 35</option>
												<option value="temp36"<?php if($t_templ == 'temp36') { ?> selected<?php } ?>>Template 36</option>
												<option value="temp37"<?php if($t_templ == 'temp37') { ?> selected<?php } ?>>Template 37</option>
												<option value="temp38"<?php if($t_templ == 'temp38') { ?> selected<?php } ?>>Template 38</option>
												<option value="temp39"<?php if($t_templ == 'temp39') { ?> selected<?php } ?>>Template 39</option>
												<option value="temp40"<?php if($t_templ == 'temp40') { ?> selected<?php } ?>>Template 40</option>
												<option value="temp41"<?php if($t_templ == 'temp41') { ?> selected<?php } ?>>Template 41</option>
												<option value="temp42"<?php if($t_templ == 'temp42') { ?> selected<?php } ?>>Template 42</option>
												<option value="temp43"<?php if($t_templ == 'temp43') { ?> selected<?php } ?>>Template 43</option>
												<option value="temp44"<?php if($t_templ == 'temp44') { ?> selected<?php } ?>>Template 44</option>
												<option value="temp45"<?php if($t_templ == 'temp45') { ?> selected<?php } ?>>Template 45</option>
												<option value="temp46"<?php if($t_templ == 'temp46') { ?> selected<?php } ?>>Template 46</option>
												<option value="temp47"<?php if($t_templ == 'temp47') { ?> selected<?php } ?>>Template 47</option>
												<option value="temp48"<?php if($t_templ == 'temp48') { ?> selected<?php } ?>>Template 48</option>
												<option value="temp49"<?php if($t_templ == 'temp49') { ?> selected<?php } ?>>Template 49</option>
												<option value="temp50"<?php if($t_templ == 'temp50') { ?> selected<?php } ?>>Template 50</option>
												<option value="temp51"<?php if($t_templ == 'temp51') { ?> selected<?php } ?>>Template 51</option>
												<option value="temp52"<?php if($t_templ == 'temp52') { ?> selected<?php } ?>>Template 52</option>
												<option value="temp53"<?php if($t_templ == 'temp53') { ?> selected<?php } ?>>Template 53</option>
												<option value="temp54"<?php if($t_templ == 'temp54') { ?> selected<?php } ?>>Template 54</option>
												<option value="temp55"<?php if($t_templ == 'temp55') { ?> selected<?php } ?>>Template 55</option>
												<option value="temp56"<?php if($t_templ == 'temp56') { ?> selected<?php } ?>>Template 56</option>
												<option value="temp57"<?php if($t_templ == 'temp57') { ?> selected<?php } ?>>Template 57</option>
												<option value="temp58"<?php if($t_templ == 'temp58') { ?> selected<?php } ?>>Template 58</option>
												<option value="temp59"<?php if($t_templ == 'temp59') { ?> selected<?php } ?>>Template 59</option>
												<option value="temp60"<?php if($t_templ == 'temp60') { ?> selected<?php } ?>>Template 60</option>
												<option value="temp61"<?php if($t_templ == 'temp61') { ?> selected<?php } ?>>Template 61</option>
												<option value="temp62"<?php if($t_templ == 'temp62') { ?> selected<?php } ?>>Template 62</option>
												<option value="temp63"<?php if($t_templ == 'temp63') { ?> selected<?php } ?>>Template 63</option>
												<option value="temp64"<?php if($t_templ == 'temp64') { ?> selected<?php } ?>>Template 64</option>
											</select>
										</div></td>
										<td class="wrc-status"><?php if(isset($packageCombine['enable']) && $packageCombine['enable'] == 'yes') {_e('<span class="status active">Active</span>', 'wrcpt');} else {_e('<span class="status inactive">Inactive</span>', 'wrcpt');} ?></td>
									</tr>
								</tbody>
<?php
							}
						} else { 
							$flag = 0; ?>
							<tbody id="wrcpt_<?php echo $list; ?>">
								<tr <?php if($tableId % 2 == 0) { echo 'class="alt"'; } ?> data-row-id="<?php echo $list; ?>">
									<td><input type="checkbox" class='wrcpt_checkbox' name="table_name" value="<?php echo $list; ?>" data-id="<?php echo $list; ?>"></td>
									<td><?php echo $tableId; ?></td>
									<td class="table_name" id="<?php echo $list; ?>">
										<div id="edit_package"><?php echo $table_name; ?></div>
										<span id="edit_feature" class="wrcpt_feature" data-id="<?php echo $list; ?>"><?php _e('Add Features', 'wrcpt'); ?></span>
										<span id="remTable" class="wrcpt_remove" data-id="<?php echo $list; ?>"><?php _e('Delete', 'wrcpt'); ?></span>
									</td>
									<td class="wrcpt_notice"><span><?php _e('Mouseover on the table name in the left and clicked on <strong>Add Feature</strong> link. To get started you have to add some pricing features first. After that, you will be able to add pricing columns. After adding pricing columns you will get the <strong>SHORTCODE</strong> here.', 'wrcpt'); ?></span></td>
									<td><?php _e('Not Ready!', 'wrcpt'); ?></td>
									<td><?php _e('<span class="status inactive">Inactive</span>', 'wrcpt'); ?></td>
								</tr>
							</tbody>
						<?php
						}
					} ?>
				</table>
				<?php if($package_table && $flag == 1) { ?>
				<div class="reset_shortcode"><input type="button" name="reset_shortcode" class="button-primary" value="<?php _e('Regenerate Shortcode', 'wrcpt'); ?>" /></div>
				<?php } ?>
			</form>
		</div>
<?php
	/* If no pricing table available */
	} else {
		$flag = 0; ?>
		<div class="table_list">
			<p class="get_started"><?php _e('You didn\'t add any pricing tables yet! Click on <strong>Add Template</strong> button to get started. If you feel trouble to understand how to create pricing table, then navigate to <strong>Pricing Tables &raquo; <a href="?page=wrcpt_template">Template</a></strong>. There you will get <strong>60+ ready-made templates</strong> to get started. Simply choose one template and click on <strong>Create Table</strong> button to create a pricing table instantly!<br /><br />If you have any questions that are beyond the scope of the help <a href="?page=wrcpt_help"><strong>documentation</strong></a>, please feel free to open a ticket to any of our support team <a href="https://www.realwebcare.com/billing/submitticket.php" target="_blank"><strong>here</strong></a>. We&#39;d be happy to help you.', 'wrcpt'); ?></p>
		</div>
<?php
	}
?>
	</div>
	<?php if($package_table && $flag == 1) { ?>
	<div id="wrcpt-narration" class="postbox-container code">
		<div id="wrcptusage-premium" class="wrcptusage-sidebar">
			<div class="wrcpt">
				<h3><?php _e('Read the following information carefully', 'wrcpt'); ?></h3>
				<blockquote><p><?php _e('The ', 'wrcpt'); ?><strong><?php _e('General Settings', 'wrcpt'); ?></strong><?php _e(' section of each pricing table now includes the innovative ', 'wrcpt'); ?><strong><?php _e('Shortcode Post/Page URLs', 'wrcpt'); ?></strong><?php _e(' feature. This can help you ensure that your ', 'wrcpt'); ?><strong><?php _e('Custom CSS', 'wrcpt'); ?></strong><?php _e(' file only contains the customizations relevant to the chosen pricing table. Just include the URL of the page where the price table is located and you\'ll be set! This will result in significantly ', 'wrcpt'); ?><strong><?php _e('smaller and faster loading', 'wrcpt'); ?></strong><?php _e(' Custom CSS files.', 'wrcpt'); ?></p><cite><?php _e('Realwebcare', 'wrcpt'); ?>&nbsp;<span class="cite-last-name"><?php _e('ADMIN', 'wrcpt'); ?></span></cite><div class="blockquote-author-image"></div></blockquote>
				<p><?php _e('There is a ', 'wrcpt'); ?><a href="?page=wrcpt_help"><?php _e('YouTube video', 'wrcpt'); ?></a><?php _e(' available that explains how the Pricing Table plugin works. If you have any trouble to understand, feel free to ', 'wrcpt'); ?><a href="https://www.realwebcare.com/billing/submitticket.php" target="_blank"><?php _e('Contact Us', 'wrcpt'); ?></a> <?php _e(' at anytime.', 'wrcpt'); ?>
				<p class="likeit">
				<?php _e('We greatly value your feedback! Please spare a moment to rate your recent experience with our products/services. Your input is highly appreciated and helps us improve. Thank you for your support!', 'wrcpt'); ?>
				<a target="_blank" href="https://wordpress.org/support/plugin/wrc-pricing-tables/reviews/?filter=5/#new-post">&#9733;&#9733;&#9733;&#9733;&#9733;</a>
				</p>
			</div>
		</div>
	</div>
	<div id="wrcpt-sidebar" class="postbox-container code">
		<div id="wrcptusage-premium" class="wrcptusage-sidebar">
			<h3><?php _e('Code Usage Instruction', 'wrcpt'); ?></h3>
			<div class="wrcpt">
				<p><?php _e('To display a pricing table shortcode in a WordPress post or page, you need to access the post or page editor in the WordPress dashboard. Here\'s how:', 'wrcpt'); ?></p>
				<ol>
					<li><?php _e('Go to Posts or Pages, depending on where you want to display the pricing table.', 'wrcpt'); ?></li>
					<li><?php _e('Either create a new post or page, or edit an existing one.', 'wrcpt'); ?></li>
					<!-- <li><?php //_e('Switch to the visual editor if it\'s not already active.', 'wrcpt'); ?></li> -->
					<li><?php _e('Locate the spot in the post or page where you want to display the pricing table.', 'wrcpt'); ?></li>
					<li>
						<?php _e('Paste the following shortcode into the editor:', 'wrcpt'); ?>
						<pre><code>[wrc-pricing-table</span> <span class="wrcpt-built_in">id</span>=<span class="wrcpt-string">"SHORTCODE_ID"</span>]</code></pre>
						<?php _e('Replace "SHORTCODE_ID" with the actual id of the pricing table that you want to display.', 'wrcpt'); ?>
					</li>
					<li><?php _e('Save or publish the post or page.', 'wrcpt'); ?></li>
				</ol>
				<p><?php _e('Once you\'ve saved or published the post or page, the pricing table shortcode will be processed and the pricing table will be displayed on the front end of your site.', 'wrcpt'); ?></p>
			</div>
		</div>
	</div>
	<?php } ?>
</div>