<?php
/**
 * Help file about how to use the plugin.
 *
 * WRC Pricing Tables Ultimate - v1.2.4 - 16 July, 2023
 */
?>
<div class="wrap">
	<div class="wrcpt_guide postbox-container" style="width:65%;">
		<h2 class="main-header"><?php _e('WRC Pricing Tables - Help', 'wrcpt'); ?></h2>
		<div class="wrcusage-maincontent">
			<hr>
			<div class="wrcpt">
				<h3><?php _e('Watch the Video', 'wrcpt'); ?></h3>
				<p><?php _e('We recommend you watch this 7 minutes getting started video, and then try to create your first pricing table using various pricing table options.', 'wrcpt'); ?></p>
				<div class="getting-started_video">
					<iframe width="620" height="350" src="https://www.youtube-nocookie.com/embed/iaAH_-iPO90" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
				</div>
			</div>

			<div class="wrcpt">
				<h3><?php _e('Read the following information carefully', 'wrcpt'); ?></h3>
				<blockquote><p><?php _e('The ', 'wrcpt'); ?><strong><?php _e('General Settings', 'wrcpt'); ?></strong><?php _e(' section of each pricing table now includes the innovative ', 'wrcpt'); ?><strong><?php _e('Shortcode Post/Page URLs', 'wrcpt'); ?></strong><?php _e(' feature. This can help you ensure that your ', 'wrcpt'); ?><strong><?php _e('Custom CSS', 'wrcpt'); ?></strong><?php _e(' file only contains the customizations relevant to the chosen pricing table. Just include the URL of the page where the price table is located and you\'ll be set! This will result in significantly ', 'wrcpt'); ?><strong><?php _e('smaller and faster loading', 'wrcpt'); ?></strong><?php _e(' Custom CSS files.', 'wrcpt'); ?></p><cite><?php _e('Realwebcare', 'wrcpt'); ?>&nbsp;<span class="cite-last-name"><?php _e('ADMIN', 'wrcpt'); ?></span></cite><div class="blockquote-author-image"></div></blockquote>
				<p><?php _e('If the pricing table is still not displayed correctly after updating the above setting, please go to ', 'wrcpt'); ?><strong><?php _e('Pricing Table &raquo; Tools', 'wrcpt'); ?></strong><?php _e(' and click Update Changes. Hopefully, you will get all your tables back as before. If you have any trouble to understand, feel free to ', 'wrcpt'); ?><a href="https://www.realwebcare.com/billing/submitticket.php" target="_blank"><?php _e('Contact Us', 'wrcpt'); ?></a> <?php _e(' at anytime.', 'wrcpt'); ?>
				<h3><?php _e('What\'s New in Version 1.2.4?', 'wrcpt'); ?></h3>
				<ol>
					<li><?php _e('Enhanced support for 4 pricing toggles.', 'wrcpt'); ?></li>
					<li><?php _e('Added an extra button, totaling 2 buttons.', 'wrcpt'); ?></li>
					<li><?php _e('Introduced an option to display the Caption Column\'s tooltip on the Package Column.', 'wrcpt'); ?></li>
					<li><?php _e('Provided the ability to hide pricing table display name.', 'wrcpt'); ?></li>
					<li><?php _e('Included an option to specify the top margin of the pricing table.', 'wrcpt'); ?></li>
					<li><?php _e('Incorporated an option to customize the font size of the cut price in the pricing table.', 'wrcpt'); ?></li>
					<li><?php _e('Implemented an option to personalize the text of the cut price in the pricing table.', 'wrcpt'); ?></li>
				</ol>
			</div>

			<div class="wrcpt">
				<h3><?php _e('Documentation', 'wrcpt'); ?></h3>
				<p><?php _e('To see the full documentation, please click on the following link: <strong><a href="https://www.realwebcare.com/plugin/wrc-pricing-tables/" target="_blank">Documentation</a></strong>.', 'wrcpt'); ?></p>
			</div>
			<hr>
			<div class="wrcpt">
				<p class="prepend-top append-1"><?php _e('Thank you so much for purchasing this plugin. If you have any questions that are beyond the scope of the help documentation, please feel free to open a ticket to any of our support team <a href="https://www.realwebcare.com/billing/submitticket.php" target="_blank">here</a>. We&#39;d be happy to help you.', 'wrcpt'); ?></p>
			</div>
		</div><!-- End wrcusage-maincontent -->
	</div><!-- End postbox-container -->
	<?php wrcpt_sidebar($class='wrc-guide'); ?>
</div><!-- End wrap -->