<?php
/**
 * Adding info about the plugin at the botoom of help file.
 *
 * WRC Pricing Tables Ultimate - v1.2.4 - 16 July, 2023
 */
function wrcpt_sidebar($class='') {
    if($class != '') {
        $class = ' '.$class;
    } ?>
    <div id="wrcpt-sidebar" class="postbox-container<?php echo $class; ?>">
        <div id="wrcptusage-premium" class="wrcptusage-sidebar">
            <h3><?php _e('Code Usage Instruction', 'wrcpt'); ?></h3>
            <div class="wrcpt">
                <p><?php _e('To display a pricing table shortcode in a WordPress theme file, you can use the ', 'wrcpt'); ?><strong><?php _e('do_shortcode', 'wrcpt'); ?></strong> <?php _e(' function:', 'wrcpt'); ?></p>
                <p><pre><code><span class="wrcpt-meta">&lt;?php</span> <span class="wrcpt-keyword">echo</span> <span class="wrcpt-function">do_shortcode</span>(<span class="wrcpt-string">'[wrc-pricing-table id=&quot;SHORTCODE_ID&quot;]'</span>); <span class="wrcpt-meta">?&gt;</span></code></pre></p>
                <p><?php _e('Replace "SHORTCODE_ID" with the actual id of the pricing table that you want to display.', 'wrcpt'); ?></p>
                <p><?php _e('You can place this code anywhere in your theme file where you want the pricing table to appear. For example, you could place it in the template file for a specific page of your site.', 'wrcpt'); ?></p>
                <p><?php _e('Keep in mind that if you are making changes directly to your theme files, those changes will be overwritten if you update the theme. To avoid this, you can create a child theme and make your changes there instead.', 'wrcpt'); ?></p>
            </div>
        </div>
        <div id="wrcptusage-info" class="wrcptusage-sidebar">
            <h3><?php _e('Plugin Info', 'wrcpt'); ?></h3>
            <ul class="wrcptusage-list">
                <li><?php _e('WRC Pricing Tables - Ultimate', 'wrcpt'); ?></li>
                <li><?php _e('Version: 1.2.4', 'wrcpt'); ?></li>
                <li><?php _e('Scripts: PHP + CSS + JS', 'wrcpt'); ?></li>
                <li><?php _e('Requires: Wordpress 5.4+', 'wrcpt'); ?></li>
                <li><?php _e('First released: 19 April, 2019', 'wrcpt'); ?></li>
                <li><?php _e('Last Updated: 16 July, 2023', 'wrcpt'); ?></li>
                <li><?php _e('By', 'wrcpt'); ?>: <a href="https://www.realwebcare.com/" target="_blank"><?php _e('Realwebcare', 'wrcpt'); ?></a></li>
                <li><?php _e('Facebook Page', 'wrcpt'); ?>: <a href="https://www.facebook.com/realwebcare" target="_blank"><?php _e('Realwebcare', 'wrcpt'); ?></a></li>
                <li><?php _e('Need Help', 'wrcpt'); ?>? <a href="https://www.realwebcare.com/billing/submitticket.php" target="_blank">Support</a></li>
                <li><?php _e('Like it? Please leave us a', 'wrcpt'); ?> <a target="_blank" href="https://wordpress.org/support/plugin/wrc-pricing-tables/reviews/?filter=5/#new-post">&#9733;&#9733;&#9733;&#9733;&#9733;</a> <?php _e('rating. We highly appreciate your support!', 'wrcpt'); ?></li>
            </ul>
        </div>
    </div>
<?php
}
?>