/*! WRC Pricing Tables Ultimate - v1.2.4 - 16 July, 2023 */
jQuery(document).ready(function($) {
	"use strict";
	// Hide span tag to show on mouse over
	$(".table_name span").css("display","none");

	// Check or Uncheck All checkboxes
	$("#checkall, #checkallhide").change(function() {
		var checked = $(this).is(':checked');
		if(checked) {
			$(".wrcpt_checkbox").each(function() {
				$("#wrcptaction").slideDown("slow");
				$("#wrcptaction").css("display","inline-block");
				$("#wrcptupdate").slideDown("slow");
				$("#wrcptupdate").css("display","inline-block");
				$(this).prop("checked", true);
			});
		} else {
			$(".wrcpt_checkbox").each(function() {
				$("#wrcptaction").slideUp("slow");
				$("#wrcptupdate").slideUp("slow");
				$(this).prop("checked",false);
			});
		}
	});

	// Changing state of CheckAll checkbox 
	$(".wrcpt_checkbox").click(function() {
		var checkbox = $(this).is(':checked');
		if(checkbox) {
			$("#wrcptaction").slideDown("slow");
			$("#wrcptaction").css("display","inline-block");
			$("#wrcptupdate").slideDown("slow");
			$("#wrcptupdate").css("display","inline-block");
		} else {
			if($(".wrcpt_checkbox:checked").length === 0) {
				$("#wrcptaction").slideUp("slow");
				$("#wrcptupdate").slideUp("slow");
			}
		}
		if($(".wrcpt_checkbox").length === $(".wrcpt_checkbox:checked").length) {
			$("#checkall").prop("checked", true);
		} else {
			$("#checkall").removeAttr("checked");
		}
	});

	// Update all records using Ajax request(Server-Side) or jQuery(Client-Side)
	$('#wrcptupdate').on('click', function() {
		$.wrcptUpdateTableList();
	});

	// Delete all records using Ajax request(Server-Side) or jQuery(Client-Side)
	$('#wrcptaction').on('click', function() {
		$.wrcptDelTableList();
	});

	// Edit pricing column, column info and column settings
	$('.edit_pack').on('click', function() {
		$.wrcpteditpackages();
	});

	// Edit features of a selected table
	$('.wrcpt_feature').on('click', function() {
		$.wrcpteditfeature();
	});

	// Preview a selected table
	$('.view_pack').on('click', function() {
		$.wrcptviewpack();
	});

	// Delete only a selected table
	$('.wrcpt_remove').on('click', function() {
		$.wrcptdeletetable();
	});

	// Switch into a selected teplates
	$('.wrcpt_template').on('change', function() {
		$.wrcpttemplate();
	});

	// Duplicate a selected table
	$('.duplicate_table').on('click', function() {
		$.wrcptcopypackages();
	});

	// Regenerating Shortcode IDs
	$('.reset_shortcode').on('click', function() {
		$.wrcptresetshortcode();
	});

	// Create a new table from selected template
	$('.activate_temp').on('click', function() {
		$.wrcptactivatetemp();
	});
	
	// Show span tag on mouse over
	$(".table_name").mouseover(function(){
		var linkid = $(this).attr("id");
		$("td#" + linkid + " span").css("display","inline-block");
	});
	
	// Hide span tag on mouse out
	$(".table_name").mouseout(function(){
		var linkid = $(this).attr("id");
		$("td#" + linkid + " span").css("display","none");
	});

	// check default font is checked or not
	if($("#default_font").is(':checked')) {
		$("#user_choice_font").css("display","none");
	} else {
		$("#user_choice_font").css("display","inline-block");
	}

	// show or hide custom font on default font selection
	$("#default_font").click(function() {
		var dfont = $(this).is(':checked');
		if(dfont) {
			$("#user_choice_font").slideUp("slow");
		} else {
			$("#user_choice_font").slideDown("slow");
		}
	});

	$('#wrcpt-tabs').tabs();	// Tabs
	$('#wrcpt-tabs').css('visibility','visible');
	
	$(function(){
        if( $('#wrcpt-fancy-textarea').length ) {
            var editorSettings = wp.codeEditor.defaultSettings ? _.clone( wp.codeEditor.defaultSettings ) : {};
            editorSettings.codemirror = _.extend(
                {},
                editorSettings.codemirror,
                {
					autoRefresh:true,
                    mode: 'css',
                }
            );
            var editor = wp.codeEditor.initialize( $('#wrcpt-fancy-textarea'), editorSettings );
			setTimeout(function() {
				editor.codeMirrorInstance.refresh();
			},1);
        }
    });

	const alertMessage = $('#alert-message');
	const optimMessage = $('#optimize-message');
	$('body').on('click', '.wrcpt_close', function() {
		alertMessage.fadeOut('slow');
		optimMessage.fadeOut('slow');
	});

	// check WP Post Editor is checked or not
	if($("#wp_post_editor").is(':checked')) {
		$("#htmleditor").css("display","block");
	} else {
		$("#htmleditor").css("display","none");
	}

	// show or hide Mirror Editor on WP Post Editor selection
	$("#wp_post_editor").click(function() {
		var wpeditor = $(this).is(':checked');
		if(wpeditor) {
			$("#htmleditor").slideDown("slow");
		} else {
			$("#htmleditor").slideUp("slow");
		}
	});

	// Initialize MixItUp
	var containerEl = document.querySelector('.template-container');
	var mixer = mixitup(containerEl, {
	selectors: {
		target: '.template-items'
	},
	animation: {
		effects: 'fade rotateZ(-180deg)',
		duration: 500
	}
	});

	$('.filter-btn').on('click', function() {
		var filter = $(this).attr('data-filter');
		mixer.filter(filter);
		$('.filter-btn').removeClass('active');
		$(this).addClass('active');
	});
});

/* copy shorcode on click */
function myFunction(id) {
	"use strict";
	var copyText = document.getElementById("myInput-" + id);
	
	if (copyText !== null) {
	  copyText.select();
	  document.execCommand("copy");
  
	  var tooltip = document.getElementById("myTooltip-" + id);
	  
	  if (tooltip !== null) {
		tooltip.innerHTML = "Copied!";
	  }
	}
}

function outFunc() {
	"use strict";
	var id;
	var tooltip = document.getElementById("myTooltip-" + id);
	if (tooltip !== null) {
		tooltip.innerHTML = "Click to Copy Shortcode!";
	}
}

( function($) {
	"use strict";
	// Set a flag to keep track of whether or not the form has been submitted.
	/* var formSubmitted = false; */
	// Update all pricing tables from multiple checkbox
	$.wrcptUpdateTableList = function() {
		var allVals = [];
		$(".wrcpt_checkbox:checked").each(function() {
			allVals.push($(this).attr('data-id'));
		});

		if(allVals.length <= 0) {
			alert("Please select row.");
		} else {
			var check = confirm("Are you sure you want to update this row?");
			if(check === true) {
				$.ajax({
					type: 'POST',
					url: wrcptajax.ajaxurl,
					data: {
						action: 'wrcpt_update_multiple_pricing_table',	// delete multiple tables
						packtable: allVals
					},
					beforeSend: function(){
						// Show image container
						$("#wrcpt-loading-image").css("display","inline-block");
					},
					success:function(data, textStatus, XMLHttpRequest){
						//event.preventDefault();
						$.each(allVals, function( index, value ) {
							var linkid = '#wrcpt_' + value;
							$(linkid).remove();
							$(linkid).append(data);
							window.location.reload();
						});
						//alert("All the tables deleted successfully!");
					},
					complete:function(){
						// Hide image container
						$("#wrcpt-loading-image").hide();
					},
					error: function(MLHttpRequest, textStatus, errorThrown){
						alert(errorThrown);
					}
				});
			}
		}
	};
	// Delete list of pricing tables from multiple checkbox
	$.wrcptDelTableList = function() {
		// Below function is use to delete all records using Ajax request(Server-Side) or jQuery(Client-Side)
		//$('#wrcptaction').on('click', function(e) {
		var allVals = [];
		$(".wrcpt_checkbox:checked").each(function() {
			allVals.push($(this).attr('data-id'));
		});
		//alert(allVals.length); return false;
		if(allVals.length <= 0) {
			alert("Please select row.");
		} else {
			var check = confirm("Are you sure you want to delete this row?");
			if(check === true) {
				$.ajax({
					type: 'POST',
					url: wrcptajax.ajaxurl,
					data: {
						action: 'wrcpt_delete_multiple_pricing_table',	// delete multiple tables
						packtable: allVals
					},
					beforeSend: function(){
						// Show image container
						$("#wrcpt-loading-image").css("display","inline-block");
					},
					success:function(data, textStatus, XMLHttpRequest){
						//event.preventDefault();
						$.each(allVals, function( index, value ) {
							var linkid = '#wrcpt_' + value;
							$(linkid).remove();
							$(linkid).append(data);
							window.location.reload();
						});
						//alert("All the tables deleted successfully!");
					},
					complete:function(){
						// Hide image container
						$("#wrcpt-loading-image").hide();
					},
					error: function(MLHttpRequest, textStatus, errorThrown){
						alert(errorThrown);
					}
				});
			}
		}
	};
	// Edit existed pricing table
	$.wrcpteditpackages = function () {
		var ptable;
		var pcount;
		$('body').on('click', '.edit_pack', function() {
			ptable = $(this).attr('data-id');
			pcount = $(this).attr('data-count');
			$.ajax({
				type: 'POST',
				url: wrcptajax.ajaxurl,
				data: {
					action: 'wrcpt_edit_pricing_packages',			// The function that will edit a table
					packtable: ptable
				},
				beforeSend: function(){
					// Show image container
					$("#wrcpt-loading-image").css("display","inline-block");
				},
				success:function(data, textStatus, XMLHttpRequest){
					var linkid = '#wrcpt_list';
					$(linkid).html('');
					$("#new_template").hide();
					$('#wrcpt-sidebar').hide();
					$('#wrcpt-narration').hide();
					$(".table_list .subsubsub").hide();
					$('.reset_shortcode').hide();
					$(".check-all-hidden").hide();
					$(linkid).append(data);
					$(".collapse").hide();
					$.wrcptSelectOption();
		
					// Collapse all package details
					$(".collapse").click(function() {
						$(".column_container").accordion({
							collapsible: true,
							active:false
						});
						$(".package_advance").accordion({
							collapsible: true,
							active:false
						});
						$(".collapse").hide();
						$(".expand").show();
					});

					// Expand all package details
					$(".expand").click(function() {
						$(".column_container").accordion({
							collapsible: false,
							active:true
						});
						$(".package_advance").accordion({
							collapsible: false,
							active:true
						});
						$(".expand").hide();
						$(".collapse").show();
					});
		
					// Enable/Disable second button
					$("#pbtn_two").click(function() {
						if($("#pbtn_two").is(":checked")){
							$(".element-input .pricing_button_two").slideDown("slow");
						} else {
							$(".element-input .pricing_button_two").slideUp("slow");
						}
					});
					if($("#pbtn_two").is(":checked")){
						$(".element-input .pricing_button_two").css("display","block");
					}
		
					// Enable/Disable 3rd toggle features
					$("#third_toggle").click(function() {
						if($("#third_toggle").is(":checked")){
							$(".element-input #third_toggle_features").slideDown("slow");
						} else {
							$(".element-input #third_toggle_features").slideUp("slow");
						}
					});
					if($("#third_toggle").is(":checked")){
						$(".element-input #third_toggle_features").css("display","block");
					}
		
					// Enable/Disable 4th toggle features
					$("#forth_toggle").click(function() {
						if($("#forth_toggle").is(":checked")){
							$(".element-input #forth_toggle_features").slideDown("slow");
						} else {
							$(".element-input #forth_toggle_features").slideUp("slow");
						}
					});
					if($("#forth_toggle").is(":checked")){
						$(".element-input #forth_toggle_features").css("display","block");
					}
		
					// Enable/Disable auto column width
					$("#auto_column").click(function() {
						if($("#auto_column").is(":checked")){
							$("label#margin_right").slideDown("slow");
							$("input#column_space").slideDown("slow");
							if($("#feature_caption").is(":checked")) {
								$("label#cap_col_width").slideDown("slow");
								$("input#cap_column_width").slideDown("slow");
							}
						} else {
							$("label#margin_right").slideUp("slow");
							$("input#column_space").slideUp("slow");
							$("label#cap_col_width").slideUp("slow");
							$("input#cap_column_width").slideUp("slow");
						}
					});
					if($("#auto_column").is(":checked")){
						$("label#margin_right").css("display","block");
						$("input#column_space").css("display","block");
					}
		
					// Enable/Disable caption column
					$("#feature_caption").click(function() {
						if($("#feature_caption").is(":checked") && $("#auto_column").is(":checked")){
							$("label#cap_col_width").slideDown("slow");
							$("input#cap_column_width").slideDown("slow");
						} else {
							$("label#cap_col_width").slideUp("slow");
							$("input#cap_column_width").slideUp("slow");
						}
					});
					if($("#feature_caption").is(":checked") && $("#auto_column").is(":checked")){
						$("label#cap_col_width").css("display","block");
						$("input#cap_column_width").css("display","block");
					}
		
					// Enable/Disable table background
					$("#table_color").click(function() {
						if($("#table_color").is(":checked")){
							$("#tb_bground").slideDown("slow");
						} else {
							$("#tb_bground").slideUp("slow");
						}
					});
					if($("#table_color").is(":checked")){
						$("#tb_bground").css("display","block");
					} else {
						$("#tb_bground").slideUp("slow");
					}
		
					// Enable/Disable price toggle
					$("#toggle_price").click(function() {
						if($("#toggle_price").is(":checked")){
							$("#pricing_toggle").slideDown("slow");
						} else {
							$("#pricing_toggle").slideUp("slow");
						}
					});
					if($("#toggle_price").is(":checked")){
						$("#pricing_toggle").css("display","block");
					} else {
						$("#pricing_toggle").slideUp("slow");
					}

					// Enable/Disable 3rd price toggle
					$("#third_toggle").click(function() {
						if($("#third_toggle").is(":checked")){
							$("#pricing_toggle_3").slideDown("slow");
						} else {
							$("#pricing_toggle_3").slideUp("slow");
						}
					});
					if($("#third_toggle").is(":checked")){
						$("#pricing_toggle_3").css("display","block");
					} else {
						$("#pricing_toggle_3").slideUp("slow");
					}

					// Enable/Disable 4th price toggle
					$("#forth_toggle").click(function() {
						if($("#forth_toggle").is(":checked")){
							$("#pricing_toggle_4").slideDown("slow");
						} else {
							$("#pricing_toggle_4").slideUp("slow");
						}
					});
					if($("#forth_toggle").is(":checked")){
						$("#pricing_toggle_4").css("display","block");
					} else {
						$("#pricing_toggle_4").slideUp("slow");
					}
		
					// Enable/Disable package ribbon
					$("#enable_ribbon").click(function() {
						if($("#enable_ribbon").is(":checked")){
							$("label#ribbon-choice").slideDown("slow");
							$("div.ribbon-all").css("display","block");
							$("label.ribbon_label").slideDown("slow");
						} else {
							$("label#ribbon-choice").slideUp("slow");
							$("div.ribbon-all").slideUp("slow");
							$("label.ribbon_label").slideUp("slow");
						}
					});
					if($("#enable_ribbon").is(":checked")){
						$("label#ribbon-choice").css("display","block");
						$("div.ribbon-all").css("display","block");
						$("label.ribbon_label").slideDown("slow");
					}
		
					// Enable/Disable package image
					$("#enable_image").click(function() {
						if($("#enable_image").is(":checked")){
							$("#bground_image").click(function() {
								if($("#bground_image").is(":checked")){
									$("label#image-option").slideUp("slow");
									$("div.img-options").slideUp("slow");
									$("label.image_label").slideUp("slow");
									$("label#img-width").slideUp("slow");
									$("label#img-height").slideUp("slow");
									$("label#img-margin").slideUp("slow");
									$("label#img-opacity").slideUp("slow");
									$("#image_width").slideUp("slow");
									$("#image_height").slideUp("slow");
									$("#image_margin").slideUp("slow");
									$("#image_opacity").slideUp("slow");
									$("label#img-overlay").slideDown("slow");
								} else {
									$("label#img-overlay").slideUp("slow");
									$("label#image-option").slideDown("slow");
									$("div.img-options").slideDown("slow");
									$("label.image_label").slideDown("slow");
									$("label#img-width").slideDown("slow");
									$("label#img-height").slideDown("slow");
									$("label#img-margin").slideDown("slow");
									$("label#img-opacity").slideDown("slow");
									$("#image_width").slideDown("slow");
									$("#image_height").slideDown("slow");
									$("#image_margin").slideDown("slow");
									$("#image_opacity").slideDown("slow");
								}
							});
							if($("#bground_image").is(":checked")){
								$("label#image-option").slideUp("slow");
								$("div.img-options").slideUp("slow");
								$("label.image_label").slideUp("slow");
								$("label#img-width").slideUp("slow");
								$("label#img-height").slideUp("slow");
								$("label#img-margin").slideUp("slow");
								$("label#img-opacity").slideUp("slow");
								$("#image_width").slideUp("slow");
								$("#image_height").slideUp("slow");
								$("#image_margin").slideUp("slow");
								$("#image_opacity").slideUp("slow");
								$("#img-overlay").slideDown("slow");
							} else {
								$("#img-overlay").slideUp("slow");
								$("label#image-option").slideDown("slow");
								$("div.img-options").slideDown("slow");
								$("label.image_label").slideDown("slow");
								$("label#img-width").slideDown("slow");
								$("label#img-height").slideDown("slow");
								$("label#img-margin").slideDown("slow");
								$("label#img-opacity").slideDown("slow");
								$("#image_width").slideDown("slow");
								$("#image_height").slideDown("slow");
								$("#image_margin").slideDown("slow");
								$("#image_opacity").slideDown("slow");
							}
							$("label#img-bground").slideDown("slow");
							$("#bground_image").slideDown("slow");
						} else {
							$("label#img-overlay").slideUp("slow");
							$("label#img-bground").slideUp("slow");
							$("label#image-option").slideUp("slow");
							$("div.img-options").slideUp("slow");
							$("label.image_label").slideUp("slow");
							$("label#img-width").slideUp("slow");
							$("label#img-height").slideUp("slow");
							$("label#img-opacity").slideUp("slow");
							$("label#img-margin").slideUp("slow");
							$("#bground_image").slideUp("slow");
							$("#image_width").slideUp("slow");
							$("#image_height").slideUp("slow");
							$("#image_opacity").slideUp("slow");
							$("#image_margin").slideUp("slow");
						}
					});
					if($("#enable_image").is(":checked")){
						$("#bground_image").click(function() {
							if($("#bground_image").is(":checked")){
								$("label#image-option").slideUp("slow");
								$("div.img-options").slideUp("slow");
								$("label.image_label").slideUp("slow");
								$("label#img-width").slideUp("slow");
								$("label#img-height").slideUp("slow");
								$("label#img-margin").slideUp("slow");
								$("label#img-opacity").slideUp("slow");
								$("#image_width").slideUp("slow");
								$("#image_height").slideUp("slow");
								$("#image_margin").slideUp("slow");
								$("#image_opacity").slideUp("slow");
								$("label#img-overlay").slideDown("slow");
							} else {
								$("label#img-overlay").slideUp("slow");
								$("label#image-option").css("display","block");
								$("div.img-options").css("display","block");
								$("label.image_label").slideDown("slow");
								$("label#img-width").slideDown("slow");
								$("label#img-height").slideDown("slow");
								$("label#img-margin").slideDown("slow");
								$("label#img-opacity").slideDown("slow");
								$("#image_width").slideDown("slow");
								$("#image_height").slideDown("slow");
								$("#image_margin").slideDown("slow");
								$("#image_opacity").slideDown("slow");
							}
						});
						if($("#bground_image").is(":checked")){
							$("label#image-option").slideUp("slow");
							$("div.img-options").slideUp("slow");
							$("label.image_label").slideUp("slow");
							$("label#img-width").slideUp("slow");
							$("label#img-height").slideUp("slow");
							$("label#img-margin").slideUp("slow");
							$("label#img-opacity").slideUp("slow");
							$("#image_width").slideUp("slow");
							$("#image_height").slideUp("slow");
							$("#image_margin").slideUp("slow");
							$("#image_opacity").slideUp("slow");
							$("label#img-overlay").slideDown("slow");
						} else {
							$("label#img-overlay").slideUp("slow");
							$("label#image-option").slideDown("slow");
							$("div.img-options").slideDown("slow");
							$("label.image_label").slideDown("slow");
							$("label#img-width").slideDown("slow");
							$("label#img-height").slideDown("slow");
							$("label#img-margin").slideDown("slow");
							$("label#img-opacity").slideDown("slow");
							$("#image_width").slideDown("slow");
							$("#image_height").slideDown("slow");
							$("#image_margin").slideDown("slow");
							$("#image_opacity").slideDown("slow");
						}
						$("label#img-bground").slideDown("slow");
						$("#bground_image").slideDown("slow");
					} else {
						$("label#img-overlay").slideUp("slow");
						$("label#img-bground").slideUp("slow");
						$("label#img-width").slideUp("slow");
						$("label#img-height").slideUp("slow");
						$("label#img-height").slideUp("slow");
						$("label#img-opacity").slideUp("slow");
						$("label#img-margin").slideUp("slow");
						$("#bground_image").slideUp("slow");
						$("#image_width").slideUp("slow");
						$("#image_height").slideUp("slow");
						$("#image_opacity").slideUp("slow");
						$("#image_margin").slideUp("slow");
					}
		
					// Enable/Disable package video
					$("#enable_video").click(function() {
						if($("#enable_video").is(":checked")){
							$("label#video-option").slideDown("slow");
							$("div.vid-options").slideDown("slow");
							$("label.video_label").slideDown("slow");
							$("label#vid-height").slideDown("slow");
							$("#video_body").slideDown("slow");
							$("label#full_screen").slideDown("slow");
							$("#video_screen").slideDown("slow");
							$("label#show_brand").slideDown("slow");
							$("#modest_brand").slideDown("slow");
						} else {
							//$("#enable_image").attr('class', 'tickbox');
							$("label#video-option").slideUp("slow");
							$("div.vid-options").slideUp("slow");
							$("label.video_label").slideUp("slow");
							$("label#vid-height").slideUp("slow");
							$("#video_body").slideUp("slow");
							$("label#full_screen").slideUp("slow");
							$("#video_screen").slideUp("slow");
							$("label#show_brand").slideUp("slow");
							$("#modest_brand").slideUp("slow");
						}
					});
					if($("#enable_video").is(":checked")){
						$("label#video-option").css("display","block");
						$("div.vid-options").css("display","block");
						$("label.video_label").slideDown("slow");
						$("label#vid-height").slideDown("slow");
						$("#video_body").slideDown("slow");
						$("label#full_screen").slideDown("slow");
						$("#video_screen").slideDown("slow");
						$("label#show_brand").slideDown("slow");
						$("#modest_brand").slideDown("slow");
					} else {
						//$("#enable_image").attr('class', 'tickbox');
						$("label#vid-height").slideUp("slow");
						$("#video_body").slideUp("slow");
						$("label#full_screen").slideUp("slow");
						$("#video_screen").slideUp("slow");
						$("label#show_brand").slideUp("slow");
						$("#modest_brand").slideUp("slow");
					}
		
					// Switch between font awesome icon and plugin default icons for tick/cross
					$("#enable_tickcross").click(function() {
						if($("#enable_tickcross").is(":checked")){
							$("#tickcross-items").slideUp("slow");
							$("#awesome-icon").slideDown("slow");
						} else {
							$("#tickcross-items").slideDown("slow");
							$("#awesome-icon").slideUp("slow");
						}
					});
					if($("#enable_tickcross").is(":checked")){
						$("#tickcross-items").slideUp("slow");
						$("#awesome-icon").css("display","block");
					} else {
						$("#tickcross-items").css("display","block");
						$("#awesome-icon").slideUp("slow");
					}
		
					if(pcount === 1) {
						$('#wrcpt-1 #delPackage').attr('id', 'delDisable');
						$('#wrcpt-1 #hidePack').attr('class', 'inactive');
					}
					$(".table_list").css("width","100%");
					$("#add_new_table h2").text("Edit Pricing Table");
					$(".postbox-container").css("width","100%");
		
					// Make the column sortable
					$(function() {
						$('#sortable_column').sortable({
							cancel: ".column_container"
						});

						// Bind touchstart event to input elements
						$('#sortable_column input, #sortable_column textarea').on('touchstart', function(e) {
							e.preventDefault();
							$(this).focus();
							var val = $(this).val();
							$(this).val('').val(val); // Move cursor to end of input field
						});
					});
					$(".package_details").css("cursor","move");
		
					// Enable accordion for pricing table settings
					$('#accordion_advance').accordion({
						collapsible: true,
						active:false,
						heightStyle: "content"
					});
		
					for(var i = 1; i <= pcount; i++) {
						// Enable Accordion for Package Details
						$('#accordion' + i).accordion({
							collapsible: true,
							active:false,
							heightStyle: "content"
						});
						if($('#showPack' + i + ' input').val() === 'hide') {
							$('#accordion' + i).addClass('column_inactive');
						}
						// Show toggle for Package Details
						if($('#showToggle' + i + ' input').val() === 'show') {
							$('#showToggle' + i).parents('.package_details').find('#enable_toggle').show();
						}
						// Show paypal for Package Details
						if($('#showPayPal' + i + ' input').val() === 'show') {
							$('#showPayPal' + i).parents('.package_details').find('#paypal_code').show();
							$('#showPayPal' + i).parents('.package_details').find('#normal_button').hide();
						}
						// Show host id for PayPal
						if($('#showHosted' + i + ' input').val() === 'show') {
							$('#showHosted' + i).parents('.package_details').find('#unencrypted-button').hide();
							$('#showHosted' + i).parents('.package_details').find('#hosted-button').show();
						}
					}
		
					// Activating ColorPicker
					$('.title_color').wpColorPicker();
					$('.title_hover').wpColorPicker();
					$('.title_descp').wpColorPicker();
					$('.table_bg').wpColorPicker();
					$('.title_bg').wpColorPicker();
					$('.price_color_big').wpColorPicker();
					$('.price_hover_big').wpColorPicker();
					$('.price_color_small').wpColorPicker();
					$('.price_hover_small').wpColorPicker();
					$('.cut_price_color').wpColorPicker();
					$('.price_bg').wpColorPicker();
					$('.price_cr').wpColorPicker();
					$('.image_bg').wpColorPicker();
					$('.feature_name_color').wpColorPicker();
					$('.feature_text_color').wpColorPicker();
					$('.feat_row1_color').wpColorPicker();
					$('.feat_row2_color').wpColorPicker();
					$('.button_text_color').wpColorPicker();
					$('.button_text_hover').wpColorPicker();
					$('.button_color').wpColorPicker();
					$('.button_hover').wpColorPicker();
					$('.button_bg').wpColorPicker();
					$('.ribbon_text_color').wpColorPicker();
					$('.ribbon_text_hover').wpColorPicker();
					$('.ribbon_bg').wpColorPicker();
					$('.feat_border').wpColorPicker();
					$('.ttip_font_color').wpColorPicker();
					$('.ptn_font_color').wpColorPicker();
					$('.pta_font_color').wpColorPicker();
					$('.ptsp_font_color').wpColorPicker();
					$('.fawe_tick_color').wpColorPicker();
					$('.fawe_cross_color').wpColorPicker();
					$('.ttip_bg_color').wpColorPicker();
					$('.ptog_bg_active').wpColorPicker();
					$('.ptog_bg_normal').wpColorPicker();
					$('.cap_font_color').wpColorPicker();
					$('.cap_feat_color').wpColorPicker();
					$('.feat_url_color').wpColorPicker();
					$('.feat_url_hover').wpColorPicker();
					$('.cap_col_bg').wpColorPicker();
					$('.pricing_name_bg').wpColorPicker();
					$('.ft_cate_color').wpColorPicker();
					$('.ft_font_color').wpColorPicker();
					$('.cap_row1_color').wpColorPicker();
					$('.cap_row2_color').wpColorPicker();
					$('.cap_border_color').wpColorPicker();
					$('.col_shad_color').wpColorPicker();
					$('.col_shad_hover_color').wpColorPicker();
		
					// Add New Column
					$('#addPackage').click(function () {
						var num = $('.package_details').length,
						newNum  = Number(num + 1),
						newElem = $('#wrcpt-' + num).clone().attr('id', 'wrcpt-' + newNum).fadeIn('slow');
						newElem.find('#pcolumn' + num).attr('id', 'pcolumn' + newNum);
						newElem.find('#showPack' + num).attr('id', 'showPack' + newNum);
						newElem.find('#hidePack' + num).attr('id', 'hidePack' + newNum);
						newElem.find('#showToggle' + num).attr('id', 'showToggle' + newNum);
						newElem.find('#showPayPal' + num).attr('id', 'showPayPal' + newNum);
						newElem.find('#showHosted' + num).attr('id', 'showHosted' + newNum);
						newElem.find('#accordion' + num).attr('id', 'accordion' + newNum);
						$('#wrcpt-' + num).after(newElem);
						$('.ptitle').focus();
		
						// Activate Accordion for Added Column
						$('#accordion' + newNum).accordion({
							collapsible: true,
							active:false,
							heightStyle: "content"
						});
						$('#pcolumn' + newNum).text('Pricing Column ' + newNum);
						$('#accordion' + newNum + ' .wp-color-result').remove();
		
						// Add Color Option for New Column
						$('.title_color').wpColorPicker();
						$('.title_hover').wpColorPicker();
						$('.title_descp').wpColorPicker();
						$('.table_bg').wpColorPicker();
						$('.title_bg').wpColorPicker();
						$('.price_color_big').wpColorPicker();
						$('.price_hover_big').wpColorPicker();
						$('.price_color_small').wpColorPicker();
						$('.price_hover_small').wpColorPicker();
						$('.cut_price_color').wpColorPicker();
						$('.price_bg').wpColorPicker();
						$('.price_cr').wpColorPicker();
						$('.image_bg').wpColorPicker();
						$('.feature_name_color').wpColorPicker();
						$('.feature_text_color').wpColorPicker();
						$('.feat_row1_color').wpColorPicker();
						$('.feat_row2_color').wpColorPicker();
						$('.button_text_color').wpColorPicker();
						$('.button_text_hover').wpColorPicker();
						$('.button_color').wpColorPicker();
						$('.button_hover').wpColorPicker();
						$('.button_bg').wpColorPicker();
						$('.ribbon_text_color').wpColorPicker();
						$('.ribbon_text_hover').wpColorPicker();
						$('.ribbon_bg').wpColorPicker();
						$('.feat_border').wpColorPicker();
						$('#wrcpt-1 #delDisable').attr('id', 'delPackage');
						$('#wrcpt-' + newNum + ' #delDisable').attr('id', 'delPackage');
						$('.inactive').attr('class', 'column_hide');

						var removeSuccess;
						removeSuccess = function() {
							return $('.newcolumn').removeClass('column-success');
						};						
						$(this).addClass('column-success');
						return setTimeout(removeSuccess, 3000);
					});
		
					$.wrcptMediaUploader();
		
					// Remove image
					$('body').on('click', '#remove_image', function() {
						var targetfield = $(this).parents('.element-input').find('#image_path');
						$(targetfield).val('');
						$(this).parents('#show_upload_preview').slideUp('slow');
					});
		
					// Delete a Column
					$('body').on('click', '#delPackage', function() {
						var num = $('.package_details').length;
						var answer = confirm ("Are you sure you wish to remove this package? This cannot be undone!");
						if (answer) {
							$(this).parents('.package_details').slideUp('slow', function () {
								$(this).remove();
								if (num -1 === 1) {
									$('#delPackage').attr('id', 'delDisable');
									$('.column_hide').attr('class', 'column_hide inactive');
									$(".package_details").css("cursor","auto");
									$("#sortable_column").sortable({ disabled: true });
								}
								$('#addPackage').attr('disabled', false).prop('value', "New Column");
								var j = 1;
								for(i=1; i<=num; i++) {
									if($('#wrcpt-' + i).length !== 0) {
										$('#wrcpt-' + i).attr('id', 'wrcpt-' + j);
										$("#pcolumn"+ i).text("Pricing Column " + j);
										$("#pcolumn"+ i).attr("id", "pcolumn"+ j);
										$("#hidePack"+ i).attr("id", "hidePack"+ j);
										$("#showPack"+ i).attr("id", "showPack"+ j);
										$("#showPayPal"+ i).attr("id", "showPayPal"+ j);
										$("#showHosted"+ i).attr("id", "showHosted"+ j);
										$("#showToggle"+ i).attr("id", "showToggle"+ j);
										$('#accordion' + i).attr('id', 'accordion' + j);
										j++;
									}
								}
							});
						}
					});
		
					// Hide a Column
					$('body').on('click', '.column_hide', function() {
						var num = $('.package_details').length;
						var $container = $(this).parents('.package_details').find('.column_container');
						if(num > 1) {
							$container.accordion('option', 'active', false);
							$container.accordion({disabled: true});
							$container.addClass('column_inactive');
							$(this).prop('class', 'column_show');
							$(this).children('.dashicons-fullscreen-alt').prop('class', 'dashicons dashicons-fullscreen-exit-alt');
							$(this).children('input').prop('value', 'hide');
						}
					});
		
					// Show a Column
					$('body').on('click', '.column_show', function() {
						var $container = $(this).parents('.package_details').find('.column_container');						
						$container.accordion({disabled: false});
						$container.removeClass('column_inactive');
						$(this).prop('class', 'column_hide');
						$(this).children('.dashicons-fullscreen-exit-alt').prop('class', 'dashicons dashicons-fullscreen-alt');
						$(this).children('input').prop('value', 'show');
					});
		
					// Change Toggle Icon to Hide Column
					$('body').on('click', '.toggle_hide', function() {
						$(this).parents('.package_details').find('#enable_toggle').fadeOut("slow");
						$(this).prop('class', 'toggle_show');
						$(this).children('.dashicons-yes').prop('class', 'dashicons dashicons-empty');
						$(this).children('input#toggle_display').prop('value', 'hide');
					});
		
					// Change Toggle Icon to Show Column
					$('body').on('click', '.toggle_show', function() {
						$(this).parents('.package_details').find('#enable_toggle').fadeIn("slow");
						$(this).prop('class', 'toggle_hide');
						$(this).children('.dashicons-empty').prop('class', 'dashicons dashicons-yes');
						$(this).children('input#toggle_display').prop('value', 'show');
					});
		
					// Enable/Disable Paypal
					$('body').on('click', '.paypal_hide', function() {
						$(this).parents('.package_details').find('#paypal_code').fadeOut("slow");
						$(this).parents('.package_details').find('#normal_button').fadeIn("slow");
						$(this).prop('class', 'paypal_show');
						$(this).children('.dashicons-yes').prop('class', 'dashicons dashicons-empty');
						$(this).children('input#paypal_button').prop('value', 'hide');
					});
					$('body').on('click', '.paypal_show', function() {
						$(this).parents('.package_details').find('#normal_button').fadeOut("slow");
						$(this).parents('.package_details').find('#paypal_code').fadeIn("slow");
						$(this).prop('class', 'paypal_hide');
						$(this).children('.dashicons-empty').prop('class', 'dashicons dashicons-yes');
						$(this).children('input#paypal_button').prop('value', 'show');
					});
		
					// Enable/Disable Paypal Hosted Button
					$('body').on('click', '.hosted_hide', function() {
						$(this).parents('.package_details').find('#hosted-button').fadeOut("slow");
						$(this).parents('.package_details').find('#unencrypted-button').fadeIn("slow");
						$(this).prop('class', 'hosted_show');
						$(this).children('.dashicons-yes').prop('class', 'dashicons dashicons-empty');
						$(this).children('input#hosted_button').prop('value', 'hide');
					});
					$('body').on('click', '.hosted_show', function() {
						$(this).parents('.package_details').find('#unencrypted-button').fadeOut("slow");
						$(this).parents('.package_details').find('#hosted-button').fadeIn("slow");
						$(this).prop('class', 'hosted_hide');
						$(this).children('.dashicons-empty').prop('class', 'dashicons dashicons-yes');
						$(this).children('input#hosted_button').prop('value', 'show');
					});

					// Edit pricing column, column info and column settings
					$('#wrcpt_edit').on('click', function() {
						$.wrcptsettableoptions();
					});
				},
				complete:function(){
					// Hide image container
					$("#wrcpt-loading-image").hide();
				},
				error: function(MLHttpRequest, textStatus, errorThrown){
					alert(errorThrown);
				}
			});
		});
		// Customizing to add 18 color palettes
		if (typeof $.wp !== 'undefined' && typeof $.wp.wpColorPicker !== 'undefined') {
			$.wp.wpColorPicker.prototype.options = {
				width: 255,
				hide: true,
				border: false,
				palettes: ['#ededed', '#ecf0f1',  '#c8d6e5', '#7f8c8d', '#34495e', '#22313f', '#2ecc71', '#48b56a', '#0abde3', '#1f8dd6', '#2574a9', '#1f3a93', '#5f27cd', '#fad232','#ff9f43', '#ed6789', '#ff6b6b', '#ee5253'],    
			};
		}
	};
	// save table options
	$.wrcptsettableoptions = function () {
		// let submitted = false;
		var submitted = $('#submitted').val();
		// Get the form.
		const form = $('#wrcpt_edit_form');
		const formMessages = $('#form-messages');
		// Bind the click event of the submit button
		form.on('submit', function(event) {
			// Prevent the form from submitting normally
			event.preventDefault();
			// Get the form data
			const formData = $(this).serialize();
			// Submit the form via AJAX
			$.ajax({
				type: 'POST',
				url: $(this).attr('action'),
				data: formData,
				success: function(response) {
					// Make sure that the formMessages div has the 'success' class.
					formMessages.addClass('success').css('display', 'block');
					// Clear the form and retrieve it again.
					form.hide().fadeIn(1000);
					$('html, body').animate({ scrollTop: 0 }, 0);

					$('body').on('click', '.wrcpt_close', function() {
						formMessages.fadeOut('slow');
					});

					if (submitted === 'no') {
						window.location.reload();
					}
				},
				error: function(jqXHR, textStatus, errorThrown) {
					console.error('An error occurred:', textStatus, '-', errorThrown);
					// Display an error message
					alert('An error occurred, please try again later.');
				}
			});
		});
	};
	// Edit Package Features
	$.wrcpteditfeature = function() {
		var ptable;
		$('body').on('click', '.wrcpt_feature', function() {
			ptable = $(this).attr('data-id');
			$.ajax({
				type: 'POST',
				url: wrcptajax.ajaxurl,
				data: {
					action: 'wrcpt_process_package_features',			// The function that will edit features
					packtable: ptable
				},
				beforeSend: function(){
					// Show image container
					$("#wrcpt-loading-image").css("display","inline-block");
				},
				success:function(data, textStatus, XMLHttpRequest){
					var linkid = '#wrcpt_list';
					$(linkid).html('');
					$("#new_template").hide();
					$('#wrcpt-sidebar').hide();
					$('#wrcpt-narration').hide();
					$(".table_list .subsubsub").hide();
					$(".check-all-hidden").hide();
					$('.reset_shortcode').hide();
					$(linkid).append(data);
					$("#add_new_table h2").text("Edit Pricing Column Features");
					$.wrcptSelectOption();
		
					// Add extra feature when click on Add Feature button
					var featureName = $('#feature_edititem');
					$('body').on('click', '#editfeature', function() {
						$('<tr class="featurebody"><td><input type="text" name="feature_name[]" placeholder="Enter Feature Name" size="20" required /></td><td><input type="text" name="feature_cate[]" value="" placeholder="Enter Category Name" size="15" /></td><td><input type="text" name="feature_link[]" value="" placeholder="Enter Feature URL" size="20" /></td><td><input type="text" name="feature_desc[]" value="" placeholder="Enter Short Description" size="20" /></td><td><select name="feature_type[]" id="feature_type"><option value="text" selected="selected">Text</option><option value="html">HTML</option><option value="check">Checkbox</option><option value="textcheck">Text &amp; Checkbox</option><option value="starcheck">Star and Checkbox</option></select></td><td><input type="text" name="awesome_icon[]" value="" placeholder="Enter Icon Class" size="15" /></td> <td><span id="remFeatute"></span></td></tr>').appendTo(featureName);
						return false;
					});
		
					// Remove feature
					$('body').on('click', '#remFeatute', function() {
						$(this).parents('tr.featurebody').remove();
						return false;
					});

					$(function() {					  
						$('#feature_edititem tbody').sortable({
							helper: function(e, ui) {
								ui.children().each(function() {
									$(this).width($(this).width());
								});
								return ui;
							},
							cancel: 'input, select'
						});
						// Bind touchstart event to input elements
						$('.featurebody input').on('touchstart', function(e) {
							e.preventDefault();
							$(this).focus();
							var val = $(this).val();
							$(this).val('').val(val); // Move cursor to end of input field
						});
					});

					// Add pricing features
					$('#wrcpt_addfeature').on('click', function() {
						$.wrcptsettableoptions();
					});

					// Edit pricing features
					$('#wrcpt_upfeature').on('click', function() {
						$.wrcptsettableoptions();
					});
				},
				complete:function(){
					// Hide image container
					$("#wrcpt-loading-image").hide();
				},
				error: function(MLHttpRequest, textStatus, errorThrown){
					alert(errorThrown);
				}
			});
		});
	};
	// Preview Pricing Table
	$.wrcptviewpack = function () {
		var tabid;
		var ptable;
		$('body').on('click', '.view_pack', function() {
			tabid = $(this).attr('data-id');
			ptable = $(this).attr('data-table');
			$.ajax({
				type: 'POST',
				url: wrcptajax.ajaxurl,
				data: {
					action: 'wrcpt_view_pricing_packages',			// The function that will preview a table
					packtable: ptable,
					tableid: tabid
				},
				beforeSend: function(){
					// Show image container
					$("#wrcpt-loading-image").css("display","inline-block");
				},
				success:function(data, textStatus, XMLHttpRequest){
					var linkid = '#wrcpt_list';
					var replace_name = ptable.replace("_", " ");
					var pricing_table_name = replace_name.replace(/^([a-z\u00E0-\u00FC])|\s+([a-z\u00E0-\u00FC])/g, function(m){ return m.toUpperCase(); });
					$(linkid).html('');
					$("#new_template").hide();
					$('#wrcpt-sidebar').hide();
					$('#wrcpt-narration').hide();
					$(".table_list .subsubsub").hide();
					$(".check-all-hidden").hide();
					$('.reset_shortcode').hide();
					$(linkid).append(data);
					$("#add_new_table h2.main-header").text("Preview of " + pricing_table_name);
					$(".table_list").css("width","100%");
					$(".postbox-container").css("width","100%");

					// Edit pricing column, column info and column settings
					$('.edit_pack').on('click', function() {
						$.wrcpteditpackages();
					});
				},
				complete:function(){
					// Hide image container
					$("#wrcpt-loading-image").hide();
				},
				error: function(MLHttpRequest, textStatus, errorThrown){
					alert(errorThrown);
				}
			});
			//e.preventDefault();
		});
	};
	// Delete only a selected pricing table after confirmation
	$.wrcptdeletetable = function (e) {
		var selector;
		$('body').on('click', '.wrcpt_remove', function() {
			selector = $(this).attr('data-id');
			var answer = confirm ("Are you sure you want to delete?");
			if (answer === true) {
				//alert(selector);
				$.ajax({
					type: 'POST',
					url: wrcptajax.ajaxurl,
					data: {
						action: 'wrcpt_delete_pricing_table',			// The function that will delete the table
						packtable: selector
					},
					beforeSend: function(){
						// Show image container
						$("#wrcpt-loading-image").css("display","inline-block");
					},
					success:function(data, textStatus, XMLHttpRequest){
						var linkid = '#wrcpt_' + selector;
						$(linkid).remove();
						$(linkid).append(data);
						window.location.reload();
					},
					complete:function(){
						// Hide image container
						$("#wrcpt-loading-image").hide();
					},
					error: function(MLHttpRequest, textStatus, errorThrown){
						alert(errorThrown);
					}
				});
				e.preventDefault();
			} else{
				window.location.reload();
			}
		});
	};
	// Create Pricing Table Templates
	$.wrcpttemplate = function () {
		var ptable;
		$('body').on('click', '.wrcpt_template', function() {
			ptable = $(this).attr('data-id');
			var answer = confirm ("Are you sure you want to setup this template?");
			if (answer === true) {
				$.ajax({
					type: 'POST',
					url: wrcptajax.ajaxurl,
					data: {
						action: 'wrcpt_setup_selected_template',		// function that will create a template
						packtable: ptable,
						template: this.value
					},
					beforeSend: function(){
						// Show image container
						$("#wrcpt-loading-image").css("display","inline-block");
					},
					success:function(data, textStatus, XMLHttpRequest){
						alert('The template has been successfully setup!');
						window.location.reload();
					},
					complete:function(){
						// Hide image container
						$("#wrcpt-loading-image").hide();
					},
					error: function(MLHttpRequest, textStatus, errorThrown){
						alert(errorThrown);
					}
				});
			} else{
				window.location.reload();
			}
		});
	};
	// Copy Pricing Table
	$.wrcptcopypackages = function () {
		var ptable;
		var pcount;
		$('body').on('click', '.duplicate_table', function() {
			ptable = $(this).attr('data-id');
			pcount = $(this).attr('data-count');
			var answer = confirm ("Are you sure you want to duplicate this table?");
			if (answer === true) {
				$.ajax({
					type: 'POST',
					url: wrcptajax.ajaxurl,
					data: {
						action: 'wrcpt_copy_pricing_packages',		// The function that will copy a table
						packtable: ptable,
						packcount: pcount
					},
					beforeSend: function(){
						// Show image container
						$("#wrcpt-loading-image").css("display","inline-block");
					},
					success:function(data, textStatus, XMLHttpRequest){
						alert('Successfully Copied!');
						window.location.reload();
					},
					complete:function(){
						// Hide image container
						$("#wrcpt-loading-image").hide();
					},
					error: function(MLHttpRequest, textStatus, errorThrown){
						alert(errorThrown);
					}
				});
			} else{
				window.location.reload();
			}
		});
	};
	// Regenerate Shortcode IDs
	$.wrcptresetshortcode = function () {
		var answer = confirm ("Are you sure you want to Regenerate Shortcode IDs?");
		if (answer === true) {
			jQuery.ajax({
				type: 'POST',
				url: wrcptajax.ajaxurl,
				data: {
					action: 'wrcpt_regenerate_shortcode'
				},
				beforeSend: function(){
					// Show image container
					$("#wrcpt-loading-image").css("display","inline-block");
				},
				success:function(data, textStatus, XMLHttpRequest){
					alert('Successfully Regenerated Shortcode ID!');
					window.location.reload();
				},
				complete:function(){
					// Hide image container
					$("#wrcpt-loading-image").hide();
				},
				error: function(MLHttpRequest, textStatus, errorThrown){
					alert(errorThrown);
				}
			});
		} else{
			window.location.reload();
		}
	};
	// Activate a template for an Existed Pricing Table
	$.wrcptactivatetemp = function () {
		var tcount;
		$('body').on('click', '.activate_temp', function() {
			tcount = $(this).attr('data-count');
			$.ajax({
				type: 'POST',
				url: wrcptajax.ajaxurl,
				data: {
					action: 'wrcpt_activate_template',		// The function that will activate a template
					tempcount: tcount
				},
				beforeSend: function(){
					// Show image container
					$("#wrcpt-loading-image").css("display","inline-block");
				},
				success:function(data, textStatus, XMLHttpRequest){
					alert('Successfully Activated!');
					window.location.reload();
				},
				complete:function(){
					// Hide image container
					$("#wrcpt-loading-image").hide();
				},
				error: function(MLHttpRequest, textStatus, errorThrown){
					alert(errorThrown);
				}
			});
		});
	};
	/**
	 * 
	 * wrcptMediaUploader v1.0 2019-10-04
	 * Copyright (c) 2019 wrcpt
	 * 
	 */
	$.wrcptMediaUploader = function( options ) {
		var settings = $.extend({
			target : '.wrcpt-uploader', // The class wrapping the textbox
			uploaderTitle : 'Select or upload image', // The title of the media upload popup
			uploaderButton : 'Set image', // the text of the button in the media upload popup
			multiple : false, // Allow the user to select multiple images
			buttonText : 'Upload image', // The text of the upload button
			buttonClass : '.wrcpt-upload', // the class of the upload button
			previewSize : '', // The preview image size
			modal : false, // is the upload button within a bootstrap modal ?
			buttonStyle : { // style the button
				color : '#fff',               
			},
		}, options );

		$( settings.target ).append( '<a href="#" class="button-primary ' + settings.buttonClass.replace('.','') + '">' + settings.buttonText + '</a>' );
		$( settings.target ).append('<div id="show_preview" style="display: none;"><label class="input-image">Preview</label><img class="preview_image" src="#" style="display: none;"><span id="remove_image"></span></div>');
		$( settings.buttonClass ).css( settings.buttonStyle );

		$('body').on('click', settings.buttonClass, function(e) {
			e.preventDefault();
			var selector = $(this).parent( settings.target );
			var custom_uploader = wp.media({
				title: settings.uploaderTitle,
				button: {
					text: settings.uploaderButton
				},
				multiple: settings.multiple
			})

			.on('select', function() {
				var attachment = custom_uploader.state().get('selection').first().toJSON();
				selector.find( '#show_preview' ).slideDown("slow");
				selector.parents('.element-input').find('#show_upload_preview').hide();
				selector.find( 'img' ).attr( 'src', attachment.url).show();
				selector.find( 'input' ).val(attachment.url);
				if( settings.modal ) {
					$('.modal').css( 'overflowY', 'auto');
				}
				// Remove image
				$('body').on('click', '#remove_image', function() {
					var targetfield = $(this).parents('.element-input').find('#image_path');
					$(targetfield).val('');
					$(this).parents('#show_preview').slideUp('slow');
				});
			})
			.open();
		}); 
	};
	// Iterate over each select element
	$.wrcptSelectOption = function() {
		$('.select_ft select, select.font-dir').each(function () {

			// Cache the number of options
			var $this = $(this),
				numberOfOptions = $(this).children('option').length;

			// Hides the select element
			$this.addClass('s-hidden');

			// Wrap the select element in a div
			$this.wrap('<div class="select'+(($this.attr("data-class")) ? " "+$this.attr("data-class") : "")+'"></div>');

			// Insert a styled div to sit over the top of the hidden select element
			$this.after('<div class="styledSelect"></div>');

			// Cache the styled div
			var $styledSelect = $this.next('div.styledSelect');

			var $selected = $this.children('option:selected');

			var $contentSelected = (($selected.attr("data-photo")) ? '<img src="'+$selected.attr("data-photo")+'" />' : "") + (($selected.attr("data-icon")) ? '<span class="ir ico '+$selected.attr("data-icon")+'"></span>' : "") + $selected.text();

			// Show the first select option in the styled div
			$styledSelect.html($contentSelected);

			// Insert an unordered list after the styled div and also cache the list
			var $list = $('<ul />', {
				'class': 'options',
			}).insertAfter($styledSelect);

			// Insert a list item into the unordered list for each select option
			for (var i = 0; i < numberOfOptions; i++) {
				var content = (($this.children('option').eq(i).attr("data-photo")) ? '<img src="'+$this.children('option').eq(i).attr("data-photo")+'" />' : "") + (($this.children('option').eq(i).attr("data-icon")) ? '<span class="ir ico '+$this.children('option').eq(i).attr("data-icon")+'"></span>' : "") + $this.children('option').eq(i).text();
				var $option = $this.children('option').eq(i);
	
				$('<li />', {
					html: content,
					rel: $this.children('option').eq(i).val(),
					"class": (($selected.val() == $option.val()) ? 'active' : '') +
								($option.attr('disabled') ? ' disabled' : ''),
					"data-photo": $option.attr("data-photo"),
					"data-icon": $option.attr("data-icon")
				}).appendTo($list);
			}

			// Cache the list items
			var $listItems = $list.children('li');

			if($this.attr("data-error")){
				$this.parent().append('<div class="select__error">'+ $this.attr("data-error") +'</div><div class="select__ico select__ico--error"></div></div><div class="select__ico select__ico--ok"></div>');
			}

			// Show the unordered list when the styled div is clicked (also hides it if the div is clicked again)
			$styledSelect.click(function(e) {
				e.stopPropagation();
				if (!$(this).hasClass("active")) {
					$('div.styledSelect.active').each(function() {
						$(this).removeClass('active').next('ul.options').hide();
					});
				}
				$(this).toggleClass('active').next('ul.options').toggle();
			});

			// Hides the unordered list when a list item is clicked and updates the styled div to show the selected list item
			// Updates the select element to have the value of the equivalent option
			$listItems.click(function(e) {
				e.stopPropagation();
				var $selected = $(this);
				if ($selected.hasClass('disabled')){return;}
				var $contentSelected = (($selected.attr("data-photo")) ? '<img src="'+$selected.attr("data-photo")+'" />' : "") + (($selected.attr("data-icon")) ? '<span class="ir ico '+$selected.attr("data-icon")+'"></span>' : "") + $selected.text();
				$styledSelect.html($contentSelected).removeClass('active');
	
				if ($this.val() != $(this).attr('rel')) {
					$this.val($(this).attr('rel')).change();
				}
	
				$list.hide();
			});

			// Hides the unordered list when clicking outside of it
			$(document).click(function () {
				$styledSelect.removeClass('active');
				$list.hide();
			});
		});
	};
})(jQuery);