<?php
/**
 * Pricing Table Global Settings.
 *
 * Exporting Pricing Tables by generating a JSON file.
 * Contains all the data and setting options of all pricing tables
 *
 * Importing Pricing Tables by JSON file that was exported before.
 *
 * WRC Pricing Tables Ultimate - v1.2.4 - 16 July, 2023
 */
if ( ! defined( 'ABSPATH' ) ) exit; ?>
<div id="wrcpt_global_settings" class="wrap">
	<h2><?php _e( 'Pricing Table Global Settings', 'wrcpt'); ?></h2><?php
	if(isset($_POST['wrcpt_process'])) {
		echo '<div id="message" class="updated"><p><strong>'.__( 'Global Settings Updated.', 'wrcpt' ).'</strong></p></div>';
	}
	if(isset($_POST['wrcpt_optimize'])) {
		$pcount = wrcpt_unuseful_package_options();
		echo '<div id="optimize-message" class="success">
		<button type="button" class="wrcpt_close">
			<span aria-hidden="true"><a><i class="dashicons dashicons-dismiss blackcross"></i></a></span>
		</button>
		<i class="start-icon dashicons dashicons-smiley"></i>'.
		__( 'Bravo! You don\'t have anymore unnecessary package options to clear!', 'wrcpt' ).'</div>';
	}
	$upcount = wrcpt_count_unuseful_package_options();
	if ($upcount > 0 && !isset($pcount)) {
		echo '<div id="alert-message" class="notice-warning">
		<button type="button" class="wrcpt_close">
			<span aria-hidden="true"><a><i class="dashicons dashicons-dismiss blackcross"></i></a></span>
		</button>
		<i class="start-icon dashicons dashicons-warning"></i>'.
		sprintf(__( '<strong>Alert!</strong> %d unnecessary package options have been created unintentionally! Click on <strong>Optimize Pricing Tables</strong> button to clear.', 'wrcpt' ), $upcount).'</div>';
	}
	if(isset($_POST['wrcpt_ccss'])) {
		echo '<div id="message" class="updated"><p><strong>'.__( 'Pricing Table Custom CSS Updated.', 'wrcpt' ).'</strong></p></div>';
	} ?>
	<div id="wrcpt-tabs" class="wrcpt_global" style="visibility:hidden">
		<ul>
			<li><a href="#options"><?php _e('Options', 'wrcpt'); ?></a></li>
			<li><a href="#custcss"><?php _e('Custom Style', 'rcpig'); ?></a></li>
			<li><a href="#export"><?php _e('Export Table', 'wrcpt'); ?></a></li>
			<li><a href="#import"><?php _e('Import Table', 'wrcpt'); ?></a></li>
		</ul>
		
		<div id="options">
			<h2><?php _e( 'Global Settings' ); ?></h2>
			<form id="wrcpt_template_form" method="post" action=""><?php
				$wrcpt_options = get_option('pricing_table_global'); ?>
				<input type="hidden" name="wrcpt_global" value="process" />
				<div class="wrcpt_options">
					<label class="input-check"><?php _e('Minify Pricing Table CSS &amp; JS', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('Minification dramatically improves site speed and accessibility, directly translating into a better user experience. Minification is the process of minimizing code and markup in your web pages and script files. It\'s one of the main methods used to reduce load times and bandwidth usage on websites.', 'wrcpt'); ?>"></a><span class="dashicons dashicons-megaphone"></span><a href="#" class="wrc_tooltip wrc_note" rel="<?php _e('When creating CSS and JS files, developers tend to use spacing, comments and well-named variables to make code and markup readable for themselves. It also helps others who might later work on the assets. While this is a plus in the development phase, it becomes a negative when it comes to serving your pages. Web servers and browsers can parse file content without comments and well-structured code, both of which create additional network traffic without providing any functional benefit. To minify JS and CSS files, comments and extra spaces need to be removed, as well as crunch variable names so as to minimize code and reduce file size. The minified file version provides the same functionality while reducing the bandwidth of network requests.', 'wrcpt'); ?>"><i class="attention" title="Why minify CSS &amp; JS Files?"></i></a></label>
					<label for="minify_script" class="wrcpt_global_check">
					<input type="checkbox" name="minify_script" class="tickbox" id="minify_script" value="yes" <?php if(isset($wrcpt_options['minify']) && $wrcpt_options['minify'] == 'yes') echo('checked="checked"'); ?>/>
					</label>
				</div>
				<div class="wrcpt_options">
					<label class="input-check"><?php _e('Enable WP Post Editor for HTML Feature Type', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('Instead of worrying about the alignment and organization of text, quotes, and images, enable WP default post editor and you can focus on creating. Most of the users prefer to write on it.', 'wrcpt'); ?>"></a></label>
					<label for="editor_choice" class="wrcpt_global_check">
					<input type="checkbox" name="wp_post_editor" class="tickbox" id="wp_post_editor" value="yes" <?php if(isset($wrcpt_options['wpedit']) && $wrcpt_options['wpedit'] == "yes") echo "checked"; ?>>
					</label>
				</div>
				<div id="htmleditor" class="wrcpt_options">
					<label class="input-check"><?php _e('Enable HTML Editor as the Default Post Editor', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('It is useful when you have only a few users and most of them agree to your choice to set HTML editor as the default post editor in WordPress. The advantage is that you will have the visual editor in the background which you can choose to use anytime.', 'wrcpt'); ?>"></a></label>
					<label for="html_editor" class="wrcpt_global_check">
					<input type="checkbox" name="html_editor" class="tickbox" id="html_editor" value="yes" <?php if(isset($wrcpt_options['htmled']) && $wrcpt_options['htmled'] == "yes") echo "checked"; ?>>
					</label>
				</div>
				<div class="wrcpt_options">
					<label class="input-check"><?php _e('Enable Plugin Default Google Font', 'wrcpt'); ?>:</label>
					<label for="default_font" class="wrcpt_global_check">
					<input type="checkbox" name="default_font" class="tickbox" id="default_font" value="yes" <?php if(isset($wrcpt_options['gdfont']) && $wrcpt_options['gdfont'] == "yes") echo('checked="checked"'); ?>/>
					</label>
				</div>
				<div id="user_choice_font">
					<div class="wrcpt_options">
						<label class="input-title"><?php _e('Enter <a class="global-link" href="https://fonts.google.com/" target="_blank">Google Fonts</a> URL link', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('If you want your website to stand out from the others, then using custom fonts like Google Fonts will get you there. Google Web Designer lets you select a font from a list of common fonts or from Google Fonts. You can use hundreds of open-source fonts available through Google Fonts at no cost.', 'wrcpt'); ?>"></a><span class="dashicons dashicons-megaphone"></span><a href="#" class="wrc_tooltip wrc_note" rel="<?php _e('Find a Google font that you\'d like to use on your pricing table. When you find the font that you like, click on the \'Plus\' icon at the right. After clicking on the plus icon a popup window will appear from right named as Selected family. Add more font if you want. After adding all the fonts, in the \'Use on the web\' section you will find generated links. You don\'t need to copy the whole code. You just need to add an URL link without http: or https: (e.g. //fonts.googleapis.com/css?family=Roboto+Condensed:400,700).', 'wrcpt'); ?>"><i class="attention" title="Add a font from Google Fonts"></i></a></label>
						<input type="text" name="custom_font" class="medium" id="custom_font" value="<?php if(isset($wrcpt_options['gcfont'])) echo $wrcpt_options['gcfont']; ?>" placeholder="e.g. //fonts.googleapis.com/css?family=Roboto+Condensed:400,700" />
					</div>
                    <div class="wrcpt_options">
                        <label class="input-title"><?php _e('Enter Primary Font Family', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('Each price table you create has it\'s own primary font family settings under \'Pricing Tables Settings &raquo; Font Settings\'. If you leave that blank, only then primary font family entered here will work.', 'wrcpt'); ?>"></a><span class="dashicons dashicons-megaphone"></span><a href="#" class="wrc_tooltip wrc_note" rel="<?php _e('When using the \'font-family\' property, you can provide the name of the font without quotation marks, as long as the font name consists of a single word or does not contain any special characters or spaces. For example: \'body {font-family: Arial, sans-serif;}\'. In the example, the font family \'Arial\' is specified without quotation marks. However, if you want to use a font name that contains spaces or special characters, you need to enclose it in quotation marks. For example: \'body {font-family: \'Times New Roman\', serif;\'. In this case, the font name \'Times New Roman\' contains spaces, so it is enclosed in quotation marks to ensure proper interpretation by the browser. When specifying a generic font family like \'sans-serif\', quotation marks are not necessary. The generic font families, which include \'serif\', \'sans-serif\', \'monospace\', \'cursive\', and \'fantasy\', are predefined and do not require quotation marks. These generic families represent a category of fonts rather than specific font names.', 'wrcpt'); ?>"><i class="attention" title="Quoting Font Family"></i></a></label>
                        <input type="text" name="primary_font" class="medium" id="primary_font" value="<?php echo $wrcpt_options['prfont']; ?>" placeholder="'Roboto Condensed', serif">
                    </div>
                    <div class="wrcpt_options">
                        <label class="input-title"><?php _e('Enter Secondary Font Family', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('Each price table you create has it\'s own secondary font family settings under \'Pricing Tables Settings &raquo; Font Settings\'. If you leave that blank, only then secondary font family entered here will work.', 'wrcpt'); ?>"></a></label>
                        <input type="text" name="secondary_font" class="medium" id="secondary_font" value="<?php echo $wrcpt_options['scfont']; ?>" placeholder="'Open Sans', sans-serif">
                    </div>
				</div>
				<div class="wrcpt_options">
					<label class="input-check"><?php _e('Enable Font Awesome in Theme', 'wrcpt'); ?>:</label>
					<label for="font_awesome" class="wrcpt_global_check">
					<input type="checkbox" name="font_awesome" class="tickbox" id="font_awesome" value="yes" <?php if(isset($wrcpt_options['fasome']) && $wrcpt_options['fasome'] == "yes") echo('checked="checked"'); ?>/>
					</label>
				</div>
				<div class="wrcpt_options">
					<label class="input-check"><?php _e('Add View Port Meta in the Header', 'wrcpt'); ?>:</label>
					<label for="view_port" class="wrcpt_global_check">
					<input type="checkbox" name="view_port" class="tickbox" id="view_port" value="yes" <?php if(isset($wrcpt_options['vwport']) && $wrcpt_options['vwport'] == "yes") echo('checked="checked"'); ?>/>
					</label>
				</div>
				<div class="wrcpt_options">
					<label class="input-check"><?php _e('Clear Database on Delete', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('If you decide not to use the plugin anymore, you can leave this option checked. By doing this, all the data stored in the database will be deleted along with the deletion of the plugin.', 'wrcpt'); ?>"></a>:</label>
					<label for="clear_db" class="wrcpt_global_check">
					<input type="checkbox" name="clear_db" class="tickbox" id="clear_db" value="yes" <?php if(isset($wrcpt_options['clrdb']) && $wrcpt_options['clrdb'] == "yes") echo('checked="checked"'); ?>/>
					</label>
				</div>
				<div class="wrcpt_options">
					<label class="input-check"><?php _e('Don\'t Enqueue Custom CSS:', 'wrcpt'); ?><a href="#" class="wrc_tooltip" rel="<?php _e('If you don\'t want the plugin to automatically enqueue custom style sheets, you can turn it off here. This will help you to keep the number of CSS files in your theme under the limit. Before turning off custom CSS, make sure you manually load it into your theme. Otherwise, the pricing table will not be displayed according to the customization.', 'wrcpt'); ?>"></a><span class="dashicons dashicons-megaphone"></span><a href="#" class="wrc_tooltip wrc_note" rel="<?php _e('When it comes to reducing the amount of CSS files, remember that fewer doesn\'t necessarily mean faster. In sites that have a huge number of CSS files, combining them all into one gargantuan 1MB file may have more of a negative impact than having lots of small files. In such instances, try to be methodical and logical in your approach to combining files; combining files that offer similar functions or applications within your site can be a easy way to reduce sizes without mashing everything together. For regularly-sized sites though, combining all the CSS files into one is a sound solution.', 'wrcpt'); ?>"><i class="attention" title="Attention!"></i></a></label>
					<label for="custom-css-off" class="wrcpt_global_check">
					<input type="checkbox" name="custom_off" class="tickbox" id="custom_off" value="yes" <?php if(isset($wrcpt_options['ccoff']) && $wrcpt_options['ccoff'] == "yes") echo('checked="checked"'); ?>/>
					</label>
				</div>
				<div class="wrcpt_options">
					<label for="optimize_data" class="input-check"><?php _e('Remove Unnecessary Package Option', 'wrcpt'); ?>:<a href="#" class="wrc_tooltip" rel="<?php _e('While customizing the pricing table, some unnecessary package options may be created, which can make the database heavier. By clicking on this button, without any hassle, unnecessary options can be removed from the database right away!', 'wrcpt'); ?>"></a></label>
                	<input type="submit" id="wrcpt_optimize" name="wrcpt_optimize" class="button-secondary" value="<?php _e('Optimize Pricing Tables', 'wrcpt'); ?>">
					</label>
				</div><?php
				if(isset($wrcpt_options) && $wrcpt_options != '') { ?>
					<input type="submit" id="wrcpt_process" name="wrcpt_process" class="button-primary" value="<?php _e('Update Changes', 'wrcpt'); ?>"><?php
				} else { ?>
					<input type="submit" id="wrcpt_process" name="wrcpt_process" class="button-primary" value="<?php _e('Save Changes', 'wrcpt'); ?>"><?php
				} ?>
                <input type="hidden" name="wrcpt_custom_css" value="<?php echo $wrcpt_options['wrccss']; ?>">
			</form>
		</div>

		<div id="custcss">
			<form id="custom_css_form" method="post" action="">
				<?php $wrcpt_options = get_option('pricing_table_global'); ?>
				<input type="hidden" name="wrcpt_custom" value="custcss">
                <div class="wrcpt_custom_css">
                    <label class="label-check"><h2><?php _e( 'Pricing Table Custom CSS', 'wrcpt' ); ?></h2></label>
                    <textarea id="wrcpt-fancy-textarea" class="wrcpt-wp-editor" name="wrcpt_custom_css"><?php if(isset($wrcpt_options['wrccss']) && $wrcpt_options['wrccss'] != '') { echo htmlspecialchars_decode($wrcpt_options['wrccss']); } ?></textarea>
                    <p><input type="submit" id="wrcpt_ccss" name="wrcpt_ccss"  class="button-primary" value="<?php _e( 'Save Changes', 'wrcpt' ) ?>"></p>
                    <p class="get_started"><?php _e('Please add all your custom CSS here and avoid modifying the core plugin CSS, since that\'ll make upgrading the plugin problematic. Your custom CSS will be loaded after the plugin\'s stylesheets, which means that your rules will take precedence. Just add your CSS here for what you want to change.', 'wrcpt'); ?></p>
                </div>
                <input type="hidden" name="minify_script" value="<?php echo $wrcpt_options['minify']; ?>">
                <input type="hidden" name="wp_post_editor" value="<?php echo $wrcpt_options['wpedit']; ?>">
                <input type="hidden" name="html_editor" value="<?php echo $wrcpt_options['htmled']; ?>">
                <input type="hidden" name="default_font" value="<?php echo $wrcpt_options['gdfont']; ?>">
                <input type="hidden" name="custom_font" value="<?php echo $wrcpt_options['gcfont']; ?>">
                <input type="hidden" name="primary_font" value="<?php echo $wrcpt_options['prfont']; ?>">
                <input type="hidden" name="secondary_font" value="<?php echo $wrcpt_options['scfont']; ?>">
                <input type="hidden" name="font_awesome" value="<?php echo $wrcpt_options['fasome']; ?>">
                <input type="hidden" name="view_port" value="<?php echo $wrcpt_options['vwport']; ?>">
                <input type="hidden" name="clear_db" value="<?php echo $wrcpt_options['clrdb']; ?>">
                <input type="hidden" name="custom_off" value="<?php echo $wrcpt_options['ccoff']; ?>">
			</form>
		</div>

		<div id="export"><?php
			$package_table = get_option('packageTables');
			$table_lists = explode(', ', $package_table);
			$temp_option = 'packageTables, packageCount, ' . $package_table;
			foreach($table_lists as $list) {
				$table_options = get_option($list);
				$merge_option  = $temp_option . ', ' . $table_options . ', ' . $list . '_feature' . ', ' . $list . '_option';
				$temp_option = $merge_option;
			}
			if (!isset($_POST['wrc_export'])) { ?>
                <div id="icon-tools" class="icon32"><br /></div>
                <h2>Export</h2>
                <p><?php echo __('When you click <strong>Download Export File</strong> button, WordPress will generate a JSON file for you to save to your computer.', 'wrcpt') ?></p>
                <p><?php echo __('This backup file contains all the configuration and setting options of your pricing tables. Note that it do <b>NOT</b> contain posts, pages, or any relevant data, just your all pricing table options.', 'wrcpt') ?></p>
                <p><?php echo __('After exporting, you can either use the backup file to restore your settings on this site again or another WordPress site.', 'wrcpt') ?></p>
                <form method="post" id="export-wrcpt">
                    <p class="submit">
                        <?php wp_nonce_field('wrcpt-export'); ?>
                        <input type="submit" name="wrc_export" id="wrc_export" class="button button-primary" value="<?php echo __('Download Export File', 'wrcpt') ?>" />
                    </p>
                </form><?php
			} elseif (check_admin_referer('wrcpt-export')) {
				$blogname = str_replace(" ", "", get_option('blogname'));
				$date = date("m-d-Y");
				$json_name = $blogname."-".$date; // Namming the filename will be generated.
			
				$option_lists = explode(', ', $merge_option);
				foreach($option_lists as $oplist) {
					$options[] = array($oplist => get_option($oplist));
				}
				$json_file = json_encode($options);
			
				ob_clean();
				echo $json_file;
				header("Content-Type: text/json; charset=" . get_option( 'blog_charset'));
				header("Content-Disposition: attachment; filename=$json_name.json");
				exit();
			} ?>
		</div>

		<div id="import">
            <div id="icon-tools" class="icon32"><br /></div>
            <h2>Import</h2><?php
            if (isset($_FILES['wrc_import']) && check_admin_referer('wrcpt-import')) {
                if ($_FILES['wrc_import']['error'] > 0) {
                    wp_die("Error happens");
                } else {
                    $file_name = $_FILES['wrc_import']['name'];
                    $file_ext = strtolower(end(explode(".", $file_name)));
                    $file_size = $_FILES['wrc_import']['size'];
                    if (($file_ext == "json") && ($file_size < 500000)) {
                        $encode_options = file_get_contents($_FILES['wrc_import']['tmp_name']);
                        $option_lists = json_decode($encode_options, true);
                        foreach ($option_lists as $key => $options) {
                            foreach ($options as $key => $value) {
                                update_option($key, $value);
                            }
                        }
                        echo "<div class='updated'><p>All options are imported successfully.</p></div>";
                    } else {
                        echo "<div class='error'><p>Invalid file or file size too big.</p></div>";
                    }
                }
            } ?>
            <p><?php echo __('Choose a json file to upload that you backup before, then click <strong>Upload file and import</strong>. Wordpress do the rest for you.', 'wrcpt') ?></p>
            <form method="post" enctype="multipart/form-data" id="import-wrcpt">
                <?php wp_nonce_field('wrcpt-import'); ?>
                <p>
                    <label for="wrcpt_upload"><?php echo __('Choose a file from your computer:', 'wrcpt') ?></label> <?php echo __('(Maximum size: 450 MB)', 'wrcpt') ?>
                    <input type="file" id="wrcpt_upload" name="wrc_import" size="25" />
                </p>
                <p class="submit">
                    <input type="submit" name="submit" id="submit" class="button button-primary" value="<?php echo __('Upload file and import', 'wrcpt') ?>" />
                </p>
            </form>
		</div>
	</div>
	<?php wrcpt_sidebar($class='tools'); ?>
</div>