<?php
/**
 * WRC Pricing Tables Ultimate - v1.2.4 - 16 July, 2023
 *
 * Pricing Table Shortcode 1
 * Display pricing table responsively.
 * In tablet view, the pricing table will be divided into two columns.
 * In mobile view, each column of the price table will be displayed below each other.
 */
function wrcpt_shortcode1( $p_table, $t_name, $tableID, $p_feature, $p_combo, $tot_feat, $p_lists, $p_options, $p_count, $flag ) {
	$i = 1; $j = 0;
	$ptn_light = wrcpt_adjustBrightness($p_combo['ptnbg'], 50);
	$pta_light = wrcpt_adjustBrightness($p_combo['ptabg'], 50);
	$cbdlight = wrcpt_adjustBrightness($p_combo['ccborder'], 50);

	/* Preparing structural settings of the different parts of the table. */
	if($p_combo['cwidth']) { $container_width = (int)$p_combo['cwidth']; } else { $container_width = 100; }
	if($p_combo['maxcol']) { $maximum_column = (int)$p_combo['maxcol']; } else { $maximum_column = 4; }
	if($p_combo['tbody']) { $title_box_height = (int)$p_combo['tbody']; } else { $title_box_height = 62; }
	if($p_combo['pbody']) { $price_box_height = (int)$p_combo['pbody']; } else { $price_box_height = 120; }
	if($p_combo['imghgt']) { $image_height_a = (int)$p_combo['imghgt']; } else { $image_height_a = $price_box_height; }
	if($p_combo['vbody']) { $video_height = (int)$p_combo['vbody']; } else { $video_height = $price_box_height; }
	if($p_combo['btbody']) { $button_box_height = (int)$p_combo['btbody']; } else { $button_box_height = 60; }
	if($p_combo['etclr'] == 'yes' && $p_combo['tbpad']) { $table_padding = (int)$p_combo['tbpad']; } else { $table_padding = 0; }
	if($p_combo['vbody']) { $video_box_height = (int)$p_combo['vbody']; } else { $video_box_height = 150; }
	if($p_combo['bwidth'] && (int)$p_combo['bwidth'] < 120) { $button_padding = (int)$p_combo['bwidth'] * 0.0833; } else { $button_padding = 10; }
	if($p_combo['colgap']) { $margin = $p_combo['colgap']; } else { $margin = 0; }
	if($p_combo['capwidth']) { $caption_width = (float)$p_combo['capwidth']; } else { $caption_width = 19; }

	/* FEATURED THUMBNAILS */
	if($p_combo['imgwid']) {
		$image_wide = (int)$p_combo['imgwid'];
		$image_height_b = $title_box_height+$image_height_a;
		add_theme_support( 'post-thumbnails' );
		add_image_size( 'full-pack', $image_wide, $image_height_b, true );
		add_image_size( 'pack-wide', $image_wide, $image_height_a, true );
	}

	/* Calculating responsive width of the pricing table for both tablet and mobile view.
	 * Here, we are calculating responsive width both for caption column and package column.
	 */
	if($p_combo) {
		if($p_combo['autocol'] == 'no') {
			if($p_count > $maximum_column) {
				$width = ($container_width)/$maximum_column . '%';
				$cap_width = ($container_width)/($maximum_column+1) . '%';
			} else {
				$width = ($container_width)/$p_count . '%';
				$cap_width = ($container_width)/($p_count+1) . '%';
			}
		} else {
			if($p_combo['ftcap'] == "yes") {
				$single_column_width = ((100 - $caption_width) - ($margin * (12-1)))/12;
			} else {
				$single_column_width = (100 - ($margin * (12-1)))/12;
			}
			$width = ($single_column_width * (12 / $maximum_column)) + ($margin * ((12 / $maximum_column) - 1)) . '%';
			$cap_width = $caption_width . '%';
		}
		$tab_width = (((100 - ($margin * (12-1)))/12) * (12 / 2)) + ($margin * ((12 / 2) - 1)) . '%';
		$mob_width = ((100/12 * (12 / 1))) . '%';
	}

	/* Start pricing table */
	/* check if the table is enable */
	if(!empty($p_lists) && $p_combo['enable'] == 'yes' && $flag == 1) { ?>
		<div id="<?php echo $tableID; ?>" class="wrcpt_content wrcpt_container" data-id="<?php echo $tableID; ?>" data-col="package" data-sc="" data-button="table">
<?php if($p_combo['mcurr'] == 'yes') { ?>
			<div class="toggle toggle-select">
				<div class="toggle-slide toggle-select">
					<div class="toggle-one active"><?php echo $p_combo['tgtext1']; ?></div>
					<div class="toggle-two"><?php echo $p_combo['tgtext2']; ?><?php if($p_combo['sptext'] != '') { ?><span><?php echo $p_combo['sptext']; ?></span><?php } ?></div><?php
					if($p_combo['togg3'] == 'yes') { ?>
					<div class="toggle-three"><?php echo $p_combo['tgtext3']; ?><?php if($p_combo['sptext2'] != '') { ?><span><?php echo $p_combo['sptext2']; ?></span><?php } ?></div><?php
					} 
					if(isset($p_combo['togg4']) && $p_combo['togg4'] == 'yes') { ?>
					<div class="toggle-four"><?php echo $p_combo['tgtext4']; ?><?php if($p_combo['sptext3'] != '') { ?><span><?php echo $p_combo['sptext3']; ?></span><?php } ?></div><?php
					} ?>
				</div>
			</div>
            <!-- pricing toggle switching -->
			<?php
			/* add toggle script in footer */
			wp_enqueue_script('toggle_script', plugins_url('../js/wrcpt-front.js', __FILE__), array( 'jquery' ), null, true); ?>
<?php } ?>
			<div class="wrc_pricing_table wrcpt_row">
<?php
	/**
	 * @variable $p_options - All the package options name.
	 * Check each package option's values
	 */
	foreach($p_options as $key => $value) :
		$packageType = get_option($value);
		if($packageType['paypal'] == 'show') {
			// live of test mode
			if ($packageType['pmode'] == "1") {
				$pp_account = $packageType['ppsbx'];
				$pp_path = "sandbox.paypal";
			} elseif ($packageType['pmode'] == "2")  {
				$pp_account = $packageType['pplva'];
				$pp_path = "paypal";
			}
			// payment action
			if ($packageType['pactn'] == "1") {
				$pp_action = "sale";
			} elseif ($packageType['pactn'] == "2")  {
				$pp_action = "authorization";
			} else {
				$pp_action = "sale";
			}
			// currency
			$pp_currency = $packageType['ppcur'];
			// price
			if($packageType['cent']) {
				$pp_price = $packageType['price'].'.'.$packageType['cent'];
				$pp_price2 = $packageType['tgprice'].'.'.$packageType['tgcent'];
				$pp_price3 = $packageType['tgprc2'].'.'.$packageType['tgcnt2'];
				$pp_price4 = $packageType['tgprc3'].'.'.$packageType['tgcnt3'];
			} else {
				$pp_price = $packageType['price'].'.00';
				$pp_price2 = $packageType['tgprice'].'.00';
				$pp_price3 = $packageType['tgprc2'].'.00';
				$pp_price4 = $packageType['tgprc3'].'.00';
			}
			// language
			if ($packageType['pplng'] == "1") {
				$pp_language = "da_DK";
			} //Danish
		
			if ($packageType['pplng'] == "2") {
				$pp_language = "nl_BE";
			} //Dutch
		
			if ($packageType['pplng'] == "3") {
				$pp_language = "EN_US";
			} //English
		
			if ($packageType['pplng'] == "20") {
				$pp_language = "en_GB";
			} //English - UK
		
			if ($packageType['pplng'] == "4") {
				$pp_language = "fr_CA";
			} //French
		
			if ($packageType['pplng'] == "5") {
				$pp_language = "de_DE";
			} //German
		
			if ($packageType['pplng'] == "6") {
				$pp_language = "he_IL";
			} //Hebrew
		
			if ($packageType['pplng'] == "7") {
				$pp_language = "it_IT";
			} //Italian
		
			if ($packageType['pplng'] == "8") {
				$pp_language = "ja_JP";
			} //Japanese
		
			if ($packageType['pplng'] == "9") {
				$pp_language = "no_NO";
			} //Norwgian
		
			if ($packageType['pplng'] == "10") {
				$pp_language = "pl_PL";
			} //Polish
		
			if ($packageType['pplng'] == "11") {
				$pp_language = "pt_BR";
			} //Portuguese
		
			if ($packageType['pplng'] == "12") {
				$pp_language = "ru_RU";
			} //Russian
		
			if ($packageType['pplng'] == "13") {
				$pp_language = "es_ES";
			} //Spanish
		
			if ($packageType['pplng'] == "14") {
				$pp_language = "sv_SE";
			} //Swedish
		
			if ($packageType['pplng'] == "15") {
				$pp_language = "zh_CN";
			} //Simplified Chinese - China
		
			if ($packageType['pplng'] == "16") {
				$pp_language = "zh_HK";
			} //Traditional Chinese - Hong Kong
		
			if ($packageType['pplng'] == "17") {
				$pp_language = "zh_TW";
			} //Traditional Chinese - Taiwan
		
			if ($packageType['pplng'] == "18") {
				$pp_language = "tr_TR";
			} //Turkish
		
			if ($packageType['pplng'] == "19") {
				$pp_language = "th_TH";
			} //Thai
			if($packageType['hsbtn'] == 'show') {
				$pp_image = "https://www.paypalobjects.com/en_US/i/btn/btn_buynow_SM.gif";
				$pp_imageb = "https://www.paypalobjects.com/en_US/i/btn/btn_buynow_LG.gif";
				$pp_imagecc = "https://www.paypalobjects.com/en_US/i/btn/btn_buynowCC_LG.gif";
				$pp_imagenew = "https://www.paypalobjects.com/webstatic/en_US/i/buttons/buy-logo-medium.png";
			} else {
				if ($packageType['pplng'] == "1") {
					$pp_image = "https://www.paypalobjects.com/da_DK/i/btn/btn_buynow_SM.gif";
					$pp_imageb = "https://www.paypalobjects.com/da_DK/i/btn/btn_buynow_LG.gif";
					$pp_imagecc = "https://www.paypalobjects.com/da_DK/DK/i/btn/btn_buynowCC_LG.gif";
					$pp_imagenew = "https://www.paypalobjects.com/webstatic/en_US/i/buttons/buy-logo-medium.png";
				} //Danish
			
				if ($packageType['pplng'] == "2") {
					$pp_image = "https://www.paypalobjects.com/nl_NL/NL/i/btn/btn_buynow_SM.gif";
					$pp_imageb = "https://www.paypalobjects.com/nl_NL/NL/i/btn/btn_buynow_LG.gif";
					$pp_imagecc = "https://www.paypalobjects.com/nl_NL/NL/i/btn/btn_buynowCC_LG.gif";
					$pp_imagenew = "https://www.paypalobjects.com/webstatic/en_US/i/buttons/buy-logo-medium.png";
				} //Dutch
			
				if ($packageType['pplng'] == "3") {
					$pp_image = "https://www.paypalobjects.com/en_US/i/btn/btn_buynow_SM.gif";
					$pp_imageb = "https://www.paypalobjects.com/en_US/i/btn/btn_buynow_LG.gif";
					$pp_imagecc = "https://www.paypalobjects.com/en_US/i/btn/btn_buynowCC_LG.gif";
					$pp_imagenew = "https://www.paypalobjects.com/webstatic/en_US/i/buttons/buy-logo-medium.png";
				} //English
			
				if ($packageType['pplng'] == "20") {
					$pp_image = "https://www.paypalobjects.com/en_US/i/btn/btn_buynow_SM.gif";
					$pp_imageb = "https://www.paypalobjects.com/en_US/i/btn/btn_buynow_LG.gif";
					$pp_imagecc = "https://www.paypalobjects.com/en_US/i/btn/btn_buynowCC_LG.gif";
					$pp_imagenew = "https://www.paypalobjects.com/webstatic/en_US/i/buttons/buy-logo-medium.png";
				} //English - UK
			
				if ($packageType['pplng'] == "4") {
					$pp_image = "https://www.paypalobjects.com/fr_CA/i/btn/btn_buynow_SM.gif";
					$pp_imageb = "https://www.paypalobjects.com/fr_CA/i/btn/btn_buynow_LG.gif";
					$pp_imagecc = "https://www.paypalobjects.com/fr_CA/i/btn/btn_buynowCC_LG.gif";
					$pp_imagenew = "https://www.paypalobjects.com/webstatic/en_US/i/buttons/buy-logo-medium.png";
				} //French
			
				if ($packageType['pplng'] == "5") {
					$pp_image = "https://www.paypalobjects.com/de_DE/DE/i/btn/btn_buynow_SM.gif";
					$pp_imageb = "https://www.paypalobjects.com/de_DE/DE/i/btn/btn_buynow_LG.gif";
					$pp_imagecc = "https://www.paypalobjects.com/de_DE/DE/i/btn/btn_buynowCC_LG.gif";
					$pp_imagenew = "https://www.paypalobjects.com/webstatic/en_US/i/buttons/buy-logo-medium.png";
				} //German
			
				if ($packageType['pplng'] == "6") {
					$pp_image = "https://www.paypalobjects.com/he_IL/i/btn/btn_buynow_SM.gif";
					$pp_imageb = "https://www.paypalobjects.com/he_IL/i/btn/btn_buynow_LG.gif";
					$pp_imagecc = "https://www.paypalobjects.com/he_IL/IL/i/btn/btn_buynowCC_LG.gif";
					$pp_imagenew = "https://www.paypalobjects.com/webstatic/en_US/i/buttons/buy-logo-medium.png";
				} //Hebrew
			
				if ($packageType['pplng'] == "7") {
					$pp_image = "https://www.paypalobjects.com/it_IT/IT/i/btn/btn_buynow_SM.gif";
					$pp_imageb = "https://www.paypalobjects.com/it_IT/IT/i/btn/btn_buynow_LG.gif";
					$pp_imagecc = "https://www.paypalobjects.com/it_IT/IT/i/btn/btn_buynowCC_LG.gif";
					$pp_imagenew = "https://www.paypalobjects.com/webstatic/en_US/i/buttons/buy-logo-medium.png";
				} //Italian
			
				if ($packageType['pplng'] == "8") {
					$pp_image = "https://www.paypalobjects.com/ja_JP/JP/i/btn/btn_buynow_SM.gif";
					$pp_imageb = "https://www.paypalobjects.com/ja_JP/JP/i/btn/btn_buynow_LG.gif";
					$pp_imagecc = "https://www.paypalobjects.com/ja_JP/JP/i/btn/btn_buynowCC_LG.gif";
					$pp_imagenew = "https://www.paypalobjects.com/webstatic/en_US/i/buttons/buy-logo-medium.png";
				} //Japanese
			
				if ($packageType['pplng'] == "9") {
					$pp_image = "https://www.paypalobjects.com/no_NO/i/btn/btn_buynow_SM.gif";
					$pp_imageb = "https://www.paypalobjects.com/no_NO/i/btn/btn_buynow_LG.gif";
					$pp_imagecc = "https://www.paypalobjects.com/no_NO/NO/i/btn/btn_buynowCC_LG.gif";
					$pp_imagenew = "https://www.paypalobjects.com/webstatic/en_US/i/buttons/buy-logo-medium.png";
				} //Norwgian
			
				if ($packageType['pplng'] == "10") {
					$pp_image = "https://www.paypalobjects.com/pl_PL/PL/i/btn/btn_buynow_SM.gif";
					$pp_imageb = "https://www.paypalobjects.com/pl_PL/PL/i/btn/btn_buynow_LG.gif";
					$pp_imagecc = "https://www.paypalobjects.com/pl_PL/PL/i/btn/btn_buynowCC_LG.gif";
					$pp_imagenew = "https://www.paypalobjects.com/webstatic/en_US/i/buttons/buy-logo-medium.png";
				} //Polish
			
				if ($packageType['pplng'] == "11") {
					$pp_image = "https://www.paypalobjects.com/pt_PT/PT/i/btn/btn_buynow_SM.gif";
					$pp_imageb = "https://www.paypalobjects.com/pt_PT/PT/i/btn/btn_buynow_LG.gif";
					$pp_imagecc = "https://www.paypalobjects.com/pt_PT/PT/i/btn/btn_buynowCC_LG.gif";
					$pp_imagenew = "https://www.paypalobjects.com/webstatic/en_US/i/buttons/buy-logo-medium.png";
				} //Portuguese
			
				if ($packageType['pplng'] == "12") {
					$pp_image = "https://www.paypalobjects.com/ru_RU/i/btn/btn_buynow_SM.gif";
					$pp_imageb = "https://www.paypalobjects.com/ru_RU/i/btn/btn_buynow_LG.gif";
					$pp_imagecc = "https://www.paypalobjects.com/ru_RU/RU/i/btn/btn_buynowCC_LG.gif";
					$pp_imagenew = "https://www.paypalobjects.com/webstatic/en_US/i/buttons/buy-logo-medium.png";
				} //Russian
			
				if ($packageType['pplng'] == "13") {
					$pp_image = "https://www.paypalobjects.com/es_ES/ES/i/btn/btn_buynow_SM.gif";
					$pp_imageb = "https://www.paypalobjects.com/es_ES/ES/i/btn/btn_buynow_LG.gif";
					$pp_imagecc = "https://www.paypalobjects.com/es_ES/ES/i/btn/btn_buynowCC_LG.gif";
					$pp_imagenew = "https://www.paypalobjects.com/webstatic/en_US/i/buttons/buy-logo-medium.png";
				} //Spanish
			
				if ($packageType['pplng'] == "14") {
					$pp_image = "https://www.paypalobjects.com/sv_SE/i/btn/btn_buynow_SM.gif";
					$pp_imageb = "https://www.paypalobjects.com/sv_SE/i/btn/btn_buynow_LG.gif";
					$pp_imagecc = "https://www.paypalobjects.com/sv_SE/SE/i/btn/btn_buynowCC_LG.gif";
					$pp_imagenew = "https://www.paypalobjects.com/webstatic/en_US/i/buttons/buy-logo-medium.png";
				} //Swedish
			
				if ($packageType['pplng'] == "15") {
					$pp_image = "https://www.paypalobjects.com/zh_XC/i/btn/btn_buynow_SM.gif";
					$pp_imageb = "https://www.paypalobjects.com/zh_XC/i/btn/btn_buynow_LG.gif";
					$pp_imagecc = "https://www.paypalobjects.com/zh_XC/C2/i/btn/btn_buynowCC_LG.gif";
					$pp_imagenew = "https://www.paypalobjects.com/webstatic/en_US/i/buttons/buy-logo-medium.png";
				} //Simplified Chinese - China
			
				if ($packageType['pplng'] == "16") {
					$pp_image = "https://www.paypalobjects.com/zh_HK/i/btn/btn_buynow_SM.gif";
					$pp_imageb = "https://www.paypalobjects.com/zh_HK/i/btn/btn_buynow_LG.gif";
					$pp_imagecc = "https://www.paypalobjects.com/zh_HK/HK/i/btn/btn_buynowCC_LG.gif";
					$pp_imagenew = "https://www.paypalobjects.com/webstatic/en_US/i/buttons/buy-logo-medium.png";
				} //Traditional Chinese - Hong Kong
			
				if ($packageType['pplng'] == "17") {
					$pp_image = "https://www.paypalobjects.com/zh_TW/TW/i/btn/btn_buynow_SM.gif";
					$pp_imageb = "https://www.paypalobjects.com/zh_TW/TW/i/btn/btn_buynow_LG.gif";
					$pp_imagecc = "https://www.paypalobjects.com/zh_TW/TW/i/btn/btn_buynowCC_LG.gif";
					$pp_imagenew = "https://www.paypalobjects.com/webstatic/en_US/i/buttons/buy-logo-medium.png";
				} //Traditional Chinese - Taiwan
			
				if ($packageType['pplng'] == "18") {
					$pp_image = "https://www.paypalobjects.com/tr_TR/i/btn/btn_buynow_SM.gif";
					$pp_imageb = "https://www.paypalobjects.com/tr_TR/i/btn/btn_buynow_LG.gif";
					$pp_imagecc = "https://www.paypalobjects.com/tr_TR/TR/i/btn/btn_buynowCC_LG.gif";
					$pp_imagenew = "https://www.paypalobjects.com/webstatic/en_US/i/buttons/buy-logo-medium.png";
				} //Turkish
			
				if ($packageType['pplng'] == "19") {
					$pp_image = "https://www.paypalobjects.com/th_TH/i/btn/btn_buynow_SM.gif";
					$pp_imageb = "https://www.paypalobjects.com/th_TH/i/btn/btn_buynow_LG.gif";
					$pp_imagecc = "https://www.paypalobjects.com/th_TH/TH/i/btn/btn_buynowCC_LG.gif";
					$pp_imagenew = "https://www.paypalobjects.com/webstatic/en_US/i/buttons/buy-logo-medium.png";
				} //Thai
			}
			// image size
			if ($packageType['ppbsz'] == "1") { $pp_img = $pp_image; }
			if ($packageType['ppbsz'] == "2") { $pp_img = $pp_imageb; }
			if ($packageType['ppbsz'] == "3") { $pp_img = $pp_imagecc; }
			if ($packageType['ppbsz'] == "4") { $pp_img = $pp_imagenew; }
			// window action
			if ($p_combo['nltab'] != "yes") { $pp_target = ""; }
			else { $pp_target = "_blank"; }
			$pp_note = "";
		}
		if(($j < 1 || $j % $maximum_column == 0) && $j <= $p_count) {
			$i = 1;
			/* If package column and feature caption column is enable */
			if($p_combo['ftcap'] == "yes" && $packageType['pdisp'] == "show") { ?>
				<div class="package_caption">
					<ul>
                        <li class="pricing_table_title"><?php if(($p_combo['hprice'] == 'yes' || $p_combo['btompr'] == 'yes') && $p_combo['envid'] != 'yes' && $p_combo['enimg'] != 'yes') { ?><h3 class="caption"><?php echo ucwords(str_replace('_', ' ', $t_name)); ?></h3><?php } ?></li>
                        <li class="pricing_table_plan">
                            <h3 class="caption"><?php echo ucwords(str_replace('_', ' ', $t_name)); ?></h3>
                        </li>
<?php
				if($p_combo['topbut'] == 'yes') { ?>
                        <li class="pricing_table_button"></li>
<?php
				}
				$p_feature['fcate0'] = '';
				$pf = 0;
				for($tf = 1; $tf <= $tot_feat; $tf++) {
					if($p_combo['enicon'] == "yes" && $p_feature['fasom'.$i] != '') {
						$fa_class = $p_feature['fasom'.$i];
						$fa_icon = '<span class="fa-icon"><i class="'.$fa_class.' fa-lg"></i></span>';
					} else { $fa_icon = ''; }
					if($p_combo['entips'] == "yes" && $p_feature['fdesc'.$i] != '') {
						$cap_tooltip = '<span class="cap_tooltip" rel="'.$p_feature['fdesc'.$i].'"><i class="fas fa-info-circle"></i></span>';
					} else { $cap_tooltip = ''; }
					if($i % 2 == 0) {
						if($i == $tot_feat) {
							if($p_combo['ftcap'] == 'yes' && $p_combo['encate'] == 'yes' && $p_feature['fcate'.$tf] != $p_feature['fcate'.$pf]) { ?>
                        <li class="feature_cate_row"><span class="feat_cate"><?php echo $p_feature['fcate'.$tf]; ?></span></li>
<?php
							} ?>
						<li class="feature_style_2 bottom_left"><div class="caption_lists"><?php echo $fa_icon; ?><span class="caption"><?php if($p_feature['flink'.$tf] != ''){ ?><a href="<?php echo $p_feature['flink'.$tf]; ?>"<?php if($p_combo['nltab'] == 'yes') { ?> target="_blank"<?php } ?>><?php echo $p_feature['fitem'.$tf]; ?></a><?php } else { echo $p_feature['fitem'.$tf]; } ?></span><?php echo $cap_tooltip; ?></div></li>
<?php
						} else {
							if($p_combo['ftcap'] == 'yes' && $p_combo['encate'] == 'yes' && $p_feature['fcate'.$tf] != $p_feature['fcate'.$pf]) { ?>
                        <li class="feature_cate_row"><span class="feat_cate"><?php echo $p_feature['fcate'.$tf]; ?></span></li>
<?php
							} ?>
						<li class="feature_style_2">
                        	<div class="caption_lists"><?php echo $fa_icon; ?><span class="caption"><?php if($p_feature['flink'.$tf] != ''){ ?><a href="<?php echo $p_feature['flink'.$tf]; ?>"<?php if($p_combo['nltab'] == 'yes') { ?> target="_blank"<?php } ?>><?php echo $p_feature['fitem'.$tf]; ?></a><?php } else { echo $p_feature['fitem'.$tf]; } ?></span><?php echo $cap_tooltip; ?></div>
                        </li>
<?php
						}
					} else {
						if($i == 1) {
							if($p_combo['ftcap'] == 'yes' && $p_combo['encate'] == 'yes' && $p_feature['fcate'.$tf] != $p_feature['fcate'.$pf]) { ?><li class="feature_cate_row top_left"><span class="feat_cate"><?php echo $p_feature['fcate'.$tf]; ?></span></li>
<?php
							} ?>
						<li class="feature_style_3<?php if($p_combo['encate'] != 'yes') { echo ' top_left'; } ?>">
                        	<div class="caption_lists"><?php echo $fa_icon; ?><span class="caption"><?php if($p_feature['flink'.$tf] != ''){ ?><a href="<?php echo $p_feature['flink'.$tf]; ?>"<?php if($p_combo['nltab'] == 'yes') { ?> target="_blank"<?php } ?>><?php echo $p_feature['fitem'.$tf]; ?></a><?php } else { echo $p_feature['fitem'.$tf]; } ?></span><?php echo $cap_tooltip; ?></div>
                        </li>
<?php
						} elseif($i == $tot_feat) {
							if($p_combo['ftcap'] == 'yes' && $p_combo['encate'] == 'yes' && $p_feature['fcate'.$tf] != $p_feature['fcate'.$pf]) { ?>
                        <li class="feature_cate_row"><span class="feat_cate"><?php echo $p_feature['fcate'.$tf]; ?></span></li>
<?php
							} ?>
						<li class="feature_style_3 bottom_left"><div class="caption_lists"><?php echo $fa_icon; ?><span class="caption"><?php if($p_feature['flink'.$tf] != ''){ ?><a href="<?php echo $p_feature['flink'.$tf]; ?>"<?php if($p_combo['nltab'] == 'yes') { ?> target="_blank"<?php } ?>><?php echo $p_feature['fitem'.$tf]; ?></a><?php } else { echo $p_feature['fitem'.$tf]; } ?></span><?php echo $cap_tooltip; ?></div></li>
<?php
						} else {
							if($p_combo['ftcap'] == 'yes' && $p_combo['encate'] == 'yes' && $p_feature['fcate'.$tf] != $p_feature['fcate'.$pf]) { ?>
                        <li class="feature_cate_row"><span class="feat_cate"><?php echo $p_feature['fcate'.$tf]; ?></span></li>
<?php
							} ?>
						<li class="feature_style_3"><div class="caption_lists"><?php echo $fa_icon; ?><span class="caption"><?php if($p_feature['flink'.$tf] != ''){ ?><a href="<?php echo $p_feature['flink'.$tf]; ?>"<?php if($p_combo['nltab'] == 'yes') { ?> target="_blank"<?php } ?>><?php echo $p_feature['fitem'.$tf]; ?></a><?php } else { echo $p_feature['fitem'.$tf]; } ?></span><?php echo $cap_tooltip; ?></div></li>
<?php
						}
					} $i++; $pf++;
				} ?>
					</ul>
				</div>
<?php
			}
		}
		/**
		 * Set video player height for special package and regular packgae
		 * also set video player height for price at bottom and top
		 */
		if($packageType['spack'] == 'yes') {
			if($p_combo['envid'] == 'yes' && ($p_combo['opvid'] == 'vid-1' || $p_combo['opvid'] == 'vid-2')) {
				if($p_combo['btompr'] == 'yes') {
					$video_player_height = $video_box_height;
				} else {
					$video_player_height = $video_box_height + 20;
				}
			} else {
				if($p_combo['btompr'] == 'yes') {
					$video_player_height = $video_box_height + 20;
				} else {
					$video_player_height = $video_box_height + 40;
				}
			}
		} else {
			$video_player_height = $video_box_height;
		}
		/**
		 * Set background gradient for title, price and button body
		 */
		if($p_combo['ttgrd'] == 'yes') { $tlight = wrcpt_adjustBrightness($packageType['tbcolor'], 0); }
		else { $tlight = wrcpt_adjustBrightness($packageType['tbcolor'], 50); }
		if($p_combo['prgrd'] == 'yes') { $pdark = wrcpt_adjustBrightness($packageType['pbcolor'], 0); }
		else { $pdark = wrcpt_adjustBrightness($packageType['pbcolor'], 20); }
		$blight = wrcpt_adjustBrightness($packageType['bcolor'], 50);
		$bdark = wrcpt_adjustBrightness($packageType['bhover'], 20);
		$bhlight = wrcpt_adjustBrightness($packageType['bhover'], 50);
		if($p_combo['dsgrd'] == 'yes') { $bbdark = wrcpt_adjustBrightness($packageType['bbcolor'], 0); }
		else { $bbdark = wrcpt_adjustBrightness($packageType['bbcolor'], 20); }
		$rlight = wrcpt_adjustBrightness($packageType['rbcolor'], 80);
		$rdark = wrcpt_adjustBrightness($packageType['rbcolor'], 20);
		$bdlight = wrcpt_adjustBrightness($packageType['ftborder'], 50);
		$i = 1;

		/* If package column is enable */
		if($packageType['pdisp'] == 'show') : ?>
                <!-- Package Column Start -->
                <div class="package_details<?php if($p_combo['etclr'] == 'yes') { echo ' details-'.$packageType['pid']; } else { echo ' package-'.$packageType['pid']; } ?><?php if($packageType['spack'] == 'yes') { echo ' special-package'; } ?>">
                    <ul>
<?php
			/* Ribbon Start */
			if($p_combo['enribs'] == "yes" && $packageType['rtext'] != '') :
				if($p_combo['markrib'] == 'rb-5') :
					if($p_combo['btompr'] != "yes" || ($p_combo['enimg'] == "yes" && $p_combo['bgimg'] != 'yes') || $p_combo['envid'] == "yes") : ?>
                        <li>
                            <div class="corner-ribbon rcon-color-<?php echo $packageType['pid']; ?>"><a href="#"><?php echo $packageType['rtext']; ?></a></div>
                        </li>
<?php
					endif;
				elseif($p_combo['markrib'] == 'rb-4') :
					if($p_combo['btompr'] != "yes" || ($p_combo['enimg'] == "yes" && $p_combo['bgimg'] != 'yes') || $p_combo['envid'] == "yes") : ?>
                        <li>
                            <div class="ribbon-banner rban-color-<?php echo $packageType['pid']; ?>"><a href="#" id="ribbon"><?php echo $packageType['rtext']; ?></a></div>
                        </li>
<?php
					endif;
				elseif($p_combo['markrib'] == 'rb-3') : ?>
                        <li>
                            <div class="ribbon-corner ribbon-color-<?php echo $packageType['pid']; ?>"><span><?php echo $packageType['rtext']; ?></span></div>
                        </li>
<?php
				elseif($p_combo['markrib'] == 'rb-2') :
					if($p_combo['btompr'] != "yes" || ($p_combo['enimg'] == "yes" && $p_combo['bgimg'] != 'yes') || $p_combo['envid'] == "yes") : ?>
                        <li>
                        	<span class="ribbon-container rc-color-<?php echo $packageType['pid']; ?>"><?php echo $packageType['rtext']; ?></span>
                        </li>
<?php
					endif;
				else :
					if($p_combo['btompr'] != "yes" || ($p_combo['enimg'] == "yes" && $p_combo['bgimg'] != 'yes') || $p_combo['envid'] == "yes") : ?>
                        <li>
                            <div class="wrc-ribbon ribbon_color-<?php echo $packageType['pid']; ?>">
                                <a href="#" id="wrc-ribbon"><?php echo $packageType['rtext']; ?></a>
                            </div>
                        </li>
<?php
					endif;
				endif;
			endif;
			/* Ribbon End */
			/* Image Start */
			if($p_combo['enimg'] == 'yes' && $p_combo['bgimg'] != 'yes') {
				/* Return an ID of an attachment by searching the database with the file URL. */
				$image_id = wrcpt_get_attachment_id_by_url($packageType['pimg']); ?>
<?php
				if($p_combo['opimg'] == 'opt-1') { ?>
                        <li class="pricing_table_title color-<?php echo $packageType['pid']; ?> title_top_radius">
                            <h3 class="package_type txcolor-<?php echo $packageType['pid']; ?>"><?php echo $packageType['type']; ?><span class="package_desc"><?php echo $packageType['tdesc']; ?></span></h3>
                        </li>
                        <li class="pricing_table_plan plan-<?php echo $packageType['pid']; ?> top_price"><?php
					if ( wp_get_attachment_image($image_id) ) {
						if($p_combo['imgwid']) {
							echo wp_get_attachment_image( $image_id, 'pack-wide' );
						} else {
							echo wp_get_attachment_image( $image_id, 'full' );
						}
					} else {
                    	if($packageType['pimg'] == '') { ?>
                        	<img src="<?php echo 'https://www.realwebcare.com/images/bg/pricing_table_'.$p_combo['templ'].'_'.$packageType['pid'].'.png'; ?>" alt="pricing-table-image" /><?php
						} else { ?>
							<img src="<?php echo $packageType['pimg']; ?>" alt="pricing-table-image" /><?php
						} ?>
<?php
					} ?>

							<h2 class="package_plan txcolor-<?php echo $packageType['pid']; ?>">
<?php
							// Price Toggle
							if($p_combo['mcurr'] == 'yes') { ?>
								<div class="price-toggle-one">
<?php
									if($packageType['cutpr'] != '') { ?><span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?><?php echo $packageType['cutpr']; ?><?php if($packageType['cutfr']) echo '.'.$packageType['cutfr']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									} ?>
<?php
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['price']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['cent'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
<?php
									if($packageType['cent']) { ?>
									<span class="cent"><?php echo '.'.$packageType['cent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['plan']; ?></span>
								</div>
								<div class="price-toggle-two">
<?php
								if($packageType['enptg'] == 'show') { ?>
<?php
									if($packageType['tgcut'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['tgunit']; ?><?php } ?><?php echo $packageType['tgcut']; ?><?php if($packageType['tgcutfr']) { echo '.'.$packageType['tgcutfr']; } ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunit']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['tgunit']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['tgprice']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['tgcent'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['tgunit']; ?></span>
<?php
									} ?>
<?php
									if($packageType['tgcent']) { ?>
									<span class="cent"><?php echo '.'.$packageType['tgcent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunit']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['tgplan']; ?></span>
<?php
								} else { ?>
<?php
									if($packageType['cutpr'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?><?php echo $packageType['cutpr']; ?><?php if($packageType['cutfr']) echo '.'.$packageType['cutfr']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['price']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['cent'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
<?php
									if($packageType['cent']) { ?>
									<span class="cent"><?php echo '.'.$packageType['cent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['plan']; ?></span>
<?php
								} ?>
								</div><?php
								if($p_combo['togg3'] == 'yes') { ?>
								<div class="price-toggle-three">
<?php
								if($packageType['enptg'] == 'show') { ?>
<?php
									if($packageType['tgcut2'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['tgunt2']; ?><?php } ?><?php echo $packageType['tgcut2']; ?><?php if($packageType['tgcfr2']) { echo '.'.$packageType['tgcfr2']; } ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunt2']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['tgunt2']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['tgprc2']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['tgcnt2'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['tgunt2']; ?></span>
<?php
									} ?>
<?php
									if($packageType['tgcnt2']) { ?>
									<span class="cent"><?php echo '.'.$packageType['tgcnt2']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunt2']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['tgpln2']; ?></span>
<?php
								} else { ?>
<?php
									if($packageType['cutpr'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?><?php echo $packageType['cutpr']; ?><?php if($packageType['cutfr']) echo '.'.$packageType['cutfr']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['price']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['cent'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
<?php
									if($packageType['cent']) { ?>
									<span class="cent"><?php echo '.'.$packageType['cent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['plan']; ?></span>
<?php
								} ?>
                                </div><?php
								}
								if(isset($p_combo['togg4']) && $p_combo['togg4'] == 'yes') { ?>
								<div class="price-toggle-four">
<?php
								if($packageType['enptg'] == 'show') { ?>
<?php
									if($packageType['tgcut3'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['tgunt3']; ?><?php } ?><?php echo $packageType['tgcut3']; ?><?php if($packageType['tgcfr3']) { echo '.'.$packageType['tgcfr3']; } ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunt3']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['tgunt3']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['tgprc3']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['tgcnt3'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['tgunt3']; ?></span>
<?php
									} ?>
<?php
									if($packageType['tgcnt3']) { ?>
									<span class="cent"><?php echo '.'.$packageType['tgcnt3']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunt3']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['tgpln3']; ?></span>
<?php
								} else { ?>
<?php
									if($packageType['cutpr'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?><?php echo $packageType['cutpr']; ?><?php if($packageType['cutfr']) echo '.'.$packageType['cutfr']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['price']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['cent'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
<?php
									if($packageType['cent']) { ?>
									<span class="cent"><?php echo '.'.$packageType['cent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['plan']; ?></span>
<?php
								} ?>
                                </div><?php
								}
							// No Toggle
							} else {
								if($packageType['cutpr'] != '') { ?>
                                <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?><?php echo $packageType['cutpr']; ?><?php if($packageType['cutfr']) echo '.'.$packageType['cutfr']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
								}
								if($p_combo['purgt'] != 'yes') { ?>
								<span class="unit"><?php echo $packageType['unit']; ?></span>
<?php
								} ?>
								<span class="price"><?php echo $packageType['price']; ?></span>
<?php
								if($p_combo['purgt'] == 'yes' && $packageType['cent'] == '') { ?>
								<span class="unit unit_right"><?php echo $packageType['unit']; ?></span>
<?php
								} ?>
<?php
								if($packageType['cent']) { ?>
								<span class="cent"><?php echo '.'.$packageType['cent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
								} ?>
								<span class="plan"><?php echo $packageType['plan']; ?></span>
<?php
							} ?>
							<span class="price_desc"><?php echo $packageType['pdesc']; ?></span>
							</h2>
						</li>
<?php
				} elseif($p_combo['opimg'] == 'opt-2') { ?>
                        <li class="pricing_table_title color-<?php echo $packageType['pid']; ?> title_top_radius">
                            <h3 class="package_type txcolor-<?php echo $packageType['pid']; ?>"><?php echo $packageType['type']; ?><span class="package_desc"><?php echo $packageType['tdesc']; ?></span></h3>
                        </li>
<?php
						if($p_combo['crlepr'] == 'yes') { ?>
                        <li class="pricing_table_plan plan-<?php echo $packageType['pid']; ?> top_price img_circle">
<?php
						} else { ?>
                        <li class="pricing_table_plan plan-<?php echo $packageType['pid']; ?> top_price">
<?php
						}
					if ( wp_get_attachment_image($image_id) ) {
						if($p_combo['imgwid']) {
							echo wp_get_attachment_image( $image_id, 'pack-wide' );
						} else {
							echo wp_get_attachment_image( $image_id, 'full' );
						}
					} else {
                    	if($packageType['pimg'] == '') { ?>
                        	<img src="<?php echo 'https://www.realwebcare.com/images/bg/pricing_table_'.$p_combo['templ'].'_'.$packageType['pid'].'.png'; ?>" alt="pricing-table-image" /><?php
						} else { ?>
							<img src="<?php echo $packageType['pimg']; ?>" alt="pricing-table-image" /><?php
						} ?>
<?php
					} ?>

                        </li>
<?php
				} elseif($p_combo['opimg'] == 'opt-3') { ?>
						<li class="pricing_table_plan plan-<?php echo $packageType['pid']; ?> top_price"><?php
					if ( wp_get_attachment_image($image_id) ) {
						if($p_combo['imgwid']) {
							echo wp_get_attachment_image( $image_id, 'full-pack' );
						} else {
							echo wp_get_attachment_image( $image_id, 'full' );
						}
					} else {
                    	if($packageType['pimg'] == '') { ?>
                        	<img src="<?php echo 'https://www.realwebcare.com/images/bg/pricing_table_'.$p_combo['templ'].'_'.$packageType['pid'].'.png'; ?>" alt="pricing-table-image" /><?php
						} else { ?>
							<img src="<?php echo $packageType['pimg']; ?>" alt="pricing-table-image" /><?php
						} ?>
<?php
					} ?>

							<h2 class="package_plan txcolor-<?php echo $packageType['pid']; ?>">
<?php
							// Price Toggle
							if($p_combo['mcurr'] == 'yes') { ?>
								<div class="price-toggle-one">
<?php
									if($packageType['cutpr'] != '') { ?><span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?><?php echo $packageType['cutpr']; ?><?php if($packageType['cutfr']) echo '.'.$packageType['cutfr']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									} ?>
<?php
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['price']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['cent'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
<?php
									if($packageType['cent']) { ?>
									<span class="cent"><?php echo '.'.$packageType['cent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['plan']; ?></span>
								</div>
								<div class="price-toggle-two">
<?php
								if($packageType['enptg'] == 'show') { ?>
<?php
									if($packageType['tgcut'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['tgunit']; ?><?php } ?><?php echo $packageType['tgcut']; ?><?php if($packageType['tgcutfr']) { echo '.'.$packageType['tgcutfr']; } ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunit']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['tgunit']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['tgprice']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['tgcent'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['tgunit']; ?></span>
<?php
									} ?>
<?php
									if($packageType['tgcent']) { ?>
									<span class="cent"><?php echo '.'.$packageType['tgcent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunit']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['tgplan']; ?></span>
<?php
								} else { ?>
<?php
									if($packageType['cutpr'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?><?php echo $packageType['cutpr']; ?><?php if($packageType['cutfr']) echo '.'.$packageType['cutfr']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['price']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['cent'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
<?php
									if($packageType['cent']) { ?>
									<span class="cent"><?php echo '.'.$packageType['cent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['plan']; ?></span>
<?php
								} ?>
								</div><?php
								if($p_combo['togg3'] == 'yes') { ?>
								<div class="price-toggle-three">
<?php
								if($packageType['enptg'] == 'show') { ?>
<?php
									if($packageType['tgcut2'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['tgunt2']; ?><?php } ?><?php echo $packageType['tgcut2']; ?><?php if($packageType['tgcfr2']) { echo '.'.$packageType['tgcfr2']; } ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunt2']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['tgunt2']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['tgprc2']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['tgcnt2'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['tgunt2']; ?></span>
<?php
									} ?>
<?php
									if($packageType['tgcnt2']) { ?>
									<span class="cent"><?php echo '.'.$packageType['tgcnt2']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunt2']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['tgpln2']; ?></span>
<?php
								} else { ?>
<?php
									if($packageType['cutpr'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?><?php echo $packageType['cutpr']; ?><?php if($packageType['cutfr']) echo '.'.$packageType['cutfr']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['price']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['cent'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
<?php
									if($packageType['cent']) { ?>
									<span class="cent"><?php echo '.'.$packageType['cent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['plan']; ?></span>
<?php
								} ?>
                                </div><?php
								}
								if(isset($p_combo['togg4']) && $p_combo['togg4'] == 'yes') { ?>
								<div class="price-toggle-four">
<?php
								if($packageType['enptg'] == 'show') { ?>
<?php
									if($packageType['tgcut3'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['tgunt3']; ?><?php } ?><?php echo $packageType['tgcut3']; ?><?php if($packageType['tgcfr3']) { echo '.'.$packageType['tgcfr3']; } ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunt3']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['tgunt3']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['tgprc3']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['tgcnt3'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['tgunt3']; ?></span>
<?php
									} ?>
<?php
									if($packageType['tgcnt3']) { ?>
									<span class="cent"><?php echo '.'.$packageType['tgcnt3']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunt3']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['tgpln3']; ?></span>
<?php
								} else { ?>
<?php
									if($packageType['cutpr'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?><?php echo $packageType['cutpr']; ?><?php if($packageType['cutfr']) echo '.'.$packageType['cutfr']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['price']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['cent'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
<?php
									if($packageType['cent']) { ?>
									<span class="cent"><?php echo '.'.$packageType['cent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['plan']; ?></span>
<?php
								} ?>
                                </div><?php
								}
							// No Toggle
							} else {
								if($packageType['cutpr'] != '') { ?>
                                <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?><?php echo $packageType['cutpr']; ?><?php if($packageType['cutfr']) echo '.'.$packageType['cutfr']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
								}
								if($p_combo['purgt'] != 'yes') { ?>
								<span class="unit"><?php echo $packageType['unit']; ?></span>
<?php
								} ?>
								<span class="price"><?php echo $packageType['price']; ?></span>
<?php
								if($p_combo['purgt'] == 'yes' && $packageType['cent'] == '') { ?>
								<span class="unit unit_right"><?php echo $packageType['unit']; ?></span>
<?php
								} ?>
<?php
								if($packageType['cent']) { ?>
								<span class="cent"><?php echo '.'.$packageType['cent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
								} ?>
								<span class="plan"><?php echo $packageType['plan']; ?></span>
<?php
							} ?>
								<span class="price_desc"><?php echo $packageType['pdesc']; ?></span>
							</h2>
						</li>
<?php
				} else {
					if($p_combo['crlepr'] == 'yes') { ?>
                        <li class="pricing_table_plan plan-<?php echo $packageType['pid']; ?> top_price img_circle">
<?php
					} else { ?>
                        <li class="pricing_table_plan plan-<?php echo $packageType['pid']; ?> top_price">
<?php
					}
					if ( wp_get_attachment_image($image_id) ) {
						if($p_combo['imgwid']) {
							echo wp_get_attachment_image( $image_id, 'full-pack' );
						} else {
							echo wp_get_attachment_image( $image_id, 'full' );
						}
					} else {
                    	if($packageType['pimg'] == '') { ?>
                        	<img src="<?php echo 'https://www.realwebcare.com/images/bg/pricing_table_'.$p_combo['templ'].'_'.$packageType['pid'].'.png'; ?>" alt="pricing-table-image" /><?php
						} else { ?>
							<img src="<?php echo $packageType['pimg']; ?>" alt="pricing-table-image" /><?php
						} ?>
<?php
					} ?></li>
<?php
				}
			/* Image End */
			/* Video Start */
			} elseif($p_combo['envid'] == 'yes') {
				if($p_combo['opvid'] == 'vid-1') { ?>
                        <li class="pricing_table_title color-<?php echo $packageType['pid']; ?> title_top_radius">
                            <h3 class="package_type txcolor-<?php echo $packageType['pid']; ?>"><?php echo $packageType['type']; ?><span class="package_desc"><?php echo $packageType['tdesc']; ?></span></h3>
                        </li>
                        <li class="pricing_table_video video-<?php echo $packageType['pid']; ?>">
                            <iframe width="100%" height="<?php echo $video_player_height; ?>" src="//www.youtube.com/embed/<?php echo wrcpt_parse_yturl($packageType['pvid']); ?>?rel=0&amp;controls=1&amp;<?php if($p_combo['mbrand'] == 'yes') { ?>modestbranding=0<?php } else { ?>modestbranding=1<?php } ?>&amp;autohide=1&amp;autoplay=0" marginheight="0" marginwidth="0" frameborder="0" <?php if($p_combo['vfscr'] == 'yes') { echo 'allowfullscreen'; } ?>></iframe>
                        </li>
                        <li class="pricing_table_plan plan-<?php echo $packageType['pid']; ?> top_price">
							<h2 class="package_plan txcolor-<?php echo $packageType['pid']; ?>">
<?php
							// Price Toggle
							if($p_combo['mcurr'] == 'yes') { ?>
								<div class="price-toggle-one">
<?php
									if($packageType['cutpr'] != '') { ?><span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?><?php echo $packageType['cutpr']; ?><?php if($packageType['cutfr']) echo '.'.$packageType['cutfr']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									} ?>
<?php
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['price']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['cent'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
<?php
									if($packageType['cent']) { ?>
									<span class="cent"><?php echo '.'.$packageType['cent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['plan']; ?></span>
								</div>
								<div class="price-toggle-two">
<?php
								if($packageType['enptg'] == 'show') { ?>
<?php
									if($packageType['tgcut'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['tgunit']; ?><?php } ?><?php echo $packageType['tgcut']; ?><?php if($packageType['tgcutfr']) { echo '.'.$packageType['tgcutfr']; } ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunit']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['tgunit']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['tgprice']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['tgcent'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['tgunit']; ?></span>
<?php
									} ?>
<?php
									if($packageType['tgcent']) { ?>
									<span class="cent"><?php echo '.'.$packageType['tgcent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunit']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['tgplan']; ?></span>
<?php
								} else { ?>
<?php
									if($packageType['cutpr'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?><?php echo $packageType['cutpr']; ?><?php if($packageType['cutfr']) echo '.'.$packageType['cutfr']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['price']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['cent'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
<?php
									if($packageType['cent']) { ?>
									<span class="cent"><?php echo '.'.$packageType['cent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['plan']; ?></span>
<?php
								} ?>
								</div><?php
								if($p_combo['togg3'] == 'yes') { ?>
								<div class="price-toggle-three">
<?php
								if($packageType['enptg'] == 'show') { ?>
<?php
									if($packageType['tgcut2'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['tgunt2']; ?><?php } ?><?php echo $packageType['tgcut2']; ?><?php if($packageType['tgcfr2']) { echo '.'.$packageType['tgcfr2']; } ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunt2']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['tgunt2']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['tgprc2']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['tgcnt2'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['tgunt2']; ?></span>
<?php
									} ?>
<?php
									if($packageType['tgcnt2']) { ?>
									<span class="cent"><?php echo '.'.$packageType['tgcnt2']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunt2']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['tgpln2']; ?></span>
<?php
								} else { ?>
<?php
									if($packageType['cutpr'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?><?php echo $packageType['cutpr']; ?><?php if($packageType['cutfr']) echo '.'.$packageType['cutfr']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['price']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['cent'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
<?php
									if($packageType['cent']) { ?>
									<span class="cent"><?php echo '.'.$packageType['cent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['plan']; ?></span>
<?php
								} ?>
                                </div><?php
								}
								if(isset($p_combo['togg4']) && $p_combo['togg4'] == 'yes') { ?>
								<div class="price-toggle-four">
<?php
								if($packageType['enptg'] == 'show') { ?>
<?php
									if($packageType['tgcut3'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['tgunt3']; ?><?php } ?><?php echo $packageType['tgcut3']; ?><?php if($packageType['tgcfr3']) { echo '.'.$packageType['tgcfr3']; } ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunt3']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['tgunt3']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['tgprc3']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['tgcnt3'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['tgunt3']; ?></span>
<?php
									} ?>
<?php
									if($packageType['tgcnt3']) { ?>
									<span class="cent"><?php echo '.'.$packageType['tgcnt3']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunt3']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['tgpln3']; ?></span>
<?php
								} else { ?>
<?php
									if($packageType['cutpr'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?><?php echo $packageType['cutpr']; ?><?php if($packageType['cutfr']) echo '.'.$packageType['cutfr']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['price']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['cent'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
<?php
									if($packageType['cent']) { ?>
									<span class="cent"><?php echo '.'.$packageType['cent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['plan']; ?></span>
<?php
								} ?>
                                </div><?php
								}
							// No Toggle
							} else {
								if($packageType['cutpr'] != '') { ?>
                                <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?><?php echo $packageType['cutpr']; ?><?php if($packageType['cutfr']) echo '.'.$packageType['cutfr']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
								}
								if($p_combo['purgt'] != 'yes') { ?>
								<span class="unit"><?php echo $packageType['unit']; ?></span>
<?php
								} ?>
								<span class="price"><?php echo $packageType['price']; ?></span>
<?php
								if($p_combo['purgt'] == 'yes' && $packageType['cent'] == '') { ?>
								<span class="unit unit_right"><?php echo $packageType['unit']; ?></span>
<?php
								} ?>
<?php
								if($packageType['cent']) { ?>
								<span class="cent"><?php echo '.'.$packageType['cent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
								} ?>
								<span class="plan"><?php echo $packageType['plan']; ?></span>
<?php
							} ?>
								<span class="price_desc"><?php echo $packageType['pdesc']; ?></span>
							</h2>
						</li>
<?php
				} elseif($p_combo['opvid'] == 'vid-2') { ?>
                        <li class="pricing_table_title color-<?php echo $packageType['pid']; ?> title_top_radius">
                            <h3 class="package_type txcolor-<?php echo $packageType['pid']; ?>"><?php echo $packageType['type']; ?><span class="package_desc"><?php echo $packageType['tdesc']; ?></span></h3>
                        </li>
                        <li class="pricing_table_video video-<?php echo $packageType['pid']; ?>">
                            <iframe width="100%" height="<?php echo $video_player_height; ?>" src="//www.youtube.com/embed/<?php echo wrcpt_parse_yturl($packageType['pvid']); ?>?rel=0&amp;controls=1&amp;<?php if($p_combo['mbrand'] == 'yes') { ?>modestbranding=0<?php } else { ?>modestbranding=1<?php } ?>&amp;autohide=1&amp;autoplay=0" marginheight="0" marginwidth="0" frameborder="0" <?php if($p_combo['vfscr'] == 'yes') { echo 'allowfullscreen'; } ?>></iframe>
                        </li>
<?php
				} elseif($p_combo['opvid'] == 'vid-3') { ?>
                        <li class="pricing_table_video video-<?php echo $packageType['pid']; ?>">
                            <iframe width="100%" height="<?php echo $video_player_height; ?>" src="//www.youtube.com/embed/<?php echo wrcpt_parse_yturl($packageType['pvid']); ?>?rel=0&amp;controls=1&amp;<?php if($p_combo['mbrand'] == 'yes') { ?>modestbranding=0<?php } else { ?>modestbranding=1<?php } ?>&amp;autohide=1&amp;autoplay=0" marginheight="0" marginwidth="0" frameborder="0" <?php if($p_combo['vfscr'] == 'yes') { echo 'allowfullscreen'; } ?>></iframe>
                        </li>
                        <li class="pricing_table_plan plan-<?php echo $packageType['pid']; ?> top_price">
							<h2 class="package_plan txcolor-<?php echo $packageType['pid']; ?>">
<?php
							// Price Toggle
							if($p_combo['mcurr'] == 'yes') { ?>
								<div class="price-toggle-one">
<?php
									if($packageType['cutpr'] != '') { ?><span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?><?php echo $packageType['cutpr']; ?><?php if($packageType['cutfr']) echo '.'.$packageType['cutfr']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									} ?>
<?php
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['price']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['cent'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
<?php
									if($packageType['cent']) { ?>
									<span class="cent"><?php echo '.'.$packageType['cent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['plan']; ?></span>
								</div>
								<div class="price-toggle-two">
<?php
								if($packageType['enptg'] == 'show') { ?>
<?php
									if($packageType['tgcut'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['tgunit']; ?><?php } ?><?php echo $packageType['tgcut']; ?><?php if($packageType['tgcutfr']) { echo '.'.$packageType['tgcutfr']; } ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunit']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['tgunit']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['tgprice']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['tgcent'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['tgunit']; ?></span>
<?php
									} ?>
<?php
									if($packageType['tgcent']) { ?>
									<span class="cent"><?php echo '.'.$packageType['tgcent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunit']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['tgplan']; ?></span>
<?php
								} else { ?>
<?php
									if($packageType['cutpr'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?><?php echo $packageType['cutpr']; ?><?php if($packageType['cutfr']) echo '.'.$packageType['cutfr']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['price']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['cent'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
<?php
									if($packageType['cent']) { ?>
									<span class="cent"><?php echo '.'.$packageType['cent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['plan']; ?></span>
<?php
								} ?>
								</div><?php
								if($p_combo['togg3'] == 'yes') { ?>
								<div class="price-toggle-three">
<?php
								if($packageType['enptg'] == 'show') { ?>
<?php
									if($packageType['tgcut2'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['tgunt2']; ?><?php } ?><?php echo $packageType['tgcut2']; ?><?php if($packageType['tgcfr2']) { echo '.'.$packageType['tgcfr2']; } ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunt2']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['tgunt2']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['tgprc2']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['tgcnt2'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['tgunt2']; ?></span>
<?php
									} ?>
<?php
									if($packageType['tgcnt2']) { ?>
									<span class="cent"><?php echo '.'.$packageType['tgcnt2']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunt2']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['tgpln2']; ?></span>
<?php
								} else { ?>
<?php
									if($packageType['cutpr'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?><?php echo $packageType['cutpr']; ?><?php if($packageType['cutfr']) echo '.'.$packageType['cutfr']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['price']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['cent'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
<?php
									if($packageType['cent']) { ?>
									<span class="cent"><?php echo '.'.$packageType['cent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['plan']; ?></span>
<?php
								} ?>
                                </div><?php
								}
								if(isset($p_combo['togg4']) && $p_combo['togg4'] == 'yes') { ?>
								<div class="price-toggle-four">
<?php
								if($packageType['enptg'] == 'show') { ?>
<?php
									if($packageType['tgcut3'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['tgunt3']; ?><?php } ?><?php echo $packageType['tgcut3']; ?><?php if($packageType['tgcfr3']) { echo '.'.$packageType['tgcfr3']; } ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunt3']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['tgunt3']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['tgprc3']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['tgcnt3'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['tgunt3']; ?></span>
<?php
									} ?>
<?php
									if($packageType['tgcnt3']) { ?>
									<span class="cent"><?php echo '.'.$packageType['tgcnt3']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunt3']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['tgpln3']; ?></span>
<?php
								} else { ?>
<?php
									if($packageType['cutpr'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?><?php echo $packageType['cutpr']; ?><?php if($packageType['cutfr']) echo '.'.$packageType['cutfr']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['price']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['cent'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
<?php
									if($packageType['cent']) { ?>
									<span class="cent"><?php echo '.'.$packageType['cent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['plan']; ?></span>
<?php
								} ?>
                                </div><?php
								}
							// No Toggle
							} else {
								if($packageType['cutpr'] != '') { ?>
                                <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?><?php echo $packageType['cutpr']; ?><?php if($packageType['cutfr']) echo '.'.$packageType['cutfr']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
								}
								if($p_combo['purgt'] != 'yes') { ?>
								<span class="unit"><?php echo $packageType['unit']; ?></span>
<?php
								} ?>
								<span class="price"><?php echo $packageType['price']; ?></span>
<?php
								if($p_combo['purgt'] == 'yes' && $packageType['cent'] == '') { ?>
								<span class="unit unit_right"><?php echo $packageType['unit']; ?></span>
<?php
								} ?>
<?php
								if($packageType['cent']) { ?>
								<span class="cent"><?php echo '.'.$packageType['cent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
								} ?>
								<span class="plan"><?php echo $packageType['plan']; ?></span>
<?php
							} ?>
								<span class="price_desc"><?php echo $packageType['pdesc']; ?></span>
							</h2>
						</li>
<?php
				} else { ?>
                        <li class="pricing_table_video video-<?php echo $packageType['pid']; ?>">
                            <iframe width="100%" height="<?php echo $video_player_height; ?>" src="//www.youtube.com/embed/<?php echo wrcpt_parse_yturl($packageType['pvid']); ?>?rel=0&amp;controls=1&amp;<?php if($p_combo['mbrand'] == 'yes') { ?>modestbranding=0<?php } else { ?>modestbranding=1<?php } ?>&amp;autohide=1&amp;autoplay=0" marginheight="0" marginwidth="0" frameborder="0" <?php if($p_combo['vfscr'] == 'yes') { echo 'allowfullscreen'; } ?>></iframe>
                        </li>
<?php
				}
			/* Video End */
			/* No Image and Video */
			} else { ?>
                        <li class="pricing_table_title color-<?php echo $packageType['pid']; ?> title_top_radius">
                            <h3 class="package_type txcolor-<?php echo $packageType['pid']; ?>"><?php echo $packageType['type']; ?><span class="package_desc"><?php echo $packageType['tdesc']; ?></span></h3>
                        </li>
                        <li class="pricing_table_plan plan-<?php echo $packageType['pid']; ?> top_price">
							<h2 class="package_plan txcolor-<?php echo $packageType['pid']; ?>">
<?php
							// Price Toggle
							if($p_combo['mcurr'] == 'yes') { ?>
								<div class="price-toggle-one">
<?php
									if($packageType['cutpr'] != '') { ?><span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?><?php echo $packageType['cutpr']; ?><?php if($packageType['cutfr']) echo '.'.$packageType['cutfr']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									} ?>
<?php
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['price']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['cent'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
<?php
									if($packageType['cent']) { ?>
									<span class="cent"><?php echo '.'.$packageType['cent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['plan']; ?></span>
								</div>
								<div class="price-toggle-two">
<?php
								if($packageType['enptg'] == 'show') { ?>
<?php
									if($packageType['tgcut'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['tgunit']; ?><?php } ?><?php echo $packageType['tgcut']; ?><?php if($packageType['tgcutfr']) { echo '.'.$packageType['tgcutfr']; } ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunit']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['tgunit']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['tgprice']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['tgcent'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['tgunit']; ?></span>
<?php
									} ?>
<?php
									if($packageType['tgcent']) { ?>
									<span class="cent"><?php echo '.'.$packageType['tgcent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunit']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['tgplan']; ?></span>
<?php
								} else { ?>
<?php
									if($packageType['cutpr'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?><?php echo $packageType['cutpr']; ?><?php if($packageType['cutfr']) echo '.'.$packageType['cutfr']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['price']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['cent'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
<?php
									if($packageType['cent']) { ?>
									<span class="cent"><?php echo '.'.$packageType['cent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['plan']; ?></span>
<?php
								} ?>
								</div><?php
								if($p_combo['togg3'] == 'yes') { ?>
								<div class="price-toggle-three">
<?php
								if($packageType['enptg'] == 'show') { ?>
<?php
									if($packageType['tgcut2'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['tgunt2']; ?><?php } ?><?php echo $packageType['tgcut2']; ?><?php if($packageType['tgcfr2']) { echo '.'.$packageType['tgcfr2']; } ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunt2']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['tgunt2']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['tgprc2']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['tgcnt2'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['tgunt2']; ?></span>
<?php
									} ?>
<?php
									if($packageType['tgcnt2']) { ?>
									<span class="cent"><?php echo '.'.$packageType['tgcnt2']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunt2']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['tgpln2']; ?></span>
<?php
								} else { ?>
<?php
									if($packageType['cutpr'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?><?php echo $packageType['cutpr']; ?><?php if($packageType['cutfr']) echo '.'.$packageType['cutfr']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['price']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['cent'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
<?php
									if($packageType['cent']) { ?>
									<span class="cent"><?php echo '.'.$packageType['cent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['plan']; ?></span>
<?php
								} ?>
                                </div><?php
								}
								if(isset($p_combo['togg4']) && $p_combo['togg4'] == 'yes') { ?>
								<div class="price-toggle-four">
<?php
								if($packageType['enptg'] == 'show') { ?>
<?php
									if($packageType['tgcut3'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['tgunt3']; ?><?php } ?><?php echo $packageType['tgcut3']; ?><?php if($packageType['tgcfr3']) { echo '.'.$packageType['tgcfr3']; } ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunt3']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['tgunt3']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['tgprc3']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['tgcnt3'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['tgunt3']; ?></span>
<?php
									} ?>
<?php
									if($packageType['tgcnt3']) { ?>
									<span class="cent"><?php echo '.'.$packageType['tgcnt3']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunt3']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['tgpln3']; ?></span>
<?php
								} else { ?>
<?php
									if($packageType['cutpr'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?><?php echo $packageType['cutpr']; ?><?php if($packageType['cutfr']) echo '.'.$packageType['cutfr']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['price']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['cent'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
<?php
									if($packageType['cent']) { ?>
									<span class="cent"><?php echo '.'.$packageType['cent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['plan']; ?></span>
<?php
								} ?>
                                </div><?php
								}
							// No Toggle
							} else {
								if($packageType['cutpr'] != '') { ?>
                                <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?><?php echo $packageType['cutpr']; ?><?php if($packageType['cutfr']) echo '.'.$packageType['cutfr']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
								}
								if($p_combo['purgt'] != 'yes') { ?>
								<span class="unit"><?php echo $packageType['unit']; ?></span>
<?php
								} ?>
								<span class="price"><?php echo $packageType['price']; ?></span>
<?php
								if($p_combo['purgt'] == 'yes' && $packageType['cent'] == '') { ?>
								<span class="unit unit_right"><?php echo $packageType['unit']; ?></span>
<?php
								} ?>
<?php
								if($packageType['cent']) { ?>
								<span class="cent"><?php echo '.'.$packageType['cent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
								} ?>
								<span class="plan"><?php echo $packageType['plan']; ?></span>
<?php
							} ?>
								<span class="price_desc"><?php echo $packageType['pdesc']; ?></span>
							</h2>
						</li>
<?php
			}
			if($p_combo['topbut'] == 'yes') { ?>
                        <li class="pricing_table_button bbcolor-<?php echo $packageType['pid']; ?> button-<?php echo $packageType['pid']; ?>">
<?php
						/* If Paypal */
						if($packageType['paypal'] == 'show') { ?>
							<div class="button_code">
                            	<form target='<?php echo $pp_target; ?>' action='https://www.<?php echo $pp_path; ?>.com/cgi-bin/webscr' method='post'>
<?php
									if($packageType['hsbtn'] == 'show') { ?>
									<input type="hidden" name="cmd" value="_s-xclick">
									<input type="hidden" name="hosted_button_id" value="<?php echo $packageType['hsbid']; ?>">
<?php
									} else { ?>
                                    <input type='hidden' name='cmd' value='_xclick'>
                                    <input type='hidden' name='business' value='<?php echo $pp_account; ?>'>
                                    <input id="pp-price-1" type='hidden' name='amount' value='<?php echo $pp_price; ?>'>
                                    <input id="pp-price-2" type='hidden' name='amount' value='<?php echo $pp_price2; ?>' disabled>
<?php
									if($p_combo['togg3'] == 'yes') { ?>
                                    <input id="pp-price-3" type='hidden' name='amount' value='<?php echo $pp_price3; ?>' disabled>
<?php
									}
									if(isset($p_combo['togg4']) && $p_combo['togg4'] == 'yes') { ?>
                                    <input id="pp-price-4" type='hidden' name='amount' value='<?php echo $pp_price4; ?>' disabled>
<?php
									} ?>
                                    <input type='hidden' name='currency_code' value='<?php echo $pp_currency; ?>'>
                                    <input type='hidden' name='lc' value='<?php echo $pp_language; ?>'>
                                    <input type='hidden' name='no_note' value='<?php echo $pp_note; ?>'>
                                    <input type='hidden' name='paymentaction' value='<?php echo $pp_action; ?>'>
                                    <input type='hidden' name='return' value='<?php echo $packageType['pprtn']; ?>'>
                                    <input type='hidden' name='bn' value='PP-BuyNowBF'>
                                    <input type='hidden' name='cancel_return' value='<?php echo $packageType['ppcnc']; ?>'>
<?php
									} ?>
                                    <input type='hidden' name='item_name' value='<?php echo $packageType['type']; ?>'>
                                    <input type='image' src='<?php echo $pp_img; ?>' border='0' name='submit' alt='Make your payments with PayPal. It is free, secure, effective.'>
                                    <img alt='' border='0' src='https://www.paypal.com/<?php echo $pp_language; ?>/i/scr/pixel.gif' width='1' height='1'>
                                </form>
							</div>
<?php
						/* Pricing Tbale Button */
						} else { ?>
							<div class="button_code">
<?php
							/* If Price Toggle */
							if($p_combo['mcurr'] == 'yes' && $packageType['enptg'] == 'show') {
								if($p_combo['togg3'] == 'yes') { ?>
                                <a href="<?php echo $packageType['tgbln2']; ?>" class="price-toggle-three action_button"<?php if($p_combo['nltab'] == 'yes') { ?> target="_blank"<?php } ?>><?php if($packageType['bicon'] != '') { ?><span class="button_icon"><i class="<?php echo $packageType['bicon']; ?> fa-lg"></i></span><span class="icon_divider"></span><?php } ?><?php echo $packageType['btext']; ?></a>
<?php
								} if(isset($p_combo['togg4']) && $p_combo['togg4'] == 'yes') { ?>
									<a href="<?php echo $packageType['tgbln3']; ?>" class="price-toggle-four action_button"<?php if($p_combo['nltab'] == 'yes') { ?> target="_blank"<?php } ?>><?php if($packageType['bicon'] != '') { ?><span class="button_icon"><i class="<?php echo $packageType['bicon']; ?> fa-lg"></i></span><span class="icon_divider"></span><?php } ?><?php echo $packageType['btext']; ?></a>
<?php
								} ?>
								<a href="<?php echo $packageType['btglink']; ?>" class="price-toggle-two action_button"<?php if($p_combo['nltab'] == 'yes') { ?> target="_blank"<?php } ?>><?php if($packageType['bicon'] != '') { ?><span class="button_icon"><i class="<?php echo $packageType['bicon']; ?> fa-lg"></i></span><span class="icon_divider"></span><?php } ?><?php echo $packageType['btext']; ?></a>
								<a href="<?php echo $packageType['blink']; ?>" class="price-toggle-one action_button"<?php if($p_combo['nltab'] == 'yes') { ?> target="_blank"<?php } ?>><?php if($packageType['bicon'] != '') { ?><span class="button_icon"><i class="<?php echo $packageType['bicon']; ?> fa-lg"></i></span><span class="icon_divider"></span><?php } ?><?php echo $packageType['btext']; ?></a>
<?php
							/* No Price Toggle */
							} else { ?>
								<a href="<?php echo $packageType['blink']; ?>" class="action_button"<?php if($p_combo['nltab'] == 'yes') { ?> target="_blank"<?php } ?>><?php if($packageType['bicon'] != '') { ?><span class="button_icon"><i class="<?php echo $packageType['bicon']; ?> fa-lg"></i></span><span class="icon_divider"></span><?php } ?><?php echo $packageType['btext']; ?></a>
<?php
							} ?>
							</div>
<?php
                        } ?>
                        </li>
<?php
			}
			/**
			 * Start Feature Section
			 */
			$p_feature['fcate0'] = '';
			$pf = 0;
			if($p_feature) {
				for($tf = 1; $tf <= $tot_feat; $tf++) {
					if(isset($packageType['fitem'.$tf])) {
						if($p_feature['ftype'.$tf] != 'textcheck') {
							$f_value = $packageType['fitem'.$tf];
						} else {
							$f_value = $packageType['fitem'.$tf];
							$tc_value = $packageType['fitem'.$tf.'c'];
						}
						$f_tips = $packageType['tip'.$tf];
					}
					if($p_combo['entips'] == "yes" && $p_feature['fdesc'.$i] != '') {
						$caption_ttip = 1;
					} else { $caption_ttip = 0;}
					if($p_combo['enicon'] == "yes" && $p_feature['fasom'.$i] != '') {
						$fa_class = $p_feature['fasom'.$i];
						$fa_icon = '<span class="fa-icon"><i class="'.$fa_class.' fa-lg"></i></span>';
					} else { $fa_icon = ''; }
					if ($i % 2 == 0) { $row_color = 'rowcolor'; } else { $row_color = 'altrowcolor'; }
					/* Check Empty Feature */
					if($p_combo['empft'] == 'yes' && $p_feature['ftype'.$tf] == 'text' && $f_value == '') : $i++;
					elseif($p_combo['empft'] == 'yes' && $p_feature['ftype'.$tf] == 'check' && $f_value != 'tick') : $i++;
					elseif($p_combo['empft'] == 'yes' && $p_feature['ftype'.$tf] == 'textcheck' && $tc_value != 'tick' && $f_value == '') : $i++;
					elseif($p_combo['empft'] == 'yes' && $p_feature['ftype'.$tf] == 'starrate' && $f_value == '') : $i++;
					/* No Empty Feature */
					else :
						if($p_combo['encate'] == 'yes' && $p_feature['fcate'.$tf] != $p_feature['fcate'.$pf]) { ?>
						<li class="feature_cate_row">
<?php
							if($key == 0) { ?>
                            <span class="feat_cate <?php if($p_combo['ftcap'] != 'yes') { echo 'show_cate'; } else { echo 'no_cate'; } ?>"><?php echo $p_feature['fcate'.$tf]; ?></span>
<?php
							} else { ?>
                            <span class="feat_cate <?php if($p_combo['ftcap'] != 'yes') { echo 'feature_cate'; } else { echo 'caption_cate'; } ?>"><?php echo $p_feature['fcate'.$tf]; ?></span>
<?php
							} ?>
						</li>
<?php
						} ?>
						<li class="feature_style_1 ftcolor-<?php echo $packageType['pid']; ?> <?php echo $row_color; ?>-<?php echo $packageType['pid']; ?><?php if($tf == 1) { echo ' top-feature'; } ?><?php if($tf == $tot_feat) { echo ' last-feature'; } ?>">
							<div class="feature_lists">
<?php
						if($f_value == 'tick' || $f_value == 'cross') {
							if($p_combo['ftcap'] == "yes") {
								$ttip = 'icon';
								if($p_combo['enicon'] == "yes" && $p_feature['fasom'.$i] != '') { ?>
                                <span class="hide-fa-icon"><i class="<?php echo $p_feature['fasom'.$i]; ?> fa-lg"></i></span>
<?php
								}
								if($p_combo['hidefn'] != 'yes') { ?>
                                <span class="media_screen"><?php if($p_combo['fealn'] != 'yes') { ?><?php echo $p_feature['fitem'.$i]; ?><?php } else { ?><a href="<?php echo $p_feature['flink'.$i]; ?>"><?php echo $p_feature['fitem'.$i]; ?></a><?php } ?><?php if(isset($p_combo['cpttpc']) && $p_combo['cpttpc'] == 'yes') { if($caption_ttip == 1) { echo '<span class="'.$ttip.'_tooltip wrcds-tooltip" rel="'.$p_feature['fdesc'.$i].'"><i class="fas fa-info-circle"></i></span>'; }} ?></span>
<?php
								}
								if($p_combo['enfatc'] == 'yes') {
									if($f_value == 'tick') {
										echo '<span class="ic-tick"><i class="'.$p_combo['awetick'].' fa-lg"></i></span>';
									} else {
										echo '<span class="ic-cross"><i class="'.$p_combo['awecross'].' fa-lg"></i></span>';
									}
								} else {
									if($f_value == 'tick') { ?>
                                <span class="feature_yes"></span>
<?php
									} else { ?>
                                <span class="feature_no"></span>
<?php
									}
								}
								if($p_combo['entips'] == "yes" && $f_tips != '') { ?>
                                <span class="<?php echo $ttip; ?>_tooltip wrcds-tooltip" rel="<?php echo $f_tips; ?>"><i class="fas fa-info-circle"></i></span>
<?php
								}
							} else {
								$ttip = 'text'; echo $fa_icon;
								if($p_combo['hidefn'] != 'yes') { ?>

								<span class="feat_value"><?php if($p_combo['fealn'] != 'yes') { ?><?php echo $p_feature['fitem'.$i]; ?><?php } else { ?><a href="<?php echo $p_feature['flink'.$i]; ?>"><?php echo $p_feature['fitem'.$i]; ?></a><?php } ?><?php if(isset($p_combo['cpttpc']) && $p_combo['cpttpc'] == 'yes') { if($caption_ttip == 1) { echo '<span class="'.$ttip.'_tooltip wrcds-tooltip" rel="'.$p_feature['fdesc'.$i].'"><i class="fas fa-info-circle"></i></span>'; }} ?></span>
<?php
								}
								if($p_combo['enfatc'] == 'yes') {
									if($f_value == 'tick') {
										echo '<span class="ic-tick"><i class="'.$p_combo['awetick'].' fa-lg"></i></span>';
									} else {
										echo '<span class="ic-cross"><i class="'.$p_combo['awecross'].' fa-lg"></i></span>';
									}
								} else {
									if($f_value == 'tick') { ?>
                                <span class="feature_yes"></span>
<?php
									} else { ?>
                                <span class="feature_no"></span>
<?php
									}
								}
								if($p_combo['entips'] == "yes" && $f_tips != '') { ?>
                                <span class="<?php echo $ttip; ?>_tooltip wrcds-tooltip" rel="<?php echo $f_tips; ?>"><i class="fas fa-info-circle"></i></span>
<?php
								}
							}
						} /*elseif($f_value == 'star') {
							$ttip = 'text';
							if($p_combo['ftcap'] == "yes") { ?>
								<span class="feature_star"></span>
<?php
							} else {
								if($p_combo['hidefn'] != 'yes') { ?>
								<span class="feat_value"><?php echo $p_feature['fitem'.$i]; ?></span>
<?php
								} ?>
								<span class="feature_star"></span>
<?php
							}
						} */elseif($f_value == '') {
							if($p_combo['ftcap'] == "yes") {
								$ttip = 'icon';
								if($p_combo['enicon'] == "yes" && $p_feature['fasom'.$i] != '') { ?>
                            	<span class="hide-fa-icon"><i class="<?php echo $p_feature['fasom'.$i]; ?> fa-lg"></i></span>
<?php
								}
								if($p_combo['hidefn'] != 'yes') { ?>
								<span class="media_screen<?php if($f_value == '' && $tc_value != 'tick') { ?> not-available<?php } ?>"><?php if($p_combo['fealn'] != 'yes') { ?><?php echo $p_feature['fitem'.$i]; ?><?php } else { ?><a href="<?php echo $p_feature['flink'.$i]; ?>"><?php echo $p_feature['fitem'.$i]; ?></a><?php } ?><?php if(isset($p_combo['cpttpc']) && $p_combo['cpttpc'] == 'yes') { if($caption_ttip == 1) { echo '<span class="'.$ttip.'_tooltip wrcds-tooltip" rel="'.$p_feature['fdesc'.$i].'"><i class="fas fa-info-circle"></i></span>'; }} ?></span>
<?php
								}
								if($p_feature['ftype'.$tf] == 'textcheck') {
									if($p_combo['enfatc'] == 'yes') {
										if($tc_value == 'tick') {
											echo '<span class="ic-tick"><i class="'.$p_combo['awetick'].' fa-lg"></i></span>';
										} else {
											echo '<span class="ic-cross"><i class="'.$p_combo['awecross'].' fa-lg"></i></span>';
										}
									} else {
										if($tc_value == 'tick') { ?>
                                <span class="feature_yes"></span>
<?php
										} else { ?>
                                <span class="feature_no"></span>
<?php
										}
									}
								} else { ?>
                                <span class="feature_empty"><i class="fas fa-minus"></i></span>
<?php
								}
								if($p_combo['entips'] == "yes" && $f_tips != '') { ?>
                                <span class="<?php echo $ttip; ?>_tooltip wrcds-tooltip" rel="<?php echo $f_tips; ?>"><i class="fas fa-info-circle"></i></span>
<?php
								}
							} else {
								$ttip = 'text'; echo $fa_icon;
								if($p_combo['hidefn'] != 'yes') { ?>

								<span class="feat_value<?php if($f_value == '' && $tc_value != 'tick') { ?> not-available<?php } ?>"><?php if($p_combo['fealn'] != 'yes') { ?><?php echo $p_feature['fitem'.$i]; ?><?php } else { ?><a href="<?php echo $p_feature['flink'.$i]; ?>"><?php echo $p_feature['fitem'.$i]; ?></a><?php } ?><?php if(isset($p_combo['cpttpc']) && $p_combo['cpttpc'] == 'yes') { if($caption_ttip == 1) { echo '<span class="'.$ttip.'_tooltip wrcds-tooltip" rel="'.$p_feature['fdesc'.$i].'"><i class="fas fa-info-circle"></i></span>'; }} ?></span>
<?php
								}
								if($p_feature['ftype'.$tf] == 'textcheck') {
									if($p_combo['enfatc'] == 'yes') {
										if($tc_value == 'tick') {
											echo '<span class="ic-tick"><i class="'.$p_combo['awetick'].' fa-lg"></i></span>';
										} else {
											echo '<span class="ic-cross"><i class="'.$p_combo['awecross'].' fa-lg"></i></span>';
										}
									} else {
										if($tc_value == 'tick') { ?>
                                <span class="feature_yes"></span>
<?php
										} else { ?>
                                <span class="feature_no"></span>
<?php
										}
									}
								}
								if($p_combo['entips'] == "yes" && $f_tips != '') { ?>
                                <span class="<?php echo $ttip; ?>_tooltip wrcds-tooltip" rel="<?php echo $f_tips; ?>"><i class="fas fa-info-circle"></i></span>
<?php
								}
							}
						} else {
							$ttip = 'text';
							if($p_combo['ftcap'] == "yes") {
								if($p_combo['enicon'] == "yes" && $p_feature['fasom'.$i] != '') { ?>
                                <span class="hide-fa-icon"><i class="<?php echo $p_feature['fasom'.$i]; ?> fa-lg"></i></span>
<?php
								}
								if($p_combo['hidefn'] != 'yes') { ?>
								<span class="media_screen"><?php if($p_combo['fealn'] != 'yes') { ?><?php echo $p_feature['fitem'.$i]; ?><?php } else { ?><a href="<?php echo $p_feature['flink'.$i]; ?>"><?php echo $p_feature['fitem'.$i]; ?></a><?php } ?><?php if(isset($p_combo['cpttpc']) && $p_combo['cpttpc'] == 'yes') { if($caption_ttip == 1) { echo '<span class="'.$ttip.'_tooltip wrcds-tooltip" rel="'.$p_feature['fdesc'.$i].'"><i class="fas fa-info-circle"></i></span>'; }} ?></span>
<?php
								}
									if($p_feature['ftype'.$tf] == 'html') { ?>
								<div class="feat_cap"><?php echo htmlspecialchars_decode(esc_html($f_value)); ?></div>
<?php
									} elseif($p_feature['ftype'.$tf] == 'starrate') {
									if($p_combo['entips'] == "yes" && $f_tips != '') { ?>
                                <span class="<?php echo $ttip; ?>_tooltip wrcds-tooltip" rel="<?php echo $f_tips; ?>"><i class="fas fa-info-circle"></i></span>
<?php
									} ?>
								<div class="feat_cap star_rate"><?php echo wrcpt_display_star_rating( $f_value ); ?></div>
<?php
									} else { ?>
								<div class="feat_cap"><?php echo $f_value; ?></div>
<?php
									}
									if($p_combo['entips'] == "yes" && $f_tips != '' && $p_feature['ftype'.$tf] != 'starrate') { ?>
                                <span class="<?php echo $ttip; ?>_tooltip wrcds-tooltip" rel="<?php echo $f_tips; ?>"><i class="fas fa-info-circle"></i></span>
<?php
									}
								//}
								if($p_feature['ftype'.$tf] == 'textcheck') {
									if($p_combo['enfatc'] == 'yes') {
										if($tc_value == 'tick') {
											echo '<span class="ic-tick"><i class="'.$p_combo['awetick'].' fa-lg"></i></span>';
										} else {
											echo '<span class="ic-cross"><i class="'.$p_combo['awecross'].' fa-lg"></i></span>';
										}
									} else {
										if($tc_value == 'tick') { ?>
                                <span class="feature_yes"></span>
<?php
										} else { ?>
                                <span class="feature_no"></span>
<?php
										}
									}
								}
							} else {
								echo $fa_icon;
								if($p_combo['hidefn'] != 'yes') { ?>

								<span class="feat_value"><?php if($p_combo['fealn'] != 'yes') { ?><?php echo $p_feature['fitem'.$i]; ?><?php } else { ?><a href="<?php echo $p_feature['flink'.$i]; ?>"><?php echo $p_feature['fitem'.$i]; ?></a><?php } ?><?php if(isset($p_combo['cpttpc']) && $p_combo['cpttpc'] == 'yes') { if($caption_ttip == 1) { echo '<span class="'.$ttip.'_tooltip wrcds-tooltip" rel="'.$p_feature['fdesc'.$i].'"><i class="fas fa-info-circle"></i></span>'; }} ?></span>
<?php
								}
								if($p_feature['ftype'.$tf] == 'html') { ?>
								<div class="feat_cap"><?php echo htmlspecialchars_decode(esc_html($f_value)); ?></div>
<?php
								} elseif($p_feature['ftype'.$tf] == 'starrate') {
									if($p_combo['entips'] == "yes" && $f_tips != '') { ?>
                                    <span class="<?php echo $ttip; ?>_tooltip wrcds-tooltip" rel="<?php echo $f_tips; ?>"><i class="fas fa-info-circle"></i></span>
<?php
									} ?>
								<div class="feat_cap star_rate"><?php echo wrcpt_display_star_rating( $f_value ); ?></div>
<?php
								} else { ?>
								<div class="feat_cap"><?php echo $f_value; ?></div>
<?php
								}
								if($p_combo['entips'] == "yes" && $f_tips != '' && $p_feature['ftype'.$tf] != 'starrate') { ?>
                                <span class="<?php echo $ttip; ?>_tooltip wrcds-tooltip" rel="<?php echo $f_tips; ?>"><i class="fas fa-info-circle"></i></span>
<?php
								}
								if($p_feature['ftype'.$tf] == 'textcheck') {
									if($p_combo['enfatc'] == 'yes') {
										if($tc_value == 'tick') {
											echo '<span class="ic-tick"><i class="'.$p_combo['awetick'].' fa-lg"></i></span>';
										} else {
											echo '<span class="ic-cross"><i class="'.$p_combo['awecross'].' fa-lg"></i></span>';
										}
									} else {
										if($tc_value == 'tick') { ?>
                                <span class="feature_yes"></span>
<?php
										} else { ?>
                                <span class="feature_no"></span>
<?php
										}
									}
								}
							}
						} ?>
							</div>
						</li>
<?php
						$i++;
					endif;
					$pf++;
				} $j++;
			}
			/* If price section is at bottom */
			if($p_combo['btompr'] == 'yes') {
				if($p_combo['enribs'] == "yes" && $packageType['rtext'] != '') {
					if($p_combo['markrib'] == 'rb-1' && ($p_combo['enimg'] != 'yes' && $p_combo['envid'] != 'yes')) { ?>
                        <li>
                            <div class="wrc-ribbon ribbon_color-<?php echo $packageType['pid']; ?>"><a href="#" id="wrc-ribbon"><?php echo $packageType['rtext']; ?></a></div>
                        </li>
<?php
					} elseif($p_combo['markrib'] == 'rb-2' && ($p_combo['enimg'] != 'yes' && $p_combo['envid'] != 'yes')) { ?>
                        <li><span class="ribbon-container rc-color-<?php echo $packageType['pid']; ?>"><?php echo $packageType['rtext']; ?></span></li>
<?php
					} elseif($p_combo['markrib'] == 'rb-4' && ($p_combo['enimg'] != 'yes' && $p_combo['envid'] != 'yes')) { ?>
                        <li>
                            <div class="ribbon-banner rban-color-<?php echo $packageType['pid']; ?>"><a href="#" id="ribbon"><?php echo $packageType['rtext']; ?></a></div>
                        </li>
<?php
					} elseif($p_combo['markrib'] == 'rb-5' && ($p_combo['enimg'] != 'yes' && $p_combo['envid'] != 'yes')) { ?>
                        <li>
                            <div class="corner-ribbon rcon-color-<?php echo $packageType['pid']; ?>"><a href="#"><?php echo $packageType['rtext']; ?></a></div>
                        </li>
<?php
					}
				} ?>
                        <li class="pricing_table_plan plan-<?php echo $packageType['pid']; ?>">
 							<h2 class="package_plan txcolor-<?php echo $packageType['pid']; ?>">
<?php
							// Price Toggle
							if($p_combo['mcurr'] == 'yes') { ?>
								<div class="price-toggle-one">
<?php
									if($packageType['cutpr'] != '') { ?><span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?><?php echo $packageType['cutpr']; ?><?php if($packageType['cutfr']) echo '.'.$packageType['cutfr']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									} ?>
<?php
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['price']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['cent'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
<?php
									if($packageType['cent']) { ?>
									<span class="cent"><?php echo '.'.$packageType['cent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['plan']; ?></span>
								</div>
								<div class="price-toggle-two">
<?php
								if($packageType['enptg'] == 'show') { ?>
<?php
									if($packageType['tgcut'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['tgunit']; ?><?php } ?><?php echo $packageType['tgcut']; ?><?php if($packageType['tgcutfr']) { echo '.'.$packageType['tgcutfr']; } ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunit']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['tgunit']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['tgprice']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['tgcent'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['tgunit']; ?></span>
<?php
									} ?>
<?php
									if($packageType['tgcent']) { ?>
									<span class="cent"><?php echo '.'.$packageType['tgcent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunit']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['tgplan']; ?></span>
<?php
								} else { ?>
<?php
									if($packageType['cutpr'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?><?php echo $packageType['cutpr']; ?><?php if($packageType['cutfr']) echo '.'.$packageType['cutfr']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['price']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['cent'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
<?php
									if($packageType['cent']) { ?>
									<span class="cent"><?php echo '.'.$packageType['cent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['plan']; ?></span>
<?php
								} ?>
								</div><?php
								if($p_combo['togg3'] == 'yes') { ?>
								<div class="price-toggle-three">
<?php
								if($packageType['enptg'] == 'show') { ?>
<?php
									if($packageType['tgcut2'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['tgunt2']; ?><?php } ?><?php echo $packageType['tgcut2']; ?><?php if($packageType['tgcfr2']) { echo '.'.$packageType['tgcfr2']; } ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunt2']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['tgunt2']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['tgprc2']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['tgcnt2'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['tgunt2']; ?></span>
<?php
									} ?>
<?php
									if($packageType['tgcnt2']) { ?>
									<span class="cent"><?php echo '.'.$packageType['tgcnt2']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunt2']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['tgpln2']; ?></span>
<?php
								} else { ?>
<?php
									if($packageType['cutpr'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?><?php echo $packageType['cutpr']; ?><?php if($packageType['cutfr']) echo '.'.$packageType['cutfr']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['price']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['cent'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
<?php
									if($packageType['cent']) { ?>
									<span class="cent"><?php echo '.'.$packageType['cent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['plan']; ?></span>
<?php
								} ?>
                                </div><?php
								}
								if(isset($p_combo['togg4']) && $p_combo['togg4'] == 'yes') { ?>
								<div class="price-toggle-four">
<?php
								if($packageType['enptg'] == 'show') { ?>
<?php
									if($packageType['tgcut3'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['tgunt3']; ?><?php } ?><?php echo $packageType['tgcut3']; ?><?php if($packageType['tgcfr3']) { echo '.'.$packageType['tgcfr3']; } ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunt3']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['tgunt3']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['tgprc3']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['tgcnt3'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['tgunt3']; ?></span>
<?php
									} ?>
<?php
									if($packageType['tgcnt3']) { ?>
									<span class="cent"><?php echo '.'.$packageType['tgcnt3']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['tgunt3']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['tgpln3']; ?></span>
<?php
								} else { ?>
<?php
									if($packageType['cutpr'] != '') { ?>
                                    <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?><?php echo $packageType['cutpr']; ?><?php if($packageType['cutfr']) echo '.'.$packageType['cutfr']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									}
									if($p_combo['purgt'] != 'yes') { ?>
									<span class="unit"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
									<span class="price"><?php echo $packageType['price']; ?></span>
<?php
									if($p_combo['purgt'] == 'yes' && $packageType['cent'] == '') { ?>
									<span class="unit unit_right"><?php echo $packageType['unit']; ?></span>
<?php
									} ?>
<?php
									if($packageType['cent']) { ?>
									<span class="cent"><?php echo '.'.$packageType['cent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
									} ?>
									<span class="plan"><?php echo $packageType['plan']; ?></span>
<?php
								} ?>
                                </div><?php
								}
							// No Toggle
							} else {
								if($packageType['cutpr'] != '') { ?>
                                <span class="price_cut"><?php if(isset($p_combo['cprtx']) && $p_combo['cprtx']) { ?><?php echo $p_combo['cprtx'].' '; ?><?php } ?><?php if($p_combo['purgt'] != 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?><?php echo $packageType['cutpr']; ?><?php if($packageType['cutfr']) echo '.'.$packageType['cutfr']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
								}
								if($p_combo['purgt'] != 'yes') { ?>
								<span class="unit"><?php echo $packageType['unit']; ?></span>
<?php
								} ?>
								<span class="price"><?php echo $packageType['price']; ?></span>
<?php
								if($p_combo['purgt'] == 'yes' && $packageType['cent'] == '') { ?>
								<span class="unit unit_right"><?php echo $packageType['unit']; ?></span>
<?php
								} ?>
<?php
								if($packageType['cent']) { ?>
								<span class="cent"><?php echo '.'.$packageType['cent']; ?><?php if($p_combo['purgt'] == 'yes') { ?><?php echo $packageType['unit']; ?><?php } ?></span>
<?php
								} ?>
								<span class="plan"><?php echo $packageType['plan']; ?></span>
<?php
							} ?>
								<span class="price_desc"><?php echo $packageType['pdesc']; ?></span>
							</h2>
                        </li>
<?php
                }
				if($p_combo['topbut'] != 'yes') { ?>
                        <li class="pricing_table_button bbcolor-<?php echo $packageType['pid']; ?> button-<?php echo $packageType['pid']; ?>">
<?php
						/* If Paypal */
						if($packageType['paypal'] == 'show') { ?>
							<div class="button_code">
                            	<form target='<?php echo $pp_target; ?>' action='https://www.<?php echo $pp_path; ?>.com/cgi-bin/webscr' method='post'>
<?php
									if($packageType['hsbtn'] == 'show') { ?>
									<input type="hidden" name="cmd" value="_s-xclick">
									<input type="hidden" name="hosted_button_id" value="<?php echo $packageType['hsbid']; ?>">
<?php
									} else { ?>
                                    <input type='hidden' name='cmd' value='_xclick'>
                                    <input type='hidden' name='business' value='<?php echo $pp_account; ?>'>
                                    <input id="pp-price-1" type='hidden' name='amount' value='<?php echo $pp_price; ?>'>
                                    <input id="pp-price-2" type='hidden' name='amount' value='<?php echo $pp_price2; ?>' disabled>
<?php
									if($p_combo['togg3'] == 'yes') { ?>
                                    <input id="pp-price-3" type='hidden' name='amount' value='<?php echo $pp_price3; ?>' disabled>
<?php
									}
									if(isset($p_combo['togg4']) && $p_combo['togg4'] == 'yes') { ?>
                                    <input id="pp-price-4" type='hidden' name='amount' value='<?php echo $pp_price4; ?>' disabled>
<?php
									} ?>
                                    <input type='hidden' name='currency_code' value='<?php echo $pp_currency; ?>'>
                                    <input type='hidden' name='lc' value='<?php echo $pp_language; ?>'>
                                    <input type='hidden' name='no_note' value='<?php echo $pp_note; ?>'>
                                    <input type='hidden' name='paymentaction' value='<?php echo $pp_action; ?>'>
                                    <input type='hidden' name='return' value='<?php echo $packageType['pprtn']; ?>'>
                                    <input type='hidden' name='bn' value='PP-BuyNowBF'>
                                    <input type='hidden' name='cancel_return' value='<?php echo $packageType['ppcnc']; ?>'>
<?php
									} ?>
                                    <input type='hidden' name='item_name' value='<?php echo $packageType['type']; ?>'>
                                    <input type='image' src='<?php echo $pp_img; ?>' border='0' name='submit' alt='Make your payments with PayPal. It is free, secure, effective.'>
                                    <img alt='' border='0' src='https://www.paypal.com/<?php echo $pp_language; ?>/i/scr/pixel.gif' width='1' height='1'>
                                </form>
							</div>
<?php
						/* Pricing Tbale Button */
						} else { ?>
							<div class="button_code">
<?php
							/* If Price Toggle */
							if($p_combo['mcurr'] == 'yes' && $packageType['enptg'] == 'show') {
								if($p_combo['togg3'] == 'yes') { ?>
                                <a href="<?php echo $packageType['tgbln2']; ?>" class="price-toggle-three action_button"<?php if($p_combo['nltab'] == 'yes') { ?> target="_blank"<?php } ?>><?php if($packageType['bicon'] != '') { ?><span class="button_icon"><i class="<?php echo $packageType['bicon']; ?> fa-lg"></i></span><span class="icon_divider"></span><?php } ?><?php echo $packageType['btext']; ?></a>
<?php
								} if(isset($p_combo['togg4']) && $p_combo['togg4'] == 'yes') { ?>
									<a href="<?php echo $packageType['tgbln3']; ?>" class="price-toggle-four action_button"<?php if($p_combo['nltab'] == 'yes') { ?> target="_blank"<?php } ?>><?php if($packageType['bicon'] != '') { ?><span class="button_icon"><i class="<?php echo $packageType['bicon']; ?> fa-lg"></i></span><span class="icon_divider"></span><?php } ?><?php echo $packageType['btext']; ?></a>
<?php
								} ?>
								<a href="<?php echo $packageType['btglink']; ?>" class="price-toggle-two action_button"<?php if($p_combo['nltab'] == 'yes') { ?> target="_blank"<?php } ?>><?php if($packageType['bicon'] != '') { ?><span class="button_icon"><i class="<?php echo $packageType['bicon']; ?> fa-lg"></i></span><span class="icon_divider"></span><?php } ?><?php echo $packageType['btext']; ?></a>
								<a href="<?php echo $packageType['blink']; ?>" class="price-toggle-one action_button"<?php if($p_combo['nltab'] == 'yes') { ?> target="_blank"<?php } ?>><?php if($packageType['bicon'] != '') { ?><span class="button_icon"><i class="<?php echo $packageType['bicon']; ?> fa-lg"></i></span><span class="icon_divider"></span><?php } ?><?php echo $packageType['btext']; ?></a>
<?php
							/* No Price Toggle */
							} else { ?>
								<a href="<?php echo $packageType['blink']; ?>" class="action_button"<?php if($p_combo['nltab'] == 'yes') { ?> target="_blank"<?php } ?>><?php if($packageType['bicon'] != '') { ?><span class="button_icon"><i class="<?php echo $packageType['bicon']; ?> fa-lg"></i></span><span class="icon_divider"></span><?php } ?><?php echo $packageType['btext']; ?></a>
<?php
							} ?>
							</div>
<?php
                        } ?>
                        </li>
<?php
				}
				if((isset($p_combo['pbttwo']) && $p_combo['pbttwo'] == 'yes') && $packageType['btext2']) { ?>
						<li class="pricing_table_button bbcolor-<?php echo $packageType['pid']; ?> button-<?php echo $packageType['pid']; ?>">
							<div class="button_code">
<?php
							/* If Price Toggle */
							if($p_combo['mcurr'] == 'yes' && $packageType['enptg'] == 'show') {
								if((isset($p_combo['togg3']) && $p_combo['togg3'] == 'yes') && $packageType['sbntl2']) { ?>
								<a href="<?php echo $packageType['sbntl2']; ?>" class="price-toggle-three action_button"<?php if($p_combo['nltab'] == 'yes') { ?> target="_blank"<?php } ?>><?php if($packageType['bicon2'] != '') { ?><span class="button_icon"><i class="<?php echo $packageType['bicon2']; ?> fa-lg"></i></span><span class="icon_divider"></span><?php } ?><?php echo $packageType['btext2']; ?></a>
<?php
								}
								if((isset($p_combo['togg4']) && $p_combo['togg4'] == 'yes') && $packageType['sbntl3']) { ?>
									<a href="<?php echo $packageType['sbntl3']; ?>" class="price-toggle-four action_button"<?php if($p_combo['nltab'] == 'yes') { ?> target="_blank"<?php } ?>><?php if($packageType['bicon2'] != '') { ?><span class="button_icon"><i class="<?php echo $packageType['bicon2']; ?> fa-lg"></i></span><span class="icon_divider"></span><?php } ?><?php echo $packageType['btext2']; ?></a>
<?php
								} 
								if($packageType['sbntl1']) { ?>
									<a href="<?php echo $packageType['sbntl1']; ?>" class="price-toggle-two action_button"<?php if($p_combo['nltab'] == 'yes') { ?> target="_blank"<?php } ?>><?php if($packageType['bicon2'] != '') { ?><span class="button_icon"><i class="<?php echo $packageType['bicon2']; ?> fa-lg"></i></span><span class="icon_divider"></span><?php } ?><?php echo $packageType['btext2']; ?></a>
<?php
								}
								if($packageType['blink2']) { ?>
									<a href="<?php echo $packageType['blink2']; ?>" class="price-toggle-one action_button"<?php if($p_combo['nltab'] == 'yes') { ?> target="_blank"<?php } ?>><?php if($packageType['bicon2'] != '') { ?><span class="button_icon"><i class="<?php echo $packageType['bicon2']; ?> fa-lg"></i></span><span class="icon_divider"></span><?php } ?><?php echo $packageType['btext2']; ?></a>
<?php
								}
							/* No Price Toggle */
							} else { ?>
								<a href="<?php echo $packageType['blink2']; ?>" class="action_button"<?php if($p_combo['nltab'] == 'yes') { ?> target="_blank"<?php } ?>><?php if($packageType['bicon2'] != '') { ?><span class="button_icon2"><i class="<?php echo $packageType['bicon2']; ?> fa-lg"></i></span><span class="icon_divider"></span><?php } ?><?php echo $packageType['btext2']; ?></a>
<?php
							} ?>
							</div>
						</li>
<?php
				} ?>
					</ul>
                </div>
                <!-- Package Column End -->
<?php
		endif;
	endforeach; // End of ForEach ?>
			</div>
		</div>
		<div class="wrc_clear"></div>
<?php
	/* if table is not enable */
	} else { ?>
		<style type="text/css">
			p.wrcpt_notice {background-color: #FFF;padding: 15px 20px;font-size: 24px;line-height: 24px;border-left: 4px solid #7ad03a;-webkit-box-shadow: 0 1px 1px 0 rgba(0,0,0,.1);box-shadow: 2px 2px 5px 2px rgba(0,0,0,.1);display: inline-block}
		</style>
<?php
		if($p_table == '' || $flag == 0) { ?>
			<p class="wrcpt_notice"><?php echo __('You didn\'t add any pricing tables yet!', 'wrcpt') ?></p>
<?php
		} elseif(empty($p_lists)) { ?>
			<p class="wrcpt_notice"><?php echo __('You didn\'t add any pricing column yet!', 'wrcpt') ?></p>
<?php
		} else { ?>
			<p class="wrcpt_notice"><?php echo __('Please <strong>Enable</strong> pricing table to display pricing table columns!', 'wrcpt') ?></p>
<?php
		}
	}
}
?>