<?php
/**
 * WRC Pricing Tables Ultimate - v1.2.4 - 16 July, 2023
 *
 * Add New Table, Add and Update pricing table options,
 * Delete a table, Duplicate a table and Process global settings
 */

/* Add package features for pricing table. */
function wrcpt_add_package_features() {
	$fn = 1;
	$package_feature = $_POST['package_feature'] != '' ? $_POST['package_feature'] : '';
	$feature_cate = $_POST['feature_cate'];
	$feature_link = $_POST['feature_link'];
	$feature_desc = $_POST['feature_desc'];
	$feature_type = $_POST['feature_type'];
	$awesome_icon = $_POST['awesome_icon'];
	if($package_feature) {
		if(isset($_POST['feature_name'])) {
			foreach($_POST['feature_name'] as $key => $feature) {
				if($feature) {
					$feature_name['fitem'.$fn] = sanitize_text_field( $feature );
					$feature_name['fcate'.$fn] = sanitize_text_field( $feature_cate[$key] );
					$feature_name['flink'.$fn] = esc_url( $feature_link[$key] );
					$feature_name['fdesc'.$fn] = sanitize_text_field( $feature_desc[$key] );
					$feature_name['ftype'.$fn] = $feature_type[$key];
					$feature_name['fasom'.$fn] = sanitize_text_field( $awesome_icon[$key] );
					$fn++;
				} else {
					$feature_name['fitem'.$fn] = '';
					$feature_name['fcate'.$fn] = '';
					$feature_name['flink'.$fn] = '';
					$feature_name['fdesc'.$fn] = '';
					$feature_name['ftype'.$fn] = '';
					$feature_name['fasom'.$fn] = '';
					$fn++;
				}
			}
			add_option($package_feature, $feature_name);
		}
	}
	wp_die();
}
add_action( 'wp_ajax_nopriv_wrcpt_add_package_features', 'wrcpt_add_package_features' );
add_action( 'wp_ajax_wrcpt_add_package_features', 'wrcpt_add_package_features' );

/* Update package features for pricing table. */
function wrcpt_update_package_features() {
	$fn = 1; $count_item = 0;
	$feature_cate = isset($_POST['feature_cate']) ? $_POST['feature_cate'] : '';
	$feature_link = isset($_POST['feature_link']) ? $_POST['feature_link'] : '';
	$feature_desc = isset($_POST['feature_desc']) ? $_POST['feature_desc'] : '';
	$feature_type = isset($_POST['feature_type']) ? $_POST['feature_type'] : '';
	$awesome_icon = isset($_POST['awesome_icon']) ? $_POST['awesome_icon'] : '';
	$package_feature = $_POST['package_feature'] != '' ? $_POST['package_feature'] : '';
	$feature_lists = get_option($package_feature, 'default_value');
	if ( $feature_lists !== 'default_value' ) {
		if(isset($feature_lists['flink1'])) {
			if(isset($feature_lists['fcate1'])) {
				$featureNum = count($feature_lists)/6;
			} else {
				$featureNum = count($feature_lists)/5;
			}
		} else {
			$featureNum = count($feature_lists)/2;
		}
	} else {
		$featureNum = 0;
	}
	$pricing_table = $_POST['pricing_table'] != '' ? sanitize_text_field( $_POST['pricing_table'] ) : '';
	$package_lists = get_option($pricing_table);
	$packageOptions = explode(', ', $package_lists);
	if(isset($_POST['feature_name'])) { $count_item = count($_POST['feature_name']); }
	if($count_item > 0) {
		$feature_value = $_POST['feature_value'];
		$tooltips = $_POST['tooltips'];
		$sn = 0; $fd = 1;
		foreach($_POST['feature_name'] as $key => $feature) {
			if($feature) {
				$feature_name['fitem'.$fn] = sanitize_text_field( $feature );
				$feature_name['fcate'.$fn] = sanitize_text_field( $feature_cate[$fn-1] );
				$feature_name['flink'.$fn] = esc_url( $feature_link[$fn-1] );
				$feature_name['fdesc'.$fn] = sanitize_text_field( $feature_desc[$fn-1] );
				$feature_name['ftype'.$fn] = $feature_type[$fn-1];
				$feature_name['fasom'.$fn] = sanitize_text_field( $awesome_icon[$fn-1] );
				$fn++;
			}
			foreach($packageOptions as $item => $option) {
				$packageItem = get_option($option);
				if(array_key_exists($key, $feature_lists)) {
					$packageItem['fitem'.$fd] = $feature_value[$sn];
					$packageItem['tip'.$fd] = $tooltips[$sn];
					update_option($option, $packageItem);
					$sn++;
				} else {
					$packageItem['fitem'.$fd] = '';
					$packageItem['tip'.$fd] = '';
					update_option($option, $packageItem);
				}
			}
			$fd++;
		}
		update_option($package_feature, $feature_name);
	} else {
		$feature_name[] = '';
		delete_option($package_feature);
	}
	foreach($packageOptions as $key => $option) {
		$packageItem = get_option($option);
		// $feature_item = (count($packageItem) - 73)/2;
		for($i = 1; $i <= $featureNum; $i++) {
			if($i > $count_item) {
				$feature_key = 'fitem'.$i;
				$tip_key = 'tip'.$i;
				unset($packageItem[$feature_key]);
				unset($packageItem[$tip_key]);
				update_option($option, $packageItem);
			}
		}
		$i = 1;
	}
	wp_die();
}
add_action( 'wp_ajax_nopriv_wrcpt_update_package_features', 'wrcpt_update_package_features' );
add_action( 'wp_ajax_wrcpt_update_package_features', 'wrcpt_update_package_features' );

/**
 * Edit pricing table name and check that the table name is unique as well.
 *
 * @param string  $edited_table - The name of the table that needs to be edited.
 * @param string  $pricing_table - Edited name of the table..
 */
function wrcpt_edit_pricing_table($edited_table, $pricing_table) {
	if($pricing_table && $pricing_table != $edited_table) {
		$package_table = get_option('packageTables');
		$table_item = explode(', ', $package_table);
		foreach($table_item as $key => $value) {
			if($value == $edited_table) {
				if(in_array($pricing_table, $table_item)) {
					$pricing_table = 'another_' . $pricing_table;
					$new_package_table[$key] = $pricing_table;
				} else {
					$new_package_table[$key] = $pricing_table;
				}
			} else {
				$new_package_table[$key] = $value;
			}
		}
		$new_package_table = implode(', ', $new_package_table);
		update_option('packageTables', $new_package_table);
		$edited_table_value = get_option($edited_table);
		if($edited_table_value) {
			delete_option($edited_table);
			add_option($pricing_table, $edited_table_value);
		}
		$edited_feature_value = get_option($edited_table.'_feature');
		if($edited_feature_value) {
			delete_option($edited_table.'_feature');
			add_option($pricing_table.'_feature', $edited_feature_value);
		}
		$edited_option_value = get_option($edited_table.'_option');
		if($edited_option_value) {
			delete_option($edited_table.'_option');
			add_option($pricing_table.'_option', $edited_option_value);
		}
		return $pricing_table;
	} else {
		return $edited_table;
	}
}

/* Delete pricing table by clearing table features and column details. */
function wrcpt_delete_pricing_table() {
	$pricing_table = $_POST['packtable'];
	$package_table_lists = get_option('packageTables');
	$package_id_lists = get_option('packageIDs');
	$package_lists = get_option($pricing_table);
	if(isset($package_lists)) {
		if($package_lists) {
			$table_packages = explode(', ', $package_lists);
			foreach($table_packages as $package) { delete_option($package); }
		}
		delete_option($pricing_table);
	}
	$package_feature_lists = get_option($pricing_table.'_feature');
	$package_option_lists = get_option($pricing_table.'_option');
	if(isset($package_feature_lists)) { delete_option($pricing_table.'_feature'); }
	if(isset($package_option_lists)) { delete_option($pricing_table.'_option'); }
	$package_table_lists = explode(', ', $package_table_lists);
	$package_id_lists = explode(', ', $package_id_lists);
	$key = array_search($pricing_table, $package_table_lists); // $key = 2;
	$package_table_diff = array_diff($package_table_lists, array($pricing_table));
	if($package_table_diff) {
		$new_package_table_lists = implode(', ', $package_table_diff);
		unset($package_id_lists[$key]);
		$new_package_id_lists = implode(', ', $package_id_lists);
		update_option('packageTables', $new_package_table_lists);
		update_option('packageIDs', $new_package_id_lists);
	} else {
		delete_option('packageTables');
		delete_option('packageCount');
		delete_option('packageIDs');
		delete_option('IDsCount');
		//delete_option('pricing_table_global');
	}
	wp_die();
}
add_action( 'wp_ajax_nopriv_wrcpt_delete_pricing_table', 'wrcpt_delete_pricing_table' );
add_action( 'wp_ajax_wrcpt_delete_pricing_table', 'wrcpt_delete_pricing_table' );

/* Delete pricing table by clearing table features and column details. */
function wrcpt_delete_multiple_pricing_table() {
	$pricing_tables = $_POST['packtable'];
	$table_lists = explode(', ', $pricing_tables);
	foreach($pricing_tables as $key => $list) {
		$package_table_lists = get_option('packageTables');
		$package_id_lists = get_option('packageIDs');
		$package_table_lists = explode(', ', $package_table_lists);
		$package_id_lists = explode(', ', $package_id_lists);
		$key = array_search($list, $package_table_lists); // $key = 2;
		$package_table_diff = array_diff($package_table_lists, array($list));
		if($package_table_diff) {
			$new_package_table_lists = implode(', ', $package_table_diff);
			unset($package_id_lists[$key]);
			$new_package_id_lists = implode(', ', $package_id_lists);
			update_option('packageTables', $new_package_table_lists);
			update_option('packageIDs', $new_package_id_lists);
		} else {
			delete_option('packageTables');
			delete_option('packageCount');
			delete_option('packageIDs');
			delete_option('IDsCount');
		}
		$package_lists = get_option($list);
		if(isset($package_lists)) {
			if($package_lists) {
				$table_packages = explode(', ', $package_lists);
				foreach($table_packages as $package) { delete_option($package); }
			}
			delete_option($list);
		}
		$package_feature_lists = get_option($list.'_feature');
		$package_option_lists = get_option($list.'_option');
		if(isset($package_feature_lists)) { delete_option($list.'_feature'); }
		if(isset($package_option_lists)) { delete_option($list.'_option'); }
	}
	wp_die();
}
add_action( 'wp_ajax_nopriv_wrcpt_delete_multiple_pricing_table', 'wrcpt_delete_multiple_pricing_table' );
add_action( 'wp_ajax_wrcpt_delete_multiple_pricing_table', 'wrcpt_delete_multiple_pricing_table' );

/**
 * Update pricing table package's option name in the database.
 *
 * @param string  $pricing_table - The name of the pricing table.
 * @param string  $package_lists - Lists of the package option name.
 */
function wrcpt_update_pricing_table($pricing_table, $package_lists) {
	$package_count = get_option('packageCount');
	if(!isset($package_count)) {
		$package_count = 1;
		add_option('packageCount', $package_count);
	} elseif($package_count == 0) {
		$package_count = 1;
		update_option('packageCount', $package_count);
	} else {
		$package_count = $package_count + 1;
		update_option('packageCount', $package_count);
	}
	$optionName = 'packageOptions' . $package_count;
	$pack_option = get_option($optionName);
	if($pack_option === true) {
		foreach ( wp_load_alloptions() as $option => $value ) {
			if ( strpos( $option, $optionName ) === 0 ) {
				delete_option( $optionName );
			}
		}
	}
	if(!isset($package_lists)) {
		$package_lists = $optionName;
		add_option($pricing_table, $package_lists);
	} elseif(empty($package_lists)){
		$package_lists = $optionName;
		update_option($pricing_table, $package_lists);
	} else {
		$package_lists = $package_lists . ', ' . $optionName;
		update_option($pricing_table, $package_lists);
	}
	return $optionName;
}

/* Delete pricing table packages. */
function wrcpt_delete_pricing_packages($pricing_table, $new_lists) {
	$old_package_lists = get_option($pricing_table);
	$packageOptions = explode(', ', $old_package_lists);
	$package_diff = array_diff($packageOptions, $new_lists);
	foreach($package_diff as $delpack) { delete_option($delpack); }
}

/* Update pricing table package details, features, colors and all the settings. */
function wrcpt_update_pricing_package() {
	$fc = 0; $tc = 0; $temp_id = 0; $cf = 1; $ht = 1; $sc = 1;
	$pricing_table = $_POST['pricing_table'] != '' ? $_POST['pricing_table'] : '';
	$pricing_table_name = $_POST['pricing_table_name'] != '' ? trim(preg_replace('/[^A-Za-z0-9-\w_]+/', '_', sanitize_text_field( $_POST['pricing_table_name'] ))) : $pricing_table;

	// Editing pricing table name
	$pricing_table = wrcpt_edit_pricing_table($pricing_table, $pricing_table_name);

	// Array of pricing table settings with array keys and inputs name
	$package_text_values = array( 'templ' => 'template', 'dname' => 'pt_nice_name', 'spurl' => 'shortcode_page_url', 'cprtx' => 'cut_pr_txt', 'cwidth' => 'container_width', 'maxcol' => 'max_column', 'ptmtop' => 'ptmargin_top', 'colgap' => 'column_space', 'capwidth' => 'cap_column_width', 'pgfont' => 'primary_font', 'sgfont' => 'secondary_font', 'ctsize' => 'caption_size', 'cfsize' => 'ft_cate_fsize', 'cftsize' => 'cap_feat_size', 'tbpad' => 'table_pad', 'tbody' => 'title_body', 'tsize' => 'title_size', 'tdesc' => 'desc_size', 'pbody' => 'price_body', 'psbig' => 'price_size_big', 'pssmall' => 'price_size_small', 'cutprs' => 'cut_price_size', 'tgtext1' => 'toggle_text_one', 'tgtext2' => 'toggle_text_two', 'sptext' => 'special_text', 'tgtext3' => 'toggle_text_three', 'sptext2' => 'special_text_2', 'tgtext4' => 'toggle_text_four', 'sptext3' => 'special_text_3', 'fcbody' => 'ft_cate_height', 'ftbody' => 'feature_body', 'ftsize' => 'feature_text_size', 'btbody' => 'button_body', 'bwidth' => 'button_width', 'bheight' => 'button_height', 'btsize' => 'button_text_size', 'rtsize' => 'ribbon_text_size', 'ptsize' => 'ptog_text_size', 'ptspsize' => 'ptogsp_text_size', 'ttwidth' => 'tooltip_width', 'ptwidth' => 'ptoggle_width', 'ptheight' => 'ptoggle_height', 'tgpos' => 'ptoggle_pos', 'tttext' => 'ttip_font_color', 'ptntext' => 'ptn_font_color', 'ptatext' => 'pta_font_color', 'ptsptext' => 'ptsp_font_color', 'fatclr' => 'fawe_tick_color', 'facclr' => 'fawe_cross_color', 'ttbg' => 'ttip_bg_color', 'ptabg' => 'ptog_bg_active', 'ptnbg' => 'ptog_bg_normal', 'ctcolor' => 'cap_font_color', 'cftcolor' => 'cap_feat_color', 'furlclr' => 'feat_url_color', 'furlhvr' => 'feat_url_hover', 'fcatbg' => 'ft_cate_color', 'ffnclr' => 'ft_font_color', 'ccolbg' => 'cap_col_bg', 'prnbg' => 'pricing_name_bg', 'capbg1' => 'cap_row1_color', 'capbg2' => 'cap_row2_color', 'ccborder' => 'cap_border_color', 'cscolor' => 'col_shad_color', 'cshcolor' => 'col_shad_hover_color', 'imgwid' => 'image_width', 'imghgt' => 'image_height', 'imgmrg' => 'image_margin', 'imgopc' => 'image_opacity', 'vbody' => 'video_body', 'ftdir' => 'feature_align', 'pbrad' => 'pack_radius', 'cbrad' => 'cap_radius', 'cttdir' => 'caption_title', 'cftdir' => 'caption_align', 'ftpad' => 'feature_padding', 'awetick' => 'awesome_tick', 'awecross' => 'awesome_cross' );
	
	// Sanitizing input values and put the values in an array.
	foreach($package_text_values as $key => $value) {
		if( isset( $_POST[$value] ) ) {
			if($key == 'spurl') {
				$optionValue_text[$key] = esc_textarea( $_POST[$value] );
			} elseif ($key == 'sgfont' || $key == 'pgfont') {
				$font_family = $_POST[$value];
				$font_family = str_replace('"', "'", $font_family);
				$optionValue_text[$key] = wp_unslash($font_family);
			} else {
				$optionValue_text[$key] = sanitize_text_field( $_POST[$value] );
			}
		}
	}

	// Declaring variables for input check values of pricing table settings
	$wrcpt_option = isset($_POST['wrcpt_option']) ? $_POST['wrcpt_option'] : 'no';
	$feature_caption = isset($_POST['feature_caption']) ? $_POST['feature_caption'] : 'no';
	$auto_column = isset($_POST['auto_column']) ? $_POST['auto_column'] : 'no';
	$enlarge_column = isset($_POST['enlarge_column']) ? $_POST['enlarge_column'] : 'no';
	$table_color = isset($_POST['table_color']) ? $_POST['table_color'] : 'no';
	$column_shadow = isset($_POST['column_shadow']) ? $_POST['column_shadow'] : 'no';
	$disable_shadow = isset($_POST['disable_shadow']) ? $_POST['disable_shadow'] : 'no';
	$title_gradient = isset($_POST['title_gradient']) ? $_POST['title_gradient'] : 'no';
	$price_gradient = isset($_POST['price_gradient']) ? $_POST['price_gradient'] : 'no';
	$disable_gradient = isset($_POST['disable_gradient']) ? $_POST['disable_gradient'] : 'no';
	$unit_right = isset($_POST['unit_right']) ? $_POST['unit_right'] : 'no';
	$tcicon_left = isset($_POST['tcicon_left']) ? $_POST['tcicon_left'] : '';
	$enable_category = isset($_POST['enable_category']) ? $_POST['enable_category'] : 'no';
	$enable_icon = isset($_POST['enable_icon']) ? $_POST['enable_icon'] : 'no';
	$tick_mark = isset($_POST['tick_mark']) ? $_POST['tick_mark'] : 'tick-1';
	$cross_mark = isset($_POST['cross_mark']) ? $_POST['cross_mark'] : 'cross-1';
	$star_mark = isset($_POST['star_mark']) ? $_POST['star_mark'] : 'star-1';
	$enable_tooltip = isset($_POST['enable_tooltip']) ? $_POST['enable_tooltip'] : 'no';
	$feature_border = isset($_POST['feature_border']) ? $_POST['feature_border'] : 'no';
	$caption_border = isset($_POST['caption_border']) ? $_POST['caption_border'] : 'no';
	$cap_titlebg = isset($_POST['cap_titlebg']) ? $_POST['cap_titlebg'] : 'no';
	$feat_link = isset($_POST['feat_link']) ? $_POST['feat_link'] : 'no';
	$cap_ttip_pc = isset($_POST['cap_ttip_pc']) ? $_POST['cap_ttip_pc'] : 'no';
	$empty_feature = isset($_POST['empty_feature']) ? $_POST['empty_feature'] : 'no';
	$hide_fname = isset($_POST['hide_fname']) ? $_POST['hide_fname'] : 'no';
	$hide_cfname = isset($_POST['hide_cfname']) ? $_POST['hide_cfname'] : 'no';
	$pbtn_two = isset($_POST['pbtn_two']) ? $_POST['pbtn_two'] : 'no';
	$hide_ptname = isset($_POST['hide_ptname']) ? $_POST['hide_ptname'] : 'no';
	$caption_shadow = isset($_POST['caption_shadow']) ? $_POST['caption_shadow'] : 'no';
	$bottom_price = isset($_POST['bottom_price']) ? $_POST['bottom_price'] : 'no';
	$price_circle = isset($_POST['price_circle']) ? $_POST['price_circle'] : 'no';
	$button_top = isset($_POST['button_top']) ? $_POST['button_top'] : 'no';
	$toggle_price = isset($_POST['toggle_price']) ? $_POST['toggle_price'] : 'no';
	$third_toggle = isset($_POST['third_toggle']) ? $_POST['third_toggle'] : 'no';
	$forth_toggle = isset($_POST['forth_toggle']) ? $_POST['forth_toggle'] : 'no';
	$enable_ribbon = isset($_POST['enable_ribbon']) ? $_POST['enable_ribbon'] : 'no';
	$marked_ribbon = isset($_POST['marked_ribbon']) ? $_POST['marked_ribbon'] : 'rb-1';
	$marked_scode = isset($_POST['marked_scode']) ? $_POST['marked_scode'] : 'sc-1';
	$new_tab = isset($_POST['new_tab']) ? $_POST['new_tab'] : 'no';
	$enable_image = isset($_POST['enable_image']) ? $_POST['enable_image'] : 'no';
	$bground_image = isset($_POST['bground_image']) ? $_POST['bground_image'] : 'no';
	$img_overlay = isset($_POST['img_overlay']) ? $_POST['img_overlay'] : 'no';
	$image_show = isset($_POST['image_show']) ? $_POST['image_show'] : 'no';
	$enable_video = isset($_POST['enable_video']) ? $_POST['enable_video'] : 'no';
	$video_show = isset($_POST['video_show']) ? $_POST['video_show'] : 'no';
	$video_screen = isset($_POST['video_screen']) ? $_POST['video_screen'] : 'no';
	$modest_brand = isset($_POST['modest_brand']) ? $_POST['modest_brand'] : 'no';
	$enable_tickcross = isset($_POST['enable_tickcross']) ? $_POST['enable_tickcross'] : 'no';
	$hide_title = isset($_POST['hide_title']) ? $_POST['hide_title'] : 'no';
	$hide_price = isset($_POST['hide_price']) ? $_POST['hide_price'] : 'no';
	$hide_feature = isset($_POST['hide_feature']) ? $_POST['hide_feature'] : 'no';
	$hide_button = isset($_POST['hide_button']) ? $_POST['hide_button'] : 'no';
	$submitted = (isset($_POST['submitted']) && $_POST['submitted'] == 'yes') ? $_POST['submitted'] : 'yes';
	
	// Pricing table option name
	$table_option = $pricing_table.'_option';
	
	// Storing all the checked input values in an array
	$optionValue_check = array( 'enable' => $wrcpt_option, 'scode' => $marked_scode, 'ftcap' => $feature_caption, 'autocol' => $auto_column, 'encol' => $enlarge_column, 'etclr' => $table_color, 'colshad' => $column_shadow, 'dscol' => $disable_shadow, 'ttgrd' => $title_gradient, 'prgrd' => $price_gradient, 'dsgrd' => $disable_gradient, 'purgt' => $unit_right, 'tcleft' => $tcicon_left, 'encate' => $enable_category, 'enicon' => $enable_icon, 'tick' => $tick_mark, 'cross' => $cross_mark, 'fstar' => $star_mark, 'entips' => $enable_tooltip, 'enfbor' => $feature_border, 'encbor' => $caption_border, 'captbg' => $cap_titlebg, 'fealn' => $feat_link, 'cpttpc' => $cap_ttip_pc, 'empft' => $empty_feature, 'hidefn' => $hide_fname, 'hidecfn' => $hide_cfname, 'pbttwo' => $pbtn_two, 'hdptnm' => $hide_ptname, 'cshade' => $caption_shadow, 'btompr' => $bottom_price, 'crlepr' => $price_circle, 'topbut' => $button_top, 'mcurr' => $toggle_price, 'togg3' => $third_toggle, 'togg4' => $forth_toggle, 'enribs' => $enable_ribbon, 'markrib' => $marked_ribbon, 'nltab' => $new_tab, 'enimg' => $enable_image, 'bgimg' => $bground_image, 'imgov' => $img_overlay, 'opimg' => $image_show, 'envid' => $enable_video, 'opvid' => $video_show, 'vfscr' => $video_screen, 'mbrand' => $modest_brand, 'enfatc' => $enable_tickcross, 'htitle' => $hide_title, 'hprice' => $hide_price, 'hfeat' => $hide_feature, 'hbutton' => $hide_button, 'subform' => $submitted );

	// Merging all the input values in one array
	$optionValue = array_merge($optionValue_text, $optionValue_check);
	// Updating all the setting values in the database by serealizing
	update_option($table_option, $optionValue);
	// Deleting packages if not available while updating
	wrcpt_delete_pricing_packages($pricing_table, $_POST['pricing_packages']);

	$package_id = $_POST['package_id'] != '' ? $_POST['package_id'] : '';
	$order_id =  $_POST['order_id'] != '' ? $_POST['order_id'] : '';
	$special_package = isset($_POST['special_package']) ? $_POST['special_package'] : array();
	$package_type = $_POST['package_type'] != '' ? $_POST['package_type'] : '';
	$hidden_path = $_POST['hidden_path'] != '' ? $_POST['hidden_path'] : '';

	// Array of package details with array keys and inputs name
	$package_text_options = array( 'pdisp' => 'hide_show', 'type' => 'package_type', 'tdesc' => 'package_desc', 'tcolor' => 'title_color', 'thover' => 'title_hover', 'tdescl' => 'title_descp', 'pbclr' => 'table_bg', 'tbcolor' => 'title_bg', 'price' => 'price_number', 'pcbig' => 'price_color_big', 'phbig' => 'price_hover_big', 'cent' => 'price_fraction', 'cutpr' => 'price_cut', 'cutfr' => 'cut_fraction', 'unit' => 'price_unit', 'plan' => 'package_plan', 'pdesc' => 'price_desc', 'pcsmall' => 'price_color_small', 'phsmall' => 'price_hover_small', 'cutclr' => 'cut_price_color', 'pbcolor' => 'price_bg', 'pcircle' => 'price_cr', 'imgclr' => 'image_bg', 'enptg' => 'toggle_display', 'tgprice' => 'price_number_toggle', 'tgcent' => 'price_fraction_toggle', 'tgcut' => 'price_cut_toggle', 'tgcutfr' => 'cut_fraction_toggle', 'tgplan' => 'package_plan_toggle', 'tgunit' => 'price_unit_toggle', 'btglink' => 'button_toggle_link', 'sbntl1' => 'second_btn_tglink1', 'tgprc2' => 'price_number_toggle2', 'tgcnt2' => 'price_fraction_toggle2', 'tgcut2' => 'price_cut_toggle2', 'tgcfr2' => 'cut_fraction_toggle2', 'tgpln2' => 'package_plan_toggle2', 'tgunt2' => 'price_unit_toggle2', 'tgbln2' => 'button_toggle_link2', 'sbntl2' => 'second_btn_tglink2', 'tgprc3' => 'price_number_toggle3', 'tgcnt3' => 'price_fraction_toggle3', 'tgcut3' => 'price_cut_toggle3', 'tgcfr3' => 'cut_fraction_toggle3', 'tgpln3' => 'package_plan_toggle3', 'tgunt3' => 'price_unit_toggle3', 'tgbln3' => 'button_toggle_link3', 'sbntl3' => 'second_btn_tglink3', 'fncolor' => 'feature_name_color', 'ftcolor' => 'feature_text_color', 'fbrow1' => 'feat_row1_color', 'fbrow2' => 'feat_row2_color', 'paypal' => 'paypal_button', 'hsbtn' => 'hosted_button', 'pplng' => 'pp_language', 'ppcur' => 'pp_currency', 'pplva' => 'pp_liveacc', 'ppsbx' => 'pp_sandbox', 'pmode' => 'pp_mode', 'pactn' => 'pp_action', 'ppbsz' => 'pp_button', 'ppcnc' => 'pp_cancel', 'pprtn' => 'pp_return', 'hsbid' => 'host_button_id', 'btext' => 'button_text', 'blink' => 'button_link', 'bicon' => 'button_icon', 'btext2' => 'button_text2', 'blink2' => 'button_link2', 'bicon2' => 'button_icon2', 'pimg' => 'image_path', 'pvid' => 'video_path', 'btcolor' => 'button_text_color', 'bthover' => 'button_text_hover', 'bcolor' => 'button_color', 'bhover' => 'button_hover', 'bbcolor' => 'button_bg', 'rtext' => 'ribbon_text', 'rtcolor' => 'ribbon_text_color', 'rthover' => 'ribbon_text_hover', 'rbcolor' => 'ribbon_bg', 'ftborder' => 'feat_border' );

	// Storing feature values and tooltips by declaring variables
	$package_features = $_POST['feature_value'] != '' ? $_POST['feature_value'] : '';
	$package_tooltips = $_POST['tooltips'] != '' ? $_POST['tooltips'] : '';
	$checkbox_value = $_POST['checkbox_value'] != '' ? $_POST['checkbox_value'] : '';

	// Pricing table feature name
	$table_feature = $pricing_table.'_feature';
	// Retrieving pricing table feature options
	$feature_items = get_option($table_feature);
	$temp = '';

	// Processing each column of the pricing table
	foreach($_POST['pricing_packages'] as $key => $package) {
		$vl =1;  $fk = 1;

		// Retrieving all the package list name
		$packVal = get_option('packageOptions' . $package_id[$key]);	//	2	pro

		// Updating package list name with edited (if any) pricing table name
		if($packVal['type'] == $package_type[$key]) {
			if($temp != $package_type[$key]) {
				$optionName = 'packageOptions' . $package_id[$key];
				$order_id[$key] = $key+1;
			} else {
				$package_lists = get_option($pricing_table);
				$optionName = wrcpt_update_pricing_table($pricing_table, $package_lists);
				// Counting total numbe of package column
				$package_id[$key] = get_option('packageCount');
				$order_id[$key] = $key+1;
			}
			$temp = $package_type[$key];
		} else {
			$package_lists = get_option($pricing_table);
			$optionName = wrcpt_update_pricing_table($pricing_table, $package_lists);
			// Counting total numbe of package column
			$package_id[$key] = get_option('packageCount');
			$order_id[$key] = $key+1;
			$temp = $package_type[$key];
		}
		$package_order[] = $optionName;

		// Processing package features and tooltips
		foreach($feature_items as $fkey => $item) {
			if($fkey == 'fitem'.$fk) {
				if($feature_items['ftype'.$fk] == 'text') {
					if($package_features[$fc]) { $feature_value[$fkey] = sanitize_text_field( $package_features[$fc] ); }
					else { $feature_value[$fkey] = ''; }
				} elseif($feature_items['ftype'.$fk] == 'html') {
					if($package_features[$fc]) { $feature_value[$fkey] = esc_html( $package_features[$fc] ); }
					else { $feature_value[$fkey] = ''; }
				} elseif($feature_items['ftype'.$fk] == 'check') {
					if(array_key_exists('ftype'.$cf, $package_features)) {
						$feature_value[$fkey] = 'tick';
						$cf++; $fc--;
					}
					else {
						$feature_value[$fkey] = 'cross';
						$cf++; $fc--;
					}
				} elseif($feature_items['ftype'.$fk] == 'starrate') {
					if($package_features[$fc]) { $feature_value[$fkey] = sanitize_text_field( $package_features[$fc] ); }
					else { $feature_value[$fkey] = ''; }
				} else {
					if($package_features[$fc]) { $feature_value[$fkey] = sanitize_text_field( $package_features[$fc] ); $fc++; }
					else { $feature_value[$fkey] = ''; $fc++; }
					if(array_key_exists('ftype'.$cf, $package_features)) {
						$feature_value[$fkey.'c'] = 'tick';
						$cf++; $fc--;
					}
					else {
						$feature_value[$fkey.'c'] = 'cross';
						$cf++; $fc--;
					}
				}
				if($package_tooltips) {
					if($package_tooltips[$tc]) {
						$tooltips['tip'.$vl] = sanitize_text_field( $package_tooltips[$tc] );
						$vl++;
					} else {
						$tooltips['tip'.$vl] = '';
						$vl++;
					}
				}
				$fc++; $tc++;
			} else { 
				if($fkey == 'ftype'.$fk) {
					$fk++;
				}
			}
		}
		// Checking if the package is speacial or not
		if(!isset($special_package[$key])) {
			$special_package[$key] = 'no';
		}
		
		// Storing all the package deatils in an array
		foreach($package_text_options as $pkey => $value) {
			if( isset( $_POST[$value] ) ) {
				$packValue = $_POST[$value];
				/*if($pkey == 'pimg') {
					// removing image from database
					if($packValue[$key] == '' || $packValue[$key] != $hidden_path[$key]) {	
						global $wpdb;
						$table_name = $wpdb->prefix.'posts';
						$img_path = $hidden_path[$key];
						// We need to get the images meta ID.
						$query = "SELECT ID FROM $table_name where guid = '" . esc_url($img_path) . "' AND post_type = 'attachment'";
						$results = $wpdb->get_results($query);
						// And delete it
						foreach ( $results as $row ) {
							if($row->ID != '') {
								wp_delete_attachment( $row->ID ); //delete the image and also delete the attachment from the Media Library.
							}
						}
					}
				}*/
				if($pkey == 'blink') {
					$packageOptions_text[$pkey] = esc_url( $packValue[$key] );
				} else {
					$packageOptions_text[$pkey] = sanitize_text_field( $packValue[$key] );
				}
			}
		}
		$packageOptions_extra = array( 'pop' => $package_id[$key], 'pid' => $key + 1, 'order' => $order_id[$key], 'spack' => $special_package[$key] );

		// Merging all the package arrays in one array
		$mergePackages = array_merge($packageOptions_extra, $packageOptions_text, $feature_value, $tooltips);

		// Updating all the package details in the database by serializing
		update_option($optionName, $mergePackages);
	}

	// Reordering packages according to package order and updating again
	$table_lists = implode(', ', $package_order);
	update_option($pricing_table, $table_lists);
	wp_die();
}
add_action( 'wp_ajax_nopriv_wrcpt_update_pricing_package', 'wrcpt_update_pricing_package' );
add_action( 'wp_ajax_wrcpt_update_pricing_package', 'wrcpt_update_pricing_package' );

/* Update multiple pricing table at once. */
function wrcpt_update_multiple_pricing_table() {
	$pricing_tables = $_POST['packtable'];
	$fn=0;
	foreach($pricing_tables as $key => $pricing_table) {
		if($pricing_table) {
			$package_feature = get_option($pricing_table.'_feature');
			$package_combine = get_option($pricing_table.'_option');
			$package_columns = get_option($pricing_table);
			$packageOptions = explode(', ', $package_columns);
		}
		if (array_key_exists("fcate1", $package_feature)) {
			$tfeat = count($package_feature)/6;
		} elseif (array_key_exists("flink1", $package_feature)) {
			$tfeat = count($package_feature)/5;
		} else {
			$tfeat = count($package_feature)/2;
		}
		for($fn=1; $fn <= $tfeat; $fn++) {
			$feature_name['fitem'.$fn] = '';
			$feature_name['fcate'.$fn] = '';
			$feature_name['flink'.$fn] = '';
			$feature_name['fdesc'.$fn] = '';
			$feature_name['ftype'.$fn] = '';
			$feature_name['fasom'.$fn] = '';
		}
		$fn=0;
		$final_features = array_merge($feature_name, $package_feature);
		update_option($pricing_table.'_feature', $final_features);		//Updating all the features

		$common_options = array( 'dname' => '', 'spurl' => '', 'cprtx' => '', 'cwidth' => '', 'maxcol' => '', 'ptmtop' => '', 'colgap' => '', 'capwidth' => '', 'pgfont' => '', 'sgfont' => '', 'ctsize' => '', 'cftsize' => '', 'tbpad' => '', 'tbody' => '', 'tsize' => '', 'tdesc' => '', 'pbody' => '', 'psbig' => '', 'pssmall' => '', 'cutprs' => '', 'ftbody' => '', 'ftsize' => '', 'btbody' => '', 'bwidth' => '', 'bheight' => '', 'btsize' => '', 'rtsize' => '', 'ptsize' => '', 'ptspsize' => '', 'ptwidth' => '', 'ttwidth' => '', 'ptheight' => '', 'tgpos' => '', 'imgwid' => '', 'imghgt' => '', 'imgmrg' => '', 'imgopc' => '', 'vbody' => '', 'ftdir' => '', 'cttdir' => '', 'cftdir' => '', 'pbrad' => '', 'ftpad' => '', 'awetick' => '', 'awecross' => '', 'enable' => '', 'scode' => 'sc-1', 'ftcap' => '', 'autocol' => '', 'encol' => '', 'etclr' => '', 'colshad' => '', 'dscol' => '', 'ttgrd' => '', 'prgrd' => '', 'ptabg' => '', 'ptnbg' => '', 'dsgrd' => '', 'purgt' => '', 'tcleft' => '', 'enicon' => '', 'fealn' => '', 'cpttpc' => '', 'tick' => 'tick-1', 'cross' => 'cross-1', 'entips' => '', 'enfbor' => '', 'encbor' => '', 'encate' => '', 'captbg' => '', 'empft' => '', 'hidefn' => '', 'hidecfn' => '', 'pbttwo' => '', 'hdptnm' => '', 'cshade' => '', 'enribs' => '', 'markrib' => 'rb-1', 'nltab' => '', 'enimg' => '', 'bgimg' => '', 'imgov' => '', 'opimg' => '', 'envid' => '', 'opvid' => '', 'vfscr' => '', 'mbrand' => '', 'enfatc' => '', 'htitle' => '', 'hprice' => '', 'hfeat' => '', 'btompr' => '', 'hbutton' => '', 'mcurr' => '', 'tgtext1' => '', 'tgtext2' => '', 'sptext' => '', 'tgtext3' => '', 'sptext2' => '', 'tgtext4' => '', 'sptext3' => '', 'topbut' => '', 'furlclr' => '', 'furlhvr' => '', 'togg3' => '', 'togg4' => '', 'fcatbg' => '', 'cfsize' => '', 'ffnclr' => '', 'fcbody' => '', 'ttbg' => '', 'tttext' => '', 'ptntext' => '', 'ptatext' => '', 'ptsptext' => '', 'fatclr' => '', 'facclr' => '', 'ctcolor' => '', 'cftcolor' => '', 'fstar' => 'star-1', 'cbrad' => '', 'ccborder' => '', 'cscolor' => '', 'cshcolor' => '', 'ccolbg' => '', 'prnbg' => '', 'capbg1' => '', 'capbg2' => '', 'crlepr' => '' );

		$final_options = array_merge($common_options, $package_combine);
		update_option($pricing_table.'_option', $final_options);		//Updating all the common options

		foreach($packageOptions as $key => $option) {
			$package_values = get_option($option);
			$package_column_details = array( 'spack' => '', 'pdisp' => '', 'type' => '', 'tdesc' => '', 'price' => '', 'cent' => '', 'cutpr' => '', 'cutfr' => '', 'unit' => '', 'plan' => '', 'pdesc' => '', 'pcsmall' => '', 'phsmall' => '', 'btext' => '', 'blink' => '', 'bicon' => '', 'btext2' => '', 'blink2' => '', 'bicon2' => '', 'pimg' => '', 'pvid' => '', 'rtext' => '', 'paypal' => '', 'tcolor' => '', 'thover' => '', 'tdescl' => '', 'pbclr' => $package_values['tbcolor'], 'tbcolor' => '', 'pcbig' => '', 'phbig' => '', 'fbrow1' => '', 'fbrow2' => '', 'ftcolor' => '', 'pcircle' => '', 'btcolor' => '', 'bthover' => '', 'bcolor' => '', 'bhover' => '', 'rtcolor' => '', 'rbcolor' => '', 'cutclr' => '', 'pbcolor' => $package_values['tbcolor'], 'imgclr' => '', 'enptg' => '', 'tgprice' => '', 'tgcent' => '', 'tgcut' => '', 'tgcutfr' => '', 'tgprc2' => '', 'tgcnt2' => '', 'tgcut2' => '', 'tgcfr2' => '', 'tgplan' => '', 'tgunit' => '', 'tgpln2' => '', 'tgunt2' => '', 'tgbln2' => '', 'btglink' => '', 'sbntl1' => '', 'tgprc3' => '', 'tgcnt3' => '', 'tgcut3' => '', 'tgcfr3' => '', 'tgpln3' => '', 'tgunt3' => '', 'tgbln3' => '', 'sbntl3' => '', 'fncolor' => '', 'hsbtn' =>  '','pplng' => '', 'ppcur' => '', 'pplva' => '', 'ppsbx' => '', 'pmode' => '', 'pactn' => '', 'ppbsz' => '', 'ppcnc' => '', 'pprtn' => '', 'hsbid' => '', 'bbcolor' => $package_values['tbcolor'], 'rthover' => '', 'ftborder' => '' );
				
			for($fn=1; $fn <= $tfeat; $fn++) {
				$feature_values['fitem'.$fn] = '';
				$feature_values['tip'.$fn] = '';
			}
				
			$column_details = array_merge($package_column_details, $feature_values);
			$final_column_details = array_merge($column_details, $package_values);
			update_option($option, $final_column_details);		//Updating all the columns options
		}
	}
	wp_die();
}
add_action( 'wp_ajax_nopriv_wrcpt_update_multiple_pricing_table', 'wrcpt_update_multiple_pricing_table' );
add_action( 'wp_ajax_wrcpt_update_multiple_pricing_table', 'wrcpt_update_multiple_pricing_table' );

/* Copy an existing pricing table and make a duplicate of it. */
function wrcpt_copy_pricing_packages() {
	$package_count = get_option('packageCount') + 1;
	$count = 1;
	$pricing_table = $_POST['packtable'];
	if($pricing_table) {
		$package_table = get_option('packageTables');
		$table_lists = explode(', ', $package_table);
		$count_copy = count($table_lists) + 1;
		$new_pricing_table = $pricing_table . '_copy_' . $count_copy . rand(1,100);
		if(in_array($pricing_table, $table_lists)) {
			$pricing_table_lists = $package_table . ', ' . $new_pricing_table;
			update_option('packageTables', $pricing_table_lists);
		} else {
			$pricing_table_lists = $package_table . ', ' . $pricing_table;
			update_option('packageTables', $pricing_table_lists);
		}
		$package_id = get_option('packageIDs');
		$id_count = get_option('IDsCount') + 1;
		$pricing_table_ids = $package_id . ', ' . $id_count;
		update_option('packageIDs', $pricing_table_ids);
		update_option('IDsCount', $id_count);
		$package_feature = get_option($pricing_table.'_feature');
		$new_package_feature = $new_pricing_table . '_feature';
		// Adding duplicate table features
		add_option($new_package_feature, $package_feature);
		$packageCombine = get_option($pricing_table.'_option');
		$new_package_option = $new_pricing_table . '_option';
		// Adding duplicate table options
		add_option($new_package_option, $packageCombine);
		$package_lists = get_option($pricing_table);
		$packageOptions = explode(', ', $package_lists);
		foreach($packageOptions as $key => $option) {
			$package_value = get_option($option);
			foreach($package_value as $pkey => $value) {
				if($pkey == 'pop') {
					$copy_package_value[$pkey] = $package_count;
				} elseif($pkey == 'pid') {
					$copy_package_value[$pkey] = $count;
					$count++;
				} else {
					$copy_package_value[$pkey] = $value;
				}
			}
			$new_package_name = 'packageOptions' . $package_count;
			$new_packageOptions[$key] = $new_package_name;
			add_option($new_package_name, $copy_package_value);
			$package_count++;
		}
		$new_pack_options = implode(', ', $new_packageOptions);
		add_option($new_pricing_table, $new_pack_options);
		$package_count = $package_count - 1;
		update_option('packageCount', $package_count);
	}
}
add_action( 'wp_ajax_nopriv_wrcpt_copy_pricing_packages', 'wrcpt_copy_pricing_packages' );
add_action( 'wp_ajax_wrcpt_copy_pricing_packages', 'wrcpt_copy_pricing_packages' );

/* Regenerating Shortcodes IDs */
function wrcpt_regenerate_shortcode() {
	$package_table = get_option('packageTables');
	delete_option('packageIDs');
	delete_option('IDsCount');
	//$package_ids = get_option('packageIDs');
	//$ids_count = get_option('IDsCount');
	$table_lists = explode(', ', $package_table);
	$pack_id = 1;
	$temp = '';
	$id_count = count($table_lists);
	foreach($table_lists as $key => $list) {
		if($id_count > 1) {
			$pricing_table_ids = $temp . $pack_id;
			$temp = $pricing_table_ids . ', ';
			$pack_id++;
		} else {
			$pricing_table_ids = $pack_id;
		}
	}
	add_option('packageIDs', $pricing_table_ids);
	add_option('IDsCount', $id_count);
}
add_action( 'wp_ajax_nopriv_wrcpt_regenerate_shortcode', 'wrcpt_regenerate_shortcode' );
add_action( 'wp_ajax_wrcpt_regenerate_shortcode', 'wrcpt_regenerate_shortcode' );

/* Set global options for all pricing tables. */
function wrcpt_set_global_options() {
	$wrcpt_options = get_option('pricing_table_global');

	// Declaring variables for input check values of pricing table settings
	$minify_script = isset($_POST['minify_script']) ? $_POST['minify_script'] : 'no';
	$wp_post_editor = isset($_POST['wp_post_editor']) ? $_POST['wp_post_editor'] : 'no';
	$html_editor = isset($_POST['html_editor']) ? $_POST['html_editor'] : 'no';
	$default_font = isset($_POST['default_font']) ? $_POST['default_font'] : 'no';
	$custom_font = isset($_POST['custom_font']) ? $_POST['custom_font'] : '';
	$primary_font = isset($_POST['primary_font']) ? $_POST['primary_font'] : '';
	$secondary_font = isset($_POST['secondary_font']) ? $_POST['secondary_font'] : '';
	$font_awesome = isset($_POST['font_awesome']) ? $_POST['font_awesome'] : 'no';
	$view_port = isset($_POST['view_port']) ? $_POST['view_port'] : 'no';
	$clear_db = isset($_POST['clear_db']) ? $_POST['clear_db'] : 'no';
	$custom_off = isset($_POST['custom_off']) ? $_POST['custom_off'] : 'no';
	$wrcpt_custom = isset($_POST['wrcpt_custom_css']) ? esc_textarea($_POST['wrcpt_custom_css']) : '';

	// Storing all the checked input values in an array
	$global_options = array( 'minify' => $minify_script, 'wpedit' => $wp_post_editor, 'htmled' => $html_editor, 'gdfont' => $default_font, 'gcfont' => $custom_font, 'prfont' => $primary_font, 'scfont' => $secondary_font, 'fasome' => $font_awesome, 'vwport' => $view_port, 'clrdb' => $clear_db, 'ccoff' => $custom_off, 'wrccss' => $wrcpt_custom );

	if(isset($wrcpt_options) && $wrcpt_options != '') {
		update_option('pricing_table_global', $global_options);
	} else {
		add_option('pricing_table_global', $global_options);
	}
}

/* Find how many tables are plublished */
function wrcpt_published_tables_count($table_lists) {
	$count = 0;
	foreach($table_lists as $key => $list) {
		$packageCombine = get_option($list.'_option');
		if(isset($packageCombine['enable']) && $packageCombine['enable'] == 'yes') {
			$count++;
		}
	}
	return $count;
}

/* Find unuseful package options and delete them */
function wrcpt_unuseful_package_options() {
	$package_table = get_option('packageTables');
	$table_lists = explode(', ', $package_table);
	$temp = ''; $pcount = 0;
	foreach($table_lists as $key => $table) :
		$table_options = get_option($table);
		$table_options_list = $temp . $table_options;
		$temp = $table_options_list.', ';
	endforeach;
	$total_table_options = explode(', ', $table_options_list);
	/* counting packageOptions1-100 to check
	 * if any unuseful package exist or not */
	for($i = 1; $i <= 500; $i++) {
		$package_option = 'packageOptions'.$i;
		if(get_option($package_option) == true && !in_array($package_option, $total_table_options)) {
			delete_option($package_option);
			$pcount++; // Increment the count for each deleted package
		}
	}
	return $pcount; // Return the count after the loop completes
}

/* Count unuseful package options and show number */
function wrcpt_count_unuseful_package_options() {
	$package_table = get_option('packageTables');
	$table_lists = explode(', ', $package_table);
	$temp = ''; $upcount = 0;
	foreach($table_lists as $key => $table) :
		$table_options = get_option($table);
		$table_options_list = $temp . $table_options;
		$temp = $table_options_list.', ';
	endforeach;
	$total_table_options = explode(', ', $table_options_list);
	/* counting packageOptions1-100 to check
	 * if any unuseful package exist or not */
	for($i = 1; $i <= 500; $i++) {
		$package_option = 'packageOptions'.$i;
		if(get_option($package_option) == true && !in_array($package_option, $total_table_options)) {
			$upcount++; // Increment the count for each deleted package
		}
	}
	return $upcount; // Return the count after the loop completes
}

/* Get WP editor for pricing table html feature type */
function wrcpt_get_wp_editor( $content = '', $editor_id = array(), $options = array() ) {
	ob_start();
	wp_editor( $content, $editor_id, $options );
	$temp = ob_get_clean();
	$temp .= \_WP_Editors::enqueue_scripts();
	$temp .= print_footer_scripts();
	$temp .= \_WP_Editors::editor_js();
	return $temp;
}
?>