<?php
/**
 * WRC Pricing Tables Ultimate - v1.2.4 - 16 July, 2023
 *
 * The function is generating a pricing table 
 * using selected templates with default values.
 */
function wrcpt_activate_template() {
	$template_number = $_POST['tempcount'];
	$package_table = get_option('packageTables');
	$package_id = $id_count = 1;
	$table_lists = explode(', ', $package_table);
	$count_copy = count($table_lists) + $template_number;
	$pricing_table = 'pricing_template_' . $count_copy . rand(1,1000);
	$package_feature = $pricing_table.'_feature';
	$table_option = $pricing_table.'_option';
	$fn = 1;

	if($template_number == 56) {
		$template_features = array('Details');
		$feature_cate = array('');
		$feature_link = array('');
		$feature_desc = array('');
		$awesome_icon = array('');
		$feature_type = array('html');
		$feature_values = array( 'fitem1' => array('&lt;br&gt;
&lt;h4&gt;JOHN DOE&lt;/h4&gt;&lt;br&gt;
&lt;p&gt;CEO in Bank of America &lt;br&gt;since 2016&lt;/p&gt;&lt;br&gt;
&lt;p&gt;&lt;a href=&quot;https://www.facebook.com/realwebcare&quot;&gt;&lt;i class=&quot;fab fa-facebook-f&quot; style=&quot;font-size:16px;&quot;&gt;&lt;/i&gt;&lt;/a&gt;&nbsp;&nbsp;
&lt;a href=&quot;https://twitter.com/realwebcare&quot;&gt;&lt;i class=&quot;fab fa-twitter&quot; style=&quot;font-size:17px;&quot;&gt;&lt;/i&gt;&lt;/a&gt;&nbsp;&nbsp;
&lt;a href=&quot;#&quot;&gt;&lt;i class=&quot;fab fa-pinterest-p&quot; style=&quot;font-size:17px;&quot;&gt;&lt;/i&gt;&lt;/a&gt;&lt;/p&gt;', '&lt;br&gt;
&lt;h4&gt;PETER JOHNSON&lt;/h4&gt;&lt;br&gt;
&lt;p&gt;Accountant in Bank of America &lt;br&gt;since 2016&lt;/p&gt;&lt;br&gt;
&lt;p&gt;&lt;a href=&quot;https://www.facebook.com/realwebcare&quot;&gt;&lt;i class=&quot;fab fa-facebook-f&quot; style=&quot;font-size:16px;&quot;&gt;&lt;/i&gt;&lt;/a&gt;&nbsp;&nbsp;
&lt;a href=&quot;https://twitter.com/realwebcare&quot;&gt;&lt;i class=&quot;fab fa-twitter&quot; style=&quot;font-size:17px;&quot;&gt;&lt;/i&gt;&lt;/a&gt;&nbsp;&nbsp;
&lt;a href=&quot;#&quot;&gt;&lt;i class=&quot;fab fa-pinterest-p&quot; style=&quot;font-size:17px;&quot;&gt;&lt;/i&gt;&lt;/a&gt;&lt;/p&gt;', '&lt;br&gt;
&lt;h4&gt;JAX YOUNG&lt;/h4&gt;&lt;br&gt;
&lt;p&gt;Sys Admin in Bank of America &lt;br&gt;since 2016&lt;/p&gt;&lt;br&gt;
&lt;p&gt;&lt;a href=&quot;https://www.facebook.com/realwebcare&quot;&gt;&lt;i class=&quot;fab fa-facebook-f&quot; style=&quot;font-size:16px;&quot;&gt;&lt;/i&gt;&lt;/a&gt;&nbsp;&nbsp;
&lt;a href=&quot;https://twitter.com/realwebcare&quot;&gt;&lt;i class=&quot;fab fa-twitter&quot; style=&quot;font-size:17px;&quot;&gt;&lt;/i&gt;&lt;/a&gt;&nbsp;&nbsp;
&lt;a href=&quot;#&quot;&gt;&lt;i class=&quot;fab fa-pinterest-p&quot; style=&quot;font-size:17px;&quot;&gt;&lt;/i&gt;&lt;/a&gt;&lt;/p&gt;', '&lt;br&gt;
&lt;h4&gt;WILLIUM SMITH&lt;/h4&gt;&lt;br&gt;
&lt;p&gt;Manager in Bank of America &lt;br&gt;since 2016&lt;/p&gt;&lt;br&gt;
&lt;p&gt;&lt;a href=&quot;https://www.facebook.com/realwebcare&quot;&gt;&lt;i class=&quot;fab fa-facebook-f&quot; style=&quot;font-size:16px;&quot;&gt;&lt;/i&gt;&lt;/a&gt;&nbsp;&nbsp;
&lt;a href=&quot;https://twitter.com/realwebcare&quot;&gt;&lt;i class=&quot;fab fa-twitter&quot; style=&quot;font-size:17px;&quot;&gt;&lt;/i&gt;&lt;/a&gt;&nbsp;&nbsp;
&lt;a href=&quot;#&quot;&gt;&lt;i class=&quot;fab fa-pinterest-p&quot; style=&quot;font-size:17px;&quot;&gt;&lt;/i&gt;&lt;/a&gt;&lt;/p&gt;'), 'tip1' => array('', '', '', '') );
	} else {
		$template_features = array('Webspace', 'Monthly Bandwidth', 'Domain Name', 'Email Address', 'Online Support');
		$feature_cate = array('Space', 'Space', 'Facility', 'Facility', 'Support');
		$feature_link = array('#', '#', '#', '#', '#');
		$feature_desc = array( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin condimentum elit et ipsum tempus, at ultricies odio efficitur.', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin condimentum elit et ipsum tempus, at ultricies odio efficitur.', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin condimentum elit et ipsum tempus, at ultricies odio efficitur.', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin condimentum elit et ipsum tempus, at ultricies odio efficitur.', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin condimentum elit et ipsum tempus, at ultricies odio efficitur.' );
		$awesome_icon = array('fas fa-cogs', 'fas fa-tachometer-alt', 'fas fa-globe', 'fas fa-envelope', 'fas fa-life-ring');
		if($template_number == 60 || $template_number == 61 || $template_number == 62 || $template_number == 63) {
			$feature_type = array('check', 'check', 'check', 'check', 'check');
			$feature_values = array( 'fitem1' => array('tick', 'tick', 'tick', 'tick'), 'fitem2' => array('tick', 'tick', 'tick', 'tick'), 'fitem3' => array('tick', 'cross', 'tick', 'tick'), 'fitem4' => array('tick', 'tick', 'cross', 'cross'), 'fitem5' => array('cross', 'tick', 'tick', 'cross'), 'tip1' => array('', '', '', ''), 'tip2' => array('', '', '', ''), 'tip3' => array('', '', '', ''), 'tip4' => array('', '', '', ''), 'tip5' => array('', '', '', '') );
		} else {
			$feature_type = array('text', 'text', 'text', 'text', 'check');
			$feature_values = array( 'fitem1' => array('5 GB', '15 GB', '30 GB', '50 GB'), 'fitem2' => array('50 GB', '150 GB', '300 GB', '500 GB'), 'fitem3' => array('25', '75', '150', '250'), 'fitem4' => array('50', '150', '300', '500'), 'fitem5' => array('cross', 'tick', 'tick', 'tick'), 'tip1' => array('', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin condimentum elit et ipsum tempus, at ultricies odio effic', '', ''), 'tip2' => array('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin condimentum elit et ipsum tempus, at ultricies odio effic', '', '', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin condimentum elit et ipsum tempus, at ultricies odio effic'), 'tip3' => array('', '', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin condimentum elit et ipsum tempus, at ultricies odio effic', ''), 'tip4' => array('', '', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin condimentum elit et ipsum tempus, at ultricies odio effic', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin condimentum elit et ipsum tempus, at ultricies odio effic'), 'tip5' => array('', '', '', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin condimentum elit et ipsum tempus, at ultricies odio effic') );
		}
	}

	if(!isset($package_table)) {
		add_option('packageTables', $pricing_table);
		add_option('packageIDs', $package_id);
		add_option('IDsCount', $id_count);
	} elseif(empty($package_table)){
		update_option('packageTables', $pricing_table);
		update_option('packageIDs', $package_id);
		update_option('IDsCount', $id_count);
	} else {
		if(in_array($pricing_table, $table_lists)) {
			$new_pricing_table = 'another_' . $pricing_table;
			$pricing_table_lists = $package_table . ', ' . $new_pricing_table;
			update_option('packageTables', $pricing_table_lists);
		} else {
			$pricing_table_lists = $package_table . ', ' . $pricing_table;
			update_option('packageTables', $pricing_table_lists);
		}
		$package_id = get_option('packageIDs');
		$id_count = get_option('IDsCount') + 1;
		$pricing_table_ids = $package_id . ', ' . $id_count;
		update_option('packageIDs', $pricing_table_ids);
		update_option('IDsCount', $id_count);
	}

	$package_options_check = array( 'dname' => 'Our Best Packages', 'spurl' => '', 'cprtx' => '', 'cwidth' => '', 'maxcol' => '4', 'ptmtop' => '0', 'capwidth' => '18.73', 'pgfont' => '', 'sgfont' => '', 'ctsize' => '', 'cftsize' => '', 'tbody' => '', 'pbody' => '', 'tsize' => '', 'tdesc' => '', 'psbig' => '', 'pssmall' => '', 'cutprs' => '', 'ftbody' => '', 'ftsize' => '', 'btbody' => '', 'bwidth' => '', 'bheight' => '', 'btsize' => '', 'rtsize' => '', 'ptsize' => '', 'ptspsize' => '', 'ptwidth' => '', 'ttwidth' => '150px', 'ptheight' => '', 'tgpos' => 'center', 'imgwid' => '', 'imghgt' => '', 'imgmrg' => '', 'imgopc' => '', 'vbody' => '', 'ftdir' => 'left', 'cttdir' => 'left', 'cftdir' => 'left', 'pbrad' => '10px', 'cbrad' => '0', 'ftpad' => '15px', 'awetick' => '', 'awecross' => '', 'enable' => 'yes', 'scode' => 'sc-1', 'autocol' => 'yes', 'colgap' => '1', 'ftcap' => 'no', 'encol' => 'yes', 'etclr' => 'yes', 'tbpad' => '1', 'colshad' => 'yes', 'dscol' => 'no', 'cshade' => 'no', 'ttgrd' => 'no', 'prgrd' => 'no', 'dsgrd' => 'no', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'purgt' => 'no', 'tcleft' => 'no', 'enicon' => 'yes', 'entips' => 'yes', 'fealn' => 'no', 'cpttpc' => 'no', 'tick' => 'tick-7', 'cross' => 'cross-7', 'enfbor' => 'no', 'encbor' => 'no', 'encate' => 'no', 'captbg' => 'no', 'empft' => 'no', 'hidefn' => 'no', 'hidecfn' => 'no', 'pbttwo' => 'no', 'hdptnm' => 'no', 'enribs' => 'yes', 'markrib' => 'rb-3', 'nltab' => 'no', 'enimg' => 'no', 'bgimg' => '', 'imgov' => 'no', 'opimg' => 'no', 'envid' => 'no', 'opvid' => 'no', 'vfscr' => 'no', 'mbrand' => 'no', 'enfatc' => 'no', 'htitle' => 'no', 'hprice' => 'no', 'hfeat' => 'no', 'btompr' => 'no', 'hbutton' => 'no', 'mcurr' => 'no', 'tgtext1' => '', 'tgtext2' => '', 'sptext' => '', 'tgtext3' => '', 'sptext2' => '', 'tgtext4' => '', 'sptext3' => '', 'topbut' => 'no', 'furlclr' => '', 'furlhvr' => '', 'togg3' => 'no', 'togg4' => 'no', 'fcatbg' => '#ffffff', 'cfsize' => '', 'ffnclr' => '#333333', 'fcbody' => '', 'ttbg' => '#444444', 'tttext' => '#ffffff', 'ptntext' => '', 'ptatext' => '', 'ptsptext' => '', 'fatclr' => '', 'facclr' => '', 'ctcolor' => '', 'cftcolor' => '', 'fstar' => 'star-1', 'ccborder' => '', 'cscolor' => '', 'cshcolor' => '', 'ccolbg' => '#f7f7f7', 'prnbg' => '', 'capbg1' => '', 'capbg2' => '', 'crlepr' => 'no', 'subform' => 'no' );
	$package_details_texts = array( 'spack' => array('no', 'no', 'no', 'no'), 'pdisp' => array('show', 'show', 'show', 'show'), 'type' => array('Starter', 'Professional', 'Business', 'Premier'), 'tdesc' => array('', '', '', ''), 'price' => array('9', '24', '39', '54'), 'cent' => array('', '', '', ''), 'cutpr' => array('', '', '', ''), 'cutfr' => array('', '', '', ''), 'unit' => array('$', '$', '$', '$'), 'plan' => array('month', 'month', 'month', 'month'), 'pdesc' => array('', '', '', ''), 'btext' => array('Sign Up', 'Sign Up', 'Sign Up', 'Sign Up'), 'blink' => array('#', '#', '#', '#'), 'bicon' => array('fas fa-sign-in-alt', 'fas fa-sign-in-alt', 'fas fa-sign-in-alt', 'fas fa-sign-in-alt'), 'btext2' => array('', '', '', ''), 'blink2' => array('', '', '', ''), 'bicon2' => array('', '', '', ''), 'tdescl' => array('#bdbdbd', '#bdbdbd', '#bdbdbd', '#bdbdbd'), 'pimg' => array('', '', '', ''), 'pvid' => array('https://youtu.be/fEPqgSNLfK8', 'https://youtu.be/seMwpP0yeu4', 'https://youtu.be/j3x_kGlWuvI', 'https://youtu.be/PY1UJ9oPOmU'), 'rtext' => array('', '', 'NEW', ''), 'paypal' => array('hide', 'hide', 'hide', 'hide') );

	if($template_number == 1) {
		$package_options_color = array( 'templ' => 'temp1', 'etclr' => 'yes', 'tbpad' => '1', 'ftdir' => 'left', 'ftpad' => '30', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ttwidth' => '250px', 'ctcolor' => '#333333', 'cftcolor' => '#333333', 'furlclr' => '#5C82FF', 'furlhvr' => '#333333', 'ccolbg' => '#dddddd', 'prnbg' => '', 'capbg1' => '#ffffff', 'capbg2' => '#ffffff', 'ccborder' => '#dddddd', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'pbrad' => '10', 'cbrad' => '10', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'enicon' => 'no', 'enimg' => 'yes', 'bgimg' => 'yes' );
		$package_details_color = array( 'pbclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'tcolor' => array('#52586b', '#52586b', '#52586b', '#52586b'), 'thover' => array('#52586b', '#52586b', '#52586b', '#52586b'), 'tbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcbig' => array('#FF5277', '#527BFF', '#FFB052', '#4FCA39'), 'phbig' =>array('#FF5277', '#527BFF', '#FFB052', '#4FCA39'), 'pcsmall' => array('#FF5277', '#527BFF', '#FFB052', '#4FCA39'), 'phsmall' => array('#FF5277', '#527BFF', '#FFB052', '#4FCA39'), 'cutclr' => array('#52586b', '#52586b', '#52586b', '#52586b'), 'pbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#52586b', '#52586b', '#52586b', '#52586b'), 'ftcolor' => array('#52586b', '#52586b', '#52586b', '#52586b'), 'fbrow1' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow2' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#FF5277', '#527BFF', '#FFB052', '#4FCA39'), 'bhover' => array('#52586b', '#52586b', '#52586b', '#52586b'), 'bbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#FF5277', '#527BFF', '#FFB052', '#4FCA39'), 'ftborder' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 2) {
		$package_options_color = array( 'templ' => 'temp2', 'etclr' => 'yes', 'tbpad' => '1', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#ff5a28', 'ptnbg' => '#eeeeee', 'ttwidth' => '250px', 'ctcolor' => '#ff5a28', 'cftcolor' => '#333333', 'furlclr' => '#ff5a28', 'furlhvr' => '#333333', 'ccolbg' => '#eeeeee', 'prnbg' => '', 'capbg1' => '#ffffff', 'capbg2' => '#ffffff', 'ccborder' => '#eeeeee', 'cscolor' => '#cccccc', 'cshcolor' => '#eeeeee', 'pbrad' => '5', 'cbrad' => '5', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'enicon' => 'no', 'enimg' => 'yes', 'bgimg' => 'yes' );
		$package_details_color = array( 'pbclr' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tcolor' => array('#ff5a28', '#ff5a28', '#ff5a28', '#ff5a28'), 'thover' => array('#ff5a28', '#ff5a28', '#ff5a28', '#ff5a28'), 'tbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcbig' => array('#ff5a28', '#ff5a28', '#ff5a28', '#ff5a28'), 'phbig' =>array('#ff5a28', '#ff5a28', '#ff5a28', '#ff5a28'), 'pcsmall' => array('#ff5a28', '#ff5a28', '#ff5a28', '#ff5a28'), 'phsmall' => array('#ff5a28', '#ff5a28', '#ff5a28', '#ff5a28'), 'cutclr' => array('#333333', '#333333', '#333333', '#333333'), 'pbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#333333', '#333333', '#333333', '#333333'), 'ftcolor' => array('#333333', '#333333', '#333333', '#333333'), 'fbrow1' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow2' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ff5a28', '#ff5a28', '#ff5a28', '#ff5a28'), 'bcolor' => array('#ff5a28', '#ff5a28', '#ff5a28', '#ff5a28'), 'bhover' => array('#f1f1f1', '#f1f1f1', '#f1f1f1', '#f1f1f1'), 'bbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#ff5a28', '#ff5a28', '#ff5a28', '#ff5a28'), 'ftborder' => array('#eeeeee', '#eeeeee', '#eeeeee', '#eeeeee') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 3) {
		$package_options_color = array( 'templ' => 'temp3', 'etclr' => 'no', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#2397F2', 'ptnbg' => '#F5F5F5', 'ttwidth' => '250px', 'ctcolor' => '#7d7d7d', 'cftcolor' => '#7d7d7d', 'furlclr' => '#2397F2', 'furlhvr' => '#7d7d7d', 'ccolbg' => '#F5F5F5', 'prnbg' => '', 'capbg1' => '#F5F5F5', 'capbg2' => '#F5F5F5', 'ccborder' => '#7d7d7d', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'pbrad' => '5', 'cbrad' => '5', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'enicon' => 'no', 'enimg' => 'yes', 'bgimg' => 'yes' );
		$package_details_color = array( 'pbclr' => array('#F5F5F5', '#F5F5F5', '#F5F5F5', '#F5F5F5'), 'tcolor' => array('#54AB3E', '#2397F2', '#AC598A', '#F89406'), 'thover' => array('#54AB3E', '#2397F2', '#AC598A', '#F89406'), 'tbcolor' => array('#F5F5F5', '#F5F5F5', '#F5F5F5', '#F5F5F5'), 'pcbig' => array('#54AB3E', '#2397F2', '#AC598A', '#F89406'), 'phbig' =>array('#54AB3E', '#2397F2', '#AC598A', '#F89406'), 'pcsmall' => array('#54AB3E', '#2397F2', '#AC598A', '#F89406'), 'phsmall' => array('#54AB3E', '#2397F2', '#AC598A', '#F89406'), 'cutclr' => array('#7d7d7d', '#7d7d7d', '#7d7d7d', '#7d7d7d'), 'pbcolor' => array('#F5F5F5', '#F5F5F5', '#F5F5F5', '#F5F5F5'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#7d7d7d', '#7d7d7d', '#7d7d7d', '#7d7d7d'), 'ftcolor' => array('#7d7d7d', '#7d7d7d', '#7d7d7d', '#7d7d7d'), 'fbrow1' => array('#F5F5F5', '#F5F5F5', '#F5F5F5', '#F5F5F5'), 'fbrow2' => array('#F5F5F5', '#F5F5F5', '#F5F5F5', '#F5F5F5'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#7d7d7d', '#7d7d7d', '#7d7d7d', '#7d7d7d'), 'bhover' => array('#bbbbbb', '#bbbbbb', '#bbbbbb', '#bbbbbb'), 'bbcolor' => array('#F5F5F5', '#F5F5F5', '#F5F5F5', '#F5F5F5'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#54AB3E', '#2397F2', '#AC598A', '#F89406'), 'ftborder' => array('#7d7d7d', '#7d7d7d', '#7d7d7d', '#7d7d7d') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 4) {
		$package_options_color = array( 'templ' => 'temp4', 'etclr' => 'no', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#464C5C', 'ptnbg' => '#F5F5F5', 'ttwidth' => '250px', 'ctcolor' => '#464C5C', 'cftcolor' => '#7d7d7d', 'furlclr' => '#2286C5', 'furlhvr' => '#7d7d7d', 'ccolbg' => '#F5F5F5', 'prnbg' => '', 'capbg1' => '#F5F5F5', 'capbg2' => '#F5F5F5', 'ccborder' => '#F5F5F5', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'pbrad' => '20', 'cbrad' => '20', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'enicon' => 'no', 'tick' => 'tick-2', 'cross' => 'cross-2', 'enimg' => 'yes', 'bgimg' => 'yes' );
		$package_details_color = array( 'pbclr' => array('#F5F5F5', '#F5F5F5', '#464C5C', '#F5F5F5'), 'tcolor' => array('#7d7d7d', '#7d7d7d', '#ffffff', '#7d7d7d'), 'thover' => array('#7d7d7d', '#7d7d7d', '#ffffff', '#7d7d7d'), 'tbcolor' => array('#F5F5F5', '#F5F5F5', '#464C5C', '#F5F5F5'), 'pcbig' => array('#7d7d7d', '#7d7d7d', '#ffffff', '#7d7d7d'), 'phbig' =>array('#7d7d7d', '#7d7d7d', '#ffffff', '#7d7d7d'), 'pcsmall' => array('#7d7d7d', '#7d7d7d', '#ffffff', '#7d7d7d'), 'phsmall' => array('#7d7d7d', '#7d7d7d', '#ffffff', '#7d7d7d'), 'cutclr' => array('#9d9d9d', '#9d9d9d', '#9d9d9d', '#9d9d9d'), 'pbcolor' => array('#F5F5F5', '#F5F5F5', '#464C5C', '#F5F5F5'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#7d7d7d', '#7d7d7d', '#ffffff', '#7d7d7d'), 'ftcolor' => array('#7d7d7d', '#7d7d7d', '#ffffff', '#7d7d7d'), 'fbrow1' => array('#F5F5F5', '#F5F5F5', '#464C5C', '#F5F5F5'), 'fbrow2' => array('#F5F5F5', '#F5F5F5', '#464C5C', '#F5F5F5'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#FF5277', '#527BFF', '#FFB052', '#4FCA39'), 'bhover' => array('#52586b', '#52586b', '#52586b', '#52586b'), 'bbcolor' => array('#F5F5F5', '#F5F5F5', '#464C5C', '#F5F5F5'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#2286C5', '#2286C5', '#22CD6A', '#2286C5'), 'ftborder' => array('#F5F5F5', '#F5F5F5', '#464C5C', '#F5F5F5') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 5) {
		$package_options_color = array( 'templ' => 'temp5', 'etclr' => 'yes', 'tbpad' => '1', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#3E7DE8', 'ptabg' => '#3E7DE8', 'ptnbg' => '#FCFCFD', 'ttwidth' => '220px', 'ctcolor' => '#24262E', 'cftcolor' => '#ffffff', 'furlclr' => '#3E7DE8', 'furlhvr' => '#ffffff', 'ccolbg' => '#24262E', 'prnbg' => '', 'capbg1' => '#24262E', 'capbg2' => '#24262E', 'ccborder' => '#24262E', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'pbrad' => '15', 'cbrad' => '15', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'enicon' => 'no', 'tick' => 'tick-2', 'cross' => 'cross-2', 'tcleft' => 'yes', 'enimg' => 'yes', 'bgimg' => 'yes' );
		$package_details_color = array( 'pbclr' => array('#FCFCFD', '#FCFCFD', '#24262E', '#FCFCFD'), 'tcolor' => array('#3E7DE8', '#3E7DE8', '#ffffff', '#3E7DE8'), 'thover' => array('#3E7DE8', '#3E7DE8', '#ffffff', '#3E7DE8'), 'tbcolor' => array('#FCFCFD', '#FCFCFD', '#24262E', '#FCFCFD'), 'pcbig' => array('#474A5D', '#474A5D', '#ffffff', '#474A5D'), 'phbig' =>array('#474A5D', '#474A5D', '#ffffff', '#474A5D'), 'pcsmall' => array('#474A5D', '#474A5D', '#ffffff', '#474A5D'), 'phsmall' => array('#474A5D', '#474A5D', '#ffffff', '#474A5D'), 'cutclr' => array('#8e8e91', '#8e8e91', '#8e8e91', '#8e8e91'), 'pbcolor' => array('#FCFCFD', '#FCFCFD', '#24262E', '#FCFCFD'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#eeeeee', '#eeeeee', '#eeeeee', '#eeeeee'), 'fncolor' => array('#3E7DE8', '#3E7DE8', '#ffffff', '#3E7DE8'), 'ftcolor' => array('#3E7DE8', '#3E7DE8', '#ffffff', '#3E7DE8'), 'fbrow1' => array('#FCFCFD', '#FCFCFD', '#24262E', '#FCFCFD'), 'fbrow2' => array('#FCFCFD', '#FCFCFD', '#24262E', '#FCFCFD'), 'btcolor' => array('#ffffff', '#ffffff', '#3E7DE8', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#3E7DE8', '#ffffff'), 'bcolor' => array('#3E7DE8', '#3E7DE8', '#F1F1F1', '#3E7DE8'), 'bhover' => array('#79a0e2', '#79a0e2', '#EEEEEE', '#79a0e2'), 'bbcolor' => array('#FCFCFD', '#FCFCFD', '#24262E', '#FCFCFD'), 'rtcolor' => array('#ffffff', '#ffffff', '#24262E', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#24262E', '#ffffff'), 'rbcolor' => array('#3E7DE8', '#3E7DE8', '#FCFCFD', '#3E7DE8'), 'ftborder' => array('#e1e1e1', '#e1e1e1', '#000000', '#e1e1e1') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 6) {
		$package_options_color = array( 'templ' => 'temp6', 'etclr' => 'yes', 'tbpad' => '1', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ttwidth' => '250px', 'ctcolor' => '#000000', 'cftcolor' => '#ffffff', 'furlclr' => '#ffffff', 'furlhvr' => '#FDCFDC', 'ccolbg' => '#dddddd', 'prnbg' => '', 'capbg1' => '#FB3988', 'capbg2' => '#FB3988', 'ccborder' => '#bbbbbb', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'pbrad' => '5', 'cbrad' => '5', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'enicon' => 'no', 'enimg' => 'yes', 'bgimg' => 'yes', 'crlepr' => 'yes', 'pbody' => '160px' );
		$package_details_color = array( 'pbclr' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'tcolor' => array('#000000', '#000000', '#ffffff', '#000000'), 'thover' => array('#000000', '#000000', '#ffffff', '#000000'), 'tbcolor' => array('#ffffff', '#ffffff', '#FB3988', '#ffffff'), 'pcbig' => array('#000000', '#000000', '#ffffff', '#000000'), 'phbig' =>array('#000000', '#000000', '#ffffff', '#000000'), 'pcsmall' => array('#000000', '#000000', '#ffffff', '#000000'), 'phsmall' => array('#000000', '#000000', '#ffffff', '#000000'), 'cutclr' => array('#000000', '#000000', '#ffffff', '#000000'), 'pbcolor' => array('#ffffff', '#ffffff', '#FB3988', '#ffffff'), 'pcircle' => array('#ffffff', '#ffffff', '#f94f91', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#868686', '#868686', '#fafafa', '#868686'), 'ftcolor' => array('#868686', '#868686', '#fafafa', '#868686'), 'fbrow1' => array('#ffffff', '#ffffff', '#FB3988', '#ffffff'), 'fbrow2' => array('#ffffff', '#ffffff', '#FB3988', '#ffffff'), 'btcolor' => array('#ffffff', '#ffffff', '#000000', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#000000', '#ffffff'), 'bcolor' => array('#FB3988', '#FB3988', '#f1f1f1', '#FB3988'), 'bhover' => array('#606060', '#606060', '#FDCFDC', '#606060'), 'bbcolor' => array('#ffffff', '#ffffff', '#FB3988', '#ffffff'), 'rtcolor' => array('#ffffff', '#ffffff', '#000000', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#000000', '#ffffff'), 'rbcolor' => array('#FB3988', '#FB3988', '#ffffff', '#FB3988'), 'ftborder' => array('#bbbbbb', '#bbbbbb', '#bbbbbb', '#bbbbbb') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 7) {
		$package_options_color = array( 'templ' => 'temp7', 'etclr' => 'no', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#F36523', 'ptnbg' => '#FDF5E0', 'ttwidth' => '220px', 'ctcolor' => '#00032E', 'cftcolor' => '#3D2A23', 'furlclr' => '#000000', 'furlhvr' => '#3D2A23', 'ccolbg' => '#FF9700', 'prnbg' => '', 'capbg1' => '#FF9700', 'capbg2' => '#FF9700', 'ccborder' => '#FF9700', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'pbrad' => '15', 'cbrad' => '15', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'enicon' => 'no', 'enimg' => 'yes', 'bgimg' => 'yes', 'crlepr' => 'yes', 'pbody' => '160px' );
		$package_details_color = array( 'pbclr' => array('#FFF568', '#FCD846', '#FECC17', '#FF9700'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#FFF568', '#FCD846', '#FECC17', '#FF9700'), 'pcbig' => array('#00032E', '#00032E', '#00032E', '#00032E'), 'phbig' =>array('#00032E', '#00032E', '#00032E', '#00032E'), 'pcsmall' => array('#00032E', '#00032E', '#00032E', '#00032E'), 'phsmall' => array('#00032E', '#00032E', '#00032E', '#00032E'), 'cutclr' => array('#908a3b', '#907b28', '#886d0c', '#804c00'), 'pbcolor' => array('#FFF568', '#FCD846', '#FECC17', '#FF9700'), 'pcircle' => array('#FFF568', '#FCD846', '#FECC17', '#FF9700'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#3D2A23', '#3D2A23', '#3D2A23', '#3D2A23'), 'ftcolor' => array('#3D2A23', '#3D2A23', '#3D2A23', '#3D2A23'), 'fbrow1' => array('#FFF568', '#FCD846', '#FECC17', '#FF9700'), 'fbrow2' => array('#FFF568', '#FCD846', '#FECC17', '#FF9700'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#F7BD00', '#FF9700', '#F7941D', '#F36523'), 'bhover' => array('#F7BD00', '#FF9700', '#F7941D', '#F36523'), 'bbcolor' => array('#FFF568', '#FCD846', '#FECC17', '#FF9700'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#C7BE47', '#FF9700', '#F7941D', '#F36523'), 'ftborder' => array('#FFF568', '#FCD846', '#FECC17', '#FF9700') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 8) {
		$package_options_color = array( 'templ' => 'temp8', 'etclr' => 'yes', 'tbpad' => '1', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ttwidth' => '250px', 'ctcolor' => '#173153', 'cftcolor' => '#ffffff', 'furlclr' => '#EB5D45', 'furlhvr' => '#ffffff', 'ccolbg' => '#212527', 'prnbg' => '', 'capbg1' => '#212527', 'capbg2' => '#212527', 'ccborder' => '#212527', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'pbrad' => '5', 'cbrad' => '5', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'enicon' => 'no', 'enimg' => 'yes', 'bgimg' => 'yes', 'crlepr' => 'yes', 'pbody' => '160px' );
		$package_details_color = array( 'pbclr' => array('#F36B54', '#F3BC45', '#445E80', '#0DDCA6'), 'tcolor' => array('#ffffff', '#000000', '#ffffff', '#000000'), 'thover' => array('#ffffff', '#000000', '#ffffff', '#000000'), 'tbcolor' => array('#F36B54', '#F3BC45', '#445E80', '#0DDCA6'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'pbcolor' => array('#F36B54', '#F3BC45', '#445E80', '#0DDCA6'), 'pcircle' => array('#EB5D45', '#FDC64F', '#173153', '#06D6A0'), 'imgclr' => array('#EB5D45', '#FDC64F', '#173153', '#06D6A0'), 'fncolor' => array('#650400', '#5a3900', '#97c5ff', '#004226'), 'ftcolor' => array('#650400', '#5a3900', '#97c5ff', '#004226'), 'fbrow1' => array('#F36B54', '#F3BC45', '#445E80', '#0DDCA6'), 'fbrow2' => array('#F36B54', '#F3BC45', '#445E80', '#0DDCA6'), 'btcolor' => array('#650400', '#5a3900', '#97c5ff', '#004226'), 'bthover' => array('#650400', '#5a3900', '#97c5ff', '#004226'), 'bcolor' => array('#EB5D45', '#FDC64F', '#173153', '#06D6A0'), 'bhover' => array('#FC8971', '#FEF47D', '#455F81', '#34FBCE'), 'bbcolor' => array('#F36B54', '#F3BC45', '#445E80', '#0DDCA6'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#EF476F', '#EF476F', '#EF476F', '#EF476F'), 'ftborder' => array('#F36B54', '#F3BC45', '#445E80', '#0DDCA6') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 9) {
		$package_options_color = array( 'templ' => 'temp9', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#350060', 'ptnbg' => '#f1f1f1', 'ttwidth' => '250px', 'ctcolor' => '#350060', 'cftcolor' => '#ffffff', 'furlclr' => '#ffffff', 'furlhvr' => '#ffffff', 'ccolbg' => '#350060', 'prnbg' => '', 'capbg1' => '#350060', 'capbg2' => '#350060', 'ccborder' => '#350060', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'pbrad' => '5', 'cbrad' => '5', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'enicon' => 'no', 'enimg' => 'yes', 'bgimg' => 'yes', 'tick' => 'tick-2', 'cross' => 'cross-2', 'crlepr' => 'yes', 'pbody' => '160px' );
		$package_details_color = array( 'pbclr' => array('#700389', '#53037E', '#400173', '#350060'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#700389', '#53037E', '#400173', '#350060'), 'pcbig' => array('#350060', '#350060', '#350060', '#350060'), 'phbig' =>array('#350060', '#350060', '#350060', '#350060'), 'pcsmall' => array('#350060', '#350060', '#350060', '#350060'), 'phsmall' => array('#350060', '#350060', '#350060', '#350060'), 'cutclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'pbcolor' => array('#700389', '#53037E', '#400173', '#350060'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#350060', '#350060', '#350060', '#350060'), 'fncolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'ftcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow1' => array('#700389', '#53037E', '#400173', '#350060'), 'fbrow2' => array('#700389', '#53037E', '#400173', '#350060'), 'btcolor' => array('#350060', '#350060', '#350060', '#350060'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#f1f1f1', '#f1f1f1', '#f1f1f1', '#f1f1f1'), 'bhover' => array('#EB0360', '#EB0360', '#EB0360', '#EB0360'), 'bbcolor' => array('#700389', '#53037E', '#400173', '#350060'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#E3013E', '#E3013E', '#E3013E', '#E3013E'), 'ftborder' => array('#700389', '#53037E', '#400173', '#350060') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 10) {
		$package_options_color = array( 'templ' => 'temp10', 'etclr' => 'yes', 'tbpad' => '1', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ttwidth' => '250px', 'ctcolor' => '#173153', 'cftcolor' => '#ffffff', 'furlclr' => '#EB5D45', 'furlhvr' => '#ffffff', 'ccolbg' => '#212527', 'prnbg' => '', 'capbg1' => '#212527', 'capbg2' => '#212527', 'ccborder' => '#212527', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'pbrad' => '5', 'cbrad' => '5', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'enicon' => 'no', 'enimg' => 'yes', 'bgimg' => 'yes', 'crlepr' => 'yes', 'pbody' => '160px' );
		$package_details_color = array( 'pbclr' => array('#4724CD', '#AE8819', '#465B01', '#A02A0A'), 'tcolor' => array('#4724CD', '#AE8819', '#465B01', '#A02A0A'), 'thover' => array('#4724CD', '#AE8819', '#465B01', '#A02A0A'), 'tbcolor' => array('#BFB8D9', '#EFCB60', '#C1D28D', '#FC9A6E'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'pbcolor' => array('#BFB8D9', '#EFCB60', '#C1D28D', '#FC9A6E'), 'pcircle' => array('#BFB8D9', '#EFCB60', '#C1D28D', '#FC9A6E'), 'imgclr' => array('#4724CD', '#AE8819', '#465B01', '#A02A0A'), 'fncolor' => array('#1A0295', '#765000', '#192700', '#680600'), 'ftcolor' => array('#1A0295', '#765000', '#192700', '#680600'), 'fbrow1' => array('#BFB8D9', '#EFCB60', '#C1D28D', '#FC9A6E'), 'fbrow2' => array('#BFB8D9', '#EFCB60', '#C1D28D', '#FC9A6E'), 'btcolor' => array('#BFB8D9', '#EFCB60', '#C1D28D', '#FC9A6E'), 'bthover' => array('#BFB8D9', '#EFCB60', '#C1D28D', '#FC9A6E'), 'bcolor' => array('#1A0295', '#765000', '#192700', '#680600'), 'bhover' => array('#4724CD', '#AE8819', '#465B01', '#A02A0A'), 'bbcolor' => array('#4724CD', '#AE8819', '#465B01', '#A02A0A'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#EF476F', '#EF476F', '#EF476F', '#EF476F'), 'ftborder' => array('#F36B54', '#F3BC45', '#445E80', '#0DDCA6') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 11) {
		$package_options_color = array( 'templ' => 'temp11', 'etclr' => 'yes', 'tbpad' => '10', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#AA2626', 'ptnbg' => '#dddddd', 'ttwidth' => '220px', 'ctcolor' => '#AA2626', 'cftcolor' => '#787878', 'furlclr' => '#787878', 'furlhvr' => '#212121', 'ccolbg' => '#F5F5F5', 'prnbg' => '', 'capbg1' => '#F5F5F5', 'capbg2' => '#F5F5F5', 'ccborder' => '#bbbbbb', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'pbrad' => '0', 'cbrad' => '0', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'enicon' => 'no', 'btompr' => 'yes', 'enimg' => 'yes', 'bgimg' => 'no', 'opimg' => 'opt-1', 'imgwid' => '290px', 'imghgt' => '200px', 'imgmrg' => 'auto' );
		$package_details_color = array( 'pbclr' => array('#F5F5F5', '#F5F5F5', '#AA2626', '#F5F5F5'), 'tcolor' => array('#212121', '#212121', '#ffffff', '#212121'), 'thover' => array('#212121', '#212121', '#ffffff', '#212121'), 'tbcolor' => array('#F5F5F5', '#F5F5F5', '#AA2626', '#F5F5F5'), 'pcbig' => array('#212121', '#212121', '#AA2626', '#212121'), 'phbig' =>array('#212121', '#212121', '#AA2626', '#212121'), 'pcsmall' => array('#212121', '#212121', '#AA2626', '#212121'), 'phsmall' => array('#212121', '#212121', '#AA2626', '#212121'), 'cutclr' => array('#9d9d9d', '#9d9d9d', '#9d9d9d', '#9d9d9d'), 'pbcolor' => array('#ffffff', '#ffffff', '#FFF0F0', '#ffffff'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#ffffff', '#ffffff', '#FFF0F0', '#ffffff'), 'fncolor' => array('#212121', '#212121', '#787878', '#212121'), 'ftcolor' => array('#212121', '#212121', '#787878', '#212121'), 'fbrow1' => array('#ffffff', '#ffffff', '#FFF0F0', '#ffffff'), 'fbrow2' => array('#ffffff', '#ffffff', '#FFF0F0', '#ffffff'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#B53131', '#B53131', '#B53131', '#B53131'), 'bhover' => array('#AA2626', '#AA2626', '#AA2626', '#AA2626'), 'bbcolor' => array('#F5F5F5', '#F5F5F5', '#AA2626', '#F5F5F5'), 'rtcolor' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rthover' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rbcolor' => array('#ffc100', '#ffc100', '#ffc100', '#ffc100'), 'ftborder' => array('#bbbbbb', '#bbbbbb', '#bbbbbb', '#bbbbbb') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 12) {
		$package_options_color = array( 'templ' => 'temp12', 'etclr' => 'yes', 'tbpad' => '1', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#AA2626', 'ptnbg' => '#dddddd', 'ttwidth' => '220px', 'ctcolor' => '#AA2626', 'cftcolor' => '#787878', 'furlclr' => '#787878', 'furlhvr' => '#212121', 'ccolbg' => '#F5F5F5', 'prnbg' => '', 'capbg1' => '#F5F5F5', 'capbg2' => '#F5F5F5', 'ccborder' => '#bbbbbb', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'pbrad' => '0', 'cbrad' => '0', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'enicon' => 'no', 'enimg' => 'yes', 'bgimg' => 'no', 'opimg' => 'opt-1', 'imgwid' => '130px', 'imghgt' => '160px', 'imgmrg' => 'auto', 'imgopc' => '2', 'crlepr' => 'yes', 'pbody' => '160px' );
		$package_details_color = array( 'pbclr' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'tcolor' => array('#444444', '#444444', '#444444', '#444444'), 'thover' => array('#0099E5', '#0099E5', '#0099E5', '#0099E5'), 'tbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcbig' => array('#444444', '#444444', '#444444', '#444444'), 'phbig' =>array('#0099E5', '#0099E5', '#0099E5', '#0099E5'), 'pcsmall' => array('#444444', '#444444', '#444444', '#444444'), 'phsmall' => array('#0099E5', '#0099E5', '#0099E5', '#0099E5'), 'cutclr' => array('#9d9d9d', '#9d9d9d', '#9d9d9d', '#9d9d9d'), 'pbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fncolor' => array('#444444', '#444444', '#444444', '#444444'), 'ftcolor' => array('#444444', '#444444', '#444444', '#444444'), 'fbrow1' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow2' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#444444', '#444444', '#444444', '#444444'), 'bhover' => array('#0099E5', '#0099E5', '#0099E5', '#0099E5'), 'bbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#0099E5', '#0099E5', '#0099E5', '#0099E5'), 'rbcolor' => array('#F9D930', '#F9D930', '#F9D930', '#F9D930'), 'ftborder' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 13) {
		$package_options_color = array( 'templ' => 'temp13', 'etclr' => 'yes', 'tbpad' => '3', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ttwidth' => '250px', 'ctcolor' => '#173153', 'cftcolor' => '#ffffff', 'furlclr' => '#EB5D45', 'furlhvr' => '#ffffff', 'ccolbg' => '#212527', 'prnbg' => '', 'capbg1' => '#212527', 'capbg2' => '#212527', 'ccborder' => '#212527', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'pbrad' => '5', 'cbrad' => '5', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'enicon' => 'no', 'enimg' => 'yes', 'bgimg' => 'no', 'opimg' => 'opt-1', 'imgwid' => '130px', 'imghgt' => '160px', 'imgmrg' => '18px auto 0', 'imgopc' => '10', 'btompr' => 'yes', 'pbody' => '80px', 'ftbody' => '30px' );
		$package_details_color = array( 'pbclr' => array('#7AC143', '#17D5D1', '#FFE92E', '#0F1C70'), 'tcolor' => array('#7AC143', '#17D5D1', '#FFE92E', '#0F1C70'), 'thover' => array('#7AC143', '#17D5D1', '#FFE92E', '#0F1C70'), 'tbcolor' => array('#ffffff', '#ffffff', '#0f1c70', '#ffffff'), 'pcbig' => array('#7AC143', '#17D5D1', '#FFE92E', '#0F1C70'), 'phbig' =>array('#7AC143', '#17D5D1', '#FFE92E', '#0F1C70'), 'pcsmall' => array('#7AC143', '#17D5D1', '#FFE92E', '#0F1C70'), 'phsmall' => array('#7AC143', '#17D5D1', '#FFE92E', '#0F1C70'), 'cutclr' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'pbcolor' => array('#ffffff', '#ffffff', '#0f1c70', '#ffffff'), 'pcircle' => array('#7AC143', '#17D5D1', '#FFE92E', '#0F1C70'), 'imgclr' => array('#ffffff', '#ffffff', '#0f1c70', '#ffffff'), 'fncolor' => array('#7AC143', '#17D5D1', '#FFE92E', '#0F1C70'), 'ftcolor' => array('#7AC143', '#17D5D1', '#FFE92E', '#0F1C70'), 'fbrow1' => array('#ffffff', '#ffffff', '#0f1c70', '#ffffff'), 'fbrow2' => array('#ffffff', '#ffffff', '#0f1c70', '#ffffff'), 'btcolor' => array('#333333', '#333333', '#333333', '#333333'), 'bthover' => array('#333333', '#333333', '#333333', '#333333'), 'bcolor' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'bhover' => array('#eeeeee', '#eeeeee', '#eeeeee', '#eeeeee'), 'bbcolor' => array('#7AC143', '#17D5D1', '#FFE92E', '#0F1C70'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#EF476F', '#EF476F', '#EF476F', '#EF476F'), 'ftborder' => array('#F36B54', '#F3BC45', '#445E80', '#0DDCA6') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 14) {
		$package_options_color = array( 'templ' => 'temp14', 'ftdir' => 'left', 'ftpad' => '10', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#7dc3be', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ctcolor' => '#333333', 'cftcolor' => '#ffffff', 'furlclr' => '#564817', 'furlhvr' => '#ffffff', 'ccolbg' => '#947a21', 'prnbg' => '', 'capbg1' => '#d6b02d', 'capbg2' => '#d6b02d', 'ccborder' => '#947a21', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'tick' => 'tick-2', 'cross' => 'cross-2', 'envid' => 'yes', 'opvid' => 'vid-1', 'vbody' => '200px' );
		$package_details_color = array( 'pbclr' => array('#568626', '#432463', '#841837', '#792409'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#7ec338', '#713da6', '#bc2651', '#b2350d'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#aaef64', '#c692f5', '#f877a2', '#f5865e'), 'pbcolor' => array('#7ec338', '#713da6', '#bc2651', '#b2350d'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#568626', '#432463', '#841837', '#792409'), 'fncolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'ftcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow1' => array('#7ec338', '#713da6', '#bc2651', '#b2350d'), 'fbrow2' => array('#7ec338', '#713da6', '#bc2651', '#b2350d'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#AAEF64', '#A06CD5', '#EB5580', '#E1643C'), 'bhover' => array('#AAEF64', '#A06CD5', '#EB5580', '#E1643C'), 'bbcolor' => array('#7ec338', '#713da6', '#bc2651', '#b2350d'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#AAEF64', '#A06CD5', '#EB5580', '#E1643C'), 'ftborder' => array('#568626', '#432463', '#841837', '#792409') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 15) {
		$package_options_color = array( 'templ' => 'temp15', 'etclr' => 'yes', 'tbpad' => '1', 'ftdir' => 'left', 'ftpad' => '20', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#39B54A', 'ptnbg' => '#E6E6E6', 'ttwidth' => '200px', 'ctcolor' => '#666666', 'cftcolor' => '#666666', 'furlclr' => '#39B54A', 'furlhvr' => '#666666', 'ccolbg' => '#ECECEC', 'prnbg' => '', 'capbg1' => '#ffffff', 'capbg2' => '#F7F7F7', 'ccborder' => '#ECECEC', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'pbrad' => '0', 'cbrad' => '0', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'btompr' => 'yes', 'envid' => 'yes', 'opvid' => 'vid-1', 'vbody' => '200px' );
		$package_details_color = array( 'pbclr' => array('#E6E6E6', '#E6E6E6', '#E6E6E6', '#E6E6E6'), 'tcolor' => array('#666666', '#666666', '#666666', '#666666'), 'thover' => array('#666666', '#666666', '#666666', '#666666'), 'tbcolor' => array('#E7E7E7', '#E7E7E7', '#E7E7E7', '#E7E7E7'), 'pcbig' => array('#000000', '#000000', '#ffffff', '#000000'), 'phbig' =>array('#000000', '#000000', '#ffffff', '#000000'), 'pcsmall' => array('#000000', '#000000', '#ffffff', '#000000'), 'phsmall' => array('#000000', '#000000', '#ffffff', '#000000'), 'cutclr' => array('#808080', '#808080', '#f7f7f7', '#808080'), 'pbcolor' => array('#E6E6E6', '#E6E6E6', '#39B54A', '#E6E6E6'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#666666', '#666666', '#666666', '#666666'), 'ftcolor' => array('#666666', '#666666', '#666666', '#666666'), 'fbrow1' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow2' => array('#F7F7F7', '#F7F7F7', '#F7F7F7', '#F7F7F7'), 'btcolor' => array('#ffffff', '#ffffff', '#39B54A', '#ffffff'), 'bthover' => array('#39B54A', '#39B54A', '#ffffff', '#39B54A'), 'bcolor' => array('#39B54A', '#39B54A', '#E6E6E6', '#39B54A'), 'bhover' => array('#ffffff', '#ffffff', '#39B54A', '#ffffff'), 'bbcolor' => array('#E6E6E6', '#E6E6E6', '#39B54A', '#E6E6E6'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#39B54A', '#39B54A', '#FF931E', '#FF931E'), 'ftborder' => array('#E6E6E6', '#E6E6E6', '#E6E6E6', '#E6E6E6') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 16) {
		$package_options_color = array( 'templ' => 'temp16', 'etclr' => 'yes', 'tbpad' => '1', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'colgap' => '0', 'tttext' => '#FFFFFF', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ctcolor' => '#333333', 'cftcolor' => '#000000', 'furlclr' => '#ed662f', 'furlhvr' => '#000000', 'ccolbg' => '#dddddd', 'prnbg' => '', 'capbg1' => '#ececec', 'capbg2' => '#ffffff', 'ccborder' => '#bbbbbb', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'markrib' => 'rb-2', 'ftcap' => 'yes', 'ttwidth' => '220px' );
		$package_details_color = array( 'pbclr' => array('#ed662f', '#ea2e2d', '#BE292D', '#993124'), 'tcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'thover' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'tbcolor' => array('#ed662f', '#ea2e2d', '#BE292D', '#993124'), 'pcbig' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phbig' =>array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'pcsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'cutclr' => array('#993124', '#993124', '#ed662f', '#ed662f'), 'pbcolor' => array('#ed662f', '#ea2e2d', '#BE292D', '#993124'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#000000', '#000000', '#000000', '#000000'), 'ftcolor' => array('#000000', '#000000', '#000000', '#000000'), 'fbrow1' => array('#ffffff', '#ececec', '#ffffff', '#ececec'), 'fbrow2' => array('#ececec', '#ffffff', '#ececec', '#ffffff'), 'btcolor' => array('#000000', '#000000', '#000000', '#000000'), 'bthover' => array('#000000', '#000000', '#000000', '#000000'), 'bcolor' => array('#ececec', '#ececec', '#ececec', '#ececec'), 'bhover' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'bbcolor' => array('#ed662f', '#ea2e2d', '#BE292D', '#993124'), 'rtcolor' => array('#993124', '#993124', '#993124', '#993124'), 'rthover' => array('#993124', '#993124', '#993124', '#993124'), 'rbcolor' => array('#f7db53', '#f7db53', '#f7db53', '#f7db53'), 'ftborder' => array('#bbbbbb', '#bbbbbb', '#bbbbbb', '#bbbbbb') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 17) {
		$package_options_color = array( 'templ' => 'temp17', 'etclr' => 'yes', 'tbpad' => '1', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#FF4D00', 'ptnbg' => '#f7f7f7', 'ttwidth' => '220px', 'ctcolor' => '#FF7400', 'cftcolor' => '#333333', 'furlclr' => '#FF7400', 'furlhvr' => '#333333', 'ccolbg' => '#ececec', 'prnbg' => '', 'capbg1' => '#f7f7f7', 'capbg2' => '#ffffff', 'ccborder' => '#bbbbbb', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'pbrad' => '5', 'cbrad' => '5', 'enicon' => 'no', 'ftcap' => 'yes', 'colgap' => '0', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes' );
		$package_details_color = array( 'pbclr' => array('#ececec', '#ececec', '#ececec', '#ececec'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#ffaa29', '#ff8a29', '#ff6928', '#ff462a'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#d37e00', '#cc6200', '#d12900', '#c92800'), 'pbcolor' => array('#ff9a00', '#ff7400', '#ff4d00', '#fb2201'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#333333', '#333333', '#333333', '#333333'), 'ftcolor' => array('#333333', '#333333', '#333333', '#333333'), 'fbrow1' => array('#ffffff', '#f7f7f7', '#ffffff', '#f7f7f7'), 'fbrow2' => array('#f7f7f7', '#ffffff', '#f7f7f7', '#ffffff'), 'btcolor' => array('#ff9a00', '#ff7400', '#ff4d00', '#fb2201'), 'bthover' => array('#ff9a00', '#ff7400', '#ff4d00', '#fb2201'), 'bcolor' => array('#ededed', '#ededed', '#ededed', '#ededed'), 'bhover' => array('#f7f7f7', '#f7f7f7', '#f7f7f7', '#f7f7f7'), 'bbcolor' => array('#ff9a00', '#ff7400', '#ff4d00', '#fb2201'), 'rtcolor' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rthover' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rbcolor' => array('#ffc100', '#ffc100', '#ffc100', '#ffc100'), 'ftborder' => array('#bbbbbb', '#bbbbbb', '#bbbbbb', '#bbbbbb') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 18) {
		$package_options_color = array( 'templ' => 'temp18', 'etclr' => 'no', 'colgap' => '0', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#419727', 'ptnbg' => '#F6F6F6', 'ttwidth' => '220px', 'ctcolor' => '#357B1F', 'cftcolor' => '#333333', 'furlclr' => '', 'furlhvr' => '', 'ccolbg' => '#dddddd', 'prnbg' => '', 'capbg1' => '#EBEBEB', 'capbg2' => '#FFFFFF', 'ccborder' => '#dddddd', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'pbrad' => '10', 'cbrad' => '10', 'enicon' => 'no', 'ftcap' => 'yes' );
		$package_details_color = array( 'pbclr' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#5E9737', '#487D29', '#356A1E', '#275C17'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#f5f5f5', '#f5f5f5', '#f5f5f5', '#f5f5f5'), 'pbcolor' => array('#7CAC49', '#5F9836', '#468928', '#34791F'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#333333', '#333333', '#333333', '#333333'), 'ftcolor' => array('#333333', '#333333', '#333333', '#333333'), 'fbrow1' => array('#F6F6F6', '#EBEBEB', '#F6F6F6', '#EBEBEB'), 'fbrow2' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#629634', '#478025', '#32701A', '#245F14'), 'bhover' => array('#A9CA63', '#82BE4A', '#61B637', '#47A62A'), 'bbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#B53535', '#B53535', '#B53535', '#B53535'), 'ftborder' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 19) {
		$package_options_color = array( 'templ' => 'temp19', 'etclr' => 'yes', 'tbpad' => '1', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0152C6', 'ptnbg' => '#F5F5F5', 'ttwidth' => '250px', 'ctcolor' => '#7d7d7d', 'cftcolor' => '#7d7d7d', 'furlclr' => '#2286C5', 'furlhvr' => '#7d7d7d', 'ccolbg' => '#F5F5F5', 'prnbg' => '#F5F5F5', 'capbg1' => '#EBEBEB', 'capbg2' => '#F5F5F5', 'ccborder' => '#dddddd', 'colshad' => 'no', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'enicon' => 'no', 'ftcap' => 'yes', 'colgap' => '0', 'ctsize' => '18px', 'enfatc' => 'yes', 'awetick' => 'fas fa-check', 'awecross' => 'fas fa-times', 'captbg' => 'yes', 'cttdir' => 'center' );
		$package_details_color = array( 'pbclr' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#276CCF', '#4398CE', '#5EC4CD', '#68D5CD'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#F5F5F5', '#F5F5F5', '#F5F5F5', '#F5F5F5'), 'pbcolor' => array('#0152C6', '#2286C5', '#42BAC4', '#4ECDC4'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#7d7d7d', '#7d7d7d', '#7d7d7d', '#7d7d7d'), 'ftcolor' => array('#7d7d7d', '#7d7d7d', '#7d7d7d', '#7d7d7d'), 'fbrow1' => array('#EBEBEB', '#EBEBEB', '#EBEBEB', '#EBEBEB'), 'fbrow2' => array('#F5F5F5', '#F5F5F5', '#F5F5F5', '#F5F5F5'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#0152C6', '#2286C5', '#42BAC4', '#4ECDC4'), 'bhover' => array('#3374D1', '#4E9ED0', '#67C7CF', '#71D7CF'), 'bbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#FFC400', '#FFC400', '#FFC400', '#FFC400'), 'ftborder' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 20) {
		$package_options_color = array( 'templ' => 'temp20', 'etclr' => 'no', 'colgap' => '0', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#B63636', 'ptnbg' => '#F6F6F6', 'ttwidth' => '220px', 'ctcolor' => '#D87800', 'cftcolor' => '#333333', 'furlclr' => '', 'furlhvr' => '', 'ccolbg' => '#dddddd', 'prnbg' => '', 'capbg1' => '#EBEBEB', 'capbg2' => '#FFFFFF', 'ccborder' => '#dddddd', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'pbrad' => '10', 'cbrad' => '10', 'enicon' => 'no', 'ftcap' => 'yes' );
		$package_details_color = array( 'pbclr' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#E49200', '#D66303', '#A92C2C', '#7F2A3B'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#f5f5f5', '#f5f5f5', '#f5f5f5', '#f5f5f5'), 'pbcolor' => array('#E9A500', '#D77500', '#B43333', '#7B2839'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#333333', '#333333', '#333333', '#333333'), 'ftcolor' => array('#333333', '#333333', '#333333', '#333333'), 'fbrow1' => array('#F6F6F6', '#EBEBEB', '#F6F6F6', '#EBEBEB'), 'fbrow2' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#E0900D', '#CA620D', '#A12E2E', '#682532'), 'bhover' => array('#F1C600', '#E6A000', '#CB4343', '#BA5C70'), 'bbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#59A532', '#59A532', '#59A532', '#59A532'), 'ftborder' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 21) {
		$package_options_color = array( 'templ' => 'temp21', 'etclr' => 'no', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#3A416F', 'ptabg' => '#3A416F', 'ptnbg' => '#FDFDFE', 'ttwidth' => '220px', 'ctcolor' => '#3A416F', 'cftcolor' => '#5d6494', 'furlclr' => '#5470FE', 'furlhvr' => '#5d6494', 'ccolbg' => '#E2E4EF', 'prnbg' => '#FDFDFE', 'capbg1' => '#FDFDFE', 'capbg2' => '#FDFDFE', 'ccborder' => '#E2E4EF', 'fcatbg' => '#ECEDF5', 'cfsize' => '', 'fcbody' => '', 'ffnclr' => '#5d6494', 'cscolor' => '#E0E0EA', 'cshcolor' => '#DADCE8', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'enicon' => 'no', 'encate' => 'yes', 'ftcap' => 'yes', 'colgap' => '0', 'enfbor' => 'yes', 'encbor' => 'yes', 'colshad' => 'no' );
		$package_details_color = array( 'pbclr' => array('#FEFEFE', '#FEFEFE', '#FEFEFE', '#FEFEFE'), 'tcolor' => array('#5d6494', '#5d6494', '#5d6494', '#ffffff'), 'thover' => array('#5d6494', '#5d6494', '#5d6494', '#ffffff'), 'tbcolor' => array('#F5F5FA', '#F5F5FA', '#F5F5FA', '#383F6B'), 'pcbig' => array('#383F6B', '#383F6B', '#383F6B', '#ffffff'), 'phbig' =>array('#383F6B', '#383F6B', '#383F6B', '#ffffff'), 'pcsmall' => array('#383F6B', '#383F6B', '#383F6B', '#ffffff'), 'phsmall' => array('#383F6B', '#383F6B', '#383F6B', '#ffffff'), 'cutclr' => array('#5d6494', '#5d6494', '#5d6494', '#c5c9e0'), 'pbcolor' => array('#F5F5FA', '#F5F5FA', '#F5F5FA', '#383F6B'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#848ab8', '#848ab8', '#848ab8', '#c5c9e0'), 'ftcolor' => array('#848ab8', '#848ab8', '#848ab8', '#c5c9e0'), 'fbrow1' => array('#F5F5FA', '#F5F5FA', '#F5F5FA', '#32385F'), 'fbrow2' => array('#F5F5FA', '#F5F5FA', '#F5F5FA', '#32385F'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#5d6494'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#5d6494'), 'bcolor' => array('#5A6DFF', '#5A6DFF', '#5A6DFF', '#E5E5EA'), 'bhover' => array('#5A6DFF', '#5A6DFF', '#5A6DFF', '#E5E5EA'), 'bbcolor' => array('#F5F5FA', '#F5F5FA', '#F5F5FA', '#32385F'), 'rtcolor' => array('#FEFEFE', '#FEFEFE', '#FEFEFE', '#FEFEFE'), 'rthover' => array('#FEFEFE', '#FEFEFE', '#FEFEFE', '#FEFEFE'), 'rbcolor' => array('#3AB2BD', '#F3A57E', '#EA71BC', '#5468FF'), 'ftborder' => array('#D8DBEA', '#D8DBEA', '#D8DBEA', '#282d51') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 22) {
		$package_options_color = array( 'templ' => 'temp22', 'etclr' => 'no', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#2C2C2C', 'ptnbg' => '#EBEBEB', 'ttwidth' => '200px', 'ctcolor' => '#9d9d9d', 'cftcolor' => '#7d7d7d', 'furlclr' => '#2286C5', 'furlhvr' => '#7d7d7d', 'ccolbg' => '#dddddd', 'prnbg' => '', 'capbg1' => '#e2e2e2', 'capbg2' => '#f5f5f5', 'ccborder' => '#dddddd', 'fcatbg' => '#2C2C2C', 'colshad' => 'no', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'enicon' => 'no', 'encate' => 'yes', 'ftcap' => 'yes', 'colgap' => '0', 'ctsize' => '18px', 'enfatc' => 'yes', 'awetick' => 'fas fa-check', 'awecross' => 'fas fa-times', 'captbg' => 'yes', 'cttdir' => 'left', 'pbrad' => '0', 'cbrad' => '0' );
		$package_details_color = array( 'pbclr' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'tcolor' => array('#9d9d9d', '#9d9d9d', '#9d9d9d', '#9d9d9d'), 'thover' => array('#9d9d9d', '#9d9d9d', '#9d9d9d', '#9d9d9d'), 'tbcolor' => array('#2C2C2C', '#2C2C2C', '#2C2C2C', '#2C2C2C'), 'pcbig' => array('#5EC4CD', '#5EC4CD', '#5EC4CD', '#5EC4CD'), 'phbig' =>array('#5EC4CD', '#5EC4CD', '#5EC4CD', '#5EC4CD'), 'pcsmall' => array('#9d9d9d', '#9d9d9d', '#9d9d9d', '#9d9d9d'), 'phsmall' => array('#9d9d9d', '#9d9d9d', '#9d9d9d', '#9d9d9d'), 'cutclr' => array('#7d7d7d', '#7d7d7d', '#7d7d7d', '#7d7d7d'), 'pbcolor' => array('#2C2C2C', '#2C2C2C', '#2C2C2C', '#2C2C2C'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#7d7d7d', '#7d7d7d', '#7d7d7d', '#7d7d7d'), 'ftcolor' => array('#7d7d7d', '#7d7d7d', '#7d7d7d', '#7d7d7d'), 'fbrow1' => array('#e6e6e6', '#e2e2e2', '#e6e6e6', '#e2e2e2'), 'fbrow2' => array('#ffffff', '#f5f5f5', '#ffffff', '#f5f5f5'), 'btcolor' => array('#2C2C2C', '#2C2C2C', '#2C2C2C', '#2C2C2C'), 'bthover' => array('#2C2C2C', '#2C2C2C', '#2C2C2C', '#2C2C2C'), 'bcolor' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'bhover' => array('#eeeeee', '#eeeeee', '#eeeeee', '#eeeeee'), 'bbcolor' => array('#f5f5f5', '#f5f5f5', '#f5f5f5', '#f5f5f5'), 'rtcolor' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rthover' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rbcolor' => array('#ffc100', '#ffc100', '#ffc100', '#ffc100'), 'ftborder' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 23) {
		$package_options_color = array( 'templ' => 'temp23', 'etclr' => 'no', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#AA2626', 'ptnbg' => '#EBEBEB', 'ttwidth' => '200px', 'ctcolor' => '#AA2626', 'cftcolor' => '#7d7d7d', 'furlclr' => '#2286C5', 'furlhvr' => '#7d7d7d', 'ccolbg' => '#dddddd', 'prnbg' => '', 'capbg1' => '#e2e2e2', 'capbg2' => '#f5f5f5', 'ccborder' => '#dddddd', 'fcatbg' => '#AA2626', 'colshad' => 'no', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'enicon' => 'no', 'encate' => 'yes', 'ftcap' => 'yes', 'colgap' => '0', 'ctsize' => '18px', 'enfatc' => 'yes', 'awetick' => 'fas fa-check', 'awecross' => 'fas fa-times', 'captbg' => 'yes', 'cttdir' => 'left', 'pbrad' => '0', 'cbrad' => '0' );
		$package_details_color = array( 'pbclr' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#AA2626', '#AA2626', '#AA2626', '#AA2626'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#e67e7e', '#e67e7e', '#e67e7e', '#e67e7e'), 'phsmall' => array('#e67e7e', '#e67e7e', '#e67e7e', '#e67e7e'), 'cutclr' => array('#e67e7e', '#e67e7e', '#e67e7e', '#e67e7e'), 'pbcolor' => array('#AA2626', '#AA2626', '#AA2626', '#AA2626'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#7d7d7d', '#7d7d7d', '#7d7d7d', '#7d7d7d'), 'ftcolor' => array('#7d7d7d', '#7d7d7d', '#7d7d7d', '#7d7d7d'), 'fbrow1' => array('#e6e6e6', '#e2e2e2', '#e6e6e6', '#e2e2e2'), 'fbrow2' => array('#ffffff', '#f5f5f5', '#ffffff', '#f5f5f5'), 'btcolor' => array('#AA2626', '#AA2626', '#AA2626', '#AA2626'), 'bthover' => array('#AA2626', '#AA2626', '#AA2626', '#AA2626'), 'bcolor' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'bhover' => array('#eeeeee', '#eeeeee', '#eeeeee', '#eeeeee'), 'bbcolor' => array('#f5f5f5', '#f5f5f5', '#f5f5f5', '#f5f5f5'), 'rtcolor' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rthover' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rbcolor' => array('#ffc100', '#ffc100', '#ffc100', '#ffc100'), 'ftborder' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 24) {
		$package_options_color = array( 'templ' => 'temp24', 'etclr' => 'yes', 'tbpad' => '1', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#F1F1F1', 'ptnbg' => '#F6F6F6', 'ctcolor' => '#2D3236', 'cftcolor' => '#353132', 'furlclr' => '#000000', 'furlhvr' => '#353132', 'ccolbg' => '#ffffff', 'prnbg' => '#F1F1F1', 'capbg1' => '#F6F6F6', 'capbg2' => '#EFEFEF', 'ccborder' => '#CCCCCC', 'fcatbg' => '#e4e4e4', 'ffnclr' => '#303133', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'ttwidth' => '220px', 'colshad' => 'no', 'enicon' => 'no', 'ftcap' => 'yes', 'colgap' => '0', 'ctsize' => '18px', 'pbrad' => '15', 'cbrad' => '15', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'captbg' => 'yes', 'cttdir' => 'center', 'enfbor' => 'yes', 'encbor' => 'yes', 'encate' => 'yes', 'cfsize' => '', 'fcbody' => '' );
		$package_details_color = array( 'pbclr' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#2A6E79', '#4B7221', '#A7820D', '#8B562A'), 'pcbig' => array('#303133', '#303133', '#303133', '#303133'), 'phbig' =>array('#303133', '#303133', '#303133', '#303133'), 'pcsmall' => array('#303133', '#303133', '#303133', '#303133'), 'phsmall' => array('#303133', '#303133', '#303133', '#303133'), 'cutclr' => array('#A1A1A1', '#A1A1A1', '#A1A1A1', '#A1A1A1'), 'pbcolor' => array('#ECECEC', '#ECECEC', '#ECECEC', '#ECECEC'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#353132', '#353132', '#353132', '#353132'), 'ftcolor' => array('#353132', '#353132', '#353132', '#353132'), 'fbrow1' => array('#F6F6F6', '#F6F6F6', '#F6F6F6', '#F6F6F6'), 'fbrow2' => array('#EFEFEF', '#EFEFEF', '#EFEFEF', '#EFEFEF'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#2A6E79', '#4B7221', '#A7820D', '#8B562A'), 'bhover' => array('#2A6E79', '#4B7221', '#A7820D', '#8B562A'), 'bbcolor' => array('#E2E2E2', '#E2E2E2', '#E2E2E2', '#E2E2E2'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#773332', '#773332', '#773332', '#773332'), 'ftborder' => array('#CCCCCC', '#CCCCCC', '#CCCCCC', '#CCCCCC') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 25) {
		$package_options_color = array( 'templ' => 'temp25', 'etclr' => 'no', 'colgap' => '0', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#D4ADAE', 'ptnbg' => '#E6FCF9', 'ctcolor' => '#AD8B8A', 'cftcolor' => '#00070E', 'furlclr' => '', 'furlhvr' => '', 'ccolbg' => '#D4ADAE', 'prnbg' => '', 'capbg1' => '#D4ADAE', 'capbg2' => '#D4ADAE', 'ccborder' => '#D4ADAE', 'fcatbg' => '#e0b8b9', 'ffnclr' => '#00070e', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'ttwidth' => '220px', 'colshad' => 'no', 'pbrad' => '15', 'cbrad' => '15', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'enicon' => 'no', 'ftcap' => 'yes', 'ctsize' => '18px', 'encate' => 'yes', 'cfsize' => '', 'fcbody' => '' );
		$package_details_color = array( 'pbclr' => array('#EAFAF9', '#FCE7EC', '#EBD7D8', '#A2D2E0'), 'tcolor' => array('#00070E', '#00070E', '#00070E', '#00070E'), 'thover' => array('#00070E', '#00070E', '#00070E', '#00070E'), 'tbcolor' => array('#EAFAF9', '#FCE7EC', '#EBD7D8', '#A2D2E0'), 'pcbig' => array('#00070E', '#00070E', '#00070E', '#00070E'), 'phbig' =>array('#00070E', '#00070E', '#00070E', '#00070E'), 'pcsmall' => array('#00070E', '#00070E', '#00070E', '#00070E'), 'phsmall' => array('#00070E', '#00070E', '#00070E', '#00070E'), 'cutclr' => array('#80CBC7', '#FF6B8B', '#D2AEAE', '#5BBFD9'), 'pbcolor' => array('#EAFAF9', '#FCE7EC', '#EBD7D8', '#A2D2E0'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#00070E', '#00070E', '#00070E', '#00070E'), 'ftcolor' => array('#00070E', '#00070E', '#00070E', '#00070E'), 'fbrow1' => array('#EAFAF9', '#FCE7EC', '#EBD7D8', '#A2D2E0'), 'fbrow2' => array('#EAFAF9', '#FCE7EC', '#EBD7D8', '#A2D2E0'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#80CBC7', '#FF6B8B', '#D2AEAE', '#5BBFD9'), 'bhover' => array('#80CBC7', '#FF6B8B', '#D2AEAE', '#5BBFD9'), 'bbcolor' => array('#EAFAF9', '#FCE7EC', '#EBD7D8', '#A2D2E0'), 'rtcolor' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rthover' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rbcolor' => array('#80CBC7', '#FF6B8B', '#D2AEAE', '#5BBFD9'), 'ftborder' => array('#EAFAF9', '#FCE7EC', '#EBD7D8', '#A2D2E0') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 26) {
		$package_options_color = array( 'templ' => 'temp26', 'etclr' => 'no', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#839C0E', 'ptnbg' => '#E9AA00', 'ttwidth' => '200px', 'ctcolor' => '#E18416', 'cftcolor' => '#7d7d7d', 'furlclr' => '#E18416', 'furlhvr' => '#7d7d7d', 'ccolbg' => '#dddddd', 'prnbg' => '', 'capbg1' => '#e2e2e2', 'capbg2' => '#f5f5f5', 'ccborder' => '#dddddd', 'colshad' => 'no', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'enicon' => 'no', 'ftcap' => 'yes', 'colgap' => '0', 'ctsize' => '18px', 'enfatc' => 'yes', 'awetick' => 'fas fa-check', 'awecross' => 'fas fa-times', 'captbg' => 'yes', 'cttdir' => 'center' );
		$package_details_color = array( 'pbclr' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#E18416', '#E9AA00', '#839C0E', '#418520'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#EBEBEB', '#EBEBEB', '#EBEBEB', '#EBEBEB'), 'pbcolor' => array('#EF9A36', '#F6BA18', '#94AC26', '#579E34'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#7d7d7d', '#7d7d7d', '#7d7d7d', '#7d7d7d'), 'ftcolor' => array('#7d7d7d', '#7d7d7d', '#7d7d7d', '#7d7d7d'), 'fbrow1' => array('#e6e6e6', '#e2e2e2', '#e6e6e6', '#e2e2e2'), 'fbrow2' => array('#ffffff', '#f5f5f5', '#ffffff', '#f5f5f5'), 'btcolor' => array('#7d7d7d', '#7d7d7d', '#7d7d7d', '#7d7d7d'), 'bthover' => array('#7d7d7d', '#7d7d7d', '#7d7d7d', '#7d7d7d'), 'bcolor' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'bhover' => array('#eeeeee', '#eeeeee', '#eeeeee', '#eeeeee'), 'bbcolor' => array('#f5f5f5', '#f5f5f5', '#f5f5f5', '#f5f5f5'), 'rtcolor' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rthover' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rbcolor' => array('#ffc100', '#ffc100', '#ffc100', '#ffc100'), 'ftborder' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 27) {
		$package_options_color = array( 'templ' => 'temp27', 'etclr' => 'no', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#885035', 'ptnbg' => '#f5f5f5', 'ttwidth' => '200px', 'ctcolor' => '#885035', 'cftcolor' => '#ffffff', 'furlclr' => '#ffffff', 'furlhvr' => '#d7bc83', 'ccolbg' => '#EBEBEB', 'prnbg' => '', 'capbg1' => '#9C8665', 'capbg2' => '#887255', 'ccborder' => '#dddddd', 'colshad' => 'no', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'enicon' => 'no', 'ftcap' => 'yes', 'colgap' => '0', 'ctsize' => '18px', 'enfatc' => 'yes', 'awetick' => 'fas fa-check', 'awecross' => 'fas fa-times', 'captbg' => 'yes', 'cttdir' => 'center' );
		$package_details_color = array( 'pbclr' => array('#AA8F56', '#836332', '#804B31', '#AA3926'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#AA8F56', '#836332', '#804B31', '#AA3926'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#EBEBEB', '#EBEBEB', '#EBEBEB', '#EBEBEB'), 'pbcolor' => array('#A89057', '#7C5E2F', '#72432C', '#A43724'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'ftcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow1' => array('#B6A266', '#906E37', '#854F34', '#B3402A'), 'fbrow2' => array('#A78F56', '#7B5D2F', '#7C492F', '#A33624'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#f5f5f5', '#f5f5f5', '#f5f5f5', '#f5f5f5'), 'bcolor' => array('#AA8F56', '#836332', '#804B31', '#AA3926'), 'bhover' => array('#A89057', '#7C5E2F', '#72432C', '#A43724'), 'bbcolor' => array('#A78F56', '#7B5D2F', '#7C492F', '#A33624'), 'rtcolor' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rthover' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rbcolor' => array('#ffc100', '#ffc100', '#ffc100', '#ffc100'), 'ftborder' => array('#AA8F56', '#836332', '#804B31', '#AA3926') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 28) {
		$package_options_color = array( 'templ' => 'temp28', 'etclr' => 'yes', 'tbpad' => '1', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#333333', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#cfd3cf', 'ptabg' => '#1a303a', 'ptnbg' => '#cdcdcd', 'ttwidth' => '220px', 'ctcolor' => '#073655', 'cftcolor' => '#ffffff', 'furlclr' => '#adc51e', 'furlhvr' => '#6b8d08', 'ccolbg' => '#dddddd', 'prnbg' => '', 'capbg1' => '#073655', 'capbg2' => '#093b58', 'ccborder' => '#bbbbbb', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'pbrad' => '5', 'cbrad' => '5', 'dsgrd' => 'yes', 'enicon' => 'no', 'tick' => 'tick-2', 'cross' => 'cross-2', 'ftcap' => 'yes' );
		$package_details_color = array( 'pbclr' => array('#1a303a', '#1a303a', '#1a303a', '#1a303a'), 'tcolor' => array('#1a303a', '#1a303a', '#1a303a', '#1a303a'), 'thover' => array('#1a303a', '#1a303a', '#1a303a', '#1a303a'), 'tbcolor' => array('#cdcdcd', '#cdcdcd', '#cdcdcd', '#cdcdcd'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#CFCFCF', '#CFCFCF', '#CFCFCF', '#CFCFCF'), 'pbcolor' => array('#1a303a', '#1a303a', '#1a303a', '#1a303a'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'ftcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow1' => array('#2c424c', '#2c424c', '#2c424c', '#2c424c'), 'fbrow2' => array('#1a303a', '#1a303a', '#1a303a', '#1a303a'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#6b8d08', '#6b8d08', '#6b8d08', '#6b8d08'), 'bhover' => array('#97af08', '#97af08', '#97af08', '#97af08'), 'bbcolor' => array('#1a303a', '#1a303a', '#1a303a', '#1a303a'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#fe3e1f', '#fe3e1f', '#fe3e1f', '#fe3e1f'), 'ftborder' => array('#1a303a', '#1a303a', '#1a303a', '#1a303a') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 29) {
		$package_options_color = array( 'templ' => 'temp29', 'etclr' => 'no', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#FFFFFF', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ttwidth' => '200px', 'ctcolor' => '#333333', 'cftcolor' => '#000000', 'furlclr' => '#419873', 'furlhvr' => '#317256', 'ccolbg' => '#dddddd', 'prnbg' => '', 'capbg1' => '#FAFAFA', 'capbg2' => '#EEEEEE', 'ccborder' => '#aaaaaa', 'colshad' => 'no', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'enicon' => 'no', 'ftcap' => 'yes', 'colgap' => '0', 'ctsize' => '18px', 'enfatc' => 'yes', 'awetick' => 'fas fa-check', 'awecross' => 'fas fa-times', 'cttdir' => 'center' );
		$package_details_color = array( 'pbclr' => array('#317256', '#317256', '#317256', '#317256'), 'tcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'thover' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'tbcolor' => array('#49ab81', '#419873', '#398564', '#317256'), 'pcbig' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phbig' =>array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'pcsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'cutclr' => array('#3b8666', '#316f55', '#2d674e', '#1e4a37'), 'pbcolor' => array('#49ab81', '#419873', '#398564', '#317256'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#333333', '#333333', '#333333', '#333333'), 'ftcolor' => array('#333333', '#333333', '#333333', '#333333'), 'fbrow1' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'fbrow2' => array('#f6f6f6', '#f6f6f6', '#f6f6f6', '#f6f6f6'), 'btcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'bthover' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'bcolor' => array('#49ab81', '#419873', '#398564', '#317256'), 'bhover' => array('#49ab81', '#419873', '#398564', '#317256'), 'bbcolor' => array('#49ab81', '#419873', '#398564', '#317256'), 'rtcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'rthover' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'rbcolor' => array('#93291c', '#93291c', '#93291c', '#93291c'), 'ftborder' => array('#aaaaaa', '#aaaaaa', '#aaaaaa', '#aaaaaa') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 30) {
		$package_options_color = array( 'templ' => 'temp30', 'etclr' => 'no', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#FFFFFF', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ttwidth' => '200px', 'ctcolor' => '#333333', 'cftcolor' => '#000000', 'furlclr' => '#0199BC', 'furlhvr' => '#000000', 'ccolbg' => '#005b96', 'prnbg' => '', 'capbg1' => '#fafafa', 'capbg2' => '#f9f9f9', 'ccborder' => '#aaaaaa', 'colshad' => 'no', 'cscolor' => '#ffffff', 'cshcolor' => '#333333', 'enicon' => 'no', 'ftcap' => 'yes', 'colgap' => '0', 'ctsize' => '18px', 'enfatc' => 'yes', 'awetick' => 'fas fa-check', 'awecross' => 'fas fa-times', 'cttdir' => 'center' );
		$package_details_color = array( 'pbclr' => array('#005b96', '#005b96', '#005b96', '#005b96'), 'tcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'thover' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'tbcolor' => array('#6497b1', '#005b96', '#03396c', '#011f4b'), 'pcbig' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phbig' =>array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'pcsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'cutclr' => array('#011f4b', '#011f4b', '#6497b1', '#6497b1'), 'pbcolor' => array('#6497b1', '#005b96', '#03396c', '#011f4b'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#333333', '#333333', '#ffffff', '#333333'), 'ftcolor' => array('#333333', '#333333', '#ffffff', '#333333'), 'fbrow1' => array('#FAFAFA', '#FAFAFA', '#3574a5', '#FAFAFA'), 'fbrow2' => array('#DFDFDF', '#DFDFDF', '#03396c', '#DFDFDF'), 'btcolor' => array('#012345', '#012345', '#012345', '#012345'), 'bthover' => array('#012345', '#012345', '#012345', '#012345'), 'bcolor' => array('#b3cde0', '#b3cde0', '#b3cde0', '#b3cde0'), 'bhover' => array('#b3cde0', '#b3cde0', '#b3cde0', '#b3cde0'), 'bbcolor' => array('#6497b1', '#005b96', '#03396c', '#011f4b'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#a73d30', '#a73d30', '#a73d30', '#a73d30'), 'ftborder' => array('#aaaaaa', '#aaaaaa', '#011f4b', '#aaaaaa') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 31) {
		$package_options_color = array( 'templ' => 'temp31', 'etclr' => 'yes', 'tbpad' => '1', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ttwidth' => '250px', 'ctcolor' => '#173153', 'cftcolor' => '#ffffff', 'furlclr' => '#EB5D45', 'furlhvr' => '#ffffff', 'ccolbg' => '#212527', 'prnbg' => '', 'capbg1' => '#212527', 'capbg2' => '#212527', 'ccborder' => '#212527', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'pbrad' => '5', 'cbrad' => '5', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'enicon' => 'no' );
		$package_details_color = array( 'pbclr' => array('#EB5D45', '#FDC64F', '#173153', '#06D6A0'), 'tcolor' => array('#ffffff', '#000000', '#ffffff', '#000000'), 'thover' => array('#ffffff', '#000000', '#ffffff', '#000000'), 'tbcolor' => array('#EB5D45', '#FDC64F', '#173153', '#06D6A0'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'pbcolor' => array('#EB5D45', '#FDC64F', '#173153', '#06D6A0'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#173153', '#173153', '#9FB0C7', '#173153'), 'ftcolor' => array('#173153', '#173153', '#9FB0C7', '#173153'), 'fbrow1' => array('#EB5D45', '#FDC64F', '#173153', '#06D6A0'), 'fbrow2' => array('#EB5D45', '#FDC64F', '#173153', '#06D6A0'), 'btcolor' => array('#000000', '#ffffff', '#000000', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#06D6A0', '#000000', '#FDC64F', '#EB5D45'), 'bhover' => array('#173153', '#173153', '#173153', '#173153'), 'bbcolor' => array('#EB5D45', '#FDC64F', '#173153', '#06D6A0'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#EF476F', '#EF476F', '#EF476F', '#EF476F'), 'ftborder' => array('#EB5D45', '#FDC64F', '#173153', '#06D6A0') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 32) {
		$package_options_color = array( 'templ' => 'temp32', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#1a1027', 'ptnbg' => '#d6cca8', 'ttwidth' => '250px', 'ctcolor' => '#1a1027', 'cftcolor' => '#ffffff', 'furlclr' => '#d6cca8', 'furlhvr' => '#ffffff', 'ccolbg' => '#d6cca8', 'prnbg' => '', 'capbg1' => '#2d303a', 'capbg2' => '#2d303a', 'ccborder' => '#bbbbbb', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'pbrad' => '10', 'cbrad' => '10', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'enicon' => 'no', 'tick' => 'tick-2', 'cross' => 'cross-2' );
		$package_details_color = array( 'pbclr' => array('#d6cca8', '#d6cca8', '#08090B', '#d6cca8'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#d6cca8', '#d6cca8', '#08090B', '#d6cca8'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#2d303a', '#2d303a', '#d6cca8', '#2d303a'), 'pbcolor' => array('#d6cca8', '#d6cca8', '#08090B', '#d6cca8'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#d6cca8', '#d6cca8', '#d6cca8', '#d6cca8'), 'ftcolor' => array('#d6cca8', '#d6cca8', '#d6cca8', '#d6cca8'), 'fbrow1' => array('#1a1027', '#1a1027', '#2d303a', '#1a1027'), 'fbrow2' => array('#1a1027', '#1a1027', '#2d303a', '#1a1027'), 'btcolor' => array('#ffffff', '#ffffff', '#000000', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#000000', '#ffffff'), 'bcolor' => array('#08090B', '#08090B', '#cac09f', '#08090B'), 'bhover' => array('#000000', '#000000', '#d6cca8', '#000000'), 'bbcolor' => array('#d6cca8', '#d6cca8', '#08090B', '#d6cca8'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#1a1027', '#1a1027', '#2D303A', '#1a1027'), 'ftborder' => array('#d6cca8', '#d6cca8', '#08090B', '#d6cca8') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 33) {
		$package_options_color = array( 'templ' => 'temp33', 'etclr' => 'yes', 'tbpad' => '1', 'ftdir' => 'left', 'ftpad' => '15', 'cftdir' => 'left', 'enfbor' => 'yes', 'encbor' => 'yes', 'tttext' => '#ffffff', 'fatclr' => '#256540', 'facclr' => '#63231b', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ctcolor' => '#333333', 'cftcolor' => '#ffe3e0', 'furlclr' => '#8a0e01', 'furlhvr' => '#ffe3e0', 'ccolbg' => '#e74c3a', 'prnbg' => '', 'capbg1' => '#fd6757', 'capbg2' => '#e74c3a', 'ccborder' => '#e81700', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'markrib' => 'rb-5' );
		$package_details_color = array( 'pbclr' => array('#e74c3a', '#f2a730', '#9b58b5', '#27ae61'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#e74c3a', '#f2a730', '#9b58b5', '#27ae61'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#b13b2e', '#a57120', '#8d1ab9', '#1e7543'), 'pbcolor' => array('#ee5545', '#f2a730', '#a862c5', '#33ba6d'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'ftcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow1' => array('#e74c3a', '#f2a730', '#9b58b5', '#27ae61'), 'fbrow2' => array('#e74c3a', '#f2a730', '#9b58b5', '#27ae61'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#e81700', '#f29500', '#8d29b5', '#00ad4b'), 'bhover' => array('#ee5545', '#f8a92a', '#a862c5', '#33ba6d'), 'bbcolor' => array('#e74c3a', '#f2a730', '#9b58b5', '#27ae61'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#e74c3a', '#f2a730', '#8e42ae', '#27ae61'), 'ftborder' => array('#e83825', '#f29500', '#8d29b5', '#1e9150') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 34) {
		$package_options_color = array( 'templ' => 'temp34', 'etclr' => 'yes', 'tbpad' => '1', 'ftdir' => 'left', 'ftpad' => '15', 'cftdir' => 'left', 'enfbor' => 'yes', 'encbor' => 'yes', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ctcolor' => '#333333', 'cftcolor' => '#ffffff', 'furlclr' => '#0199BC', 'furlhvr' => '#000000', 'ccolbg' => '#1a1c1f', 'prnbg' => '', 'capbg1' => '#32373c', 'capbg2' => '#32373c', 'ccborder' => '#1a1c1f', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details_color = array( 'pbclr' => array('#1a1c1f', '#7b5f10', '#1d5b84', '#285820'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#32373c', '#c09319', '#2980b9', '#3b802f'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#1a1c1f', '#7b5f10', '#1d5b84', '#285820'), 'pbcolor' => array('#32373c', '#c09319', '#2980b9', '#3b802f'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'ftcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow1' => array('#32373c', '#c09319', '#2980b9', '#3b802f'), 'fbrow2' => array('#32373c', '#c09319', '#2980b9', '#3b802f'), 'btcolor' => array('#3d3d3d', '#3d3d3d', '#3d3d3d', '#3d3d3d'), 'bthover' => array('#3d3d3d', '#3d3d3d', '#3d3d3d', '#3d3d3d'), 'bcolor' => array('#d1d1d1', '#d1d1d1', '#d1d1d1', '#d1d1d1'), 'bhover' => array('#d1d1d1', '#d1d1d1', '#d1d1d1', '#d1d1d1'), 'bbcolor' => array('#32373c', '#c09319', '#2980b9', '#3b802f'), 'rtcolor' => array('#ffffff', '#c09319', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#c09319', '#ffffff', '#ffffff'), 'rbcolor' => array('#e74c3a', '#ffffff', '#8e42ae', '#27ae61'), 'ftborder' => array('#17191c', '#997513', '#215f96', '#236014') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 35) {
		$package_options_color = array( 'templ' => 'temp35', 'etclr' => 'yes', 'tbpad' => '1', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ttwidth' => '220px', 'ctcolor' => '#24262E', 'cftcolor' => '#24262E', 'furlclr' => '#16C1F5', 'furlhvr' => '#24262E', 'ccolbg' => '#dddddd', 'prnbg' => '', 'capbg1' => '#ffffff', 'capbg2' => '#F0F0F0', 'ccborder' => '#dddddd', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'pbrad' => '5', 'cbrad' => '5', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'enicon' => 'no', 'enfbor' => 'yes', 'encbor' => 'yes' );
		$package_details_color = array( 'pbclr' => array('#16C1F5', '#E04658', '#F6C815', '#4AD877'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#16C1F5', '#E04658', '#F6C815', '#4AD877'), 'pcbig' => array('#24262E', '#24262E', '#24262E', '#24262E'), 'phbig' =>array('#24262E', '#24262E', '#24262E', '#24262E'), 'pcsmall' => array('#24262E', '#24262E', '#24262E', '#24262E'), 'phsmall' => array('#24262E', '#24262E', '#24262E', '#24262E'), 'cutclr' => array('#949494', '#949494', '#949494', '#949494'), 'pbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'ftcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow1' => array('#16C1F5', '#E04658', '#F6C815', '#4AD877'), 'fbrow2' => array('#16C1F5', '#E04658', '#F6C815', '#4AD877'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#16C1F5', '#E04658', '#F6C815', '#4AD877'), 'bhover' => array('#24262E', '#24262E', '#24262E', '#24262E'), 'bbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rtcolor' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rthover' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rbcolor' => array('#ffc100', '#ffc100', '#ffc100', '#ffc100'), 'ftborder' => array('#13acdb', '#e02a3f', '#d1be12', '#3db563') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 36) {
		$package_options_color = array( 'templ' => 'temp36', 'etclr' => 'yes', 'tbpad' => '1', 'colgap' => '0', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ttwidth' => '220px', 'ctcolor' => '#212121', 'cftcolor' => '#212121', 'furlclr' => '#212121', 'furlhvr' => '#9d9d9d', 'ccolbg' => '#dddddd', 'prnbg' => '', 'capbg1' => '#dddddd', 'capbg2' => '#dddddd', 'ccborder' => '#bbbbbb', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'pbrad' => '5', 'cbrad' => '5', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'enicon' => 'no', 'enimg' => 'yes', 'bgimg' => 'no', 'opimg' => 'opt-1', 'imgwid' => '240px', 'imghgt' => '200px', 'imgmrg' => 'auto', 'imgopc' => '3' );
		$package_details_color = array( 'pbclr' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#7CAC49', '#E9A500', '#3E7DE8', '#A06B77'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#f5f5f5', '#f5f5f5', '#f5f5f5', '#f5f5f5'), 'pbcolor' => array('#212121', '#212121', '#212121', '#212121'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#000C02', '#000C02', '#000C02', '#000C02'), 'fncolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'ftcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow1' => array('#7CAC49', '#E9A500', '#3E7DE8', '#A06B77'), 'fbrow2' => array('#7CAC49', '#E9A500', '#3E7DE8', '#A06B77'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#7CAC49', '#E9A500', '#3E7DE8', '#A06B77'), 'bcolor' => array('#212121', '#212121', '#212121', '#212121'), 'bhover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bbcolor' => array('#7CAC49', '#E9A500', '#3E7DE8', '#A06B77'), 'rtcolor' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rthover' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rbcolor' => array('#ffc100', '#ffc100', '#ffc100', '#ffc100'), 'ftborder' => array('#7CAC49', '#E9A500', '#3E7DE8', '#A06B77') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 37) {
		$package_options_color = array( 'templ' => 'temp37', 'tttext' => '#FFFFFF', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ctcolor' => '#000000', 'cftcolor' => '#444444', 'furlclr' => '#0199BC', 'furlhvr' => '#000000', 'ccolbg' => '#64abcb', 'prnbg' => '', 'capbg1' => '#F5F5F5', 'capbg2' => '#DFDFDF', 'ccborder' => '#aaaaaa', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'markrib' => 'rb-5' );
		$package_details_color = array( 'pbclr' => array('#64abcb', '#ecb000', '#9db74b', '#988fbb'), 'tcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'thover' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'tbcolor' => array('#64abcb', '#ecb000', '#9db74b', '#988fbb'), 'pcbig' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phbig' =>array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'pcsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'cutclr' => array('#45819c', '#b78901', '#7a8e3a', '#797294'), 'pbcolor' => array('#64abcb', '#ecb000', '#9db74b', '#988fbb'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#333333', '#333333', '#333333', '#333333'), 'ftcolor' => array('#333333', '#333333', '#333333', '#333333'), 'fbrow1' => array('#FAFAFA', '#FAFAFA', '#FAFAFA', '#FAFAFA'), 'fbrow2' => array('#DFDFDF', '#DFDFDF', '#DFDFDF', '#DFDFDF'), 'btcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'bthover' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'bcolor' => array('#64abcb', '#ecb000', '#9db74b', '#988fbb'), 'bhover' => array('#64abcb', '#ecb000', '#9db74b', '#988fbb'), 'bbcolor' => array('#64abcb', '#ecb000', '#9db74b', '#988fbb'), 'rtcolor' => array('#aa4518', '#aa4518', '#aa4518', '#aa4518'), 'rthover' => array('#333333', '#333333', '#333333', '#333333'), 'rbcolor' => array('#faec00', '#faec00', '#faec00', '#faec00'), 'ftborder' => array('#aaaaaa', '#aaaaaa', '#aaaaaa', '#aaaaaa') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 38) {
		$package_options_color = array( 'templ' => 'temp38', 'tttext' => '#FFFFFF', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#355e74', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ctcolor' => '#1f8c93', 'cftcolor' => '#000000', 'furlclr' => '#0199BC', 'furlhvr' => '#000000', 'ccolbg' => '#1b3647', 'prnbg' => '', 'capbg1' => '#fafafa', 'capbg2' => '#ffffff', 'ccborder' => '#bbbbbb', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details_color = array( 'pbclr' => array('#1b3647', '#bfc946', '#fb8267', '#c44765'), 'tcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'thover' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'tbcolor' => array('#1b3647', '#bfc946', '#fb8267', '#c44765'), 'pcbig' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phbig' =>array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'pcsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'cutclr' => array('#66869a', '#7b822d', '#ab5b47', '#8e364b'), 'pbcolor' => array('#1b3647', '#bfc946', '#fb8267', '#c44765'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#333333', '#333333', '#333333', '#333333'), 'ftcolor' => array('#333333', '#333333', '#333333', '#333333'), 'fbrow1' => array('#ffffff', '#fafafa', '#ffffff', '#fafafa'), 'fbrow2' => array('#fafafa', '#ffffff', '#fafafa', '#ffffff'), 'btcolor' => array('#002c47', '#b8c900', '#f92d00', '#c4002d'), 'bthover' => array('#002c47', '#b8c900', '#f92d00', '#c4002d'), 'bcolor' => array('#e1eeef', '#f4f4cd', '#f9d7cf', '#f9d9e5'), 'bhover' => array('#e1eeef', '#f4f4cd', '#f9d7cf', '#f9d9e5'), 'bbcolor' => array('#002c47', '#b8c900', '#f92d00', '#c4002d'), 'rtcolor' => array('#333333', '#333333', '#333333', '#333333'), 'rthover' => array('#333333', '#333333', '#333333', '#333333'), 'rbcolor' => array('#f9ea00', '#f9ea00', '#f9ea00', '#f9ea00'), 'ftborder' => array('#bbbbbb', '#bbbbbb', '#bbbbbb', '#bbbbbb') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 39) {
		$package_options_color = array( 'templ' => 'temp39', 'etclr' => 'no', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#1085BF', 'ptnbg' => '#dddddd', 'ttwidth' => '220px', 'ctcolor' => '#212121', 'cftcolor' => '#ffffff', 'furlclr' => '#ffffff', 'furlhvr' => '#212121', 'ccolbg' => '#dddddd', 'prnbg' => '', 'capbg1' => '#FD5C63', 'capbg2' => '#FD5C63', 'ccborder' => '#dddddd', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'pbrad' => '10', 'cbrad' => '10', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'enicon' => 'no', 'btompr' => 'yes' );
		$package_details_color = array( 'pbclr' => array('#C73A40', '#1085BF', '#609835', '#E8C615'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#C73A40', '#1085BF', '#609835', '#E8C615'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#212121', '#212121', '#212121', '#212121'), 'pbcolor' => array('#C73A40', '#1085BF', '#609835', '#E8C615'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#212121', '#212121', '#212121', '#212121'), 'ftcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow1' => array('#FD5C63', '#0099E5', '#7AC143', '#F9D930'), 'fbrow2' => array('#FD5C63', '#0099E5', '#7AC143', '#F9D930'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#212121', '#212121', '#212121', '#212121'), 'bcolor' => array('#C73A40', '#1085BF', '#609835', '#E8C615'), 'bhover' => array('#FD5C63', '#0099E5', '#7AC143', '#F9D930'), 'bbcolor' => array('#212121', '#212121', '#212121', '#212121'), 'rtcolor' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rthover' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rbcolor' => array('#ffc100', '#ffc100', '#ffc100', '#ffc100'), 'ftborder' => array('#C73A40', '#1085BF', '#609835', '#E8C615') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 40) {
		$package_options_color = array( 'templ' => 'temp40', 'etclr' => 'yes', 'tbpad' => '5', 'ftdir' => 'left', 'ftpad' => '10', 'cftdir' => 'left', 'tttext' => '#333333', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#bdc3c7', 'ptabg' => '#34495e', 'ptnbg' => '#ffffff', 'ttwidth' => '220px', 'ctcolor' => '#34495e', 'cftcolor' => '#bdc3c7', 'furlclr' => '#aaaaaa', 'furlhvr' => '#bdc3c7', 'ccolbg' => '#dddddd', 'prnbg' => '', 'capbg1' => '#F5F5F5', 'capbg2' => '#DFDFDF', 'ccborder' => '#bbbbbb', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'pbrad' => '5', 'cbrad' => '5' );
		$package_details_color = array( 'pbclr' => array('#34495e', '#34495e', '#34495e', '#34495e'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#34495e', '#34495e', '#34495e', '#34495e'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#bdc3c7', '#bdc3c7', '#bdc3c7', '#bdc3c7'), 'pbcolor' => array('#34495e', '#34495e', '#34495e', '#34495e'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#bdc3c7', '#bdc3c7', '#bdc3c7', '#bdc3c7'), 'ftcolor' => array('#bdc3c7', '#bdc3c7', '#bdc3c7', '#bdc3c7'), 'fbrow1' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow2' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'btcolor' => array('#34495e', '#34495e', '#34495e', '#34495e'), 'bthover' => array('#bdc3c7', '#bdc3c7', '#bdc3c7', '#bdc3c7'), 'bcolor' => array('#bdc3c7', '#bdc3c7', '#bdc3c7', '#bdc3c7'), 'bhover' => array('#34495e', '#34495e', '#34495e', '#34495e'), 'bbcolor' => array('#34495e', '#34495e', '#34495e', '#34495e'), 'rtcolor' => array('#34495e', '#34495e', '#34495e', '#34495e'), 'rthover' => array('#34495e', '#34495e', '#34495e', '#34495e'), 'rbcolor' => array('#bdc3c7', '#bdc3c7', '#bdc3c7', '#bdc3c7'), 'ftborder' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 41) {
		$package_options_color = array( 'templ' => 'temp41', 'etclr' => 'yes', 'tbpad' => '1', 'ftdir' => 'left', 'ftpad' => '10', 'cftdir' => 'left', 'enfbor' => 'yes', 'encbor' => 'yes', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ctcolor' => '#333333', 'cftcolor' => '#666666', 'furlclr' => '#0199BC', 'furlhvr' => '#000000', 'ccolbg' => '#dddddd', 'prnbg' => '', 'capbg1' => '#F5F5F5', 'capbg2' => '#F5F5F5', 'ccborder' => '#dddddd', 'cscolor' => '#ffffff', 'cshcolor' => '#000000' );
		$package_details_color = array( 'pbclr' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'tcolor' => array('#faf8eb', '#faf8eb', '#faf8eb', '#faf8eb'), 'thover' => array('#faf8eb', '#faf8eb', '#faf8eb', '#faf8eb'), 'tbcolor' => array('#222222', '#222222', '#222222', '#222222'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#949494', '#949494', '#949494', '#949494'), 'pbcolor' => array('#222222', '#222222', '#222222', '#222222'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#666666', '#666666', '#666666', '#666666'), 'ftcolor' => array('#666666', '#666666', '#666666', '#666666'), 'fbrow1' => array('#f5f5f5', '#f5f5f5', '#f5f5f5', '#f5f5f5'), 'fbrow2' => array('#f5f5f5', '#f5f5f5', '#f5f5f5', '#f5f5f5'), 'btcolor' => array('#222222', '#222222', '#222222', '#222222'), 'bthover' => array('#222222', '#222222', '#222222', '#222222'), 'bcolor' => array('#d36d42', '#e7c035', '#68c495', '#d8993c'), 'bhover' => array('#d36d42', '#e7c035', '#68c495', '#d8993c'), 'bbcolor' => array('#f5f5f5', '#f5f5f5', '#f5f5f5', '#f5f5f5'), 'rtcolor' => array('#323232', '#323232', '#323232', '#323232'), 'rthover' => array('#323232', '#323232', '#323232', '#323232'), 'rbcolor' => array('#f5f5f5', '#fcc76a', '#f5f5f5', '#95f1c2'), 'ftborder' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 42) {
		$package_options_color = array( 'templ' => 'temp42', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#27589f', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ctcolor' => '#333333', 'cftcolor' => '#ffffff', 'furlclr' => '#ffffff', 'furlhvr' => '#ffffff', 'ccolbg' => '#27589f', 'prnbg' => '', 'capbg1' => '#3069e8', 'capbg2' => '#3069e8', 'ccborder' => '#27589f', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'pbrad' => '3', 'cbrad' => '3', 'enicon' => 'no', 'ftdir' => 'center', 'ttwidth' => '250px', 'enimg' => 'yes', 'bgimg' => 'yes' );
		$package_details_color = array( 'pbclr' => array('#3069e8', '#3069e8', '#3069e8', '#3069e8'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#3069e8', '#3069e8', '#3069e8', '#3069e8'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#2D62AF', '#2D62AF', '#2D62AF', '#2D62AF'), 'pbcolor' => array('#3069e8', '#3069e8', '#3069e8', '#3069e8'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#275bb3', '#275bb3', '#275bb3', '#275bb3'), 'fncolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'ftcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow1' => array('#3069e8', '#3069e8', '#3069e8', '#3069e8'), 'fbrow2' => array('#3069e8', '#3069e8', '#3069e8', '#3069e8'), 'btcolor' => array('#27589F', '#27589F', '#27589F', '#27589F'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#f1f1f1', '#f1f1f1', '#f1f1f1', '#f1f1f1'), 'bhover' => array('#27589f', '#27589f', '#27589f', '#27589f'), 'bbcolor' => array('#3069e8', '#3069e8', '#3069e8', '#3069e8'), 'rtcolor' => array('#000000', '#000000', '#000000', '#000000'), 'rthover' => array('#000000', '#000000', '#000000', '#000000'), 'rbcolor' => array('#ffc100', '#ffc100', '#ffc100', '#ffc100'), 'ftborder' => array('#27589f', '#27589f', '#27589f', '#27589f') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 43) {
		$package_options_color = array( 'templ' => 'temp43', 'etclr' => 'yes', 'tbpad' => '1', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ttwidth' => '250px', 'ctcolor' => '#3E7DE8', 'cftcolor' => '#000000', 'furlclr' => '#ffffff', 'furlhvr' => '#000000', 'ccolbg' => '#dddddd', 'prnbg' => '', 'capbg1' => '#3e7de8', 'capbg2' => '#3e7de8', 'ccborder' => '#bbbbbb', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'pbrad' => '10', 'cbrad' => '10', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'enicon' => 'no' );
		$package_details_color = array( 'pbclr' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'tcolor' => array('#000000', '#000000', '#ffffff', '#000000'), 'thover' => array('#000000', '#000000', '#ffffff', '#000000'), 'tbcolor' => array('#ffffff', '#ffffff', '#3e7de8', '#ffffff'), 'pcbig' => array('#3e7de8', '#3e7de8', '#ffffff', '#3e7de8'), 'phbig' =>array('#3e7de8', '#3e7de8', '#ffffff', '#3e7de8'), 'pcsmall' => array('#3e7de8', '#3e7de8', '#ffffff', '#3e7de8'), 'phsmall' => array('#3e7de8', '#3e7de8', '#ffffff', '#3e7de8'), 'cutclr' => array('#000000', '#000000', '#ffffff', '#000000'), 'pbcolor' => array('#ffffff', '#ffffff', '#3e7de8', '#ffffff'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#868686', '#868686', '#fafafa', '#868686'), 'ftcolor' => array('#868686', '#868686', '#fafafa', '#868686'), 'fbrow1' => array('#ffffff', '#ffffff', '#3e7de8', '#ffffff'), 'fbrow2' => array('#ffffff', '#ffffff', '#3e7de8', '#ffffff'), 'btcolor' => array('#ffffff', '#ffffff', '#000000', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#3e7de8', '#3e7de8', '#f2f2f2', '#3e7de8'), 'bhover' => array('#606060', '#606060', '#606060', '#606060'), 'bbcolor' => array('#ffffff', '#ffffff', '#3e7de8', '#ffffff'), 'rtcolor' => array('#ffffff', '#ffffff', '#000000', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#000000', '#ffffff'), 'rbcolor' => array('#3e7de8', '#3e7de8', '#ffffff', '#3e7de8'), 'ftborder' => array('#bbbbbb', '#bbbbbb', '#bbbbbb', '#bbbbbb') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 44) {
		$package_options_color = array( 'templ' => 'temp44', 'etclr' => 'yes', 'tbpad' => '5', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#47A212', 'ptnbg' => '#292c3c', 'ttwidth' => '250px', 'ctcolor' => '#292c3c', 'cftcolor' => '#292c3c', 'furlclr' => '#47A212', 'furlhvr' => '#ffffff', 'ccolbg' => '#47A212', 'prnbg' => '', 'capbg1' => '#292c3c', 'capbg2' => '#292c3c', 'ccborder' => '#292c3c', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'pbrad' => '5', 'cbrad' => '5', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'enicon' => 'no', 'tick' => 'tick-2', 'cross' => 'cross-2' );
		$package_details_color = array( 'pbclr' => array('#47A212', '#47A212', '#292c3c', '#47A212'), 'tcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'thover' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'tbcolor' => array('#292c3c', '#292c3c', '#47A212', '#292c3c'), 'pcbig' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phbig' =>array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'pcsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'cutclr' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'pbcolor' => array('#292c3c', '#292c3c', '#47A212', '#292c3c'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'ftcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'fbrow1' => array('#292c3c', '#292c3c', '#47A212', '#292c3c'), 'fbrow2' => array('#292c3c', '#292c3c', '#47A212', '#292c3c'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#47A212', '#47A212', '#292c3c', '#47A212'), 'bhover' => array('#292c3c', '#292c3c', '#47A212', '#292c3c'), 'bbcolor' => array('#292c3c', '#292c3c', '#47A212', '#292c3c'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#47A212', '#47A212', '#292c3c', '#47A212'), 'ftborder' => array('#1b1d2b', '#1b1d2b', '#2d8407', '#1b1d2b') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 45) {
		$package_options_color = array( 'templ' => 'temp45', 'etclr' => 'yes', 'tbpad' => '1', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ttwidth' => '250px', 'ctcolor' => '#4B55E4', 'cftcolor' => '#ffffff', 'furlclr' => '#ff5f85', 'furlhvr' => '#ffffff', 'ccolbg' => '#2d36af', 'prnbg' => '', 'capbg1' => '#2d36af', 'capbg2' => '#2d36af', 'ccborder' => '#2d36af', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'pbrad' => '5', 'cbrad' => '5', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'enicon' => 'no', 'btbody' => '80px', 'bheight' => '40px' );
		$package_details_color = array( 'pbclr' => array('#4b55e4', '#4b55e4', '#4b55e4', '#4b55e4'), 'tcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'thover' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'tbcolor' => array('#4b55e4', '#4b55e4', '#4b55e4', '#4b55e4'), 'pcbig' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phbig' =>array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'pcsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'cutclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'pbcolor' => array('#4b55e4', '#4b55e4', '#4b55e4', '#4b55e4'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'ftcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'fbrow1' => array('#4b55e4', '#4b55e4', '#4b55e4', '#4b55e4'), 'fbrow2' => array('#4b55e4', '#4b55e4', '#4b55e4', '#4b55e4'), 'btcolor' => array('#FFFFFF', '#4b55e4', '#FFFFFF', '#4b55e4'), 'bthover' => array('#4b55e4', '#FFFFFF', '#4b55e4', '#FFFFFF'), 'bcolor' => array('#4b55e4', '#f1f1f1', '#4b55e4', '#f1f1f1'), 'bhover' => array('#f1f1f1', '#4b55e4', '#f1f1f1', '#4b55e4'), 'bbcolor' => array('#ff5f85', '#ff5f85', '#ff5f85', '#ff5f85'), 'rtcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'rthover' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'rbcolor' => array('#ff5f85', '#ff5f85', '#ff5f85', '#ff5f85'), 'ftborder' => array('#4b55e4', '#4b55e4', '#4b55e4', '#4b55e4') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 46) {
		$package_options_color = array( 'templ' => 'temp46', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#40314E', 'ptnbg' => '#F2EDED', 'ttwidth' => '250px', 'ctcolor' => '#40314E', 'cftcolor' => '#483754', 'furlclr' => '#9F7893', 'furlhvr' => '#483754', 'ccolbg' => '#F2EDED', 'prnbg' => '', 'capbg1' => '#F2EDED', 'capbg2' => '#F2EDED', 'ccborder' => '#dddddd', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'pbrad' => '10', 'cbrad' => '10', 'dsgrd' => 'yes', 'enicon' => 'no', 'tick' => 'tick-2', 'cross' => 'cross-2' );
		$package_details_color = array( 'pbclr' => array('#41324F', '#41324F', '#40314E', '#41324F'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#41324F', '#41324F', '#40314E', '#41324F'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'pbcolor' => array('#41324F', '#41324F', '#40314E', '#41324F'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#2c2235', '#2c2235', '#2c2235', '#2c2235'), 'fncolor' => array('#ffffff', '#ffffff', '#483754', '#ffffff'), 'ftcolor' => array('#ffffff', '#ffffff', '#483754', '#ffffff'), 'fbrow1' => array('#544562', '#544562', '#F2EDED', '#544562'), 'fbrow2' => array('#5F506D', '#5F506D', '#F5F5F5', '#5F506D'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#6A5370', '#6A5370', '#6A5370', '#6A5370'), 'bhover' => array('#55425F', '#55425F', '#55425F', '#55425F'), 'bbcolor' => array('#9F7893', '#9F7893', '#9F7893', '#9F7893'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#FD4326', '#FD4326', '#FD4326', '#FD4326'), 'ftborder' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 47) {
		$package_options_color = array( 'templ' => 'temp47', 'tttext' => '#000000', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#fffff0', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ctcolor' => '#333333', 'cftcolor' => '#dbdbdb', 'furlclr' => '#0199BC', 'furlhvr' => '#000000', 'ccolbg' => '#000000', 'prnbg' => '', 'capbg1' => '#000000', 'capbg2' => '#131313', 'ccborder' => '#000000', 'cscolor' => '#333333', 'cshcolor' => '#000000', 'tick' => 'tick-2', 'cross' => 'cross-2', 'markrib' => 'rb-5' );
		$package_details_color = array( 'pbclr' => array('#000000', '#000000', '#000000', '#000000'), 'tcolor' => array('#000000', '#000000', '#000000', '#000000'), 'thover' => array('#000000', '#000000', '#000000', '#000000'), 'tbcolor' => array('#00c0e4', '#5bd999', '#eac14d', '#e13131'), 'pcbig' => array('#00c0e4', '#5bd999', '#eac14d', '#e13131'), 'phbig' =>array('#00c0e4', '#5bd999', '#eac14d', '#e13131'), 'pcsmall' => array('#00c0e4', '#5bd999', '#eac14d', '#e13131'), 'phsmall' => array('#00c0e4', '#5bd999', '#eac14d', '#e13131'), 'cutclr' => array('#808080', '#808080', '#808080', '#808080'), 'pbcolor' => array('#131313', '#131313', '#131313', '#131313'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#00c0e4', '#5bd999', '#eac14d', '#e13131'), 'ftcolor' => array('#00c0e4', '#5bd999', '#eac14d', '#e13131'), 'fbrow1' => array('#000000', '#000000', '#000000', '#000000'), 'fbrow2' => array('#131313', '#131313', '#131313', '#131313'), 'btcolor' => array('#000000', '#000000', '#000000', '#000000'), 'bthover' => array('#000000', '#000000', '#000000', '#000000'), 'bcolor' => array('#00c0e4', '#5bd999', '#eac14d', '#e13131'), 'bhover' => array('#00c0e4', '#5bd999', '#eac14d', '#e13131'), 'bbcolor' => array('#000000', '#000000', '#000000', '#000000'), 'rtcolor' => array('#333333', '#333333', '#333333', '#333333'), 'rthover' => array('#333333', '#333333', '#333333', '#333333'), 'rbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'ftborder' => array('#000000', '#000000', '#000000', '#000000') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 48) {
		$package_options_color = array( 'templ' => 'temp48', 'etclr' => 'yes', 'tbpad' => '10', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#00A8E8', 'ptnbg' => '#f5f5f5', 'ttwidth' => '220px', 'ctcolor' => '#929292', 'cftcolor' => '#ACACAC', 'furlclr' => '#00A8E8', 'furlhvr' => '#ACACAC', 'ccolbg' => '#F3F3F3', 'prnbg' => '#F3F3F3', 'capbg1' => '#F3F3F3', 'capbg2' => '#F3F3F3', 'ccborder' => '#F3F3F3', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'pbrad' => '20', 'cbrad' => '20', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'enicon' => 'no', 'tcleft' => 'yes', 'captbg' => 'yes' );
		$package_details_color = array( 'pbclr' => array('#242426', '#242426', '#242426', '#242426'), 'tcolor' => array('#929292', '#929292', '#929292', '#929292'), 'thover' => array('#929292', '#929292', '#929292', '#929292'), 'tbcolor' => array('#242426', '#242426', '#242426', '#242426'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#FFFAF1', '#EDF7FE', '#FBFEFB', '#FDF9EB'), 'pbcolor' => array('#FF28C4', '#0090ED', '#FF9780', '#EDBC00'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'ftcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow1' => array('#FF28C4', '#0090ED', '#FF9780', '#EDBC00'), 'fbrow2' => array('#FF28C4', '#0090ED', '#FF9780', '#EDBC00'), 'btcolor' => array('#FF0ACB', '#187EED', '#FF8678', '#EDBC00'), 'bthover' => array('#FF9FE5', '#75ADF7', '#FFCFC5', '#E6CE71'), 'bcolor' => array('#f1f1f1', '#f1f1f1', '#f1f1f1', '#f1f1f1'), 'bhover' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'bbcolor' => array('#242426', '#242426', '#242426', '#242426'), 'rtcolor' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rthover' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rbcolor' => array('#ffc100', '#ffc100', '#ffc100', '#ffc100'), 'ftborder' => array('#FF28C4', '#0090ED', '#FF9780', '#fb2201') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 49) {
		$package_options_color = array( 'templ' => 'temp49', 'tttext' => '#FFFFFF', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#bf5507', 'ptabg' => '#bb6e36', 'ptnbg' => '#f5f5f5', 'ctcolor' => '#333333', 'cftcolor' => '#5c331d', 'furlclr' => '#8e5124', 'furlhvr' => '#5c331d', 'ccolbg' => '#bb6e36', 'prnbg' => '', 'capbg1' => '#c3ac69', 'capbg2' => '#c3ac69', 'ccborder' => '#9a8854', 'cscolor' => '#ffffff', 'cshcolor' => '#000000', 'markrib' => 'rb-4' );
		$package_details_color = array( 'pbclr' => array('#bb6e36', '#bb6e36', '#bb6e36', '#bb6e36'), 'tcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'thover' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'tbcolor' => array('#bb6e36', '#bb6e36', '#bb6e36', '#bb6e36'), 'pcbig' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phbig' =>array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'pcsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'cutclr' => array('#bb6e36', '#bb6e36', '#bb6e36', '#bb6e36'), 'pbcolor' => array('#5c331d', '#5c331d', '#5c331d', '#5c331d'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#5c331d', '#5c331d', '#5c331d', '#5c331d'), 'ftcolor' => array('#5c331d', '#5c331d', '#5c331d', '#5c331d'), 'fbrow1' => array('#c3ac69', '#c3ac69', '#c3ac69', '#c3ac69'), 'fbrow2' => array('#c3ac69', '#c3ac69', '#c3ac69', '#c3ac69'), 'btcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'bthover' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'bcolor' => array('#bb6e36', '#bb6e36', '#bb6e36', '#bb6e36'), 'bhover' => array('#5c331d', '#5c331d', '#5c331d', '#5c331d'), 'bbcolor' => array('#c3ac69', '#c3ac69', '#c3ac69', '#c3ac69'), 'rtcolor' => array('#5c331d', '#5c331d', '#5c331d', '#5c331d'), 'rthover' => array('#5c331d', '#5c331d', '#5c331d', '#5c331d'), 'rbcolor' => array('#f7db53', '#f7db53', '#f7db53', '#f7db53'), 'ftborder' => array('#9a8854', '#9a8854', '#9a8854', '#9a8854') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 50) {
		$package_options_color = array( 'templ' => 'temp50', 'etclr' => 'no', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#ffdd65', 'ptnbg' => '#1f1800', 'ttwidth' => '250px', 'ctcolor' => '#1f1800', 'cftcolor' => '#ffdd65', 'furlclr' => '#fdd23a', 'furlhvr' => '#ffdd65', 'ccolbg' => '#1f1800', 'prnbg' => '', 'capbg1' => '#1f1800', 'capbg2' => '#1f1800', 'ccborder' => '#1f1800', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'pbrad' => '20', 'cbrad' => '20', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'enicon' => 'no', 'tick' => 'tick-2', 'cross' => 'cross-2', 'enimg' => 'yes', 'bgimg' => 'yes' );
		$package_details_color = array( 'pbclr' => array('#ffdd65', '#ffdd65', '#1f1800', '#ffdd65'), 'tcolor' => array('#1f1800', '#1f1800', '#ffdd65', '#1f1800'), 'thover' => array('#1f1800', '#1f1800', '#ffdd65', '#1f1800'), 'tbcolor' => array('#ffdd65', '#ffdd65', '#1f1800', '#ffdd65'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#1f1800', '#1f1800', '#ffdd65', '#1f1800'), 'pbcolor' => array('#ffdd65', '#ffdd65', '#1f1800', '#ffdd65'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#db9324', '#db9324', '#db9324', '#db9324'), 'fncolor' => array('#1f1800', '#1f1800', '#ffdd65', '#1f1800'), 'ftcolor' => array('#1f1800', '#1f1800', '#ffdd65', '#1f1800'), 'fbrow1' => array('#ffdd65', '#ffdd65', '#1f1800', '#ffdd65'), 'fbrow2' => array('#ffdd65', '#ffdd65', '#1f1800', '#ffdd65'), 'btcolor' => array('#1f1800', '#1f1800', '#ffdd65', '#1f1800'), 'bthover' => array('#ffdd65', '#ffdd65', '#1f1800', '#ffdd65'), 'bcolor' => array('#ffdd65', '#ffdd65', '#1f1800', '#ffdd65'), 'bhover' => array('#1f1800', '#1f1800', '#ffdd65', '#1f1800'), 'bbcolor' => array('#ffdd65', '#ffdd65', '#1f1800', '#ffdd65'), 'rtcolor' => array('#ffdd65', '#ffdd65', '#1f1800', '#ffdd65'), 'rthover' => array('#ffdd65', '#ffdd65', '#1f1800', '#ffdd65'), 'rbcolor' => array('#1f1800', '#1f1800', '#ffdd65', '#1f1800'), 'ftborder' => array('#ffdd65', '#ffdd65', '#1f1800', '#ffdd65') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 51) {
		$package_options_color = array( 'templ' => 'temp51', 'etclr' => 'yes', 'tbpad' => '5', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#FFB052', 'ptnbg' => '#292c3c', 'ttwidth' => '250px', 'ctcolor' => '#292c3c', 'cftcolor' => '#292c3c', 'furlclr' => '#FFB052', 'furlhvr' => '#ffffff', 'ccolbg' => '#FFB052', 'prnbg' => '', 'capbg1' => '#292c3c', 'capbg2' => '#292c3c', 'ccborder' => '#292c3c', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'pbrad' => '5', 'cbrad' => '5', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'enicon' => 'no', 'tick' => 'tick-2', 'cross' => 'cross-2', 'enfbor' => 'yes', 'encbor' => 'yes' );
		$package_details_color = array( 'pbclr' => array('#FFB052', '#FFB052', '#292c3c', '#FFB052'), 'tcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'thover' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'tbcolor' => array('#292c3c', '#292c3c', '#FFB052', '#292c3c'), 'pcbig' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phbig' =>array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'pcsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'cutclr' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'pbcolor' => array('#292c3c', '#292c3c', '#FFB052', '#292c3c'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'ftcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'fbrow1' => array('#292c3c', '#292c3c', '#FFB052', '#292c3c'), 'fbrow2' => array('#292c3c', '#292c3c', '#FFB052', '#292c3c'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#FFB052', '#FFB052', '#292c3c', '#FFB052'), 'bhover' => array('#292c3c', '#292c3c', '#FFB052', '#292c3c'), 'bbcolor' => array('#292c3c', '#292c3c', '#FFB052', '#292c3c'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#FFB052', '#FFB052', '#292c3c', '#FFB052'), 'ftborder' => array('#1b1d2b', '#1b1d2b', '#efb14c', '#1b1d2b') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 52) {
		$package_options_color = array( 'templ' => 'temp52', 'etclr' => 'yes', 'tbpad' => '1', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ttwidth' => '220px', 'ctcolor' => '#333333', 'cftcolor' => '#828282', 'furlclr' => '#000000', 'furlhvr' => '#828282', 'ccolbg' => '#f1f1f1', 'prnbg' => '', 'capbg1' => '#ffffff', 'capbg2' => '#ffffff', 'ccborder' => '#f1f1f1', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'pbrad' => '5', 'cbrad' => '5', 'dsgrd' => 'yes', 'enicon' => 'no', 'enimg' => 'yes', 'bgimg' => 'yes', 'pbody' => '160px' );
		$package_details_color = array( 'pbclr' => array('#f1f1f1', '#f1f1f1', '#f1f1f1', '#f1f1f1'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#cb3bc1', '#9bcf7f', '#fc8e45', '#45aefc'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#f1f1f1', '#f1f1f1', '#f1f1f1', '#f1f1f1'), 'pbcolor' => array('#cb3bc1', '#9bcf7f', '#fc8e45', '#45aefc'), 'pcircle' => array('#CE64B0', '#9CD565', '#FCA558', '#91BDFC'), 'imgclr' => array('#f1f1f1', '#f1f1f1', '#f1f1f1', '#f1f1f1'), 'fncolor' => array('#828282', '#828282', '#828282', '#828282'), 'ftcolor' => array('#828282', '#828282', '#828282', '#828282'), 'fbrow1' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow2' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#cb3bc1', '#9bcf7f', '#fc8e45', '#45aefc'), 'bhover' => array('#CE64B0', '#9CD565', '#FCA558', '#91BDFC'), 'bbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#EF476F', '#EF476F', '#EF476F', '#EF476F'), 'ftborder' => array('#f1f1f1', '#f1f1f1', '#f1f1f1', '#f1f1f1') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 53) {
		$package_options_color = array( 'templ' => 'temp53', 'etclr' => 'yes', 'tbpad' => '1', 'colgap' => '0', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#34495E', 'ptnbg' => '#dddddd', 'ttwidth' => '220px', 'ctcolor' => '#222F3D', 'cftcolor' => '#222F3D', 'furlclr' => '#222F3D', 'furlhvr' => '#34495E', 'ccolbg' => '#d2d7e2', 'prnbg' => '', 'capbg1' => '#ffffff', 'capbg2' => '#EBEBEB', 'ccborder' => '#d2d7e2', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'pbrad' => '0', 'cbrad' => '0', 'ttgrd' => 'yes', 'enicon' => 'no', 'enfbor' => 'yes' );
		$package_details_color = array( 'pbclr' => array('#dadada', '#dadada', '#dadada', '#dadada'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#222F3D', '#222F3D', '#222F3D', '#222F3D'), 'pcbig' => array('#34495E', '#34495E', '#ffffff', '#34495E'), 'phbig' =>array('#34495E', '#34495E', '#ffffff', '#34495E'), 'pcsmall' => array('#34495E', '#34495E', '#ffffff', '#34495E'), 'phsmall' => array('#34495E', '#34495E', '#ffffff', '#34495E'), 'cutclr' => array('#8e9eaf', '#8e9eaf', '#8e9eaf', '#8e9eaf'), 'pbcolor' => array('#ffffff', '#ffffff', '#34495E', '#ffffff'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#222F3D', '#222F3D', '#ffffff', '#222F3D'), 'ftcolor' => array('#222F3D', '#222F3D', '#ffffff', '#222F3D'), 'fbrow1' => array('#ffffff', '#ffffff', '#34495E', '#ffffff'), 'fbrow2' => array('#EBEBEB', '#EBEBEB', '#304357', '#EBEBEB'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#46627F', '#46627F', '#46627F', '#46627F'), 'bhover' => array('#222F3D', '#222F3D', '#222F3D', '#222F3D'), 'bbcolor' => array('#222F3D', '#222F3D', '#222F3D', '#222F3D'), 'rtcolor' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rthover' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rbcolor' => array('#ffc100', '#ffc100', '#ffc100', '#ffc100'), 'ftborder' => array('#d2d7e2', '#d2d7e2', '#222F3D', '#d2d7e2') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 54) {
		$package_options_color = array( 'templ' => 'temp54', 'etclr' => 'yes', 'tbpad' => '10', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#FF9700', 'ptnbg' => '#FFEED6', 'ttwidth' => '220px', 'ctcolor' => '#364B59', 'cftcolor' => '#ffffff', 'furlclr' => '#E2520D', 'furlhvr' => '#ffffff', 'ccolbg' => '#364B59', 'prnbg' => '', 'capbg1' => '#2D3D49', 'capbg2' => '#2D3D49', 'ccborder' => '#2D3D49', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'tick' => 'tick-2', 'cross' => 'cross-2', 'btompr' => 'yes', 'pbrad' => '0', 'cbrad' => '0' );
		$package_details_color = array( 'pbclr' => array('#233039', '#233039', '#FF9700', '#233039'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#233039', '#233039', '#FF9700', '#233039'), 'pcbig' => array('#ffffff', '#ffffff', '#FF9700', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#FF9700', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#FF9700', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#FF9700', '#ffffff'), 'cutclr' => array('#f5f5f5', '#f5f5f5', '#ffb344', '#f5f5f5'), 'pbcolor' => array('#2d3d49', '#2d3d49', '#FFEED6', '#2d3d49'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#ffffff', '#ffffff', '#787878', '#ffffff'), 'ftcolor' => array('#ffffff', '#ffffff', '#787878', '#ffffff'), 'fbrow1' => array('#2d3d49', '#2d3d49', '#FFEED6', '#2d3d49'), 'fbrow2' => array('#2d3d49', '#2d3d49', '#FFEED6', '#2d3d49'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#f26521', '#f26521', '#f26521', '#f26521'), 'bhover' => array('#E2520D', '#E2520D', '#E2520D', '#E2520D'), 'bbcolor' => array('#233039', '#233039', '#FF9700', '#233039'), 'rtcolor' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rthover' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rbcolor' => array('#ffc100', '#ffc100', '#ffc100', '#ffc100'), 'ftborder' => array('#233039', '#233039', '#FF9700', '#233039') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 55) {
		$package_options_color = array( 'templ' => 'temp55', 'etclr' => 'no', 'tbpad' => '0', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tcleft' => 'yes', 'tttext' => '#ffffff', 'fatclr' => '#11f21c', 'facclr' => '#22313f', 'ttbg' => '#333333', 'ptabg' => '#FF9700', 'ptnbg' => '#FFEED6', 'ttwidth' => '220px', 'ctcolor' => '#364B59', 'cftcolor' => '#ffffff', 'furlclr' => '#E2520D', 'furlhvr' => '#ffffff', 'ccolbg' => '#c81808', 'prnbg' => '', 'capbg1' => '#F66254', 'capbg2' => '#F66254', 'ccborder' => '#2D3D49', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'tick' => 'tick-2', 'cross' => 'cross-2', 'pbrad' => '0', 'cbrad' => '0', 'enimg' => 'yes', 'bgimg' => 'yes', 'tbody' => '100px', 'pbody' => '80px', 'enicon' => 'no', 'tsize' => '42px' );
		$package_details_color = array( 'pbclr' => array('#ef6773', '#7486f9', '#c1ad2d', '#9d1fc7'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#ef6773', '#7486f9', '#c1ad2d', '#9d1fc7'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#f5f5f5', '#f5f5f5', '#ffb344', '#f5f5f5'), 'pbcolor' => array('#ef6773', '#7486f9', '#c1ad2d', '#9d1fc7'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#ef6773', '#7486f9', '#c1ad2d', '#9d1fc7'), 'fncolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'ftcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow1' => array('#ef6773', '#7486f9', '#c1ad2d', '#9d1fc7'), 'fbrow2' => array('#ef6773', '#7486f9', '#c1ad2d', '#9d1fc7'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#ea5a6c', '#5b56f7', '#5a500c', '#610fbe'), 'bhover' => array('#ef6773', '#7486f9', '#c1ad2d', '#9d1fc7'), 'bbcolor' => array('#ef6773', '#7486f9', '#c1ad2d', '#9d1fc7'), 'rtcolor' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rthover' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rbcolor' => array('#ffc100', '#ffc100', '#ffc100', '#ffc100'), 'ftborder' => array('#ef6773', '#7486f9', '#c1ad2d', '#9d1fc7') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 56) {
		$package_options_color = array( 'templ' => 'temp56', 'etclr' => 'yes', 'tbpad' => '5', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tcleft' => 'yes', 'tttext' => '#ffffff', 'fatclr' => '#11f21c', 'facclr' => '#22313f', 'ttbg' => '#333333', 'ptabg' => '#FF9700', 'ptnbg' => '#FFEED6', 'ttwidth' => '220px', 'ctcolor' => '#364B59', 'cftcolor' => '#ffffff', 'furlclr' => '#ffd5db', 'furlhvr' => '#ffffff', 'ccolbg' => '#c81808', 'prnbg' => '', 'capbg1' => '#F66254', 'capbg2' => '#F66254', 'ccborder' => '#2D3D49', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'tick' => 'tick-2', 'cross' => 'cross-2', 'pbrad' => '0', 'cbrad' => '0', 'enimg' => 'yes', 'bgimg' => 'no', 'opimg' => 'opt-4', 'pbody' => '350px', 'enicon' => 'no', 'ftbody' => '156px', 'topbut' => 'no', 'hidefn' => 'yes', 'htitle' => 'yes', 'hbutton' => 'yes', 'enribs' => 'no', 'imgwid' => '260px', 'imghgt' => '350px', 'imgmrg' => 'auto', 'crlepr' => 'no' );
		$package_details_color = array( 'pbclr' => array('#007bfc', '#ffa900', '#522172', '#bb1b4b'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#f5f5f5', '#f5f5f5', '#ffb344', '#f5f5f5'), 'pbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fncolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'ftcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow1' => array('#007bfc', '#ffa900', '#522172', '#bb1b4b'), 'fbrow2' => array('#007bfc', '#ffa900', '#522172', '#bb1b4b'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#007bfc', '#ffa900', '#522172', '#bb1b4b'), 'bhover' => array('#50a2fb', '#fcce73', '#8535b9', '#e4527e'), 'bbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rtcolor' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rthover' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rbcolor' => array('#ffc100', '#ffc100', '#ffc100', '#ffc100'), 'ftborder' => array('#007bfc', '#ffa900', '#522172', '#bb1b4b') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 57) {
		$package_options_color = array( 'templ' => 'temp57', 'etclr' => 'yes', 'tbpad' => '1', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ttwidth' => '280px', 'ctcolor' => '#333333', 'cftcolor' => '#828282', 'furlclr' => '#000000', 'furlhvr' => '#828282', 'ccolbg' => '#f1f1f1', 'prnbg' => '', 'capbg1' => '#ffffff', 'capbg2' => '#ffffff', 'ccborder' => '#f1f1f1', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'pbrad' => '5', 'cbrad' => '5', 'dsgrd' => 'yes', 'enicon' => 'no', 'enimg' => 'yes', 'bgimg' => 'yes', 'pbody' => '160px' );
		$package_details_color = array( 'pbclr' => array('#f1f1f1', '#f1f1f1', '#f1f1f1', '#f1f1f1'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#f1f1f1', '#f1f1f1', '#f1f1f1', '#f1f1f1'), 'pbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcircle' => array('#CE64B0', '#9CD565', '#FCA558', '#91BDFC'), 'imgclr' => array('#f1f1f1', '#f1f1f1', '#f1f1f1', '#f1f1f1'), 'fncolor' => array('#828282', '#828282', '#828282', '#828282'), 'ftcolor' => array('#828282', '#828282', '#828282', '#828282'), 'fbrow1' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow2' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#FFB30F', '#7FC9F8', '#FF98A4', '#FFA562'), 'bhover' => array('#CE64B0', '#9CD565', '#FCA558', '#91BDFC'), 'bbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#EF476F', '#EF476F', '#EF476F', '#EF476F'), 'ftborder' => array('#f1f1f1', '#f1f1f1', '#f1f1f1', '#f1f1f1') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 58) {
		$package_options_color = array( 'templ' => 'temp58', 'etclr' => 'yes', 'tbpad' => '1', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ttwidth' => '220px', 'ctcolor' => '#333333', 'cftcolor' => '#828282', 'furlclr' => '#000000', 'furlhvr' => '#828282', 'ccolbg' => '#f1f1f1', 'prnbg' => '', 'capbg1' => '#ffffff', 'capbg2' => '#ffffff', 'ccborder' => '#f1f1f1', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'pbrad' => '5', 'cbrad' => '5', 'dsgrd' => 'yes', 'enicon' => 'no', 'enimg' => 'yes', 'bgimg' => 'yes', 'pbody' => '160px' );
		$package_details_color = array( 'pbclr' => array('#f1f1f1', '#f1f1f1', '#f1f1f1', '#f1f1f1'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#4A1F56', '#2D4009', '#213458', '#5B2424'), 'pcbig' => array('#000000', '#000000', '#000000', '#000000'), 'phbig' =>array('#000000', '#000000', '#000000', '#000000'), 'pcsmall' => array('#000000', '#000000', '#000000', '#000000'), 'phsmall' => array('#000000', '#000000', '#000000', '#000000'), 'cutclr' => array('#f1f1f1', '#f1f1f1', '#f1f1f1', '#f1f1f1'), 'pbcolor' => array('#4A1F56', '#2D4009', '#213458', '#5B2424'), 'pcircle' => array('#CE64B0', '#9CD565', '#FCA558', '#91BDFC'), 'imgclr' => array('#f1f1f1', '#f1f1f1', '#f1f1f1', '#f1f1f1'), 'fncolor' => array('#828282', '#828282', '#828282', '#828282'), 'ftcolor' => array('#828282', '#828282', '#828282', '#828282'), 'fbrow1' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow2' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'btcolor' => array('#301B49', '#203002', '#182846', '#491818'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#D9D7D5', '#D9D7D5', '#D9D7D5', '#D9D7D5'), 'bhover' => array('#301B49', '#203002', '#182846', '#491818'), 'bbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#EF476F', '#EF476F', '#EF476F', '#EF476F'), 'ftborder' => array('#f1f1f1', '#f1f1f1', '#f1f1f1', '#f1f1f1') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 59) {
		$package_options_color = array( 'templ' => 'temp59', 'etclr' => 'yes', 'tbpad' => '1', 'ftdir' => 'center', 'ctcolor' => '#AA2626', 'capbg1' => '#E7D54C', 'capbg2' => '#E7D54C', 'cftcolor' => '#bdb1f7', 'ccborder' => '#bbbbbb', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'enicon' => 'no', 'enimg' => 'yes', 'bgimg' => 'no', 'opimg' => 'opt-2', 'imgwid' => '148px', 'imghgt' => '148px', 'imgmrg' => '0 auto 1px', 'imgopc' => '10', 'crlepr' => 'yes', 'tbody' => '84px', 'tsize' => '36px', 'pbody' => '200px', 'bheight' => '36px', 'ttwidth' => '280px' );
		$package_details_color = array( 'pbclr' => array('#f36236', '#2f284f', '#1a9a8c', '#e71d36'), 'tcolor' => array('#702b15', '#bdb1f7', '#083c37', '#760f1c'), 'thover' => array('#702b15', '#bdb1f7', '#083c37', '#760f1c'), 'tbcolor' => array('#f36236', '#2f284f', '#1a9a8c', '#e71d36'), 'pcbig' => array('#702b15', '#bdb1f7', '#083c37', '#760f1c'), 'phbig' =>array('#702b15', '#bdb1f7', '#083c37', '#760f1c'), 'pcsmall' => array('#702b15', '#bdb1f7', '#083c37', '#760f1c'), 'phsmall' => array('#702b15', '#bdb1f7', '#083c37', '#760f1c'), 'cutclr' => array('#9d9d9d', '#9d9d9d', '#9d9d9d', '#9d9d9d'), 'pbcolor' => array('#f36236', '#2f284f', '#1a9a8c', '#e71d36'), 'pcircle' => array('#f47f5c', '#443a73', '#19ad9b', '#e9485b'), 'imgclr' => array('#f36236', '#2f284f', '#1a9a8c', '#e71d36'), 'fncolor' => array('#702b15', '#bdb1f7', '#083c37', '#760f1c'), 'ftcolor' => array('#702b15', '#bdb1f7', '#083c37', '#760f1c'), 'fbrow1' => array('#f36236', '#2f284f', '#1a9a8c', '#e71d36'), 'fbrow2' => array('#f36236', '#2f284f', '#1a9a8c', '#e71d36'), 'btcolor' => array('#f36236', '#2f284f', '#1a9a8c', '#e71d36'), 'bthover' => array('#ffffff', '#2f284f', '#ffffff', '#ffffff'), 'bcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bhover' => array('#702b15', '#bdb1f7', '#083c37', '#760f1c'), 'bbcolor' => array('#f36236', '#2f284f', '#1a9a8c', '#e71d36'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#E7D54C', '#E7D54C', '#E7D54C', '#E7D54C'), 'ftborder' => array('#f36236', '#2f284f', '#1a9a8c', '#e71d36') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 60) {
		$package_options_color = array( 'templ' => 'temp60', 'etclr' => 'yes', 'tbpad' => '30', 'enfbor' => 'yes', 'colshad' => 'yes', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'enicon' => 'no', 'entips' => 'no', 'enfatc' => 'yes', 'awetick' => 'fas fa-check-circle', 'awecross' => 'far fa-times-circle', 'pbrad' => '15', 'cbrad' => '15', 'btompr' => 'yes', 'colgap' => '0', 'tbody' => '80px', 'pbody' => '60px', 'bheight' => '40px', 'tcleft' => 'yes', 'fatclr' => '#ffffff', 'facclr' => '#333333', 'cscolor' => '#22313f', 'cshcolor' => '#0c0c0c' );
		$package_details_color = array( 'spack' => array('no', 'no', 'yes', 'no'), 'tdesc' => array('Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.'), 'pbclr' => array('#54AB3E', '#b316ed', '#ed1592', '#1581ed'), 'tbcolor' => array('#54AB3E', '#b316ed', '#ed1592', '#1581ed'), 'pbcolor' => array('#54AB3E', '#b316ed', '#ed1592', '#1581ed'), 'pcircle' => array('#54AB3E', '#b316ed', '#ed1592', '#1581ed'), 'imgclr' => array('#54AB3E', '#b316ed', '#ed1592', '#1581ed'), 'fbrow1' => array('#54AB3E', '#b316ed', '#ed1592', '#1581ed'), 'fbrow2' => array('#54AB3E', '#b316ed', '#ed1592', '#1581ed'), 'bbcolor' => array('#54AB3E', '#b316ed', '#ed1592', '#1581ed'), 'rbcolor' => array('#356c27', '#830eae', '#be1276', '#105eac'), 'ftborder' => array('#4b9b37', '#a513d8', '#d51182', '#1274d7'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#c8d6e5', '#c8d6e5', '#c8d6e5', '#c8d6e5'), 'fncolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'ftcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'btcolor' => array('#54AB3E', '#b316ed', '#ed1592', '#1581ed'), 'bthover' => array('#54AB3E', '#b316ed', '#ed1592', '#1581ed'), 'bcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bhover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 61) {
		$package_options_color = array( 'templ' => 'temp61', 'etclr' => 'no', 'enfbor' => 'yes', 'encbor' => 'yes', 'colshad' => 'no', 'enicon' => 'no', 'entips' => 'no', 'enribs' => 'no', 'enfatc' => 'yes', 'awetick' => 'fas fa-check-circle', 'awecross' => 'far fa-times-circle', 'pbrad' => '15', 'cbrad' => '15', 'topbut' => 'yes', 'colgap' => '0', 'ftcap' => 'yes', 'capwidth' => '30', 'bwidth' => '84px', 'tbody' => '26px', 'pbody' => '52px', 'ftbody' => '80px', 'bheight' => '40px', 'ftdir' => 'center', 'ftpad' => '0', 'ctsize' => '24px', 'tsize' => '18px', 'psbig' => '30px', 'pssmall' => '14px', 'ccolbg' => '#5f30e2', 'prnbg' => '#f9f9fb', 'ctcolor' => '#22313f', 'capbg1' => '#5f30e2', 'capbg2' => '#5f30e2', 'ccborder' => '#522dbb', 'cftcolor' => '#ffffff', 'furlclr' => '#ffffff', 'furlhvr' => '#cdbff7', 'fatclr' => '#cdbff7', 'facclr' => '#381696', 'cscolor' => '#ffffff', 'cshcolor' => '#ffffff' );
		$package_details_color = array( 'bicon' => array('', '', '', ''), 'pbclr' => array('#683ce5', '#683ce5', '#683ce5', '#683ce5'), 'tbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow1' => array('#683ce5', '#683ce5', '#683ce5', '#683ce5'), 'fbrow2' => array('#683ce5', '#683ce5', '#683ce5', '#683ce5'), 'bbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#5F30E2', '#5F30E2', '#5F30E2', '#5F30E2'), 'ftborder' => array('#572ad3', '#572ad3', '#572ad3', '#572ad3'), 'tcolor' => array('#22313f', '#22313f', '#22313f', '#22313f'), 'thover' => array('#22313f', '#22313f', '#22313f', '#22313f'), 'pcbig' => array('#22313f', '#22313f', '#22313f', '#22313f'), 'phbig' =>array('#22313f', '#22313f', '#22313f', '#22313f'), 'pcsmall' => array('#22313f', '#22313f', '#22313f', '#22313f'), 'phsmall' => array('#22313f', '#22313f', '#22313f', '#22313f'), 'cutclr' => array('#aaaaaa', '#aaaaaa', '#aaaaaa', '#aaaaaa'), 'fncolor' => array('#ededed', '#ededed', '#ededed', '#ededed'), 'ftcolor' => array('#ededed', '#ededed', '#ededed', '#ededed'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'btcolor' => array('#683ce5', '#683ce5', '#683ce5', '#683ce5'), 'bthover' => array('#683ce5', '#683ce5', '#683ce5', '#683ce5'), 'bcolor' => array('#f5f1ff', '#f5f1ff', '#f5f1ff', '#f5f1ff'), 'bhover' => array('#f5f1ff', '#f5f1ff', '#f5f1ff', '#f5f1ff') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 62) {
		$package_options_color = array( 'templ' => 'temp62', 'etclr' => 'no', 'enfbor' => 'yes', 'encbor' => 'yes', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'enicon' => 'no', 'entips' => 'no', 'captbg' => 'yes', 'enfatc' => 'yes', 'awetick' => 'fas fa-check-circle', 'awecross' => 'far fa-times-circle', 'pbrad' => '0', 'cbrad' => '0', 'topbut' => 'yes', 'colgap' => '0', 'ftcap' => 'yes', 'capwidth' => '25', 'bwidth' => '120px', 'tbody' => '80px', 'pbody' => '60px', 'btbody' => '60px', 'bheight' => '32px', 'ftdir' => 'center', 'ftpad' => '0', 'cttdir' => 'right', 'cftdir' => 'right', 'tcleft' => 'yes', 'ccolbg' => '#949292', 'prnbg' => '#171717', 'ctcolor' => '#ffffff', 'capbg1' => '#ededed', 'capbg2' => '#ededed', 'ccborder' => '#d1d1d1', 'fcatbg' => '#d3d3d3', 'ffnclr' => '#22313f', 'cftcolor' => '#727272', 'furlclr' => '#727272', 'furlhvr' => '#34495e', 'fatclr' => '#14a01a', 'facclr' => '#cf0310', 'cscolor' => '#c1c1c1', 'cshcolor' => '#7f8c8d' );
		$package_details_color = array( 'spack' => array('no', 'no', 'yes', 'no'), 'tdesc' => array('', 'Lorem ipsum dolor', 'LIMITED TIME OFFER', ''), 'bicon' => array('', '', '', ''), 'pbclr' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#fcfcfc', '#fcfcfc', '#ffffff', '#fcfcfc'), 'pbcolor' => array('#171717', '#171717', '#ffffff', '#171717'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow1' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow2' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bbcolor' => array('#171717', '#171717', '#ffffff', '#171717'), 'rbcolor' => array('#ffd956', '#ffd956', '#ffd956', '#ffd956'), 'ftborder' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'tcolor' => array('#22313f', '#22313f', '#22313f', '#22313f'), 'thover' => array('#22313f', '#22313f', '#22313f', '#22313f'), 'tdescl' => array('#bdbdbd', '#bdbdbd', '#e1ae00', '#bdbdbd'), 'pcbig' => array('#ffffff', '#ffffff', '#22313f', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#22313f', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#22313f', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#22313f', '#ffffff'), 'cutclr' => array('#aaaaaa', '#aaaaaa', '#aaaaaa', '#aaaaaa'), 'fncolor' => array('#1cad20', '#1cad20', '#1cad20', '#1cad20'), 'ftcolor' => array('#1cad20', '#1cad20', '#1cad20', '#1cad20'), 'rtcolor' => array('#22313f', '#22313f', '#22313f', '#22313f'), 'rthover' => array('#22313f', '#22313f', '#22313f', '#22313f'), 'btcolor' => array('#22313f', '#22313f', '#22313f', '#22313f'), 'bthover' => array('#22313f', '#22313f', '#22313f', '#22313f'), 'bcolor' => array('#ededed', '#ededed', '#ffd956', '#ededed'), 'bhover' => array('#ededed', '#ededed', '#ffd956', '#ededed') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 63) {
		$package_options_color = array( 'templ' => 'temp63', 'etclr' => 'no', 'encbor' => 'yes', 'tbpad' => '0', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'enicon' => 'no', 'entips' => 'no', 'enimg' => 'yes', 'bgimg' => 'yes', 'imgov' => 'yes', 'enfatc' => 'yes', 'awetick' => 'fas fa-check', 'awecross' => 'fas fa-times', 'pbrad' => '5', 'cbrad' => '5', 'bwidth' => '100px', 'tbody' => '45px', 'pbody' => '75px', 'btbody' => '80px', 'ftpad' => '40', 'tcleft' => 'yes', 'ccolbg' => '#242424', 'prnbg' => '#242424', 'ctcolor' => '#bdbdbd', 'capbg1' => '#000000', 'capbg2' => '#000000', 'ccborder' => '#242424', 'fcatbg' => '#242424', 'ffnclr' => '#bdbdbd', 'cftcolor' => '#bdbdbd', 'furlclr' => '#bdbdbd', 'furlhvr' => '#ffffff', 'fatclr' => '#388c00', 'facclr' => '#fe3a3b', 'cscolor' => '#515151', 'cshcolor' => '#242424' );
		$package_details_color = array( 'bicon' => array('', '', '', ''), 'pbclr' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pbcolor' => array('#000000', '#000000', '#000000', '#000000'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow1' => array('#000000', '#000000', '#000000', '#000000'), 'fbrow2' => array('#000000', '#000000', '#000000', '#000000'), 'bbcolor' => array('#000000', '#000000', '#000000', '#000000'), 'rbcolor' => array('#0079b0', '#d81a64', '#e9220d', '#9e21df'), 'ftborder' => array('#242424', '#242424', '#242424', '#242424'), 'tcolor' => array('#000000', '#000000', '#000000', '#000000'), 'thover' => array('#000000', '#000000', '#000000', '#000000'), 'tdescl' => array('#a9a9a9', '#a9a9a9', '#a9a9a9', '#a9a9a9'), 'pcbig' => array('#0079b0', '#d81a64', '#e9220d', '#9e21df'), 'phbig' =>array('#0079b0', '#d81a64', '#e9220d', '#9e21df'), 'pcsmall' => array('#0079b0', '#d81a64', '#e9220d', '#9e21df'), 'phsmall' => array('#0079b0', '#d81a64', '#e9220d', '#9e21df'), 'cutclr' => array('#a9a9a9', '#a9a9a9', '#a9a9a9', '#a9a9a9'), 'fncolor' => array('#a9a9a9', '#a9a9a9', '#a9a9a9', '#a9a9a9'), 'ftcolor' => array('#a9a9a9', '#a9a9a9', '#a9a9a9', '#a9a9a9'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#0079b0', '#d81a64', '#e9220d', '#9e21df'), 'bhover' => array('#0079b0', '#d81a64', '#e9220d', '#9e21df') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template_number == 64) {
		$package_options_color = array( 'templ' => 'temp64', 'tbpad' => '10', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'enicon' => 'no', 'enimg' => 'yes', 'bgimg' => 'yes', 'imgov' => 'yes', 'pbrad' => '0', 'bwidth' => '140px', 'tbody' => '60px', 'pbody' => '126px', 'ftbody' => '42px', 'btbody' => '70px', 'bheight' => '36px', 'ftpad' => '20', 'tsize' => '42px', 'ctcolor' => '#242424', 'capbg1' => '#ffffff', 'capbg2' => '#ffffff', 'cftcolor' => '#787878', 'furlclr' => '#787878', 'furlhvr' => '#242424', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details_color = array( 'pbclr' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#005c85', '#ff7300', '#012e55', '#ed2225'), 'pbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow1' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow2' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bbcolor' => array('#005c85', '#ff7300', '#012e55', '#ed2225'), 'rbcolor' => array('#FF5277', '#4FCA39', '#ffb052', '#527BFF'), 'ftborder' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tdescl' => array('#bdbdbd', '#bdbdbd', '#bdbdbd', '#bdbdbd'), 'pcbig' => array('#52caff', '#700000', '#FFB052', '#66080a'), 'phbig' =>array('#52caff', '#700000', '#FFB052', '#66080a'), 'pcsmall' => array('#52caff', '#700000', '#FFB052', '#66080a'), 'phsmall' => array('#52caff', '#700000', '#FFB052', '#66080a'), 'cutclr' => array('#000000', '#000000', '#000000', '#000000'), 'fncolor' => array('#787878', '#787878', '#787878', '#787878'), 'ftcolor' => array('#52586b', '#52586b', '#52586b', '#52586b'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'btcolor' => array('#005c85', '#ff7300', '#012e55', '#ed2225'), 'bthover' => array('#005c85', '#ff7300', '#012e55', '#ed2225'), 'bcolor' => array('#c8d6e5', '#c8d6e5', '#c8d6e5', '#c8d6e5'), 'bhover' => array('#c8d6e5', '#c8d6e5', '#c8d6e5', '#c8d6e5') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} else {
		$package_options_color = array( 'templ' => 'temp0', 'etclr' => 'yes', 'tbpad' => '1', 'ftdir' => 'left', 'ftpad' => '10', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#7ECE3A', 'facclr' => '#EA2E2D', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ctcolor' => '#333333', 'cftcolor' => '#000000', 'furlclr' => '#0199BC', 'furlhvr' => '#000000', 'ccolbg' => '#cccccc', 'prnbg' => '#ffffff', 'capbg1' => '#F5F5F5', 'capbg2' => '#DFDFDF', 'ccborder' => '#868686', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details_color = array( 'pbclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'tcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'thover' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'tbcolor' => array('#44A3D5', '#44A3D5', '#44A3D5', '#44A3D5'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'pbcolor' => array('#44A3D5', '#44A3D5', '#44A3D5', '#44A3D5'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#333333', '#333333', '#333333', '#333333'), 'ftcolor' => array('#333333', '#333333', '#333333', '#333333'), 'fbrow1' => array('#FAFAFA', '#FAFAFA', '#FAFAFA', '#FAFAFA'), 'fbrow2' => array('#DFDFDF', '#DFDFDF', '#DFDFDF', '#DFDFDF'), 'btcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'bthover' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'bcolor' => array('#333333', '#333333', '#333333', '#333333'), 'bhover' => array('#333333', '#333333', '#333333', '#333333'), 'bbcolor' => array('#44A3D5', '#44A3D5', '#44A3D5', '#44A3D5'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#CB0000', '#CB0000', '#CB0000', '#CB0000'), 'ftborder' => array('#868686', '#868686', '#868686', '#868686') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	}
	/* Generating Package Features */
	foreach($template_features as $key => $feature) {
		if($feature) {
			$feature_name['fitem'.$fn] = sanitize_text_field( $feature );
			$feature_name['fcate'.$fn] = sanitize_text_field( $feature_cate[$key] );
			$feature_name['flink'.$fn] = esc_url( $feature_link[$key] );
			$feature_name['fdesc'.$fn] = sanitize_text_field( $feature_desc[$key] );
			$feature_name['ftype'.$fn] = $feature_type[$key];
			$feature_name['fasom'.$fn] = sanitize_text_field( $awesome_icon[$key] );
			$fn++;
		} else {
			$feature_name['fitem'.$fn] = '';
			$feature_name['fcate'.$fn] = '';
			$feature_name['flink'.$fn] = '';
			$feature_name['fdesc'.$fn] = '';
			$feature_name['ftype'.$fn] = '';
			$feature_name['fasom'.$fn] = '';
			$fn++;
		}
	}
	add_option($package_feature, $feature_name);
	/* Generating Package Options */
	foreach($package_options as $key => $option) {
		$optionValue[$key] = sanitize_text_field( $option );
	}
	add_option($table_option, $optionValue);
	/* Generating Package Lists */
	for($pn = 0; $pn < 4; $pn++) {
		$package_lists = get_option($pricing_table);
		$optionName = wrcpt_update_pricing_table($pricing_table, $package_lists);
		$package_count = get_option('packageCount');
		$new_package_lists = get_option($pricing_table);
		$packageOptions = explode(', ', $new_package_lists);
		$list_count = count($packageOptions);
		foreach($package_details as $pkey => $value) {
			$packageOptions_text[$pkey] = sanitize_text_field( $value[$pn] );
		}
		foreach($feature_values as $fkey => $fvalue) {
			$featureValues_text[$fkey] = sanitize_text_field( $fvalue[$pn] );
		}
		$package_details_top = array( 'pop' => $package_count, 'pid' => $pn+1, 'order' => $list_count );
		$mergePackages = array_merge($package_details_top, $packageOptions_text, $featureValues_text);
		add_option($optionName, $mergePackages);
	}
}
add_action( 'wp_ajax_nopriv_wrcpt_activate_template', 'wrcpt_activate_template' );
add_action( 'wp_ajax_wrcpt_activate_template', 'wrcpt_activate_template' );

/**
 * The function is modifying a pricing table with selected templates
 * by keeping all the details of the pricing table as it is.
 */
function wrcpt_setup_selected_template() {
	$template = $_POST['template'];
	$table_name = $_POST['packtable'];
	$option_name = $table_name.'_option';
	$table_option = get_option($option_name);
	$package_lists = get_option($table_name);
	$packageOptions = explode(', ', $package_lists);
	if($template == 'temp1') {
		$package_options = array( 'templ' => 'temp1', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ctcolor' => '#333333', 'cftcolor' => '#333333', 'furlclr' => '#5C82FF', 'furlhvr' => '#333333', 'ccolbg' => '#dddddd', 'prnbg' => '', 'capbg1' => '#ffffff', 'capbg2' => '#ffffff', 'ccborder' => '#dddddd', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'tcolor' => array('#52586b', '#52586b', '#52586b', '#52586b'), 'thover' => array('#52586b', '#52586b', '#52586b', '#52586b'), 'tbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcbig' => array('#FF5277', '#527BFF', '#FFB052', '#4FCA39'), 'phbig' =>array('#FF5277', '#527BFF', '#FFB052', '#4FCA39'), 'pcsmall' => array('#FF5277', '#527BFF', '#FFB052', '#4FCA39'), 'phsmall' => array('#FF5277', '#527BFF', '#FFB052', '#4FCA39'), 'cutclr' => array('#52586b', '#52586b', '#52586b', '#52586b'), 'pbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#52586b', '#52586b', '#52586b', '#52586b'), 'ftcolor' => array('#52586b', '#52586b', '#52586b', '#52586b'), 'fbrow1' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow2' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#FF5277', '#527BFF', '#FFB052', '#4FCA39'), 'bhover' => array('#52586b', '#52586b', '#52586b', '#52586b'), 'bbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#FF5277', '#527BFF', '#FFB052', '#4FCA39'), 'ftborder' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd') );
	} elseif($template == 'temp2') {
		$package_options = array( 'templ' => 'temp2', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#ff5a28', 'ptnbg' => '#eeeeee', 'ctcolor' => '#ff5a28', 'cftcolor' => '#333333', 'furlclr' => '#ff5a28', 'furlhvr' => '#333333', 'ccolbg' => '#eeeeee', 'prnbg' => '', 'capbg1' => '#ffffff', 'capbg2' => '#ffffff', 'ccborder' => '#eeeeee', 'cscolor' => '#cccccc', 'cshcolor' => '#eeeeee' );
		$package_details = array( 'pbclr' => array('#eeeeee', '#eeeeee', '#eeeeee', '#eeeeee'), 'tcolor' => array('#ff5a28', '#ff5a28', '#ff5a28', '#ff5a28'), 'thover' => array('#ff5a28', '#ff5a28', '#ff5a28', '#ff5a28'), 'tbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcbig' => array('#ff5a28', '#ff5a28', '#ff5a28', '#ff5a28'), 'phbig' =>array('#ff5a28', '#ff5a28', '#ff5a28', '#ff5a28'), 'pcsmall' => array('#ff5a28', '#ff5a28', '#ff5a28', '#ff5a28'), 'phsmall' => array('#ff5a28', '#ff5a28', '#ff5a28', '#ff5a28'), 'cutclr' => array('#333333', '#333333', '#333333', '#333333'), 'pbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#333333', '#333333', '#333333', '#333333'), 'ftcolor' => array('#333333', '#333333', '#333333', '#333333'), 'fbrow1' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow2' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ff5a28', '#ff5a28', '#ff5a28', '#ff5a28'), 'bcolor' => array('#ff5a28', '#ff5a28', '#ff5a28', '#ff5a28'), 'bhover' => array('#f1f1f1', '#f1f1f1', '#f1f1f1', '#f1f1f1'), 'bbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#ff5a28', '#ff5a28', '#ff5a28', '#ff5a28'), 'ftborder' => array('#eeeeee', '#eeeeee', '#eeeeee', '#eeeeee') );
	} elseif($template == 'temp3') {
		$package_options = array( 'templ' => 'temp3', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#2397F2', 'ptnbg' => '#F5F5F5', 'ctcolor' => '#7d7d7d', 'cftcolor' => '#7d7d7d', 'furlclr' => '#2397F2', 'furlhvr' => '#7d7d7d', 'ccolbg' => '#F5F5F5', 'prnbg' => '', 'capbg1' => '#F5F5F5', 'capbg2' => '#F5F5F5', 'ccborder' => '#7d7d7d', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#F5F5F5', '#F5F5F5', '#F5F5F5', '#F5F5F5'), 'tcolor' => array('#54AB3E', '#2397F2', '#AC598A', '#F89406'), 'thover' => array('#54AB3E', '#2397F2', '#AC598A', '#F89406'), 'tbcolor' => array('#F5F5F5', '#F5F5F5', '#F5F5F5', '#F5F5F5'), 'pcbig' => array('#54AB3E', '#2397F2', '#AC598A', '#F89406'), 'phbig' =>array('#54AB3E', '#2397F2', '#AC598A', '#F89406'), 'pcsmall' => array('#54AB3E', '#2397F2', '#AC598A', '#F89406'), 'phsmall' => array('#54AB3E', '#2397F2', '#AC598A', '#F89406'), 'cutclr' => array('#7d7d7d', '#7d7d7d', '#7d7d7d', '#7d7d7d'), 'pbcolor' => array('#F5F5F5', '#F5F5F5', '#F5F5F5', '#F5F5F5'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#7d7d7d', '#7d7d7d', '#7d7d7d', '#7d7d7d'), 'ftcolor' => array('#7d7d7d', '#7d7d7d', '#7d7d7d', '#7d7d7d'), 'fbrow1' => array('#F5F5F5', '#F5F5F5', '#F5F5F5', '#F5F5F5'), 'fbrow2' => array('#F5F5F5', '#F5F5F5', '#F5F5F5', '#F5F5F5'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#7d7d7d', '#7d7d7d', '#7d7d7d', '#7d7d7d'), 'bhover' => array('#bbbbbb', '#bbbbbb', '#bbbbbb', '#bbbbbb'), 'bbcolor' => array('#F5F5F5', '#F5F5F5', '#F5F5F5', '#F5F5F5'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#54AB3E', '#2397F2', '#AC598A', '#F89406'), 'ftborder' => array('#7d7d7d', '#7d7d7d', '#7d7d7d', '#7d7d7d') );
	} elseif($template == 'temp4') {
		$package_options = array( 'templ' => 'temp4', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#464C5C', 'ptnbg' => '#F5F5F5', 'ctcolor' => '#464C5C', 'cftcolor' => '#7d7d7d', 'furlclr' => '#2286C5', 'furlhvr' => '#7d7d7d', 'ccolbg' => '#F5F5F5', 'prnbg' => '', 'capbg1' => '#F5F5F5', 'capbg2' => '#F5F5F5', 'ccborder' => '#F5F5F5', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#F5F5F5', '#F5F5F5', '#464C5C', '#F5F5F5'), 'tcolor' => array('#7d7d7d', '#7d7d7d', '#ffffff', '#7d7d7d'), 'thover' => array('#7d7d7d', '#7d7d7d', '#ffffff', '#7d7d7d'), 'tbcolor' => array('#F5F5F5', '#F5F5F5', '#464C5C', '#F5F5F5'), 'pcbig' => array('#7d7d7d', '#7d7d7d', '#ffffff', '#7d7d7d'), 'phbig' =>array('#7d7d7d', '#7d7d7d', '#ffffff', '#7d7d7d'), 'pcsmall' => array('#7d7d7d', '#7d7d7d', '#ffffff', '#7d7d7d'), 'phsmall' => array('#7d7d7d', '#7d7d7d', '#ffffff', '#7d7d7d'), 'cutclr' => array('#9d9d9d', '#9d9d9d', '#9d9d9d', '#9d9d9d'), 'pbcolor' => array('#F5F5F5', '#F5F5F5', '#464C5C', '#F5F5F5'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#7d7d7d', '#7d7d7d', '#ffffff', '#7d7d7d'), 'ftcolor' => array('#7d7d7d', '#7d7d7d', '#ffffff', '#7d7d7d'), 'fbrow1' => array('#F5F5F5', '#F5F5F5', '#464C5C', '#F5F5F5'), 'fbrow2' => array('#F5F5F5', '#F5F5F5', '#464C5C', '#F5F5F5'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#FF5277', '#527BFF', '#FFB052', '#4FCA39'), 'bhover' => array('#52586b', '#52586b', '#52586b', '#52586b'), 'bbcolor' => array('#F5F5F5', '#F5F5F5', '#464C5C', '#F5F5F5'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#2286C5', '#2286C5', '#22CD6A', '#2286C5'), 'ftborder' => array('#F5F5F5', '#F5F5F5', '#464C5C', '#F5F5F5') );
	} elseif($template == 'temp5') {
		$package_options = array( 'templ' => 'temp5', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#3E7DE8', 'ptabg' => '#3E7DE8', 'ptnbg' => '#FCFCFD', 'ctcolor' => '#24262E', 'cftcolor' => '#ffffff', 'furlclr' => '#3E7DE8', 'furlhvr' => '#ffffff', 'ccolbg' => '#24262E', 'prnbg' => '', 'capbg1' => '#24262E', 'capbg2' => '#24262E', 'ccborder' => '#24262E', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#FCFCFD', '#FCFCFD', '#24262E', '#FCFCFD'), 'tcolor' => array('#3E7DE8', '#3E7DE8', '#ffffff', '#3E7DE8'), 'thover' => array('#3E7DE8', '#3E7DE8', '#ffffff', '#3E7DE8'), 'tbcolor' => array('#FCFCFD', '#FCFCFD', '#24262E', '#FCFCFD'), 'pcbig' => array('#474A5D', '#474A5D', '#ffffff', '#474A5D'), 'phbig' =>array('#474A5D', '#474A5D', '#ffffff', '#474A5D'), 'pcsmall' => array('#474A5D', '#474A5D', '#ffffff', '#474A5D'), 'phsmall' => array('#474A5D', '#474A5D', '#ffffff', '#474A5D'), 'cutclr' => array('#8e8e91', '#8e8e91', '#8e8e91', '#8e8e91'), 'pbcolor' => array('#FCFCFD', '#FCFCFD', '#24262E', '#FCFCFD'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#eeeeee', '#eeeeee', '#eeeeee', '#eeeeee'), 'fncolor' => array('#3E7DE8', '#3E7DE8', '#ffffff', '#3E7DE8'), 'ftcolor' => array('#3E7DE8', '#3E7DE8', '#ffffff', '#3E7DE8'), 'fbrow1' => array('#FCFCFD', '#FCFCFD', '#24262E', '#FCFCFD'), 'fbrow2' => array('#FCFCFD', '#FCFCFD', '#24262E', '#FCFCFD'), 'btcolor' => array('#ffffff', '#ffffff', '#3E7DE8', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#3E7DE8', '#ffffff'), 'bcolor' => array('#3E7DE8', '#3E7DE8', '#F1F1F1', '#3E7DE8'), 'bhover' => array('#79a0e2', '#79a0e2', '#EEEEEE', '#79a0e2'), 'bbcolor' => array('#FCFCFD', '#FCFCFD', '#24262E', '#FCFCFD'), 'rtcolor' => array('#ffffff', '#ffffff', '#24262E', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#24262E', '#ffffff'), 'rbcolor' => array('#3E7DE8', '#3E7DE8', '#FCFCFD', '#3E7DE8'), 'ftborder' => array('#e1e1e1', '#e1e1e1', '#000000', '#e1e1e1') );
	} elseif($template == 'temp6') {
		$package_options = array( 'templ' => 'temp6', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ttwidth' => '250px', 'ctcolor' => '#000000', 'cftcolor' => '#ffffff', 'furlclr' => '#ffffff', 'furlhvr' => '#FDCFDC', 'ccolbg' => '#dddddd', 'prnbg' => '', 'capbg1' => '#FB3988', 'capbg2' => '#FB3988', 'ccborder' => '#bbbbbb', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'tcolor' => array('#000000', '#000000', '#ffffff', '#000000'), 'thover' => array('#000000', '#000000', '#ffffff', '#000000'), 'tbcolor' => array('#ffffff', '#ffffff', '#FB3988', '#ffffff'), 'pcbig' => array('#000000', '#000000', '#ffffff', '#000000'), 'phbig' =>array('#000000', '#000000', '#ffffff', '#000000'), 'pcsmall' => array('#000000', '#000000', '#ffffff', '#000000'), 'phsmall' => array('#000000', '#000000', '#ffffff', '#000000'), 'cutclr' => array('#000000', '#000000', '#ffffff', '#000000'), 'pbcolor' => array('#ffffff', '#ffffff', '#FB3988', '#ffffff'), 'pcircle' => array('#ffffff', '#ffffff', '#f94f91', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#868686', '#868686', '#fafafa', '#868686'), 'ftcolor' => array('#868686', '#868686', '#fafafa', '#868686'), 'fbrow1' => array('#ffffff', '#ffffff', '#FB3988', '#ffffff'), 'fbrow2' => array('#ffffff', '#ffffff', '#FB3988', '#ffffff'), 'btcolor' => array('#ffffff', '#ffffff', '#000000', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#000000', '#ffffff'), 'bcolor' => array('#FB3988', '#FB3988', '#ffffff', '#FB3988'), 'bhover' => array('#606060', '#606060', '#FDCFDC', '#606060'), 'bbcolor' => array('#ffffff', '#ffffff', '#FB3988', '#ffffff'), 'rtcolor' => array('#ffffff', '#ffffff', '#000000', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#000000', '#ffffff'), 'rbcolor' => array('#FB3988', '#FB3988', '#ffffff', '#FB3988'), 'ftborder' => array('#bbbbbb', '#bbbbbb', '#bbbbbb', '#bbbbbb') );
	} elseif($template == 'temp7') {
		$package_options = array( 'templ' => 'temp7', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#F36523', 'ptnbg' => '#FDF5E0', 'ctcolor' => '#00032E', 'cftcolor' => '#3D2A23', 'furlclr' => '#000000', 'furlhvr' => '#3D2A23', 'ccolbg' => '#FF9700', 'prnbg' => '', 'capbg1' => '#FF9700', 'capbg2' => '#FF9700', 'ccborder' => '#FF9700', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#FFF568', '#FCD846', '#FECC17', '#FF9700'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#FFF568', '#FCD846', '#FECC17', '#FF9700'), 'pcbig' => array('#00032E', '#00032E', '#00032E', '#00032E'), 'phbig' =>array('#00032E', '#00032E', '#00032E', '#00032E'), 'pcsmall' => array('#00032E', '#00032E', '#00032E', '#00032E'), 'phsmall' => array('#00032E', '#00032E', '#00032E', '#00032E'), 'cutclr' => array('#908a3b', '#907b28', '#886d0c', '#804c00'), 'pbcolor' => array('#FFF568', '#FCD846', '#FECC17', '#FF9700'), 'pcircle' => array('#FFF568', '#FCD846', '#FECC17', '#FF9700'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#3D2A23', '#3D2A23', '#3D2A23', '#3D2A23'), 'ftcolor' => array('#3D2A23', '#3D2A23', '#3D2A23', '#3D2A23'), 'fbrow1' => array('#FFF568', '#FCD846', '#FECC17', '#FF9700'), 'fbrow2' => array('#FFF568', '#FCD846', '#FECC17', '#FF9700'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#F7BD00', '#FF9700', '#F7941D', '#F36523'), 'bhover' => array('#F7BD00', '#FF9700', '#F7941D', '#F36523'), 'bbcolor' => array('#FFF568', '#FCD846', '#FECC17', '#FF9700'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#C7BE47', '#FF9700', '#F7941D', '#F36523'), 'ftborder' => array('#FFF568', '#FCD846', '#FECC17', '#FF9700') );
	} elseif($template == 'temp8') {
		$package_options = array( 'templ' => 'temp8', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ctcolor' => '#173153', 'cftcolor' => '#ffffff', 'furlclr' => '#EB5D45', 'furlhvr' => '#ffffff', 'ccolbg' => '#212527', 'prnbg' => '', 'capbg1' => '#212527', 'capbg2' => '#212527', 'ccborder' => '#212527', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#F36B54', '#F3BC45', '#445E80', '#0DDCA6'), 'tcolor' => array('#ffffff', '#000000', '#ffffff', '#000000'), 'thover' => array('#ffffff', '#000000', '#ffffff', '#000000'), 'tbcolor' => array('#F36B54', '#F3BC45', '#445E80', '#0DDCA6'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'pbcolor' => array('#F36B54', '#F3BC45', '#445E80', '#0DDCA6'), 'pcircle' => array('#EB5D45', '#FDC64F', '#173153', '#06D6A0'), 'imgclr' => array('#EB5D45', '#FDC64F', '#173153', '#06D6A0'), 'fncolor' => array('#650400', '#5a3900', '#97c5ff', '#004226'), 'ftcolor' => array('#650400', '#5a3900', '#97c5ff', '#004226'), 'fbrow1' => array('#F36B54', '#F3BC45', '#445E80', '#0DDCA6'), 'fbrow2' => array('#F36B54', '#F3BC45', '#445E80', '#0DDCA6'), 'btcolor' => array('#650400', '#5a3900', '#97c5ff', '#004226'), 'bthover' => array('#650400', '#5a3900', '#97c5ff', '#004226'), 'bcolor' => array('#EB5D45', '#FDC64F', '#173153', '#06D6A0'), 'bhover' => array('#FC8971', '#FEF47D', '#455F81', '#34FBCE'), 'bbcolor' => array('#F36B54', '#F3BC45', '#445E80', '#0DDCA6'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#EF476F', '#EF476F', '#EF476F', '#EF476F'), 'ftborder' => array('#F36B54', '#F3BC45', '#445E80', '#0DDCA6') );
	} elseif($template == 'temp9') {
		$package_options = array( 'templ' => 'temp9', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#350060', 'ptnbg' => '#f1f1f1', 'ctcolor' => '#350060', 'cftcolor' => '#ffffff', 'furlclr' => '#ffffff', 'furlhvr' => '#ffffff', 'ccolbg' => '#350060', 'prnbg' => '', 'capbg1' => '#350060', 'capbg2' => '#350060', 'ccborder' => '#350060', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#700389', '#53037E', '#400173', '#350060'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#700389', '#53037E', '#400173', '#350060'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#350060', '#350060', '#350060', '#350060'), 'pbcolor' => array('#700389', '#53037E', '#400173', '#350060'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'ftcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow1' => array('#700389', '#53037E', '#400173', '#350060'), 'fbrow2' => array('#700389', '#53037E', '#400173', '#350060'), 'btcolor' => array('#350060', '#350060', '#350060', '#350060'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#f1f1f1', '#f1f1f1', '#f1f1f1', '#f1f1f1'), 'bhover' => array('#EB0360', '#EB0360', '#EB0360', '#EB0360'), 'bbcolor' => array('#700389', '#53037E', '#400173', '#350060'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#E3013E', '#E3013E', '#E3013E', '#E3013E'), 'ftborder' => array('#700389', '#53037E', '#400173', '#350060') );
	} elseif($template == 'temp10') {
		$package_options = array( 'templ' => 'temp10', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ctcolor' => '#173153', 'cftcolor' => '#ffffff', 'furlclr' => '#EB5D45', 'furlhvr' => '#ffffff', 'ccolbg' => '#212527', 'prnbg' => '', 'capbg1' => '#212527', 'capbg2' => '#212527', 'ccborder' => '#212527', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#4724CD', '#AE8819', '#465B01', '#A02A0A'), 'tcolor' => array('#4724CD', '#AE8819', '#465B01', '#A02A0A'), 'thover' => array('#4724CD', '#AE8819', '#465B01', '#A02A0A'), 'tbcolor' => array('#BFB8D9', '#EFCB60', '#C1D28D', '#FC9A6E'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'pbcolor' => array('#BFB8D9', '#EFCB60', '#C1D28D', '#FC9A6E'), 'pcircle' => array('#BFB8D9', '#EFCB60', '#C1D28D', '#FC9A6E'), 'imgclr' => array('#4724CD', '#AE8819', '#465B01', '#A02A0A'), 'fncolor' => array('#1A0295', '#765000', '#192700', '#680600'), 'ftcolor' => array('#1A0295', '#765000', '#192700', '#680600'), 'fbrow1' => array('#BFB8D9', '#EFCB60', '#C1D28D', '#FC9A6E'), 'fbrow2' => array('#BFB8D9', '#EFCB60', '#C1D28D', '#FC9A6E'), 'btcolor' => array('#BFB8D9', '#EFCB60', '#C1D28D', '#FC9A6E'), 'bthover' => array('#BFB8D9', '#EFCB60', '#C1D28D', '#FC9A6E'), 'bcolor' => array('#1A0295', '#765000', '#192700', '#680600'), 'bhover' => array('#4724CD', '#AE8819', '#465B01', '#A02A0A'), 'bbcolor' => array('#4724CD', '#AE8819', '#465B01', '#A02A0A'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#EF476F', '#EF476F', '#EF476F', '#EF476F'), 'ftborder' => array('#F36B54', '#F3BC45', '#445E80', '#0DDCA6') );
	} elseif($template == 'temp11') {
		$package_options = array( 'templ' => 'temp11', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#AA2626', 'ptnbg' => '#dddddd', 'ctcolor' => '#AA2626', 'cftcolor' => '#787878', 'furlclr' => '#787878', 'furlhvr' => '#212121', 'ccolbg' => '#F5F5F5', 'prnbg' => '', 'capbg1' => '#F5F5F5', 'capbg2' => '#F5F5F5', 'ccborder' => '#bbbbbb', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#F5F5F5', '#F5F5F5', '#AA2626', '#F5F5F5'), 'tcolor' => array('#212121', '#212121', '#ffffff', '#212121'), 'thover' => array('#212121', '#212121', '#ffffff', '#212121'), 'tbcolor' => array('#F5F5F5', '#F5F5F5', '#AA2626', '#F5F5F5'), 'pcbig' => array('#212121', '#212121', '#AA2626', '#212121'), 'phbig' =>array('#212121', '#212121', '#AA2626', '#212121'), 'pcsmall' => array('#212121', '#212121', '#AA2626', '#212121'), 'phsmall' => array('#212121', '#212121', '#AA2626', '#212121'), 'cutclr' => array('#9d9d9d', '#9d9d9d', '#9d9d9d', '#9d9d9d'), 'pbcolor' => array('#ffffff', '#ffffff', '#FFF0F0', '#ffffff'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#212121', '#212121', '#787878', '#212121'), 'ftcolor' => array('#212121', '#212121', '#787878', '#212121'), 'fbrow1' => array('#ffffff', '#ffffff', '#FFF0F0', '#ffffff'), 'fbrow2' => array('#ffffff', '#ffffff', '#FFF0F0', '#ffffff'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#B53131', '#B53131', '#B53131', '#B53131'), 'bhover' => array('#AA2626', '#AA2626', '#AA2626', '#AA2626'), 'bbcolor' => array('#F5F5F5', '#F5F5F5', '#AA2626', '#F5F5F5'), 'rtcolor' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rthover' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rbcolor' => array('#ffc100', '#ffc100', '#ffc100', '#ffc100'), 'ftborder' => array('#bbbbbb', '#bbbbbb', '#bbbbbb', '#bbbbbb') );
	} elseif($template == 'temp12') {
		$package_options = array( 'templ' => 'temp12', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#AA2626', 'ptnbg' => '#dddddd', 'ctcolor' => '#AA2626', 'cftcolor' => '#787878', 'furlclr' => '#787878', 'furlhvr' => '#212121', 'ccolbg' => '#F5F5F5', 'prnbg' => '', 'capbg1' => '#F5F5F5', 'capbg2' => '#F5F5F5', 'ccborder' => '#bbbbbb', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'tcolor' => array('#444444', '#444444', '#444444', '#444444'), 'thover' => array('#0099E5', '#0099E5', '#0099E5', '#0099E5'), 'tbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcbig' => array('#444444', '#444444', '#444444', '#444444'), 'phbig' =>array('#0099E5', '#0099E5', '#0099E5', '#0099E5'), 'pcsmall' => array('#444444', '#444444', '#444444', '#444444'), 'phsmall' => array('#0099E5', '#0099E5', '#0099E5', '#0099E5'), 'cutclr' => array('#9d9d9d', '#9d9d9d', '#9d9d9d', '#9d9d9d'), 'pbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fncolor' => array('#444444', '#444444', '#444444', '#444444'), 'ftcolor' => array('#444444', '#444444', '#444444', '#444444'), 'fbrow1' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow2' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#444444', '#444444', '#444444', '#444444'), 'bhover' => array('#0099E5', '#0099E5', '#0099E5', '#0099E5'), 'bbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#0099E5', '#0099E5', '#0099E5', '#0099E5'), 'rbcolor' => array('#F9D930', '#F9D930', '#F9D930', '#F9D930'), 'ftborder' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd') );
	} elseif($template == 'temp13') {
		$package_options = array( 'templ' => 'temp13', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ctcolor' => '#173153', 'cftcolor' => '#ffffff', 'furlclr' => '#EB5D45', 'furlhvr' => '#ffffff', 'ccolbg' => '#212527', 'prnbg' => '', 'capbg1' => '#212527', 'capbg2' => '#212527', 'ccborder' => '#212527', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#7AC143', '#17D5D1', '#FFE92E', '#0F1C70'), 'tcolor' => array('#7AC143', '#17D5D1', '#FFE92E', '#0F1C70'), 'thover' => array('#7AC143', '#17D5D1', '#FFE92E', '#0F1C70'), 'tbcolor' => array('#ffffff', '#ffffff', '#0f1c70', '#ffffff'), 'pcbig' => array('#7AC143', '#17D5D1', '#FFE92E', '#0F1C70'), 'phbig' =>array('#7AC143', '#17D5D1', '#FFE92E', '#0F1C70'), 'pcsmall' => array('#7AC143', '#17D5D1', '#FFE92E', '#0F1C70'), 'phsmall' => array('#7AC143', '#17D5D1', '#FFE92E', '#0F1C70'), 'cutclr' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'pbcolor' => array('#ffffff', '#ffffff', '#0f1c70', '#ffffff'), 'pcircle' => array('#7AC143', '#17D5D1', '#FFE92E', '#0F1C70'), 'imgclr' => array('#ffffff', '#ffffff', '#0f1c70', '#ffffff'), 'fncolor' => array('#7AC143', '#17D5D1', '#FFE92E', '#0F1C70'), 'ftcolor' => array('#7AC143', '#17D5D1', '#FFE92E', '#0F1C70'), 'fbrow1' => array('#ffffff', '#ffffff', '#0f1c70', '#ffffff'), 'fbrow2' => array('#ffffff', '#ffffff', '#0f1c70', '#ffffff'), 'btcolor' => array('#333333', '#333333', '#333333', '#333333'), 'bthover' => array('#333333', '#333333', '#333333', '#333333'), 'bcolor' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'bhover' => array('#eeeeee', '#eeeeee', '#eeeeee', '#eeeeee'), 'bbcolor' => array('#7AC143', '#17D5D1', '#FFE92E', '#0F1C70'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#EF476F', '#EF476F', '#EF476F', '#EF476F'), 'ftborder' => array('#F36B54', '#F3BC45', '#445E80', '#0DDCA6') );
	} elseif($template == 'temp14') {
		$package_options = array( 'templ' => 'temp14', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#7dc3be', 'ptabg' => '#39B54A', 'ptnbg' => '#E6E6E6', 'ctcolor' => '#333333', 'cftcolor' => '#ffffff', 'furlclr' => '#564817', 'furlhvr' => '#ffffff', 'ccolbg' => '#947a21', 'prnbg' => '', 'capbg1' => '#d6b02d', 'capbg2' => '#d6b02d', 'ccborder' => '#947a21', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#568626', '#432463', '#841837', '#792409'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#7ec338', '#713da6', '#bc2651', '#b2350d'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#aaef64', '#c692f5', '#f877a2', '#f5865e'), 'pbcolor' => array('#7ec338', '#713da6', '#bc2651', '#b2350d'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#568626', '#432463', '#841837', '#792409'), 'fncolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'ftcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow1' => array('#7ec338', '#713da6', '#bc2651', '#b2350d'), 'fbrow2' => array('#7ec338', '#713da6', '#bc2651', '#b2350d'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#AAEF64', '#A06CD5', '#EB5580', '#E1643C'), 'bhover' => array('#AAEF64', '#A06CD5', '#EB5580', '#E1643C'), 'bbcolor' => array('#7ec338', '#713da6', '#bc2651', '#b2350d'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#AAEF64', '#A06CD5', '#EB5580', '#E1643C'), 'ftborder' => array('#568626', '#432463', '#841837', '#792409') );
	} elseif($template == 'temp15') {
		$package_options = array( 'templ' => 'temp15', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#39B54A', 'ptnbg' => '#E6E6E6', 'ctcolor' => '#666666', 'cftcolor' => '#666666', 'furlclr' => '#39B54A', 'furlhvr' => '#666666', 'ccolbg' => '#ECECEC', 'prnbg' => '', 'capbg1' => '#ffffff', 'capbg2' => '#F7F7F7', 'ccborder' => '#ECECEC', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#E6E6E6', '#E6E6E6', '#E6E6E6', '#E6E6E6'), 'tcolor' => array('#666666', '#666666', '#666666', '#666666'), 'thover' => array('#666666', '#666666', '#666666', '#666666'), 'tbcolor' => array('#E7E7E7', '#E7E7E7', '#E7E7E7', '#E7E7E7'), 'pcbig' => array('#000000', '#000000', '#ffffff', '#000000'), 'phbig' =>array('#000000', '#000000', '#ffffff', '#000000'), 'pcsmall' => array('#000000', '#000000', '#ffffff', '#000000'), 'phsmall' => array('#000000', '#000000', '#ffffff', '#000000'), 'cutclr' => array('#808080', '#808080', '#f7f7f7', '#808080'), 'pbcolor' => array('#E6E6E6', '#E6E6E6', '#39B54A', '#E6E6E6'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#666666', '#666666', '#666666', '#666666'), 'ftcolor' => array('#666666', '#666666', '#666666', '#666666'), 'fbrow1' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow2' => array('#F7F7F7', '#F7F7F7', '#F7F7F7', '#F7F7F7'), 'btcolor' => array('#ffffff', '#ffffff', '#39B54A', '#ffffff'), 'bthover' => array('#39B54A', '#39B54A', '#ffffff', '#39B54A'), 'bcolor' => array('#39B54A', '#39B54A', '#E6E6E6', '#39B54A'), 'bhover' => array('#ffffff', '#ffffff', '#39B54A', '#ffffff'), 'bbcolor' => array('#E6E6E6', '#E6E6E6', '#39B54A', '#E6E6E6'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#39B54A', '#39B54A', '#FF931E', '#FF931E'), 'ftborder' => array('#E6E6E6', '#E6E6E6', '#E6E6E6', '#E6E6E6') );
	} elseif($template == 'temp16') {
		$package_options = array( 'templ' => 'temp16', 'tttext' => '#FFFFFF', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ctcolor' => '#333333', 'cftcolor' => '#000000', 'furlclr' => '#ed662f', 'furlhvr' => '#000000', 'ccolbg' => '#dddddd', 'prnbg' => '', 'capbg1' => '#ececec', 'capbg2' => '#ffffff', 'ccborder' => '#bbbbbb', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#ed662f', '#ea2e2d', '#BE292D', '#993124'), 'tcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'thover' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'tbcolor' => array('#ed662f', '#ea2e2d', '#BE292D', '#993124'), 'pcbig' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phbig' =>array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'pcsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'cutclr' => array('#993124', '#993124', '#ed662f', '#ed662f'), 'pbcolor' => array('#ed662f', '#ea2e2d', '#BE292D', '#993124'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#000000', '#000000', '#000000', '#000000'), 'ftcolor' => array('#000000', '#000000', '#000000', '#000000'), 'fbrow1' => array('#ffffff', '#ececec', '#ffffff', '#ececec'), 'fbrow2' => array('#ececec', '#ffffff', '#ececec', '#ffffff'), 'btcolor' => array('#000000', '#000000', '#000000', '#000000'), 'bthover' => array('#000000', '#000000', '#000000', '#000000'), 'bcolor' => array('#ececec', '#ececec', '#ececec', '#ececec'), 'bhover' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'bbcolor' => array('#ed662f', '#ea2e2d', '#BE292D', '#993124'), 'rtcolor' => array('#993124', '#993124', '#993124', '#993124'), 'rthover' => array('#993124', '#993124', '#993124', '#993124'), 'rbcolor' => array('#f7db53', '#f7db53', '#f7db53', '#f7db53'), 'ftborder' => array('#bbbbbb', '#bbbbbb', '#bbbbbb', '#bbbbbb') );
	} elseif($template == 'temp17') {
		$package_options = array( 'templ' => 'temp17', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#FF4D00', 'ptnbg' => '#f7f7f7', 'ctcolor' => '#FF7400', 'cftcolor' => '#333333', 'furlclr' => '#FF7400', 'furlhvr' => '#333333', 'ccolbg' => '#ececec', 'prnbg' => '', 'capbg1' => '#f7f7f7', 'capbg2' => '#ffffff', 'ccborder' => '#bbbbbb', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#ececec', '#ececec', '#ececec', '#ececec'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#ffaa29', '#ff8a29', '#ff6928', '#ff462a'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#d37e00', '#cc6200', '#d12900', '#c92800'), 'pbcolor' => array('#ff9a00', '#ff7400', '#ff4d00', '#fb2201'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#333333', '#333333', '#333333', '#333333'), 'ftcolor' => array('#333333', '#333333', '#333333', '#333333'), 'fbrow1' => array('#ffffff', '#f7f7f7', '#ffffff', '#f7f7f7'), 'fbrow2' => array('#f7f7f7', '#ffffff', '#f7f7f7', '#ffffff'), 'btcolor' => array('#ff9a00', '#ff7400', '#ff4d00', '#fb2201'), 'bthover' => array('#ff9a00', '#ff7400', '#ff4d00', '#fb2201'), 'bcolor' => array('#ededed', '#ededed', '#ededed', '#ededed'), 'bhover' => array('#f7f7f7', '#f7f7f7', '#f7f7f7', '#f7f7f7'), 'bbcolor' => array('#ff9a00', '#ff7400', '#ff4d00', '#fb2201'), 'rtcolor' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rthover' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rbcolor' => array('#ffc100', '#ffc100', '#ffc100', '#ffc100'), 'ftborder' => array('#bbbbbb', '#bbbbbb', '#bbbbbb', '#bbbbbb') );
	} elseif($template == 'temp18') {
		$package_options = array( 'templ' => 'temp18', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#419727', 'ptnbg' => '#F6F6F6', 'ctcolor' => '#357B1F', 'cftcolor' => '#333333', 'furlclr' => '', 'furlhvr' => '', 'ccolbg' => '#dddddd', 'prnbg' => '', 'capbg1' => '#EBEBEB', 'capbg2' => '#FFFFFF', 'ccborder' => '#dddddd', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#5E9737', '#487D29', '#356A1E', '#275C17'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#f5f5f5', '#f5f5f5', '#f5f5f5', '#f5f5f5'), 'pbcolor' => array('#7CAC49', '#5F9836', '#468928', '#34791F'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#333333', '#333333', '#333333', '#333333'), 'ftcolor' => array('#333333', '#333333', '#333333', '#333333'), 'fbrow1' => array('#F6F6F6', '#EBEBEB', '#F6F6F6', '#EBEBEB'), 'fbrow2' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#629634', '#478025', '#32701A', '#245F14'), 'bhover' => array('#A9CA63', '#82BE4A', '#61B637', '#47A62A'), 'bbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#B53535', '#B53535', '#B53535', '#B53535'), 'ftborder' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff') );
	} elseif($template == 'temp19') {
		$package_options = array( 'templ' => 'temp19', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0152C6', 'ptnbg' => '#F5F5F5', 'ctcolor' => '#7d7d7d', 'cftcolor' => '#7d7d7d', 'furlclr' => '#2286C5', 'furlhvr' => '#7d7d7d', 'ccolbg' => '#F5F5F5', 'prnbg' => '#F5F5F5', 'capbg1' => '#EBEBEB', 'capbg2' => '#F5F5F5', 'ccborder' => '#dddddd', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#276CCF', '#4398CE', '#5EC4CD', '#68D5CD'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#F5F5F5', '#F5F5F5', '#F5F5F5', '#F5F5F5'), 'pbcolor' => array('#0152C6', '#2286C5', '#42BAC4', '#4ECDC4'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#7d7d7d', '#7d7d7d', '#7d7d7d', '#7d7d7d'), 'ftcolor' => array('#7d7d7d', '#7d7d7d', '#7d7d7d', '#7d7d7d'), 'fbrow1' => array('#EBEBEB', '#EBEBEB', '#EBEBEB', '#EBEBEB'), 'fbrow2' => array('#F5F5F5', '#F5F5F5', '#F5F5F5', '#F5F5F5'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#0152C6', '#2286C5', '#42BAC4', '#4ECDC4'), 'bhover' => array('#3374D1', '#4E9ED0', '#67C7CF', '#71D7CF'), 'bbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#FFC400', '#FFC400', '#FFC400', '#FFC400'), 'ftborder' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd') );
	} elseif($template == 'temp20') {
		$package_options = array( 'templ' => 'temp20', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#B63636', 'ptnbg' => '#F6F6F6', 'ctcolor' => '#D87800', 'cftcolor' => '#333333', 'furlclr' => '', 'furlhvr' => '', 'ccolbg' => '#dddddd', 'prnbg' => '', 'capbg1' => '#EBEBEB', 'capbg2' => '#FFFFFF', 'ccborder' => '#dddddd', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#E49200', '#D66303', '#A92C2C', '#7F2A3B'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#f5f5f5', '#f5f5f5', '#f5f5f5', '#f5f5f5'), 'pbcolor' => array('#E9A500', '#D77500', '#B43333', '#7B2839'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#333333', '#333333', '#333333', '#333333'), 'ftcolor' => array('#333333', '#333333', '#333333', '#333333'), 'fbrow1' => array('#F6F6F6', '#EBEBEB', '#F6F6F6', '#EBEBEB'), 'fbrow2' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#E0900D', '#CA620D', '#A12E2E', '#682532'), 'bhover' => array('#F1C600', '#E6A000', '#CB4343', '#BA5C70'), 'bbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#59A532', '#59A532', '#59A532', '#59A532'), 'ftborder' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff') );
	} elseif($template == 'temp21') {
		$package_options = array( 'templ' => 'temp21', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#3A416F', 'ptabg' => '#3A416F', 'ptnbg' => '#FDFDFE', 'ctcolor' => '#3A416F', 'cftcolor' => '#5d6494', 'furlclr' => '#5470FE', 'furlhvr' => '#5d6494', 'ccolbg' => '#E2E4EF', 'prnbg' => '#FDFDFE', 'capbg1' => '#FDFDFE', 'capbg2' => '#FDFDFE', 'ccborder' => '#E2E4EF', 'fcatbg' => '#ECEDF5', 'ffnclr' => '#5d6494', 'cscolor' => '#E0E0EA', 'cshcolor' => '#DADCE8' );
		$package_details = array( 'pbclr' => array('#FEFEFE', '#FEFEFE', '#FEFEFE', '#FEFEFE'), 'tcolor' => array('#5d6494', '#5d6494', '#5d6494', '#ffffff'), 'thover' => array('#5d6494', '#5d6494', '#5d6494', '#ffffff'), 'tbcolor' => array('#F5F5FA', '#F5F5FA', '#F5F5FA', '#383F6B'), 'pcbig' => array('#383F6B', '#383F6B', '#383F6B', '#ffffff'), 'phbig' =>array('#383F6B', '#383F6B', '#383F6B', '#ffffff'), 'pcsmall' => array('#383F6B', '#383F6B', '#383F6B', '#ffffff'), 'phsmall' => array('#383F6B', '#383F6B', '#383F6B', '#ffffff'), 'cutclr' => array('#5d6494', '#5d6494', '#5d6494', '#c5c9e0'), 'pbcolor' => array('#F5F5FA', '#F5F5FA', '#F5F5FA', '#383F6B'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#848ab8', '#848ab8', '#848ab8', '#c5c9e0'), 'ftcolor' => array('#848ab8', '#848ab8', '#848ab8', '#c5c9e0'), 'fbrow1' => array('#F5F5FA', '#F5F5FA', '#F5F5FA', '#32385F'), 'fbrow2' => array('#F5F5FA', '#F5F5FA', '#F5F5FA', '#32385F'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#5d6494'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#5d6494'), 'bcolor' => array('#5A6DFF', '#5A6DFF', '#5A6DFF', '#E5E5EA'), 'bhover' => array('#5A6DFF', '#5A6DFF', '#5A6DFF', '#E5E5EA'), 'bbcolor' => array('#F5F5FA', '#F5F5FA', '#F5F5FA', '#32385F'), 'rtcolor' => array('#FEFEFE', '#FEFEFE', '#FEFEFE', '#FEFEFE'), 'rthover' => array('#FEFEFE', '#FEFEFE', '#FEFEFE', '#FEFEFE'), 'rbcolor' => array('#3AB2BD', '#F3A57E', '#EA71BC', '#5468FF'), 'ftborder' => array('#D8DBEA', '#D8DBEA', '#D8DBEA', '#282d51') );
	} elseif($template == 'temp22') {
		$package_options = array( 'templ' => 'temp22', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#2C2C2C', 'ptnbg' => '#EBEBEB', 'ctcolor' => '#9d9d9d', 'cftcolor' => '#7d7d7d', 'furlclr' => '#2286C5', 'furlhvr' => '#7d7d7d', 'ccolbg' => '#dddddd', 'prnbg' => '', 'capbg1' => '#e2e2e2', 'capbg2' => '#f5f5f5', 'ccborder' => '#dddddd', 'fcatbg' => '#2C2C2C', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'tcolor' => array('#9d9d9d', '#9d9d9d', '#9d9d9d', '#9d9d9d'), 'thover' => array('#9d9d9d', '#9d9d9d', '#9d9d9d', '#9d9d9d'), 'tbcolor' => array('#2C2C2C', '#2C2C2C', '#2C2C2C', '#2C2C2C'), 'pcbig' => array('#5EC4CD', '#5EC4CD', '#5EC4CD', '#5EC4CD'), 'phbig' =>array('#5EC4CD', '#5EC4CD', '#5EC4CD', '#5EC4CD'), 'pcsmall' => array('#9d9d9d', '#9d9d9d', '#9d9d9d', '#9d9d9d'), 'phsmall' => array('#9d9d9d', '#9d9d9d', '#9d9d9d', '#9d9d9d'), 'cutclr' => array('#7d7d7d', '#7d7d7d', '#7d7d7d', '#7d7d7d'), 'pbcolor' => array('#2C2C2C', '#2C2C2C', '#2C2C2C', '#2C2C2C'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#7d7d7d', '#7d7d7d', '#7d7d7d', '#7d7d7d'), 'ftcolor' => array('#7d7d7d', '#7d7d7d', '#7d7d7d', '#7d7d7d'), 'fbrow1' => array('#e6e6e6', '#e2e2e2', '#e6e6e6', '#e2e2e2'), 'fbrow2' => array('#ffffff', '#f5f5f5', '#ffffff', '#f5f5f5'), 'btcolor' => array('#2C2C2C', '#2C2C2C', '#2C2C2C', '#2C2C2C'), 'bthover' => array('#2C2C2C', '#2C2C2C', '#2C2C2C', '#2C2C2C'), 'bcolor' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'bhover' => array('#eeeeee', '#eeeeee', '#eeeeee', '#eeeeee'), 'bbcolor' => array('#f5f5f5', '#f5f5f5', '#f5f5f5', '#f5f5f5'), 'rtcolor' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rthover' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rbcolor' => array('#ffc100', '#ffc100', '#ffc100', '#ffc100'), 'ftborder' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd') );
	} elseif($template == 'temp23') {
		$package_options = array( 'templ' => 'temp23', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#AA2626', 'ptnbg' => '#EBEBEB', 'ctcolor' => '#AA2626', 'cftcolor' => '#7d7d7d', 'furlclr' => '#2286C5', 'furlhvr' => '#7d7d7d', 'ccolbg' => '#dddddd', 'prnbg' => '', 'capbg1' => '#e2e2e2', 'capbg2' => '#f5f5f5', 'ccborder' => '#dddddd', 'fcatbg' => '#AA2626', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#AA2626', '#AA2626', '#AA2626', '#AA2626'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#e67e7e', '#e67e7e', '#e67e7e', '#e67e7e'), 'phsmall' => array('#e67e7e', '#e67e7e', '#e67e7e', '#e67e7e'), 'cutclr' => array('#e67e7e', '#e67e7e', '#e67e7e', '#e67e7e'), 'pbcolor' => array('#AA2626', '#AA2626', '#AA2626', '#AA2626'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#7d7d7d', '#7d7d7d', '#7d7d7d', '#7d7d7d'), 'ftcolor' => array('#7d7d7d', '#7d7d7d', '#7d7d7d', '#7d7d7d'), 'fbrow1' => array('#e6e6e6', '#e2e2e2', '#e6e6e6', '#e2e2e2'), 'fbrow2' => array('#ffffff', '#f5f5f5', '#ffffff', '#f5f5f5'), 'btcolor' => array('#AA2626', '#AA2626', '#AA2626', '#AA2626'), 'bthover' => array('#AA2626', '#AA2626', '#AA2626', '#AA2626'), 'bcolor' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'bhover' => array('#eeeeee', '#eeeeee', '#eeeeee', '#eeeeee'), 'bbcolor' => array('#f5f5f5', '#f5f5f5', '#f5f5f5', '#f5f5f5'), 'rtcolor' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rthover' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rbcolor' => array('#ffc100', '#ffc100', '#ffc100', '#ffc100'), 'ftborder' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd') );
	} elseif($template == 'temp24') {
		$package_options = array( 'templ' => 'temp24', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#F1F1F1', 'ptnbg' => '#F6F6F6', 'ctcolor' => '#2D3236', 'cftcolor' => '#353132', 'furlclr' => '#000000', 'furlhvr' => '#353132', 'ccolbg' => '#ffffff', 'prnbg' => '#F1F1F1', 'capbg1' => '#F6F6F6', 'capbg2' => '#EFEFEF', 'ccborder' => '#CCCCCC', 'fcatbg' => '#e4e4e4', 'ffnclr' => '#303133', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#2A6E79', '#4B7221', '#A7820D', '#8B562A'), 'pcbig' => array('#303133', '#303133', '#303133', '#303133'), 'phbig' =>array('#303133', '#303133', '#303133', '#303133'), 'pcsmall' => array('#303133', '#303133', '#303133', '#303133'), 'phsmall' => array('#303133', '#303133', '#303133', '#303133'), 'cutclr' => array('#A1A1A1', '#A1A1A1', '#A1A1A1', '#A1A1A1'), 'pbcolor' => array('#ECECEC', '#ECECEC', '#ECECEC', '#ECECEC'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#353132', '#353132', '#353132', '#353132'), 'ftcolor' => array('#353132', '#353132', '#353132', '#353132'), 'fbrow1' => array('#F6F6F6', '#F6F6F6', '#F6F6F6', '#F6F6F6'), 'fbrow2' => array('#EFEFEF', '#EFEFEF', '#EFEFEF', '#EFEFEF'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#2A6E79', '#4B7221', '#A7820D', '#8B562A'), 'bhover' => array('#2A6E79', '#4B7221', '#A7820D', '#8B562A'), 'bbcolor' => array('#E2E2E2', '#E2E2E2', '#E2E2E2', '#E2E2E2'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#773332', '#773332', '#773332', '#773332'), 'ftborder' => array('#CCCCCC', '#CCCCCC', '#CCCCCC', '#CCCCCC') );
	} elseif($template == 'temp25') {
		$package_options = array( 'templ' => 'temp25', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#D4ADAE', 'ptnbg' => '#E6FCF9', 'ctcolor' => '#AD8B8A', 'cftcolor' => '#00070E', 'furlclr' => '', 'furlhvr' => '', 'ccolbg' => '#D4ADAE', 'prnbg' => '', 'capbg1' => '#D4ADAE', 'capbg2' => '#D4ADAE', 'ccborder' => '#D4ADAE', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#EAFAF9', '#FCE7EC', '#EBD7D8', '#A2D2E0'), 'tcolor' => array('#00070E', '#00070E', '#00070E', '#00070E'), 'thover' => array('#00070E', '#00070E', '#00070E', '#00070E'), 'tbcolor' => array('#EAFAF9', '#FCE7EC', '#EBD7D8', '#A2D2E0'), 'pcbig' => array('#00070E', '#00070E', '#00070E', '#00070E'), 'phbig' =>array('#00070E', '#00070E', '#00070E', '#00070E'), 'pcsmall' => array('#00070E', '#00070E', '#00070E', '#00070E'), 'phsmall' => array('#00070E', '#00070E', '#00070E', '#00070E'), 'cutclr' => array('#80CBC7', '#FF6B8B', '#D2AEAE', '#5BBFD9'), 'pbcolor' => array('#EAFAF9', '#FCE7EC', '#EBD7D8', '#A2D2E0'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#00070E', '#00070E', '#00070E', '#00070E'), 'ftcolor' => array('#00070E', '#00070E', '#00070E', '#00070E'), 'fbrow1' => array('#EAFAF9', '#FCE7EC', '#EBD7D8', '#A2D2E0'), 'fbrow2' => array('#EAFAF9', '#FCE7EC', '#EBD7D8', '#A2D2E0'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#80CBC7', '#FF6B8B', '#D2AEAE', '#5BBFD9'), 'bhover' => array('#80CBC7', '#FF6B8B', '#D2AEAE', '#5BBFD9'), 'bbcolor' => array('#EAFAF9', '#FCE7EC', '#EBD7D8', '#A2D2E0'), 'rtcolor' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rthover' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rbcolor' => array('#80CBC7', '#FF6B8B', '#D2AEAE', '#5BBFD9'), 'ftborder' => array('#EAFAF9', '#FCE7EC', '#EBD7D8', '#A2D2E0') );
	} elseif($template == 'temp26') {
		$package_options = array( 'templ' => 'temp26', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#839C0E', 'ptnbg' => '#E9AA00', 'ctcolor' => '#E18416', 'cftcolor' => '#7d7d7d', 'furlclr' => '#E18416', 'furlhvr' => '#7d7d7d', 'ccolbg' => '#dddddd', 'prnbg' => '', 'capbg1' => '#e2e2e2', 'capbg2' => '#f5f5f5', 'ccborder' => '#dddddd', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#E18416', '#E9AA00', '#839C0E', '#418520'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#EBEBEB', '#EBEBEB', '#EBEBEB', '#EBEBEB'), 'pbcolor' => array('#EF9A36', '#F6BA18', '#94AC26', '#579E34'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#7d7d7d', '#7d7d7d', '#7d7d7d', '#7d7d7d'), 'ftcolor' => array('#7d7d7d', '#7d7d7d', '#7d7d7d', '#7d7d7d'), 'fbrow1' => array('#e6e6e6', '#e2e2e2', '#e6e6e6', '#e2e2e2'), 'fbrow2' => array('#ffffff', '#f5f5f5', '#ffffff', '#f5f5f5'), 'btcolor' => array('#7d7d7d', '#7d7d7d', '#7d7d7d', '#7d7d7d'), 'bthover' => array('#7d7d7d', '#7d7d7d', '#7d7d7d', '#7d7d7d'), 'bcolor' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'bhover' => array('#eeeeee', '#eeeeee', '#eeeeee', '#eeeeee'), 'bbcolor' => array('#f5f5f5', '#f5f5f5', '#f5f5f5', '#f5f5f5'), 'rtcolor' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rthover' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rbcolor' => array('#ffc100', '#ffc100', '#ffc100', '#ffc100'), 'ftborder' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd') );
	} elseif($template == 'temp27') {
		$package_options = array( 'templ' => 'temp27', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#885035', 'ptnbg' => '#f5f5f5', 'ctcolor' => '#885035', 'cftcolor' => '#ffffff', 'furlclr' => '#ffffff', 'furlhvr' => '#d7bc83', 'ccolbg' => '#EBEBEB', 'prnbg' => '', 'capbg1' => '#9C8665', 'capbg2' => '#887255', 'ccborder' => '#dddddd', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#AA8F56', '#836332', '#804B31', '#AA3926'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#AA8F56', '#836332', '#804B31', '#AA3926'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#EBEBEB', '#EBEBEB', '#EBEBEB', '#EBEBEB'), 'pbcolor' => array('#A89057', '#7C5E2F', '#72432C', '#A43724'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'ftcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow1' => array('#B6A266', '#906E37', '#854F34', '#B3402A'), 'fbrow2' => array('#A78F56', '#7B5D2F', '#7C492F', '#A33624'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#f5f5f5', '#f5f5f5', '#f5f5f5', '#f5f5f5'), 'bcolor' => array('#AA8F56', '#836332', '#804B31', '#AA3926'), 'bhover' => array('#A89057', '#7C5E2F', '#72432C', '#A43724'), 'bbcolor' => array('#A78F56', '#7B5D2F', '#7C492F', '#A33624'), 'rtcolor' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rthover' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rbcolor' => array('#ffc100', '#ffc100', '#ffc100', '#ffc100'), 'ftborder' => array('#AA8F56', '#836332', '#804B31', '#AA3926') );
	} elseif($template == 'temp28') {
		$package_options = array( 'templ' => 'temp28', 'tttext' => '#333333', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#cfd3cf', 'ptabg' => '#1a303a', 'ptnbg' => '#cdcdcd', 'ctcolor' => '#073655', 'cftcolor' => '#ffffff', 'furlclr' => '#adc51e', 'furlhvr' => '#6b8d08', 'ccolbg' => '#dddddd', 'prnbg' => '', 'capbg1' => '#073655', 'capbg2' => '#093b58', 'ccborder' => '#bbbbbb', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#1a303a', '#1a303a', '#1a303a', '#1a303a'), 'tcolor' => array('#1a303a', '#1a303a', '#1a303a', '#1a303a'), 'thover' => array('#1a303a', '#1a303a', '#1a303a', '#1a303a'), 'tbcolor' => array('#cdcdcd', '#cdcdcd', '#cdcdcd', '#cdcdcd'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#CFCFCF', '#CFCFCF', '#CFCFCF', '#CFCFCF'), 'pbcolor' => array('#1a303a', '#1a303a', '#1a303a', '#1a303a'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'ftcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow1' => array('#2c424c', '#2c424c', '#2c424c', '#2c424c'), 'fbrow2' => array('#1a303a', '#1a303a', '#1a303a', '#1a303a'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#6b8d08', '#6b8d08', '#6b8d08', '#6b8d08'), 'bhover' => array('#97af08', '#97af08', '#97af08', '#97af08'), 'bbcolor' => array('#1a303a', '#1a303a', '#1a303a', '#1a303a'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#fe3e1f', '#fe3e1f', '#fe3e1f', '#fe3e1f'), 'ftborder' => array('#1a303a', '#1a303a', '#1a303a', '#1a303a') );
	} elseif($template == 'temp29') {
		$package_options = array( 'templ' => 'temp29', 'tttext' => '#FFFFFF', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ctcolor' => '#333333', 'cftcolor' => '#000000', 'furlclr' => '#419873', 'furlhvr' => '#317256', 'ccolbg' => '#dddddd', 'prnbg' => '', 'capbg1' => '#FAFAFA', 'capbg2' => '#EEEEEE', 'ccborder' => '#aaaaaa', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#317256', '#317256', '#317256', '#317256'), 'tcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'thover' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'tbcolor' => array('#49ab81', '#419873', '#398564', '#317256'), 'pcbig' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phbig' =>array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'pcsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'cutclr' => array('#3b8666', '#316f55', '#2d674e', '#1e4a37'), 'pbcolor' => array('#49ab81', '#419873', '#398564', '#317256'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#333333', '#333333', '#333333', '#333333'), 'ftcolor' => array('#333333', '#333333', '#333333', '#333333'), 'fbrow1' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'fbrow2' => array('#f6f6f6', '#f6f6f6', '#f6f6f6', '#f6f6f6'), 'btcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'bthover' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'bcolor' => array('#49ab81', '#419873', '#398564', '#317256'), 'bhover' => array('#49ab81', '#419873', '#398564', '#317256'), 'bbcolor' => array('#49ab81', '#419873', '#398564', '#317256'), 'rtcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'rthover' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'rbcolor' => array('#93291c', '#93291c', '#93291c', '#93291c'), 'ftborder' => array('#aaaaaa', '#aaaaaa', '#aaaaaa', '#aaaaaa') );
	} elseif($template == 'temp30') {
		$package_options = array( 'templ' => 'temp30', 'tttext' => '#FFFFFF', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ctcolor' => '#333333', 'cftcolor' => '#000000', 'furlclr' => '#0199BC', 'furlhvr' => '#000000', 'ccolbg' => '#005b96', 'prnbg' => '', 'capbg1' => '#fafafa', 'capbg2' => '#f9f9f9', 'ccborder' => '#aaaaaa', 'cscolor' => '#ffffff', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#005b96', '#005b96', '#005b96', '#005b96'), 'tcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'thover' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'tbcolor' => array('#6497b1', '#005b96', '#03396c', '#011f4b'), 'pcbig' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phbig' =>array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'pcsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'cutclr' => array('#011f4b', '#011f4b', '#6497b1', '#6497b1'), 'pbcolor' => array('#6497b1', '#005b96', '#03396c', '#011f4b'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#333333', '#333333', '#ffffff', '#333333'), 'ftcolor' => array('#333333', '#333333', '#ffffff', '#333333'), 'fbrow1' => array('#FAFAFA', '#FAFAFA', '#3574a5', '#FAFAFA'), 'fbrow2' => array('#DFDFDF', '#DFDFDF', '#03396c', '#DFDFDF'), 'btcolor' => array('#012345', '#012345', '#012345', '#012345'), 'bthover' => array('#012345', '#012345', '#012345', '#012345'), 'bcolor' => array('#b3cde0', '#b3cde0', '#b3cde0', '#b3cde0'), 'bhover' => array('#b3cde0', '#b3cde0', '#b3cde0', '#b3cde0'), 'bbcolor' => array('#6497b1', '#005b96', '#03396c', '#011f4b'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#a73d30', '#a73d30', '#a73d30', '#a73d30'), 'ftborder' => array('#aaaaaa', '#aaaaaa', '#011f4b', '#aaaaaa') );
	} elseif($template == 'temp31') {
		$package_options = array( 'templ' => 'temp31', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ctcolor' => '#173153', 'cftcolor' => '#ffffff', 'furlclr' => '#EB5D45', 'furlhvr' => '#ffffff', 'ccolbg' => '#212527', 'prnbg' => '', 'capbg1' => '#212527', 'capbg2' => '#212527', 'ccborder' => '#212527', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#EB5D45', '#FDC64F', '#173153', '#06D6A0'), 'tcolor' => array('#ffffff', '#000000', '#ffffff', '#000000'), 'thover' => array('#ffffff', '#000000', '#ffffff', '#000000'), 'tbcolor' => array('#EB5D45', '#FDC64F', '#173153', '#06D6A0'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'pbcolor' => array('#EB5D45', '#FDC64F', '#173153', '#06D6A0'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#173153', '#173153', '#9FB0C7', '#173153'), 'ftcolor' => array('#173153', '#173153', '#9FB0C7', '#173153'), 'fbrow1' => array('#EB5D45', '#FDC64F', '#173153', '#06D6A0'), 'fbrow2' => array('#EB5D45', '#FDC64F', '#173153', '#06D6A0'), 'btcolor' => array('#000000', '#ffffff', '#000000', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#06D6A0', '#000000', '#FDC64F', '#EB5D45'), 'bhover' => array('#173153', '#173153', '#173153', '#173153'), 'bbcolor' => array('#EB5D45', '#FDC64F', '#173153', '#06D6A0'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#EF476F', '#EF476F', '#EF476F', '#EF476F'), 'ftborder' => array('#EB5D45', '#FDC64F', '#173153', '#06D6A0') );
	} elseif($template == 'temp32') {
		$package_options = array( 'templ' => 'temp32', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#1a1027', 'ptnbg' => '#d6cca8', 'ctcolor' => '#1a1027', 'cftcolor' => '#ffffff', 'furlclr' => '#d6cca8', 'furlhvr' => '#ffffff', 'ccolbg' => '#d6cca8', 'prnbg' => '', 'capbg1' => '#2d303a', 'capbg2' => '#2d303a', 'ccborder' => '#bbbbbb', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#d6cca8', '#d6cca8', '#08090B', '#d6cca8'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#d6cca8', '#d6cca8', '#08090B', '#d6cca8'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#2d303a', '#2d303a', '#d6cca8', '#2d303a'), 'pbcolor' => array('#d6cca8', '#d6cca8', '#08090B', '#d6cca8'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#d6cca8', '#d6cca8', '#d6cca8', '#d6cca8'), 'ftcolor' => array('#d6cca8', '#d6cca8', '#d6cca8', '#d6cca8'), 'fbrow1' => array('#1a1027', '#1a1027', '#2d303a', '#1a1027'), 'fbrow2' => array('#1a1027', '#1a1027', '#2d303a', '#1a1027'), 'btcolor' => array('#ffffff', '#ffffff', '#000000', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#000000', '#ffffff'), 'bcolor' => array('#08090B', '#08090B', '#cac09f', '#08090B'), 'bhover' => array('#000000', '#000000', '#d6cca8', '#000000'), 'bbcolor' => array('#d6cca8', '#d6cca8', '#08090B', '#d6cca8'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#1a1027', '#1a1027', '#2D303A', '#1a1027'), 'ftborder' => array('#d6cca8', '#d6cca8', '#08090B', '#d6cca8') );
	} elseif($template == 'temp33') {
		$package_options = array( 'templ' => 'temp33', 'tttext' => '#ffffff', 'fatclr' => '#256540', 'facclr' => '#63231b', 'ttbg' => '#333333', 'ctcolor' => '#333333', 'cftcolor' => '#ffe3e0', 'furlclr' => '#8a0e01', 'furlhvr' => '#ffe3e0', 'ccolbg' => '#e74c3a', 'prnbg' => '', 'capbg1' => '#fd6757', 'capbg2' => '#e74c3a', 'ccborder' => '#e81700', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#e74c3a', '#f2a730', '#9b58b5', '#27ae61'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#e74c3a', '#f2a730', '#9b58b5', '#27ae61'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#b13b2e', '#a57120', '#8d1ab9', '#1e7543'), 'pbcolor' => array('#ee5545', '#f2a730', '#a862c5', '#33ba6d'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'ftcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow1' => array('#e74c3a', '#f2a730', '#9b58b5', '#27ae61'), 'fbrow2' => array('#e74c3a', '#f2a730', '#9b58b5', '#27ae61'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#e81700', '#f29500', '#8d29b5', '#00ad4b'), 'bhover' => array('#ee5545', '#f8a92a', '#a862c5', '#33ba6d'), 'bbcolor' => array('#e74c3a', '#f2a730', '#9b58b5', '#27ae61'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#e74c3a', '#f2a730', '#8e42ae', '#27ae61'), 'ftborder' => array('#e83825', '#f29500', '#8d29b5', '#1e9150') );
	} elseif($template == 'temp34') {
		$package_options = array( 'templ' => 'temp34', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ctcolor' => '#333333', 'cftcolor' => '#ffffff', 'furlclr' => '#0199BC', 'furlhvr' => '#000000', 'ccolbg' => '#1a1c1f', 'prnbg' => '', 'capbg1' => '#32373c', 'capbg2' => '#32373c', 'ccborder' => '#1a1c1f', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#1a1c1f', '#7b5f10', '#1d5b84', '#285820'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#32373c', '#c09319', '#2980b9', '#3b802f'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#1a1c1f', '#7b5f10', '#1d5b84', '#285820'), 'pbcolor' => array('#32373c', '#c09319', '#2980b9', '#3b802f'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'ftcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow1' => array('#32373c', '#c09319', '#2980b9', '#3b802f'), 'fbrow2' => array('#32373c', '#c09319', '#2980b9', '#3b802f'), 'btcolor' => array('#3d3d3d', '#3d3d3d', '#3d3d3d', '#3d3d3d'), 'bthover' => array('#3d3d3d', '#3d3d3d', '#3d3d3d', '#3d3d3d'), 'bcolor' => array('#d1d1d1', '#d1d1d1', '#d1d1d1', '#d1d1d1'), 'bhover' => array('#d1d1d1', '#d1d1d1', '#d1d1d1', '#d1d1d1'), 'bbcolor' => array('#32373c', '#c09319', '#2980b9', '#3b802f'), 'rtcolor' => array('#ffffff', '#c09319', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#c09319', '#ffffff', '#ffffff'), 'rbcolor' => array('#e74c3a', '#ffffff', '#8e42ae', '#27ae61'), 'ftborder' => array('#17191c', '#997513', '#215f96', '#236014') );
	} elseif($template == 'temp35') {
		$package_options = array( 'templ' => 'temp35', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ctcolor' => '#24262E', 'cftcolor' => '#24262E', 'furlclr' => '#16C1F5', 'furlhvr' => '#24262E', 'ccolbg' => '#dddddd', 'prnbg' => '', 'capbg1' => '#ffffff', 'capbg2' => '#F0F0F0', 'ccborder' => '#dddddd', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#16C1F5', '#E04658', '#F6C815', '#4AD877'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#16C1F5', '#E04658', '#F6C815', '#4AD877'), 'pcbig' => array('#24262E', '#24262E', '#24262E', '#24262E'), 'phbig' =>array('#24262E', '#24262E', '#24262E', '#24262E'), 'pcsmall' => array('#24262E', '#24262E', '#24262E', '#24262E'), 'phsmall' => array('#24262E', '#24262E', '#24262E', '#24262E'), 'cutclr' => array('#949494', '#949494', '#949494', '#949494'), 'pbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'ftcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow1' => array('#16C1F5', '#E04658', '#F6C815', '#4AD877'), 'fbrow2' => array('#16C1F5', '#E04658', '#F6C815', '#4AD877'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#16C1F5', '#E04658', '#F6C815', '#4AD877'), 'bhover' => array('#24262E', '#24262E', '#24262E', '#24262E'), 'bbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rtcolor' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rthover' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rbcolor' => array('#ffc100', '#ffc100', '#ffc100', '#ffc100'), 'ftborder' => array('#13acdb', '#e02a3f', '#d1be12', '#3db563') );
	} elseif($template == 'temp36') {
		$package_options = array( 'templ' => 'temp36', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ctcolor' => '#212121', 'cftcolor' => '#212121', 'furlclr' => '#212121', 'furlhvr' => '#9d9d9d', 'ccolbg' => '#dddddd', 'prnbg' => '', 'capbg1' => '#dddddd', 'capbg2' => '#dddddd', 'ccborder' => '#bbbbbb', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#7CAC49', '#E9A500', '#3E7DE8', '#A06B77'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#f5f5f5', '#f5f5f5', '#f5f5f5', '#f5f5f5'), 'pbcolor' => array('#212121', '#212121', '#212121', '#212121'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#000C02', '#000C02', '#000C02', '#000C02'), 'fncolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'ftcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow1' => array('#7CAC49', '#E9A500', '#3E7DE8', '#A06B77'), 'fbrow2' => array('#7CAC49', '#E9A500', '#3E7DE8', '#A06B77'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#7CAC49', '#E9A500', '#3E7DE8', '#A06B77'), 'bcolor' => array('#212121', '#212121', '#212121', '#212121'), 'bhover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bbcolor' => array('#7CAC49', '#E9A500', '#3E7DE8', '#A06B77'), 'rtcolor' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rthover' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rbcolor' => array('#ffc100', '#ffc100', '#ffc100', '#ffc100'), 'ftborder' => array('#7CAC49', '#E9A500', '#3E7DE8', '#A06B77') );
	} elseif($template == 'temp37') {
		$package_options = array( 'templ' => 'temp37', 'tttext' => '#FFFFFF', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ctcolor' => '#000000', 'cftcolor' => '#444444', 'furlclr' => '#0199BC', 'furlhvr' => '#000000', 'ccolbg' => '#64abcb', 'prnbg' => '', 'capbg1' => '#F5F5F5', 'capbg2' => '#DFDFDF', 'ccborder' => '#aaaaaa', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#64abcb', '#ecb000', '#9db74b', '#988fbb'), 'tcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'thover' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'tbcolor' => array('#64abcb', '#ecb000', '#9db74b', '#988fbb'), 'pcbig' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phbig' =>array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'pcsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'cutclr' => array('#45819c', '#b78901', '#7a8e3a', '#797294'), 'pbcolor' => array('#64abcb', '#ecb000', '#9db74b', '#988fbb'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#333333', '#333333', '#333333', '#333333'), 'ftcolor' => array('#333333', '#333333', '#333333', '#333333'), 'fbrow1' => array('#FAFAFA', '#FAFAFA', '#FAFAFA', '#FAFAFA'), 'fbrow2' => array('#DFDFDF', '#DFDFDF', '#DFDFDF', '#DFDFDF'), 'btcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'bthover' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'bcolor' => array('#64abcb', '#ecb000', '#9db74b', '#988fbb'), 'bhover' => array('#64abcb', '#ecb000', '#9db74b', '#988fbb'), 'bbcolor' => array('#64abcb', '#ecb000', '#9db74b', '#988fbb'), 'rtcolor' => array('#aa4518', '#aa4518', '#aa4518', '#aa4518'), 'rthover' => array('#333333', '#333333', '#333333', '#333333'), 'rbcolor' => array('#faec00', '#faec00', '#faec00', '#faec00'), 'ftborder' => array('#aaaaaa', '#aaaaaa', '#aaaaaa', '#aaaaaa') );
	} elseif($template == 'temp38') {
		$package_options = array( 'templ' => 'temp38', 'tttext' => '#FFFFFF', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#355e74', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ctcolor' => '#1f8c93', 'cftcolor' => '#000000', 'furlclr' => '#0199BC', 'furlhvr' => '#000000', 'ccolbg' => '#1b3647', 'prnbg' => '', 'capbg1' => '#fafafa', 'capbg2' => '#ffffff', 'ccborder' => '#bbbbbb', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#1b3647', '#bfc946', '#fb8267', '#c44765'), 'tcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'thover' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'tbcolor' => array('#1b3647', '#bfc946', '#fb8267', '#c44765'), 'pcbig' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phbig' =>array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'pcsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'cutclr' => array('#66869a', '#7b822d', '#ab5b47', '#8e364b'), 'pbcolor' => array('#1b3647', '#bfc946', '#fb8267', '#c44765'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#333333', '#333333', '#333333', '#333333'), 'ftcolor' => array('#333333', '#333333', '#333333', '#333333'), 'fbrow1' => array('#ffffff', '#fafafa', '#ffffff', '#fafafa'), 'fbrow2' => array('#fafafa', '#ffffff', '#fafafa', '#ffffff'), 'btcolor' => array('#002c47', '#b8c900', '#f92d00', '#c4002d'), 'bthover' => array('#002c47', '#b8c900', '#f92d00', '#c4002d'), 'bcolor' => array('#e1eeef', '#f4f4cd', '#f9d7cf', '#f9d9e5'), 'bhover' => array('#e1eeef', '#f4f4cd', '#f9d7cf', '#f9d9e5'), 'bbcolor' => array('#002c47', '#b8c900', '#f92d00', '#c4002d'), 'rtcolor' => array('#333333', '#333333', '#333333', '#333333'), 'rthover' => array('#333333', '#333333', '#333333', '#333333'), 'rbcolor' => array('#f9ea00', '#f9ea00', '#f9ea00', '#f9ea00'), 'ftborder' => array('#bbbbbb', '#bbbbbb', '#bbbbbb', '#bbbbbb') );
	} elseif($template == 'temp39') {
		$package_options = array( 'templ' => 'temp39', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#1085BF', 'ptnbg' => '#dddddd', 'ctcolor' => '#212121', 'cftcolor' => '#ffffff', 'furlclr' => '#ffffff', 'furlhvr' => '#212121', 'ccolbg' => '#dddddd', 'prnbg' => '', 'capbg1' => '#FD5C63', 'capbg2' => '#FD5C63', 'ccborder' => '#dddddd', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#C73A40', '#1085BF', '#609835', '#E8C615'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#C73A40', '#1085BF', '#609835', '#E8C615'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#212121', '#212121', '#212121', '#212121'), 'pbcolor' => array('#C73A40', '#1085BF', '#609835', '#E8C615'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#212121', '#212121', '#212121', '#212121'), 'ftcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow1' => array('#FD5C63', '#0099E5', '#7AC143', '#F9D930'), 'fbrow2' => array('#FD5C63', '#0099E5', '#7AC143', '#F9D930'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#212121', '#212121', '#212121', '#212121'), 'bcolor' => array('#C73A40', '#1085BF', '#609835', '#E8C615'), 'bhover' => array('#FD5C63', '#0099E5', '#7AC143', '#F9D930'), 'bbcolor' => array('#212121', '#212121', '#212121', '#212121'), 'rtcolor' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rthover' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rbcolor' => array('#ffc100', '#ffc100', '#ffc100', '#ffc100'), 'ftborder' => array('#C73A40', '#1085BF', '#609835', '#E8C615') );
	} elseif($template == 'temp40') {
		$package_options = array( 'templ' => 'temp40', 'tttext' => '#333333', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#bdc3c7', 'ptabg' => '#34495e', 'ptnbg' => '#ffffff', 'ctcolor' => '#34495e', 'cftcolor' => '#bdc3c7', 'furlclr' => '#aaaaaa', 'furlhvr' => '#bdc3c7', 'ccolbg' => '#dddddd', 'prnbg' => '', 'capbg1' => '#F5F5F5', 'capbg2' => '#DFDFDF', 'ccborder' => '#bbbbbb', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#34495e', '#34495e', '#34495e', '#34495e'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#34495e', '#34495e', '#34495e', '#34495e'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#bdc3c7', '#bdc3c7', '#bdc3c7', '#bdc3c7'), 'pbcolor' => array('#34495e', '#34495e', '#34495e', '#34495e'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#bdc3c7', '#bdc3c7', '#bdc3c7', '#bdc3c7'), 'ftcolor' => array('#bdc3c7', '#bdc3c7', '#bdc3c7', '#bdc3c7'), 'fbrow1' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow2' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'btcolor' => array('#34495e', '#34495e', '#34495e', '#34495e'), 'bthover' => array('#bdc3c7', '#bdc3c7', '#bdc3c7', '#bdc3c7'), 'bcolor' => array('#bdc3c7', '#bdc3c7', '#bdc3c7', '#bdc3c7'), 'bhover' => array('#34495e', '#34495e', '#34495e', '#34495e'), 'bbcolor' => array('#34495e', '#34495e', '#34495e', '#34495e'), 'rtcolor' => array('#34495e', '#34495e', '#34495e', '#34495e'), 'rthover' => array('#34495e', '#34495e', '#34495e', '#34495e'), 'rbcolor' => array('#bdc3c7', '#bdc3c7', '#bdc3c7', '#bdc3c7'), 'ftborder' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd') );
	} elseif($template == 'temp41') {
		$package_options = array( 'templ' => 'temp41', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ctcolor' => '#333333', 'cftcolor' => '#666666', 'furlclr' => '#0199BC', 'furlhvr' => '#000000', 'ccolbg' => '#dddddd', 'prnbg' => '', 'capbg1' => '#F5F5F5', 'capbg2' => '#F5F5F5', 'ccborder' => '#dddddd', 'cscolor' => '#ffffff', 'cshcolor' => '#000000' );
		$package_details = array( 'pbclr' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'tcolor' => array('#faf8eb', '#faf8eb', '#faf8eb', '#faf8eb'), 'thover' => array('#faf8eb', '#faf8eb', '#faf8eb', '#faf8eb'), 'tbcolor' => array('#222222', '#222222', '#222222', '#222222'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#949494', '#949494', '#949494', '#949494'), 'pbcolor' => array('#222222', '#222222', '#222222', '#222222'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#666666', '#666666', '#666666', '#666666'), 'ftcolor' => array('#666666', '#666666', '#666666', '#666666'), 'fbrow1' => array('#f5f5f5', '#f5f5f5', '#f5f5f5', '#f5f5f5'), 'fbrow2' => array('#f5f5f5', '#f5f5f5', '#f5f5f5', '#f5f5f5'), 'btcolor' => array('#222222', '#222222', '#222222', '#222222'), 'bthover' => array('#222222', '#222222', '#222222', '#222222'), 'bcolor' => array('#d36d42', '#e7c035', '#68c495', '#d8993c'), 'bhover' => array('#d36d42', '#e7c035', '#68c495', '#d8993c'), 'bbcolor' => array('#f5f5f5', '#f5f5f5', '#f5f5f5', '#f5f5f5'), 'rtcolor' => array('#323232', '#323232', '#323232', '#323232'), 'rthover' => array('#323232', '#323232', '#323232', '#323232'), 'rbcolor' => array('#f5f5f5', '#fcc76a', '#f5f5f5', '#95f1c2'), 'ftborder' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd') );
	} elseif($template == 'temp42') {
		$package_options = array( 'templ' => 'temp42', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#27589f', 'ctcolor' => '#333333', 'cftcolor' => '#3069e8', 'furlclr' => '#3069e8', 'furlhvr' => '#3069e8', 'ccolbg' => '#3069e8', 'prnbg' => '', 'capbg1' => '#3069e8', 'capbg2' => '#3069e8', 'ccborder' => '#27589f', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#3069e8', '#3069e8', '#3069e8', '#3069e8'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#3069e8', '#3069e8', '#3069e8', '#3069e8'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#2D62AF', '#2D62AF', '#2D62AF', '#2D62AF'), 'pbcolor' => array('#3069e8', '#3069e8', '#3069e8', '#3069e8'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#275bb3', '#275bb3', '#275bb3', '#275bb3'), 'fncolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'ftcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow1' => array('#3069e8', '#3069e8', '#3069e8', '#3069e8'), 'fbrow2' => array('#3069e8', '#3069e8', '#3069e8', '#3069e8'), 'btcolor' => array('#27589F', '#27589F', '#27589F', '#27589F'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#f1f1f1', '#f1f1f1', '#f1f1f1', '#f1f1f1'), 'bhover' => array('#27589f', '#27589f', '#27589f', '#27589f'), 'bbcolor' => array('#3069e8', '#3069e8', '#3069e8', '#3069e8'), 'rtcolor' => array('#000000', '#000000', '#000000', '#000000'), 'rthover' => array('#000000', '#000000', '#000000', '#000000'), 'rbcolor' => array('#ffc100', '#ffc100', '#ffc100', '#ffc100'), 'ftborder' => array('#27589f', '#27589f', '#27589f', '#27589f') );
	} elseif($template == 'temp43') {
		$package_options = array( 'templ' => 'temp43', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ctcolor' => '#3E7DE8', 'cftcolor' => '#000000', 'furlclr' => '#ffffff', 'furlhvr' => '#000000', 'ccolbg' => '#dddddd', 'prnbg' => '', 'capbg1' => '#3e7de8', 'capbg2' => '#3e7de8', 'ccborder' => '#bbbbbb', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'tcolor' => array('#000000', '#000000', '#ffffff', '#000000'), 'thover' => array('#000000', '#000000', '#ffffff', '#000000'), 'tbcolor' => array('#ffffff', '#ffffff', '#3e7de8', '#ffffff'), 'pcbig' => array('#3e7de8', '#3e7de8', '#ffffff', '#3e7de8'), 'phbig' =>array('#3e7de8', '#3e7de8', '#ffffff', '#3e7de8'), 'pcsmall' => array('#3e7de8', '#3e7de8', '#ffffff', '#3e7de8'), 'phsmall' => array('#3e7de8', '#3e7de8', '#ffffff', '#3e7de8'), 'cutclr' => array('#000000', '#000000', '#ffffff', '#000000'), 'pbcolor' => array('#ffffff', '#ffffff', '#3e7de8', '#ffffff'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#868686', '#868686', '#fafafa', '#868686'), 'ftcolor' => array('#868686', '#868686', '#fafafa', '#868686'), 'fbrow1' => array('#ffffff', '#ffffff', '#3e7de8', '#ffffff'), 'fbrow2' => array('#ffffff', '#ffffff', '#3e7de8', '#ffffff'), 'btcolor' => array('#ffffff', '#ffffff', '#000000', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#3e7de8', '#3e7de8', '#f2f2f2', '#3e7de8'), 'bhover' => array('#606060', '#606060', '#606060', '#606060'), 'bbcolor' => array('#ffffff', '#ffffff', '#3e7de8', '#ffffff'), 'rtcolor' => array('#ffffff', '#ffffff', '#000000', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#000000', '#ffffff'), 'rbcolor' => array('#3e7de8', '#3e7de8', '#ffffff', '#3e7de8'), 'ftborder' => array('#bbbbbb', '#bbbbbb', '#bbbbbb', '#bbbbbb') );
	} elseif($template == 'temp44') {
		$package_options = array( 'templ' => 'temp44', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#47A212', 'ptnbg' => '#292c3c', 'ctcolor' => '#292c3c', 'cftcolor' => '#292c3c', 'furlclr' => '#47A212', 'furlhvr' => '#ffffff', 'ccolbg' => '#47A212', 'prnbg' => '', 'capbg1' => '#292c3c', 'capbg2' => '#292c3c', 'ccborder' => '#292c3c', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#47A212', '#47A212', '#292c3c', '#47A212'), 'tcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'thover' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'tbcolor' => array('#292c3c', '#292c3c', '#47A212', '#292c3c'), 'pcbig' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phbig' =>array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'pcsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'cutclr' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'pbcolor' => array('#292c3c', '#292c3c', '#47A212', '#292c3c'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'ftcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'fbrow1' => array('#292c3c', '#292c3c', '#47A212', '#292c3c'), 'fbrow2' => array('#292c3c', '#292c3c', '#47A212', '#292c3c'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#47A212', '#47A212', '#292c3c', '#47A212'), 'bhover' => array('#292c3c', '#292c3c', '#47A212', '#292c3c'), 'bbcolor' => array('#292c3c', '#292c3c', '#47A212', '#292c3c'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#47A212', '#47A212', '#292c3c', '#47A212'), 'ftborder' => array('#292c3c', '#292c3c', '#47A212', '#292c3c') );
	} elseif($template == 'temp45') {
		$package_options = array( 'templ' => 'temp45', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ctcolor' => '#4B55E4', 'cftcolor' => '#ffffff', 'furlclr' => '#ff5f85', 'furlhvr' => '#ffffff', 'ccolbg' => '#2d36af', 'prnbg' => '', 'capbg1' => '#2d36af', 'capbg2' => '#2d36af', 'ccborder' => '#2d36af', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#4b55e4', '#4b55e4', '#4b55e4', '#4b55e4'), 'tcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'thover' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'tbcolor' => array('#4b55e4', '#4b55e4', '#4b55e4', '#4b55e4'), 'pcbig' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phbig' =>array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'pcsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'cutclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'pbcolor' => array('#4b55e4', '#4b55e4', '#4b55e4', '#4b55e4'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'ftcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'fbrow1' => array('#4b55e4', '#4b55e4', '#4b55e4', '#4b55e4'), 'fbrow2' => array('#4b55e4', '#4b55e4', '#4b55e4', '#4b55e4'), 'btcolor' => array('#FFFFFF', '#4b55e4', '#FFFFFF', '#4b55e4'), 'bthover' => array('#4b55e4', '#FFFFFF', '#4b55e4', '#FFFFFF'), 'bcolor' => array('#4b55e4', '#f1f1f1', '#4b55e4', '#f1f1f1'), 'bhover' => array('#f1f1f1', '#4b55e4', '#f1f1f1', '#4b55e4'), 'bbcolor' => array('#ff5f85', '#ff5f85', '#ff5f85', '#ff5f85'), 'rtcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'rthover' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'rbcolor' => array('#ff5f85', '#ff5f85', '#ff5f85', '#ff5f85'), 'ftborder' => array('#4b55e4', '#4b55e4', '#4b55e4', '#4b55e4') );
	} elseif($template == 'temp46') {
		$package_options = array( 'templ' => 'temp46', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#40314E', 'ptnbg' => '#F2EDED', 'ctcolor' => '#40314E', 'cftcolor' => '#483754', 'furlclr' => '#9F7893', 'furlhvr' => '#483754', 'ccolbg' => '#F2EDED', 'prnbg' => '', 'capbg1' => '#F2EDED', 'capbg2' => '#F2EDED', 'ccborder' => '#dddddd', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#41324F', '#41324F', '#40314E', '#41324F'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#41324F', '#41324F', '#40314E', '#41324F'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'pbcolor' => array('#41324F', '#41324F', '#40314E', '#41324F'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#2c2235', '#2c2235', '#2c2235', '#2c2235'), 'fncolor' => array('#ffffff', '#ffffff', '#483754', '#ffffff'), 'ftcolor' => array('#ffffff', '#ffffff', '#483754', '#ffffff'), 'fbrow1' => array('#544562', '#544562', '#F2EDED', '#544562'), 'fbrow2' => array('#5F506D', '#5F506D', '#F5F5F5', '#5F506D'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#6A5370', '#6A5370', '#6A5370', '#6A5370'), 'bhover' => array('#55425F', '#55425F', '#55425F', '#55425F'), 'bbcolor' => array('#9F7893', '#9F7893', '#9F7893', '#9F7893'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#FD4326', '#FD4326', '#FD4326', '#FD4326'), 'ftborder' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd') );
	} elseif($template == 'temp47') {
		$package_options = array( 'templ' => 'temp47', 'tttext' => '#000000', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#fffff0', 'ctcolor' => '#333333', 'cftcolor' => '#dbdbdb', 'furlclr' => '#0199BC', 'furlhvr' => '#000000', 'ccolbg' => '#000000', 'prnbg' => '', 'capbg1' => '#000000', 'capbg2' => '#131313', 'ccborder' => '#000000', 'cscolor' => '#333333', 'cshcolor' => '#000000' );
		$package_details = array( 'pbclr' => array('#000000', '#000000', '#000000', '#000000'), 'tcolor' => array('#000000', '#000000', '#000000', '#000000'), 'thover' => array('#000000', '#000000', '#000000', '#000000'), 'tbcolor' => array('#00c0e4', '#5bd999', '#eac14d', '#e13131'), 'pcbig' => array('#00c0e4', '#5bd999', '#eac14d', '#e13131'), 'phbig' =>array('#00c0e4', '#5bd999', '#eac14d', '#e13131'), 'pcsmall' => array('#00c0e4', '#5bd999', '#eac14d', '#e13131'), 'phsmall' => array('#00c0e4', '#5bd999', '#eac14d', '#e13131'), 'cutclr' => array('#808080', '#808080', '#808080', '#808080'), 'pbcolor' => array('#131313', '#131313', '#131313', '#131313'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#00c0e4', '#5bd999', '#eac14d', '#e13131'), 'ftcolor' => array('#00c0e4', '#5bd999', '#eac14d', '#e13131'), 'fbrow1' => array('#000000', '#000000', '#000000', '#000000'), 'fbrow2' => array('#131313', '#131313', '#131313', '#131313'), 'btcolor' => array('#000000', '#000000', '#000000', '#000000'), 'bthover' => array('#000000', '#000000', '#000000', '#000000'), 'bcolor' => array('#00c0e4', '#5bd999', '#eac14d', '#e13131'), 'bhover' => array('#00c0e4', '#5bd999', '#eac14d', '#e13131'), 'bbcolor' => array('#000000', '#000000', '#000000', '#000000'), 'rtcolor' => array('#333333', '#333333', '#333333', '#333333'), 'rthover' => array('#333333', '#333333', '#333333', '#333333'), 'rbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'ftborder' => array('#000000', '#000000', '#000000', '#000000') );
	} elseif($template == 'temp48') {
		$package_options = array( 'templ' => 'temp48', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#00A8E8', 'ptnbg' => '#f5f5f5', 'ctcolor' => '#929292', 'cftcolor' => '#ACACAC', 'furlclr' => '#00A8E8', 'furlhvr' => '#ACACAC', 'ccolbg' => '#F3F3F3', 'prnbg' => '', 'capbg1' => '#F3F3F3', 'capbg2' => '#F3F3F3', 'ccborder' => '#F3F3F3', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#242426', '#242426', '#242426', '#242426'), 'tcolor' => array('#929292', '#929292', '#929292', '#929292'), 'thover' => array('#929292', '#929292', '#929292', '#929292'), 'tbcolor' => array('#242426', '#242426', '#242426', '#242426'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#FFFAF1', '#EDF7FE', '#FBFEFB', '#FDF9EB'), 'pbcolor' => array('#FF28C4', '#0090ED', '#FF9780', '#EDBC00'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'ftcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow1' => array('#FF28C4', '#0090ED', '#FF9780', '#EDBC00'), 'fbrow2' => array('#FF28C4', '#0090ED', '#FF9780', '#EDBC00'), 'btcolor' => array('#FF0ACB', '#187EED', '#FF8678', '#EDBC00'), 'bthover' => array('#FF9FE5', '#75ADF7', '#FFCFC5', '#E6CE71'), 'bcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bhover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bbcolor' => array('#FF28C4', '#0090ED', '#FF9780', '#EDBC00'), 'rtcolor' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rthover' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rbcolor' => array('#ffc100', '#ffc100', '#ffc100', '#ffc100'), 'ftborder' => array('#FF28C4', '#0090ED', '#FF9780', '#fb2201') );
	} elseif($template == 'temp49') {
		$package_options = array( 'templ' => 'temp49', 'tttext' => '#FFFFFF', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#bf5507', 'ctcolor' => '#333333', 'cftcolor' => '#5c331d', 'furlclr' => '#8e5124', 'furlhvr' => '#5c331d', 'ccolbg' => '#bb6e36', 'prnbg' => '', 'capbg1' => '#c3ac69', 'capbg2' => '#c3ac69', 'ccborder' => '#9a8854', 'cscolor' => '#ffffff', 'cshcolor' => '#000000' );
		$package_details = array( 'pbclr' => array('#bb6e36', '#bb6e36', '#bb6e36', '#bb6e36'), 'tcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'thover' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'tbcolor' => array('#bb6e36', '#bb6e36', '#bb6e36', '#bb6e36'), 'pcbig' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phbig' =>array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'pcsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'cutclr' => array('#bb6e36', '#bb6e36', '#bb6e36', '#bb6e36'), 'pbcolor' => array('#5c331d', '#5c331d', '#5c331d', '#5c331d'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#5c331d', '#5c331d', '#5c331d', '#5c331d'), 'ftcolor' => array('#5c331d', '#5c331d', '#5c331d', '#5c331d'), 'fbrow1' => array('#c3ac69', '#c3ac69', '#c3ac69', '#c3ac69'), 'fbrow2' => array('#c3ac69', '#c3ac69', '#c3ac69', '#c3ac69'), 'btcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'bthover' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'bcolor' => array('#bb6e36', '#bb6e36', '#bb6e36', '#bb6e36'), 'bhover' => array('#5c331d', '#5c331d', '#5c331d', '#5c331d'), 'bbcolor' => array('#c3ac69', '#c3ac69', '#c3ac69', '#c3ac69'), 'rtcolor' => array('#5c331d', '#5c331d', '#5c331d', '#5c331d'), 'rthover' => array('#5c331d', '#5c331d', '#5c331d', '#5c331d'), 'rbcolor' => array('#f7db53', '#f7db53', '#f7db53', '#f7db53'), 'ftborder' => array('#9a8854', '#9a8854', '#9a8854', '#9a8854') );
	} elseif($template == 'temp50') {
		$package_options = array( 'templ' => 'temp50', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#ffdd65', 'ptnbg' => '#1f1800', 'ctcolor' => '#1f1800', 'cftcolor' => '#ffdd65', 'furlclr' => '#fdd23a', 'furlhvr' => '#ffdd65', 'ccolbg' => '#1f1800', 'prnbg' => '', 'capbg1' => '#1f1800', 'capbg2' => '#1f1800', 'ccborder' => '#1f1800', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#ffdd65', '#ffdd65', '#1f1800', '#ffdd65'), 'tcolor' => array('#1f1800', '#1f1800', '#ffdd65', '#1f1800'), 'thover' => array('#1f1800', '#1f1800', '#ffdd65', '#1f1800'), 'tbcolor' => array('#ffdd65', '#ffdd65', '#1f1800', '#ffdd65'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#1f1800', '#1f1800', '#ffdd65', '#1f1800'), 'pbcolor' => array('#ffdd65', '#ffdd65', '#1f1800', '#ffdd65'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#1f1800', '#1f1800', '#ffdd65', '#1f1800'), 'ftcolor' => array('#1f1800', '#1f1800', '#ffdd65', '#1f1800'), 'fbrow1' => array('#ffdd65', '#ffdd65', '#1f1800', '#ffdd65'), 'fbrow2' => array('#ffdd65', '#ffdd65', '#1f1800', '#ffdd65'), 'btcolor' => array('#1f1800', '#1f1800', '#ffdd65', '#1f1800'), 'bthover' => array('#ffdd65', '#ffdd65', '#1f1800', '#ffdd65'), 'bcolor' => array('#ffdd65', '#ffdd65', '#1f1800', '#ffdd65'), 'bhover' => array('#1f1800', '#1f1800', '#ffdd65', '#1f1800'), 'bbcolor' => array('#ffdd65', '#ffdd65', '#1f1800', '#ffdd65'), 'rtcolor' => array('#ffdd65', '#ffdd65', '#1f1800', '#ffdd65'), 'rthover' => array('#ffdd65', '#ffdd65', '#1f1800', '#ffdd65'), 'rbcolor' => array('#1f1800', '#1f1800', '#ffdd65', '#1f1800'), 'ftborder' => array('#ffdd65', '#ffdd65', '#1f1800', '#ffdd65') );
	} elseif($template == 'temp51') {
		$package_options = array( 'templ' => 'temp51', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#FFB052', 'ptnbg' => '#292c3c', 'ctcolor' => '#292c3c', 'cftcolor' => '#292c3c', 'furlclr' => '#FFB052', 'furlhvr' => '#ffffff', 'ccolbg' => '#FFB052', 'prnbg' => '', 'capbg1' => '#292c3c', 'capbg2' => '#292c3c', 'ccborder' => '#292c3c', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#FFB052', '#FFB052', '#292c3c', '#FFB052'), 'tcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'thover' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'tbcolor' => array('#292c3c', '#292c3c', '#FFB052', '#292c3c'), 'pcbig' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phbig' =>array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'pcsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'phsmall' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'cutclr' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'pbcolor' => array('#292c3c', '#292c3c', '#FFB052', '#292c3c'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'ftcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'fbrow1' => array('#292c3c', '#292c3c', '#FFB052', '#292c3c'), 'fbrow2' => array('#292c3c', '#292c3c', '#FFB052', '#292c3c'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#FFB052', '#FFB052', '#292c3c', '#FFB052'), 'bhover' => array('#292c3c', '#292c3c', '#FFB052', '#292c3c'), 'bbcolor' => array('#292c3c', '#292c3c', '#FFB052', '#292c3c'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#FFB052', '#FFB052', '#292c3c', '#FFB052'), 'ftborder' => array('#1b1d2b', '#1b1d2b', '#efb14c', '#1b1d2b') );
	} elseif($template == 'temp52') {
		$package_options = array( 'templ' => 'temp52', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ctcolor' => '#333333', 'cftcolor' => '#828282', 'furlclr' => '#000000', 'furlhvr' => '#828282', 'ccolbg' => '#f1f1f1', 'prnbg' => '', 'capbg1' => '#ffffff', 'capbg2' => '#ffffff', 'ccborder' => '#f1f1f1', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#f1f1f1', '#f1f1f1', '#f1f1f1', '#f1f1f1'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#cb3bc1', '#9bcf7f', '#fc8e45', '#45aefc'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#f1f1f1', '#f1f1f1', '#f1f1f1', '#f1f1f1'), 'pbcolor' => array('#cb3bc1', '#9bcf7f', '#fc8e45', '#45aefc'), 'pcircle' => array('#CE64B0', '#9CD565', '#FCA558', '#91BDFC'), 'imgclr' => array('#f1f1f1', '#f1f1f1', '#f1f1f1', '#f1f1f1'), 'fncolor' => array('#828282', '#828282', '#828282', '#828282'), 'ftcolor' => array('#828282', '#828282', '#828282', '#828282'), 'fbrow1' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow2' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#cb3bc1', '#9bcf7f', '#fc8e45', '#45aefc'), 'bhover' => array('#CE64B0', '#9CD565', '#FCA558', '#91BDFC'), 'bbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#EF476F', '#EF476F', '#EF476F', '#EF476F'), 'ftborder' => array('#f1f1f1', '#f1f1f1', '#f1f1f1', '#f1f1f1') );
	} elseif($template == 'temp53') {
		$package_options = array( 'templ' => 'temp53', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#34495E', 'ptnbg' => '#dddddd', 'ctcolor' => '#222F3D', 'cftcolor' => '#222F3D', 'furlclr' => '#222F3D', 'furlhvr' => '#34495E', 'ccolbg' => '#d2d7e2', 'prnbg' => '', 'capbg1' => '#ffffff', 'capbg2' => '#EBEBEB', 'ccborder' => '#d2d7e2', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#dadada', '#dadada', '#dadada', '#dadada'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#222F3D', '#222F3D', '#222F3D', '#222F3D'), 'pcbig' => array('#34495E', '#34495E', '#ffffff', '#34495E'), 'phbig' =>array('#34495E', '#34495E', '#ffffff', '#34495E'), 'pcsmall' => array('#34495E', '#34495E', '#ffffff', '#34495E'), 'phsmall' => array('#34495E', '#34495E', '#ffffff', '#34495E'), 'cutclr' => array('#8e9eaf', '#8e9eaf', '#8e9eaf', '#8e9eaf'), 'pbcolor' => array('#ffffff', '#ffffff', '#34495E', '#ffffff'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#222F3D', '#222F3D', '#ffffff', '#222F3D'), 'ftcolor' => array('#222F3D', '#222F3D', '#ffffff', '#222F3D'), 'fbrow1' => array('#ffffff', '#ffffff', '#34495E', '#ffffff'), 'fbrow2' => array('#EBEBEB', '#EBEBEB', '#304357', '#EBEBEB'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#46627F', '#46627F', '#46627F', '#46627F'), 'bhover' => array('#222F3D', '#222F3D', '#222F3D', '#222F3D'), 'bbcolor' => array('#222F3D', '#222F3D', '#222F3D', '#222F3D'), 'rtcolor' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rthover' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rbcolor' => array('#ffc100', '#ffc100', '#ffc100', '#ffc100'), 'ftborder' => array('#d2d7e2', '#d2d7e2', '#222F3D', '#d2d7e2') );
	} elseif($template == 'temp54') {
		$package_options = array( 'templ' => 'temp54', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#FF9700', 'ptnbg' => '#FFEED6', 'ctcolor' => '#364B59', 'cftcolor' => '#ffffff', 'furlclr' => '#E2520D', 'furlhvr' => '#ffffff', 'ccolbg' => '#364B59', 'prnbg' => '', 'capbg1' => '#2D3D49', 'capbg2' => '#2D3D49', 'ccborder' => '#2D3D49', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#233039', '#233039', '#FF9700', '#233039'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#233039', '#233039', '#FF9700', '#233039'), 'pcbig' => array('#ffffff', '#ffffff', '#FF9700', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#FF9700', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#FF9700', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#FF9700', '#ffffff'), 'cutclr' => array('#f5f5f5', '#f5f5f5', '#ffb344', '#f5f5f5'), 'pbcolor' => array('#2d3d49', '#2d3d49', '#FFEED6', '#2d3d49'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#ffffff', '#ffffff', '#787878', '#ffffff'), 'ftcolor' => array('#ffffff', '#ffffff', '#787878', '#ffffff'), 'fbrow1' => array('#2d3d49', '#2d3d49', '#FFEED6', '#2d3d49'), 'fbrow2' => array('#2d3d49', '#2d3d49', '#FFEED6', '#2d3d49'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#f26521', '#f26521', '#f26521', '#f26521'), 'bhover' => array('#E2520D', '#E2520D', '#E2520D', '#E2520D'), 'bbcolor' => array('#233039', '#233039', '#FF9700', '#233039'), 'rtcolor' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rthover' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rbcolor' => array('#ffc100', '#ffc100', '#ffc100', '#ffc100'), 'ftborder' => array('#233039', '#233039', '#FF9700', '#233039') );
	} elseif($template == 'temp55') {
		$package_options = array( 'templ' => 'temp55', 'etclr' => 'no', 'tbpad' => '0', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tcleft' => 'yes', 'tttext' => '#ffffff', 'prnbg' => '', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'pbrad' => '0', 'cbrad' => '0', 'tsize' => '42px' );
		$package_details = array( 'pbclr' => array('#ef6773', '#7486f9', '#c1ad2d', '#9d1fc7'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#ef6773', '#7486f9', '#c1ad2d', '#9d1fc7'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#f5f5f5', '#f5f5f5', '#ffb344', '#f5f5f5'), 'pbcolor' => array('#ef6773', '#7486f9', '#c1ad2d', '#9d1fc7'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#ef6773', '#7486f9', '#c1ad2d', '#9d1fc7'), 'fncolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'ftcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow1' => array('#ef6773', '#7486f9', '#c1ad2d', '#9d1fc7'), 'fbrow2' => array('#ef6773', '#7486f9', '#c1ad2d', '#9d1fc7'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#ea5a6c', '#5b56f7', '#5a500c', '#610fbe'), 'bhover' => array('#ef6773', '#7486f9', '#c1ad2d', '#9d1fc7'), 'bbcolor' => array('#ef6773', '#7486f9', '#c1ad2d', '#9d1fc7'), 'rtcolor' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rthover' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rbcolor' => array('#ffc100', '#ffc100', '#ffc100', '#ffc100'), 'ftborder' => array('#ef6773', '#7486f9', '#c1ad2d', '#9d1fc7') );
	} elseif($template == 'temp56') {
		$package_options = array( 'templ' => 'temp56', 'etclr' => 'yes', 'tbpad' => '5', 'ftdir' => 'center', 'ftpad' => '0', 'cftdir' => 'left', 'tcleft' => 'yes', 'tttext' => '#ffffff', 'prnbg' => '', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'ttgrd' => 'yes', 'prgrd' => 'yes', 'dsgrd' => 'yes', 'pbrad' => '0', 'cbrad' => '0', 'enimg' => 'yes', 'opimg' => 'opt-4', 'pbody' => '350px', 'enicon' => 'no', 'ftbody' => '156px' );
		$package_details = array( 'pbclr' => array('#007bfc', '#ffa900', '#522172', '#bb1b4b'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#f5f5f5', '#f5f5f5', '#ffb344', '#f5f5f5'), 'pbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fncolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'ftcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow1' => array('#007bfc', '#ffa900', '#522172', '#bb1b4b'), 'fbrow2' => array('#007bfc', '#ffa900', '#522172', '#bb1b4b'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#007bfc', '#ffa900', '#522172', '#bb1b4b'), 'bhover' => array('#50a2fb', '#fcce73', '#8535b9', '#e4527e'), 'bbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rtcolor' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rthover' => array('#ff0000', '#ff0000', '#ff0000', '#ff0000'), 'rbcolor' => array('#ffc100', '#ffc100', '#ffc100', '#ffc100'), 'ftborder' => array('#007bfc', '#ffa900', '#522172', '#bb1b4b') );
		$package_options = array_merge($package_options_check, $package_options_color);
		$package_details = array_merge($package_details_texts, $package_details_color);
	} elseif($template == 'temp57') {
		$package_options = array( 'templ' => 'temp57', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ctcolor' => '#333333', 'cftcolor' => '#828282', 'furlclr' => '#000000', 'furlhvr' => '#828282', 'ccolbg' => '#f1f1f1', 'prnbg' => '', 'capbg1' => '#ffffff', 'capbg2' => '#ffffff', 'ccborder' => '#f1f1f1', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#f1f1f1', '#f1f1f1', '#f1f1f1', '#f1f1f1'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#FFB30F', '#7FC9F8', '#FF98A4', '#FFA562'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#f1f1f1', '#f1f1f1', '#f1f1f1', '#f1f1f1'), 'pbcolor' => array('#FFB30F', '#7FC9F8', '#FF98A4', '#FFA562'), 'pcircle' => array('#CE64B0', '#9CD565', '#FCA558', '#91BDFC'), 'imgclr' => array('#f1f1f1', '#f1f1f1', '#f1f1f1', '#f1f1f1'), 'fncolor' => array('#828282', '#828282', '#828282', '#828282'), 'ftcolor' => array('#828282', '#828282', '#828282', '#828282'), 'fbrow1' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow2' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#FFB30F', '#7FC9F8', '#FF98A4', '#FFA562'), 'bhover' => array('#CE64B0', '#9CD565', '#FCA558', '#91BDFC'), 'bbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#EF476F', '#EF476F', '#EF476F', '#EF476F'), 'ftborder' => array('#f1f1f1', '#f1f1f1', '#f1f1f1', '#f1f1f1') );
	} elseif($template == 'temp58') {
		$package_options = array( 'templ' => 'temp58', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ctcolor' => '#333333', 'cftcolor' => '#828282', 'furlclr' => '#000000', 'furlhvr' => '#828282', 'ccolbg' => '#f1f1f1', 'prnbg' => '', 'capbg1' => '#ffffff', 'capbg2' => '#ffffff', 'ccborder' => '#f1f1f1', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#f1f1f1', '#f1f1f1', '#f1f1f1', '#f1f1f1'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#4A1F56', '#2D4009', '#213458', '#5B2424'), 'pcbig' => array('#000000', '#000000', '#000000', '#000000'), 'phbig' =>array('#000000', '#000000', '#000000', '#000000'), 'pcsmall' => array('#000000', '#000000', '#000000', '#000000'), 'phsmall' => array('#000000', '#000000', '#000000', '#000000'), 'cutclr' => array('#f1f1f1', '#f1f1f1', '#f1f1f1', '#f1f1f1'), 'pbcolor' => array('#4A1F56', '#2D4009', '#213458', '#5B2424'), 'pcircle' => array('#CE64B0', '#9CD565', '#FCA558', '#91BDFC'), 'imgclr' => array('#f1f1f1', '#f1f1f1', '#f1f1f1', '#f1f1f1'), 'fncolor' => array('#828282', '#828282', '#828282', '#828282'), 'ftcolor' => array('#828282', '#828282', '#828282', '#828282'), 'fbrow1' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow2' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#D9D7D5', '#D9D7D5', '#D9D7D5', '#D9D7D5'), 'bhover' => array('#301B49', '#203002', '#182846', '#491818'), 'bbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#EF476F', '#EF476F', '#EF476F', '#EF476F'), 'ftborder' => array('#f1f1f1', '#f1f1f1', '#f1f1f1', '#f1f1f1') );
	} elseif($template == 'temp59') {
		$package_options = array( 'templ' => 'temp59', 'tttext' => '#ffffff', 'fatclr' => '#26ca2d', 'facclr' => '#d82828', 'ttbg' => '#333333', 'ptabg' => '#AA2626', 'ptnbg' => '#dddddd', 'ctcolor' => '#AA2626', 'cftcolor' => '#787878', 'furlclr' => '#787878', 'furlhvr' => '#212121', 'ccolbg' => '#F5F5F5', 'prnbg' => '', 'capbg1' => '#F5F5F5', 'capbg2' => '#F5F5F5', 'ccborder' => '#bbbbbb', 'cscolor' => '#cccccc', 'cshcolor' => '#333333', 'tbody' => '84px', 'tsize' => '36px' );
		$package_details = array( 'pbclr' => array('#f36236', '#2f284f', '#1a9a8c', '#e71d36'), 'tcolor' => array('#702b15', '#bdb1f7', '#083c37', '#760f1c'), 'thover' => array('#702b15', '#bdb1f7', '#083c37', '#760f1c'), 'tbcolor' => array('#f36236', '#2f284f', '#1a9a8c', '#e71d36'), 'pcbig' => array('#702b15', '#bdb1f7', '#083c37', '#760f1c'), 'phbig' =>array('#702b15', '#bdb1f7', '#083c37', '#760f1c'), 'pcsmall' => array('#702b15', '#bdb1f7', '#083c37', '#760f1c'), 'phsmall' => array('#702b15', '#bdb1f7', '#083c37', '#760f1c'), 'cutclr' => array('#9d9d9d', '#9d9d9d', '#9d9d9d', '#9d9d9d'), 'pbcolor' => array('#f36236', '#2f284f', '#1a9a8c', '#e71d36'), 'pcircle' => array('#f47f5c', '#443a73', '#19ad9b', '#e9485b'), 'imgclr' => array('#f36236', '#2f284f', '#1a9a8c', '#e71d36'), 'fncolor' => array('#702b15', '#bdb1f7', '#083c37', '#760f1c'), 'ftcolor' => array('#702b15', '#bdb1f7', '#083c37', '#760f1c'), 'fbrow1' => array('#f36236', '#2f284f', '#1a9a8c', '#e71d36'), 'fbrow2' => array('#f36236', '#2f284f', '#1a9a8c', '#e71d36'), 'btcolor' => array('#f36236', '#2f284f', '#1a9a8c', '#e71d36'), 'bthover' => array('#ffffff', '#2f284f', '#ffffff', '#ffffff'), 'bcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bhover' => array('#702b15', '#bdb1f7', '#083c37', '#760f1c'), 'bbcolor' => array('#f36236', '#2f284f', '#1a9a8c', '#e71d36'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#E7D54C', '#E7D54C', '#E7D54C', '#E7D54C'), 'ftborder' => array('#f36236', '#2f284f', '#1a9a8c', '#e71d36') );
	} elseif($template == 'temp60') {
		$package_options = array( 'templ' => 'temp60', 'fatclr' => '#ffffff', 'facclr' => '#333333', 'cscolor' => '#22313f', 'cshcolor' => '#0c0c0c' );
		$package_details = array( 'pbclr' => array('#54AB3E', '#b316ed', '#ed1592', '#1581ed'), 'tbcolor' => array('#54AB3E', '#b316ed', '#ed1592', '#1581ed'), 'pbcolor' => array('#54AB3E', '#b316ed', '#ed1592', '#1581ed'), 'pcircle' => array('#54AB3E', '#b316ed', '#ed1592', '#1581ed'), 'imgclr' => array('#54AB3E', '#b316ed', '#ed1592', '#1581ed'), 'fbrow1' => array('#54AB3E', '#b316ed', '#ed1592', '#1581ed'), 'fbrow2' => array('#54AB3E', '#b316ed', '#ed1592', '#1581ed'), 'bbcolor' => array('#54AB3E', '#b316ed', '#ed1592', '#1581ed'), 'rbcolor' => array('#356c27', '#830eae', '#be1276', '#105eac'), 'ftborder' => array('#4b9b37', '#a513d8', '#d51182', '#1274d7'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#c8d6e5', '#c8d6e5', '#c8d6e5', '#c8d6e5'), 'fncolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'ftcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'btcolor' => array('#54AB3E', '#b316ed', '#ed1592', '#1581ed'), 'bthover' => array('#54AB3E', '#b316ed', '#ed1592', '#1581ed'), 'bcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bhover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff') );
	} elseif($template == 'temp61') {
		$package_options = array( 'templ' => 'temp61', 'ccolbg' => '#5f30e2', 'prnbg' => '#f9f9fb', 'ctcolor' => '#22313f', 'capbg1' => '#5f30e2', 'capbg2' => '#5f30e2', 'ccborder' => '#522dbb', 'cftcolor' => '#ffffff', 'furlclr' => '#ffffff', 'furlhvr' => '#cdbff7', 'fatclr' => '#cdbff7', 'facclr' => '#381696', 'cscolor' => '#ffffff', 'cshcolor' => '#ffffff' );
		$package_details = array( 'pbclr' => array('#683ce5', '#683ce5', '#683ce5', '#683ce5'), 'tbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow1' => array('#683ce5', '#683ce5', '#683ce5', '#683ce5'), 'fbrow2' => array('#683ce5', '#683ce5', '#683ce5', '#683ce5'), 'bbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#5F30E2', '#5F30E2', '#5F30E2', '#5F30E2'), 'ftborder' => array('#572ad3', '#572ad3', '#572ad3', '#572ad3'), 'tcolor' => array('#22313f', '#22313f', '#22313f', '#22313f'), 'thover' => array('#22313f', '#22313f', '#22313f', '#22313f'), 'pcbig' => array('#22313f', '#22313f', '#22313f', '#22313f'), 'phbig' =>array('#22313f', '#22313f', '#22313f', '#22313f'), 'pcsmall' => array('#22313f', '#22313f', '#22313f', '#22313f'), 'phsmall' => array('#22313f', '#22313f', '#22313f', '#22313f'), 'cutclr' => array('#aaaaaa', '#aaaaaa', '#aaaaaa', '#aaaaaa'), 'fncolor' => array('#ededed', '#ededed', '#ededed', '#ededed'), 'ftcolor' => array('#ededed', '#ededed', '#ededed', '#ededed'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'btcolor' => array('#683ce5', '#683ce5', '#683ce5', '#683ce5'), 'bthover' => array('#683ce5', '#683ce5', '#683ce5', '#683ce5'), 'bcolor' => array('#f5f1ff', '#f5f1ff', '#f5f1ff', '#f5f1ff'), 'bhover' => array('#f5f1ff', '#f5f1ff', '#f5f1ff', '#f5f1ff') );
	} elseif($template == 'temp62') {
		$package_options = array( 'templ' => 'temp62', 'ccolbg' => '#949292', 'prnbg' => '#171717', 'ctcolor' => '#ffffff', 'capbg1' => '#ededed', 'capbg2' => '#ededed', 'ccborder' => '#d1d1d1', 'fcatbg' => '#d3d3d3', 'ffnclr' => '#22313f', 'cftcolor' => '#727272', 'furlclr' => '#727272', 'furlhvr' => '#34495e', 'fatclr' => '#14a01a', 'facclr' => '#cf0310', 'cscolor' => '#c1c1c1', 'cshcolor' => '#7f8c8d' );
		$package_details = array( 'pbclr' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#fcfcfc', '#fcfcfc', '#ffffff', '#fcfcfc'), 'pbcolor' => array('#171717', '#171717', '#ffffff', '#171717'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow1' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow2' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bbcolor' => array('#171717', '#171717', '#ffffff', '#171717'), 'rbcolor' => array('#ffd956', '#ffd956', '#ffd956', '#ffd956'), 'ftborder' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'tcolor' => array('#22313f', '#22313f', '#22313f', '#22313f'), 'thover' => array('#22313f', '#22313f', '#22313f', '#22313f'), 'tdescl' => array('#bdbdbd', '#bdbdbd', '#e1ae00', '#bdbdbd'), 'pcbig' => array('#ffffff', '#ffffff', '#22313f', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#22313f', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#22313f', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#22313f', '#ffffff'), 'cutclr' => array('#aaaaaa', '#aaaaaa', '#aaaaaa', '#aaaaaa'), 'fncolor' => array('#1cad20', '#1cad20', '#1cad20', '#1cad20'), 'ftcolor' => array('#1cad20', '#1cad20', '#1cad20', '#1cad20'), 'rtcolor' => array('#22313f', '#22313f', '#22313f', '#22313f'), 'rthover' => array('#22313f', '#22313f', '#22313f', '#22313f'), 'btcolor' => array('#22313f', '#22313f', '#22313f', '#22313f'), 'bthover' => array('#22313f', '#22313f', '#22313f', '#22313f'), 'bcolor' => array('#ededed', '#ededed', '#ffd956', '#ededed'), 'bhover' => array('#ededed', '#ededed', '#ffd956', '#ededed') );
	} elseif($template == 'temp63') {
		$package_options = array( 'templ' => 'temp63', 'ccolbg' => '#242424', 'prnbg' => '#242424', 'ctcolor' => '#bdbdbd', 'capbg1' => '#000000', 'capbg2' => '#000000', 'ccborder' => '#242424', 'fcatbg' => '#242424', 'ffnclr' => '#bdbdbd', 'cftcolor' => '#bdbdbd', 'furlclr' => '#bdbdbd', 'furlhvr' => '#ffffff', 'fatclr' => '#388c00', 'facclr' => '#fe3a3b', 'cscolor' => '#515151', 'cshcolor' => '#242424' );
		$package_details = array( 'pbclr' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pbcolor' => array('#000000', '#000000', '#000000', '#000000'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow1' => array('#000000', '#000000', '#000000', '#000000'), 'fbrow2' => array('#000000', '#000000', '#000000', '#000000'), 'bbcolor' => array('#000000', '#000000', '#000000', '#000000'), 'rbcolor' => array('#0079b0', '#d81a64', '#e9220d', '#9e21df'), 'ftborder' => array('#242424', '#242424', '#242424', '#242424'), 'tcolor' => array('#000000', '#000000', '#000000', '#000000'), 'thover' => array('#000000', '#000000', '#000000', '#000000'), 'pcbig' => array('#0079b0', '#d81a64', '#e9220d', '#9e21df'), 'phbig' =>array('#0079b0', '#d81a64', '#e9220d', '#9e21df'), 'pcsmall' => array('#0079b0', '#d81a64', '#e9220d', '#9e21df'), 'phsmall' => array('#0079b0', '#d81a64', '#e9220d', '#9e21df'), 'cutclr' => array('#a9a9a9', '#a9a9a9', '#a9a9a9', '#a9a9a9'), 'fncolor' => array('#a9a9a9', '#a9a9a9', '#a9a9a9', '#a9a9a9'), 'ftcolor' => array('#a9a9a9', '#a9a9a9', '#a9a9a9', '#a9a9a9'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'btcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bcolor' => array('#0079b0', '#d81a64', '#e9220d', '#9e21df'), 'bhover' => array('#0079b0', '#d81a64', '#e9220d', '#9e21df') );
	} elseif($template == 'temp64') {
		$package_options = array( 'templ' => 'temp64', 'ctcolor' => '#242424', 'capbg1' => '#ffffff', 'capbg2' => '#ffffff', 'cftcolor' => '#787878', 'furlclr' => '#787878', 'furlhvr' => '#242424', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tbcolor' => array('#005c85', '#ff7300', '#012e55', '#ed2225'), 'pbcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow1' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'fbrow2' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'bbcolor' => array('#005c85', '#ff7300', '#012e55', '#ed2225'), 'rbcolor' => array('#FF5277', '#4FCA39', '#ffb052', '#527BFF'), 'ftborder' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'tcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'thover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'tdescl' => array('#bdbdbd', '#bdbdbd', '#bdbdbd', '#bdbdbd'), 'pcbig' => array('#52caff', '#700000', '#FFB052', '#66080a'), 'phbig' =>array('#52caff', '#700000', '#FFB052', '#66080a'), 'pcsmall' => array('#52caff', '#700000', '#FFB052', '#66080a'), 'phsmall' => array('#52caff', '#700000', '#FFB052', '#66080a'), 'cutclr' => array('#000000', '#000000', '#000000', '#000000'), 'fncolor' => array('#787878', '#787878', '#787878', '#787878'), 'ftcolor' => array('#52586b', '#52586b', '#52586b', '#52586b'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'btcolor' => array('#005c85', '#ff7300', '#012e55', '#ed2225'), 'bthover' => array('#005c85', '#ff7300', '#012e55', '#ed2225'), 'bcolor' => array('#c8d6e5', '#c8d6e5', '#c8d6e5', '#c8d6e5'), 'bhover' => array('#c8d6e5', '#c8d6e5', '#c8d6e5', '#c8d6e5') );
	} else {
		$package_options = array( 'templ' => 'temp0', 'etclr' => 'yes', 'tbpad' => '1', 'ftdir' => 'left', 'ftpad' => '10', 'cftdir' => 'left', 'tttext' => '#ffffff', 'fatclr' => '#7ECE3A', 'facclr' => '#EA2E2D', 'ttbg' => '#333333', 'ptabg' => '#0078D7', 'ptnbg' => '#dddddd', 'ctcolor' => '#333333', 'cftcolor' => '#000000', 'furlclr' => '#0199BC', 'furlhvr' => '#000000', 'ccolbg' => '#cccccc', 'prnbg' => '#ffffff', 'capbg1' => '#F5F5F5', 'capbg2' => '#DFDFDF', 'ccborder' => '#868686', 'cscolor' => '#cccccc', 'cshcolor' => '#333333' );
		$package_details = array( 'pbclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'tcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'thover' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'tbcolor' => array('#44A3D5', '#44A3D5', '#44A3D5', '#44A3D5'), 'pcbig' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phbig' =>array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'pcsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'phsmall' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'cutclr' => array('#dddddd', '#dddddd', '#dddddd', '#dddddd'), 'pbcolor' => array('#44A3D5', '#44A3D5', '#44A3D5', '#44A3D5'), 'pcircle' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'imgclr' => array('#cccccc', '#cccccc', '#cccccc', '#cccccc'), 'fncolor' => array('#333333', '#333333', '#333333', '#333333'), 'ftcolor' => array('#333333', '#333333', '#333333', '#333333'), 'fbrow1' => array('#FAFAFA', '#FAFAFA', '#FAFAFA', '#FAFAFA'), 'fbrow2' => array('#DFDFDF', '#DFDFDF', '#DFDFDF', '#DFDFDF'), 'btcolor' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'bthover' => array('#FFFFFF', '#FFFFFF', '#FFFFFF', '#FFFFFF'), 'bcolor' => array('#333333', '#333333', '#333333', '#333333'), 'bhover' => array('#333333', '#333333', '#333333', '#333333'), 'bbcolor' => array('#44A3D5', '#44A3D5', '#44A3D5', '#44A3D5'), 'rtcolor' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rthover' => array('#ffffff', '#ffffff', '#ffffff', '#ffffff'), 'rbcolor' => array('#CB0000', '#CB0000', '#CB0000', '#CB0000'), 'ftborder' => array('#868686', '#868686', '#868686', '#868686') );
	}
	foreach($packageOptions as $key => $option) {
		$package_value = get_option($option);
		foreach($package_details as $pkey => $value) {
			$packageValues_text[$pkey] = sanitize_text_field( $value[$key] );
		}
		$mergePackages = array_merge($package_value, $packageValues_text);
		update_option($option, $mergePackages);
	}
	$mergeOptions = array_merge($table_option, $package_options);
	update_option($option_name, $mergeOptions);
	wp_die();
}
add_action( 'wp_ajax_nopriv_wrcpt_setup_selected_template', 'wrcpt_setup_selected_template' );
add_action( 'wp_ajax_wrcpt_setup_selected_template', 'wrcpt_setup_selected_template' );
?>