<?php
/**
* Plugin Name: WRC Pricing Tables Ultimate
* Description: WRC Pricing Tables is a WordPress Responsive CSS3 Pricing Table plugin, aimed to deliver an optimum viewing experience across a wide range of devices and in all major browsers.
* Plugin URI: https://www.realwebcare.com/
* Author: Realwebcare.com
* Version: 1.2.4
* Author URI: https://www.realwebcare.com/
* Domain Path: /languages/
* 
* Text Domain: wrcpt
* License: https://www.realwebcare.com/billing/licenses.php (Standard License)
*/
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}
ob_start();
define('WRCPT_PLUGIN_PATH', plugin_dir_path( __FILE__ ));

/**
 * Internationalization
 */
function wrcpt_textdomain() {
	$domain = 'wrcpt';
	$locale = apply_filters( 'plugin_locale', get_locale(), $domain );
	load_textdomain( $domain, trailingslashit( WP_LANG_DIR ) . $domain . '/' . $domain . '-' . $locale . '.mo' );
	load_plugin_textdomain( $domain, FALSE, basename( dirname( __FILE__ ) ) . '/languages/' );
}
add_action( 'init', 'wrcpt_textdomain' );

/* Checking wrcpt global options */
$wrcpt_options = get_option('pricing_table_global', 'default_value');

/* Registering plugin activation hooks */
function wrcpt_plugin_activate(){
	do_action( 'wrcpt_plugin_activation_options' );
}
register_activation_hook( __FILE__, 'wrcpt_plugin_activate' );
function wrcpt_plugin_activation_values() {
	$wrcpt_globals = get_option('pricing_table_global', 'default_value');
	// Checking global options exist or not
	if ( $wrcpt_globals === 'default_value' ) {
		// The option does not exist
		// Set default values here
		$global_options = array( 'minify' => 'yes', 'wpedit' => 'yes', 'htmled' => 'yes', 'gdfont' => 'yes', 'gcfont' => '', 'prfont' => '', 'scfont' => '', 'fasome' => 'yes', 'vwport' => 'no', 'clrdb' => 'no', 'ccoff' => 'no', 'wrccss' => '' );
		add_option('pricing_table_global', $global_options);
	} else {
		// $wrcpt_globals = get_option('pricing_table_global');
		// Checking values of pricing table global settings
		$minify_script = (isset($wrcpt_globals['minify']) && $wrcpt_globals['minify']) ? $wrcpt_globals['minify'] : 'yes';
		$wp_post_editor = (isset($wrcpt_globals['wpedit']) && $wrcpt_globals['wpedit']) ? $wrcpt_globals['wpedit'] : 'yes';
		$html_editor = (isset($wrcpt_globals['htmled']) && $wrcpt_globals['htmled']) ? $wrcpt_globals['htmled'] : 'yes';
		$default_font = (isset($wrcpt_globals['gdfont']) && $wrcpt_globals['gdfont']) ? $wrcpt_globals['gdfont'] : 'yes';
		$custom_font = (isset($wrcpt_globals['gcfont']) && $wrcpt_globals['gcfont']) ? $wrcpt_globals['gcfont'] : '';
		$primary_font = (isset($wrcpt_globals['prfont']) && $wrcpt_globals['prfont']) ? $wrcpt_globals['prfont'] : '';
		$secondary_font = (isset($wrcpt_globals['scfont']) && $wrcpt_globals['scfont']) ? $wrcpt_globals['scfont'] : '';
		$font_awesome = (isset($wrcpt_globals['fasome']) && $wrcpt_globals['fasome']) ? $wrcpt_globals['fasome'] : 'yes';
		$view_port = (isset($wrcpt_globals['vwport']) && $wrcpt_globals['vwport']) ? $wrcpt_globals['vwport'] : 'no';
		$clear_db = (isset($wrcpt_globals['clrdb']) && $wrcpt_globals['clrdb']) ? $wrcpt_globals['clrdb'] : 'no';
		$custom_off = (isset($wrcpt_globals['ccoff']) && $wrcpt_globals['ccoff']) ? $wrcpt_globals['ccoff'] : 'no';
		$wrcpt_custom = (isset($wrcpt_globals['wrccss']) && $wrcpt_globals['wrccss']) ? esc_textarea($wrcpt_globals['wrccss']) : '';
		$global_options = array( 'minify' => $minify_script, 'wpedit' => $wp_post_editor, 'htmled' => $html_editor, 'gdfont' => $default_font, 'gcfont' => $custom_font, 'prfont' => $primary_font, 'scfont' => $secondary_font, 'fasome' => $font_awesome, 'vwport' => $view_port, 'clrdb' => $clear_db, 'ccoff' => $custom_off, 'wrccss' => $wrcpt_custom );
		update_option('pricing_table_global', $global_options);
	}
	$package_table = get_option('packageTables', 'default_value');
	$package_feature = $package_combine = $package_columns = $packageOptions = array();
	if ( $package_table !== 'default_value' ) {
		// The option exists
		$pricing_tables = explode(', ', $package_table);
		$fn=0;
		foreach($pricing_tables as $key => $pricing_table) {
			if($pricing_table) {
				$package_feature = get_option($pricing_table.'_feature', 'feature_not_exists');
				$package_combine = get_option($pricing_table.'_option');
				$package_columns = get_option($pricing_table, null);
				if ( $package_columns !== null ) {
					// The option exists
					$packageOptions = explode(', ', $package_columns);
				}
			}
			if ( $package_feature !== 'feature_not_exists' ) {
				// The feature exists
				if (is_array($package_feature) && array_key_exists('fcate1', $package_feature)) {
					$tfeat = count($package_feature)/6;
				} elseif (is_array($package_feature) && array_key_exists('flink1', $package_feature)) {
					$tfeat = count($package_feature)/5;
				} else {
					$tfeat = count($package_feature)/2;
				}
			} else {
				$tfeat = 0;
			}
			for($fn=1; $fn <= $tfeat; $fn++) {
				$feature_name['fitem'.$fn] = '';
				$feature_name['fcate'.$fn] = '';
				$feature_name['flink'.$fn] = '';
				$feature_name['fdesc'.$fn] = '';
				$feature_name['ftype'.$fn] = '';
				$feature_name['fasom'.$fn] = '';
			}
			$fn=0; $pbcolor = $bbcolor = $fncolor = '';
			$final_features = array_merge($feature_name, $package_feature);
			//Updating all the features
			update_option($pricing_table.'_feature', $final_features);
			$common_options = array( 'dname' => '', 'spurl' => '', 'cprtx' => '', 'cwidth' => '', 'maxcol' => '', 'ptmtop' => '', 'colgap' => '', 'capwidth' => '', 'pgfont' => '', 'sgfont' => '', 'ctsize' => '', 'cftsize' => '', 'tbpad' => '', 'tbody' => '', 'tsize' => '', 'tdesc' => '', 'pbody' => '', 'psbig' => '', 'pssmall' => '', 'cutprs' => '', 'ftbody' => '', 'ftsize' => '', 'btbody' => '', 'bwidth' => '', 'bheight' => '', 'btsize' => '', 'rtsize' => '', 'ptsize' => '', 'ptspsize' => '', 'ptwidth' => '', 'ttwidth' => '', 'ptheight' => '', 'tgpos' => '', 'imgwid' => '', 'imghgt' => '', 'imgmrg' => '', 'imgopc' => '', 'vbody' => '', 'ftdir' => '', 'cttdir' => '', 'cftdir' => '', 'pbrad' => '', 'ftpad' => '', 'awetick' => '', 'awecross' => '', 'enable' => '', 'scode' => 'sc-1', 'ftcap' => '', 'autocol' => '', 'encol' => '', 'etclr' => '', 'colshad' => '', 'dscol' => '', 'ttgrd' => '', 'prgrd' => '', 'ptabg' => '', 'ptnbg' => '', 'dsgrd' => '', 'purgt' => '', 'tcleft' => '', 'enicon' => '', 'fealn' => '', 'cpttpc' => '', 'tick' => 'tick-1', 'cross' => 'cross-1', 'entips' => '', 'enfbor' => '', 'encbor' => '', 'encate' => '', 'captbg' => '', 'empft' => '', 'hidefn' => '', 'hidecfn' => '', 'pbttwo' => '', 'hdptnm' => '', 'cshade' => '', 'enribs' => '', 'markrib' => 'rb-1', 'nltab' => '', 'enimg' => '', 'bgimg' => '', 'imgov' => '', 'opimg' => '', 'envid' => '', 'opvid' => '', 'vfscr' => '', 'mbrand' => '', 'enfatc' => '', 'htitle' => '', 'hprice' => '', 'hfeat' => '', 'btompr' => '', 'hbutton' => '', 'mcurr' => '', 'tgtext1' => '', 'tgtext2' => '', 'sptext' => '', 'tgtext3' => '', 'sptext2' => '', 'tgtext4' => '', 'sptext3' => '', 'topbut' => '', 'furlclr' => '', 'furlhvr' => '', 'togg3' => '', 'togg4' => '', 'fcatbg' => '', 'cfsize' => '', 'ffnclr' => '', 'fcbody' => '', 'ttbg' => '', 'tttext' => '', 'ptntext' => '', 'ptatext' => '', 'ptsptext' => '', 'fatclr' => '', 'facclr' => '', 'ctcolor' => '', 'cftcolor' => '', 'fstar' => 'star-1', 'cbrad' => '', 'ccborder' => '', 'cscolor' => '', 'cshcolor' => '', 'ccolbg' => '', 'prnbg' => '', 'capbg1' => '', 'capbg2' => '', 'crlepr' => '' );
			$final_options = array_merge($common_options, $package_combine);
			//Updating all the common options
			update_option($pricing_table.'_option', $final_options);
			foreach($packageOptions as $key => $option) {
				$package_values = get_option($option);
				if(!isset($package_values['pbcolor'])) {
					$pbcolor = $package_values['tbcolor'];
				}
				if(!isset($package_values['bbcolor'])) {
					$bbcolor = $package_values['tbcolor'];
				}
				if(!isset($package_values['fncolor'])) {
					$fncolor = $package_values['ftcolor'];
				}
				$package_column_details = array( 'pdisp' => '', 'type' => '', 'tdesc' => '', 'tcolor' => '', 'thover' => '', 'tdescl' => '', 'pbclr' => '', 'tbcolor' => '', 'price' => '', 'pcbig' => '', 'phbig' => '', 'cent' => '', 'cutpr' => '', 'cutfr' => '', 'unit' => '', 'plan' => '', 'pdesc' => '', 'pcsmall' => '', 'phsmall' => '', 'cutclr' => '', 'pbcolor' => $pbcolor, 'pcircle' => '', 'imgclr' => '', 'enptg' => '', 'tgprice' => '', 'tgcent' => '', 'tgcut' => '', 'tgcutfr' => '', 'tgplan' => '', 'tgunit' => '', 'btglink' => '', 'sbntl1' => '', 'tgprc2' => '', 'tgcnt2' => '', 'tgcut2' => '', 'tgcfr2' => '', 'tgpln2' => '', 'tgunt2' => '', 'tgbln2' => '', 'sbntl2' => '', 'tgprc3' => '', 'tgcnt3' => '', 'tgcut3' => '', 'tgcfr3' => '', 'tgpln3' => '', 'tgunt3' => '', 'tgbln3' => '', 'sbntl3' => '', 'fncolor' => $fncolor, 'ftcolor' => '', 'fbrow1' => '', 'fbrow2' => '', 'paypal' => '', 'hsbtn' => '', 'pplng' => '', 'ppcur' => '', 'pplva' => '', 'ppsbx' => '', 'pmode' => '', 'pactn' => '', 'ppbsz' => '', 'ppcnc' => '', 'pprtn' => '', 'hsbid' => '', 'btext' => '', 'blink' => '', 'bicon' => '', 'btext2' => '', 'blink2' => '', 'bicon2' => '', 'pimg' => '', 'pvid' => '', 'btcolor' => '', 'bthover' => '', 'bcolor' => '', 'bhover' => '', 'bbcolor' => $bbcolor, 'rtext' => '', 'rtcolor' => '', 'rthover' => '', 'rbcolor' => '', 'ftborder' => '' );
				for($fn=1; $fn <= $tfeat; $fn++) {
					$feature_values['fitem'.$fn] = '';
					$feature_values['tip'.$fn] = '';
				}
				$column_details = array_merge($package_column_details, $feature_values);
				$final_column_details = array_merge($column_details, $package_values);
				//Updating all the columns options
				update_option($option, $final_column_details);
			}
		}
	}
}
add_action( 'wrcpt_plugin_activation_options', 'wrcpt_plugin_activation_values' );

/* Unregistering plugin deactivation hooks */
function wrcpt_plugin_deactivate(){
	do_action( 'wrcpt_plugin_deactivation_check' );
}
register_uninstall_hook( __FILE__, 'wrcpt_plugin_deactivate' );
function wrcpt_plugin_deactivate_options() {
	$wrcpt_globals = get_option('pricing_table_global', 'default_value');
	if ( $wrcpt_globals !== 'default_value' ) {
		$clear_db = isset($wrcpt_globals['clrdb']) ? $wrcpt_globals['clrdb'] : 'no';
		if($clear_db == 'yes') {
			$package_table = get_option('packageTables');
			if(isset($package_table) && $package_table != '') {
				$pricing_tables = explode(', ', $package_table);
				foreach($pricing_tables as $key => $list) {
					$package_lists = get_option($list);
					if(isset($package_lists)) {
						if($package_lists) {
							$table_packages = explode(', ', $package_lists);
							foreach($table_packages as $package) { delete_option($package); }
						}
						delete_option($list);
					}
					$package_features = get_option($list.'_feature');
					$package_options = get_option($list.'_option');
					if(isset($package_features)) { delete_option($list.'_feature'); }
					if(isset($package_options)) { delete_option($list.'_option'); }
				}
				delete_option('packageTables');
				delete_option('packageCount');
				delete_option('packageIDs');
				delete_option('IDsCount');
				delete_option('pricing_table_global');
				delete_option('external_updates-wrc-pricing-tables-ultimate');
			}
		}
	}
}
add_action( 'wrcpt_plugin_deactivation_check', 'wrcpt_plugin_deactivate_options' );

/**
 * Add plugin action links
 */
function wrcpt_plugin_actions( $links ) {
	$links[] = '<a href="'.menu_page_url('wrcpt_template', false).'">'. __('Create Table','wrcpt') .'</a>';
	$links[] = '<a href="https://www.realwebcare.com/billing/submitticket.php" target="_blank">'. __('Support','wrcpt') .'</a>';
	return $links;
}
add_filter( 'plugin_action_links_' . plugin_basename(__FILE__), 'wrcpt_plugin_actions' );
if(is_admin()) { require_once ( WRCPT_PLUGIN_PATH . 'inc/admin-menu.php' ); }

if(isset($wrcpt_options['wpedit']) && ($wrcpt_options['wpedit'] == 'yes' && $wrcpt_options['htmled'] == 'yes')) {
	add_filter( 'wp_default_editor', 'wrc_WP_default_widget' );
	function wrc_WP_default_widget() {
		return "html";
	}
}
/**
 * Admin enqueue styles and scripts
 */
function wrcpt_enqueue_scripts_admin() {
	$wrcpt_options = get_option('pricing_table_global');
	$wrcpt_cm_settings['codeEditor_html'] = wp_enqueue_code_editor(array('type' => 'text/html'));
	$wrcpt_cm_settings['codeEditor_css'] = wp_enqueue_code_editor(array('type' => 'text/css'));
	if(isset($wrcpt_options['minify']) && $wrcpt_options['minify'] == 'yes') {
		wp_register_script('wrcptjs', plugins_url( 'js/wrcpt-admin.min.js', __FILE__ ), array('jquery'), '1.2.4', true);
		wp_register_script('mixitup', plugins_url( 'js/mixitup.min.js', __FILE__ ), array('jquery'), '3.4.1', true);
	} else {
		wp_register_script('wrcptjs', plugins_url( 'js/wrcpt-admin.js', __FILE__ ), array('jquery'), '1.2.4', true);
		wp_register_script('mixitup', plugins_url( 'js/mixitup.js', __FILE__ ), array('jquery'), '3.4.1', true);
	}
	wp_enqueue_script('wrcptjs');
	wp_enqueue_script('mixitup');
	wp_enqueue_script('jquery-ui-sortable');
	wp_enqueue_script('jquery-ui-accordion');
	wp_enqueue_script('jquery-ui-tabs');
	wp_enqueue_script('wp-color-picker');
	wp_enqueue_style('wp-color-picker');
	wp_enqueue_media();
	wp_localize_script('wrcptjs', 'wrcptajax', array( 'ajaxurl' => admin_url( 'admin-ajax.php' ) ) );
	wp_localize_script('jquery', 'wrcpt_cm_settings', $wrcpt_cm_settings);
	if(isset($wrcpt_options['minify']) && $wrcpt_options['minify'] == 'yes') {
		wp_enqueue_style('wrcptscone', plugins_url( 'css/wrcpt-style.min.css', __FILE__ ), '', '1.2.4');
		wp_enqueue_style('wrcptadmin', plugins_url( 'css/wrcpt-admin.min.css', __FILE__ ), '', '1.2.4');
	} else {
		wp_enqueue_style('wrcptscone', plugins_url( 'css/wrcpt-style.css', __FILE__ ), '', '1.2.4');
		wp_enqueue_style('wrcptadmin', plugins_url( 'css/wrcpt-admin.css', __FILE__ ), '', '1.2.4');
	}
	wp_enqueue_style('jquery-ui-style', plugins_url( 'css/jquery-ui-custom.css', __FILE__ ), '', '1.10.4');
	if(isset($wrcpt_options['ccoff']) && $wrcpt_options['ccoff'] == 'no') {
		// Call the PHP file with CSS code
		require_once ( WRCPT_PLUGIN_PATH . 'css/wrcpt-custom.php' );
		// Read the contents of the PHP file
		$css_code = wrcpt_set_custom_css('preview');
		// Set the path to the output file
		$output_path = plugin_dir_path( __FILE__ ) . '/css/wrcpt-custom.css';
		// Write the CSS code to the output file
		file_put_contents($output_path, $css_code);
		// enqueue the CSS file
		wp_enqueue_style('wrcptcustom', plugins_url( 'css/wrcpt-custom.css', __FILE__ ), array(), '1.2.4');
		// wp_enqueue_style('wrcptcustm', plugins_url( 'css/wrcpt-custm.php?id=preview', __FILE__ ), array(), '1.2.4');
	}
}
add_action('admin_enqueue_scripts', 'wrcpt_enqueue_scripts_admin');

/**
 * Enqueue styles and scripts at fromt-end
 */
function wrc_pricing_table_enqueue() {
	$wrcpt_options = get_option('pricing_table_global');
	if(isset($wrcpt_options['gdfont']) && $wrcpt_options['gdfont'] == 'yes') {
		wp_enqueue_style('gfontdfault', '//fonts.googleapis.com/css?family=Roboto+Condensed:400,700|Droid+Sans:400,700', array(), null);
	} else {
		if(isset($wrcpt_options['gcfont']) && $wrcpt_options['gcfont'] != '') {
			wp_enqueue_style('gfontcustom', esc_url($wrcpt_options['gcfont']), array(), null);
		}
	}
	if(isset($wrcpt_options['minify']) && $wrcpt_options['minify'] == 'yes') {
		wp_enqueue_style('wrcptstyle', plugins_url( 'css/wrcpt-style.min.css', __FILE__ ), '', '1.2.4');
	} else {
		wp_enqueue_style('wrcptstyle', plugins_url( 'css/wrcpt-style.css', __FILE__ ), '', '1.2.4');
	}
	if(isset($wrcpt_options['fasome']) && $wrcpt_options['fasome'] == 'yes') {
		wp_enqueue_style('wrcfawsome', plugins_url( 'css/fontawesome.min.css', __FILE__ ), '', '5.5.0');
	}
	if(isset($wrcpt_options['ccoff']) && $wrcpt_options['ccoff'] == 'no') {
		$page_id = get_the_ID();
		// Call the PHP file with CSS code
		require_once ( WRCPT_PLUGIN_PATH . 'css/wrcpt-custom.php' );
		// passing true to get only the ids of the added pages
		$st_pageid = wrcpt_set_custom_css('', true);
		// Iterate through the outer array
		foreach ($st_pageid as $subarray) {
			// Check if the current page ID exists in the inner array
			if (in_array($page_id, $subarray)) {
				// Generate the file name for the pricing table
				$output_filename = 'wrcpt-custom-' . $page_id . '.css';
				// Set the path to the output file
				$output_path = plugin_dir_path( __FILE__ ) . '/css/' . $output_filename;
				// Clear the file
				file_put_contents($output_path, '');
				// Read the contents of the PHP file
				$css_code = wrcpt_set_custom_css($page_id);
				// Write the CSS code to the output file
				file_put_contents($output_path, $css_code);
				// enqueue the CSS file
				wp_enqueue_style('wrcptcustom-'.$page_id, plugins_url( 'css/wrcpt-custom-'.$page_id.'.css', __FILE__ ), array(), '1.2.4');
			}
		}
	}
}
add_action('wp_enqueue_scripts', 'wrc_pricing_table_enqueue');

/**
 * Add meta viewport in head section
 * A <meta> viewport element gives the browser instructions on how to control the page's dimensions and scaling.
 */
function wrcpt_add_view_port() {
	echo '<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">';
}
if ( $wrcpt_options !== 'default_value' ) {
	if(isset($wrcpt_options['vwport']) && $wrcpt_options['vwport'] == 'yes') {
		add_action('wp_head', 'wrcpt_add_view_port');
	}
}

require WRCPT_PLUGIN_PATH . 'lib/plugin-update-checker/plugin-update-checker.php';
use YahnisElsts\PluginUpdateChecker\v5\PucFactory;
$MyUpdateChecker = PucFactory::buildUpdateChecker('https://www.realwebcare.com/plugin/rwc-update-pro/?action=get_metadata&slug=dix-kirxrmt-gzyovh-fogrnzgv', __FILE__, 'wrc-pricing-tables-ultimate');

/**
 * The function on admin initalization.
 * Here it check the pages that we are working on are the ones used by the Media Uploader.
 */
function wrcpt_ink_options_setup() {
	global $pagenow;
	if ('media-upload.php' == $pagenow || 'async-upload.php' == $pagenow) {
		add_filter('gettext', 'wrcpt_replace_window_text', 1, 2);
	}
}
add_action('admin_init', 'wrcpt_ink_options_setup');

/**
 * Referer parameter in our script file is for to know from which page we are launching
 * the Media Uploader as we want to change the text "Insert into Post".
 */
function wrcpt_replace_window_text($translated_text, $text) {
	if ('Insert into Post' == $text) {
		$referer = strpos(wp_get_referer(), 'media_page');
		if ($referer != '') {
			return __('Upload Image', 'ink');
		}
	}
	return $translated_text;
}

/**
 * Return an ID of an attachment by searching the database with the file URL.
 *
 * First checks to see if the $url is pointing to a file that exists in
 * the wp-content directory. If so, then we search the database for a
 * partial match consisting of the remaining path AFTER the wp-content
 * directory. Finally, if a match is found the attachment ID will be
 * returned.
 *
 * @param string $url The URL of the image (ex: http://mysite.com/wp-content/uploads/2013/05/test-image.jpg)
 * 
 * @return int|null $attachment Returns an attachment ID, or null if no attachment is found
 */
function wrcpt_get_attachment_id_by_url( $url ) {
	// Split the $url into two parts with the wp-content directory as the separator
	$parsed_url = explode( parse_url( WP_CONTENT_URL, PHP_URL_PATH ), $url ) ?? array();

	// Get the host of the current site and the host of the $url, ignoring www
	$this_host = str_ireplace( 'www.', '', (parse_url( home_url(), PHP_URL_HOST ) ?? '') );
	$file_host = str_ireplace( 'www.', '', (parse_url( $url, PHP_URL_HOST ) ?? '') );

	// Return nothing if there aren't any $url parts or if the current host and $url host do not match
	if ( ! isset( $parsed_url[1] ) || empty( $parsed_url[1] ) || ( $this_host != $file_host ) ) {
		return;
	}

	// Now we're going to quickly search the DB for any attachment GUID with a partial path match
	// Example: /uploads/2013/05/test-image.jpg
	$parsed_url[1] = preg_replace( '/-[0-9]{1,4}x[0-9]{1,4}\.(jpg|jpeg|png|gif|bmp)$/i', '.$1', $parsed_url[1] );
	global $wpdb;

	$attachment = $wpdb->get_col( $wpdb->prepare( "SELECT ID FROM {$wpdb->prefix}posts WHERE guid RLIKE %s;", $parsed_url[1] ) );

	// Returns null if no attachment is found
	return $attachment[0];
}

/**
 * Regular Expression for YouTube links.
 * Gives the id of any youtube link.
 */
function wrcpt_parse_yturl($url) {
	$pattern = '#^(?:https?://)?(?:www\.)?(?:youtu\.be/|youtube\.com(?:/embed/|/v/|/watch\?v=|/watch\?.+&v=))([\w-]{11})(?:.+)?$#x';
	preg_match($pattern, $url, $matches);
	return (isset($matches[1])) ? $matches[1] : false;
}

/**
 * adjust brightness of a colour
 * not the best way to do it but works well enough here
 *
 * @param type $hex
 * @param type $steps
 * @return type
 */
function wrcpt_adjustBrightness($hex, $steps) {
	// Steps should be between -255 and 255. Negative = darker, positive = lighter
	$steps = max(-255, min(255, $steps));

	// Normalize into a six character long hex string
	$hex = str_replace('#', '', $hex);
	if (strlen($hex) == 3) {
		$hex = str_repeat(substr($hex,0,1), 2).str_repeat(substr($hex,1,1), 2).str_repeat(substr($hex,2,1), 2);
	}

	if (preg_match('/^[0-9A-Fa-f]{6}$/', $hex)) {
		// Split into three parts: R, G and B
		$color_parts = str_split($hex, 2);
		$return = '#';

		foreach ($color_parts as $color) {
			// Convert to decimal
			$color   = hexdec($color);
			// Adjust color
			$color   = max(0, min(255, $color + $steps));
			// Make two char hex code
			$return .= str_pad(dechex(intval($color)), 2, '0', STR_PAD_LEFT);
		}
		return $return;
	} else {
		return "Invalid input: '$hex'. Please provide a valid six-digit hexadecimal color code.";
	}
}

//Display star rating in pricing table features.
function wrcpt_display_star_rating( $rate='' ) {
	$stars   = '';

	if ( $rate != '' ) {
		$average = $rate;
	} else {
		$average = 0;
	}

	for ( $i = 1; $i <= $average + 1; $i++ ) {
		$width = intval( $i - $average > 0 ? 20 - ( ( $i - $average ) * 20 ) : 20 );
		if ( 0 === $width ) {
			continue;
		}
		$stars .= '<span style="overflow:hidden; width:' . $width . 'px" class="feature_star"></span>';
		if ( $i - $average > 0 ) {
			$stars .= '<span style="overflow:hidden; position:relative; left:-' . $width .'px;" class="star_empty"></span>';
		}
	}
	if ( $i == 3 || $average < 3 ) {
		$stars .= '<span style="overflow:hidden; position:relative; left:-' . $width .'px;" class="star_empty"></span>';
		if ( $average == 2 || $average < 2 ) {
			$stars .= '<span style="overflow:hidden; position:relative; left:-' . $width .'px;" class="star_empty"></span>';
			if($average < 2) {
				$stars .= '<span style="overflow:hidden; position:relative; left:-' . $width .'px;" class="star_empty"></span>';
			}
			if($average == 1) {
				$stars .= '<span style="overflow:hidden; position:relative; left:-' . $width .'px;" class="star_empty"></span>';
			}
		}
	}
	if ( $i == 4 || $average == 3 ) {
		$stars .= '<span style="overflow:hidden; position:relative; left:-' . $width .'px;" class="star_empty"></span>';
	}
	if ( $i == 5 || $average == 4 ) {
		$stars .= '<span style="overflow:hidden; position:relative; left:-' . $width .'px;" class="star_empty"></span>';
	}
	if ( $average == 0 ) {
		for ( $j = 1; $j <= 5; $j++ ) {
			$stars .= '<span style="overflow:hidden; position:relative; left:-' . $width .'px;" class="star_empty"></span>';
		}
	}
	if($average != 0) {
		$star_ratings  = '<p class="average-rating">' . $stars . '</p>';
	} else {
		$star_ratings  = '';
	}
	return $star_ratings;
}

/**
 * Pricing Table Shortcode
 */
function wrc_pricing_table_shortcode( $atts, $content = null ) {
	extract( shortcode_atts( array(
		'id' => 1
	), $atts, 'wrc-pricing-table' ) );

	ob_start();
	$f_value = $f_tips = '';
	$total_feature = $flag = 0;
	$pricing_table_lists = get_option('packageTables');
	$pricing_id_lists = get_option('packageIDs');
	if($pricing_table_lists) {
		$pricing_table_lists = explode(', ', $pricing_table_lists);
		$pricing_id_lists = explode(', ', $pricing_id_lists);
		$key = array_search($id, $pricing_id_lists);
		if(in_array($id, $pricing_id_lists)) $flag = 1;
		$pricing_table = $pricing_table_lists[$key];
		$tableID = strtolower($pricing_table) . '-' .$id;
		$package_feature = get_option($pricing_table.'_feature');
		$packageCombine = get_option($pricing_table.'_option');
		if($package_feature) { $total_feature = count($package_feature)/6; }
		$package_lists = get_option($pricing_table);
		$packageOptions = explode(', ', $package_lists);
		$package_count = count($packageOptions);
		$table_name = (isset($packageCombine['dname']) && $packageCombine['dname'] != '') ? $packageCombine['dname'] : $pricing_table;
		if($packageCombine['scode'] == 'sc-1') {
			require_once ( WRCPT_PLUGIN_PATH . 'lib/process-shortcode-one.php' );
			echo wrcpt_shortcode1($pricing_table, $table_name, $tableID, $package_feature, $packageCombine, $total_feature, $package_lists, $packageOptions, $package_count, $flag);
		} else {
			require_once ( WRCPT_PLUGIN_PATH . 'lib/process-shortcode-one.php' );
			echo wrcpt_shortcode1($pricing_table, $table_name, $tableID, $package_feature, $packageCombine, $total_feature, $package_lists, $packageOptions, $package_count, $flag);
		}
	} else {
		echo "<p class=\"wrcpt_notice\">" . __('You didn\'t add any pricing tables yet!', 'wrcpt') . "</p>";
	}
	return ob_get_clean();
}
add_shortcode('wrc-pricing-table', 'wrc_pricing_table_shortcode');
?>